const express = require('express');
const router = express.Router();
const { query } = require('../database');

// GET /api/hardware - Fetch all hardware
router.get('/hardwares', async (req, res) => {
  try {
    const result = await query(`
      SELECT id, title, content, link, documentation, image
      FROM infrastructure_schema.supported_hardwares
      ORDER BY queue
    `);
    // Transform data
    const baseUrl = process.env.BASE_URL
    const transformedData = result.rows.map(hardware => {
      return {
        index: hardware.id,
        title: hardware.title,
        content: hardware.content,
        documentation: hardware.documentation,
        image: hardware.image ? `${baseUrl}/assets/${hardware.image}` : null,
        link: hardware.link
      }
    })
    res.json({
      success: true,
      data: transformedData,
      count: transformedData.length
    });
  } catch (error) {
    console.error('Error fetching hardware:', error);
    res.status(500).json({
      success: false,
      error: 'Failed to fetch hardware'
    });
  }
});

// GET /api/tools - Fetch all tools
router.get('/tools', async (req, res) => {
  try {
    // Obtain data
    const result = await query(`
      SELECT id, title, content, link, documentation, image
      FROM infrastructure_schema.supported_tools
      ORDER BY queue
    `);
    // Transform data
    const baseUrl = process.env.BASE_URL
    const transformedData = result.rows.map(tool => {
      return {
        index: tool.id,
        title: tool.title,
        content: tool.content,
        documentation: tool.documentation,
        image: tool.image ? `${baseUrl}/assets/${tool.image}` : null,
        link: tool.link
      }
    })
    res.json({
      success: true,
      data: transformedData,
      count: transformedData.length
    });
  } catch (error) {
    console.error('Error fetching tools:', error);
    res.status(500).json({
      success: false,
      error: 'Failed to fetch tools'
    });
  }
});

module.exports = router;
