const express = require('express');
const router = express.Router();
const { query } = require('../database');

// GET /api/aboutus - Fetch all team members
router.get('/', async (req, res) => {
  try {
    //obtain data
    const result = await query(`
      SELECT id, name, surname, role, image_url, linkedin_profile, description
      FROM aboutus_schema.members am
      Where  am.active = true
      ORDER BY queue
    `);
    // transform data
    const baseUrl = process.env.BASE_URL
    const transformedData = result.rows.map(member => {
      return {
        index: member.id,
        name: member.name + ' ' + member.surname,
        // surname: member.surname,
        role: member.role,
        imgSrc: member.image_url ? `${baseUrl}/assets/${member.image_url}` : null,
        linkedInUrl: member.linkedin_profile,
        description: member.description
      }
    })
    res.json({
      success: true,
      data: transformedData,
      count: transformedData.length
    });
  } catch (error) {
    console.error('Error fetching team members:', error);
    res.status(500).json({
      success: false,
      error: 'Failed to fetch team members.'
    });
  }
});

module.exports = router;
