# INNUCE Website Backend

Node.js backend server for the INNUCE laboratory website, providing REST APIs for team members, use cases, tools, and hardware information.

## Features

- **Team Members API** - Fetch laboratory team member information
- **Use Cases API** - Retrieve research use cases with detailed content
- **Tools API** - Get information about development tools
- **Hardware API** - Access hardware infrastructure details
- **PostgreSQL Integration** - Robust database support
- **CORS Enabled** - Ready for frontend integration
- **Security Headers** - Helmet.js for enhanced security

## Tech Stack

- **Runtime**: Node.js
- **Framework**: Express.js
- **Database**: PostgreSQL
- **Security**: Helmet.js
- **CORS**: Enabled for cross-origin requests

## Project Structure

```
innuce-website-backend/
├── .env                    # Environment variables (database config)
├── server.js              # Main server file
├── database.js            # Database connection and query utilities
├── package.json           # Dependencies and scripts
├── database-schema.sql    # PostgreSQL table definitions
└── routes/                # API route handlers
    ├── team.js           # Team members endpoints
    ├── useCases.js       # Use cases endpoints
    ├── tools.js          # Tools endpoints
    └── hardware.js       # Hardware endpoints
```

## Setup Instructions

### 1. Install Dependencies

```bash
npm install
```

### 2. Database Setup

1. Ensure PostgreSQL is running on your system
2. Update the `.env` file with your database credentials:
   ```env
   DB_HOST=localhost
   DB_PORT=5432
   DB_NAME=postgres
   DB_USER=wuyuxuan
   DB_PASSWORD=your_actual_password
   ```
3. Create the database tables by running the schema file in PostgreSQL:
   ```sql
   -- Execute the contents of database-schema.sql in your PostgreSQL database
   ```

### 3. Start the Server

For development:
```bash
npm run dev
```

For production:
```bash
npm start
```

The server will run on `http://localhost:3000` by default.

## API Endpoints

### Team Members
- `GET /api/team` - Fetch all team members

### Use Cases
- `GET /api/use-cases/list` - Fetch all use cases
- `GET /api/use-cases/:slug` - Fetch specific use case with content

### Tools
- `GET /api/tools` - Fetch all tools

### Hardware
- `GET /api/hardware` - Fetch all hardware

### Health Check
- `GET /api/health` - Server health status

## Response Format

All API responses follow this structure:
```json
{
  "success": true,
  "data": [...],
  "count": 10
}
```

Error responses:
```json
{
  "success": false,
  "error": "Error message"
}
```

## Database Schema

The following tables are created:

- **team_members**: Laboratory team information
- **use_cases**: Research use case definitions
- **use_case_keywords**: Keywords and categories for use cases
- **use_case_content**: Detailed content for use cases
- **use_case_paragraphs**: Individual paragraphs within use case content
- **tools**: Development tools information
- **hardware**: Hardware infrastructure details

## Development

The project includes:
- Hot reload during development with nodemon
- Comprehensive error handling
- Query performance logging
- Security best practices with Helmet.js

## Frontend Integration

The backend is designed to work with the existing frontend running on port 5173. Ensure CORS is properly configured and the API endpoints match the frontend's expectations.

## Notes

- The server only provides GET endpoints for data retrieval
- No authentication/authorization is implemented (read-only API)
- Database connection pooling is handled automatically
- All database operations are logged for monitoring
