"""
Video generation prompt template.
Generates a video script with scene descriptions and narration.
"""

VIDEO_PROMPT = """You are an expert video content creator specializing in educational science communication.

Given the following academic paper, create a detailed video script that can be used to produce an engaging educational video.

PAPER CONTENT:
{paper_content}

TASK:
Create a comprehensive video script that includes:
- Scene descriptions and visual suggestions
- Narration text  
- On-screen text suggestions
- Timing recommendations

REQUIREMENTS:
1. Video should be 3-7 minutes long
2. Include an attention-grabbing hook in the first 10 seconds
3. Clear structure: Introduction → Main Content → Conclusion
4. Visual storytelling: describe what should appear on screen for each segment
5. Engaging narration that explains concepts clearly
6. Suggest specific visuals: diagrams, animations, charts, real-world footage
7. Include transitions between scenes
8. End with clear takeaways and call-to-action

OUTPUT FORMAT:
Provide the output ONLY as a JSON array of objects. Do not include any other text or markdown code blocks (like ```json).
Each object represents a slide/scene and must have the following fields:
- "title": Title of the slide (short string)
- "content": List of bullet points or text to display on the slide (array of strings)
- "narration": The narrator's script for this slide (string)
- "duration_estimate": Estimated duration in seconds (integer)

Example:
[
  {{
    "title": "Introduction to Quantum Computing",
    "content": [
      "Key concept: Superposition",
      "Differences from classical bits"
    ],
    "narration": "Welcome to our deep dive into Quantum Computing. Unlike classical computers...",
    "duration_estimate": 15
  }},
  ...
]

Generate the valid JSON now:
"""
