"""
Report generation prompt template.
Generates complete HTML+CSS research report with professional layout.
"""

REPORT_PROMPT = """You are an expert academic writer and web designer who creates beautifully formatted HTML research reports.

Given the following academic paper, create a COMPLETE, STANDALONE HTML research report with custom CSS styling that presents a comprehensive analysis in a professional, readable format.

PAPER CONTENT:
{paper_content}

TASK:
Create a 1000-1500 word research report as a self-contained HTML document that:
1. Synthesizes and explains the research clearly
2. Has professional academic styling (similar to Medium articles or academic blogs)
3. Uses modern web typography and layout
4. Is well-organized with clear sections
5. Accessible to educated non-specialists

OUTPUT FORMAT:
Return valid JSON with complete HTML:

```json
{{
  "html_content": "<!DOCTYPE html>\\n<html lang=\\"en\\">\\n<head>...</head>\\n<body>...</body>\\n</html>"
}}
```

CRITICAL REQUIREMENTS:
1. **Complete HTML Document**: Full HTML5 from <!DOCTYPE> to </html>
2. **Embedded CSS**: All styles in <style> tag, no external files
3. **Professional Typography**: Clear hierarchy, readable fonts (18px+ for body)
4. **Responsive Layout**: Max-width container, good line-height (1.6-1.8)
5. **Academic Styling**: Clean, professional, similar to research blogs or article sites
6. **Self-Contained**: No external dependencies or CDN links
7. **Print-Friendly**: Should look good if printed or saved as PDF

REPORT STRUCTURE:
1. **Header**: Paper title, authors (if mentioned), publication info
2. **Executive Summary**: 2-3 paragraph overview
3. **Background and Context**: Problem space, significance, prior work
4. **Research Objectives**: Research questions/hypotheses
5. **Methodology**: Research approach and methods (in accessible terms)
6. **Key Findings**: Main results and discoveries
7. **Discussion and Implications**: Significance, applications, impact
8. **Limitations and Future Work**: Acknowledged limitations, future directions
9. **Conclusion**: Main takeaways and contribution
10. **Glossary** (optional): Technical terms defined

DESIGN GUIDELINES:
- **Typography**: Use system fonts like 'Georgia', 'Merriweather', or serif fonts for body; sans-serif for headings
- **Colors**: Professional palette - dark text on light background, subtle accent colors
- **Spacing**: Generous margins, line-spacing 1.6-1.8, sections clearly separated
- **Layout**: Centered container (max-width: 800-900px), single column
- **Headings**: Clear hierarchy (h1, h2, h3) with different sizes and spacing
- **Sections**: Visual separation with spacing or subtle borders
- **Readability**: 18-20px body text, 65-75 characters per line max

HTML STRUCTURE TEMPLATE:
```html
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>[Paper Title] - Research Report</title>
  <style>
    * {{ margin: 0; padding: 0; box-sizing: border-box; }}
    
    body {{
      font-family: Georgia, 'Times New Roman', serif;
      line-height: 1.7;
      color: #2d3748;
      background: #f7fafc;
      padding: 40px 20px;
    }}
    
    .container {{
      max-width: 850px;
      margin: 0 auto;
      background: white;
      padding: 60px 80px;
      box-shadow: 0 4px 6px rgba(0,0,0,0.07);
      border-radius: 8px;
    }}
    
    h1 {{
      font-size: 2.5rem;
      font-weight: 700;
      color: #1a202c;
      margin-bottom: 10px;
      line-height: 1.2;
      font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
    }}
    
    .meta {{
      color: #718096;
      font-size: 0.95rem;
      margin-bottom: 30px;
      padding-bottom: 20px;
      border-bottom: 2px solid #e2e8f0;
    }}
    
    h2 {{
      font-size: 1.8rem;
      font-weight: 600;
      color: #2d3748;
      margin-top: 40px;
      margin-bottom: 20px;
      font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
    }}
    
    h3 {{
      font-size: 1.3rem;
      font-weight: 600;
      color: #4a5568;
      margin-top: 30px;
      margin-bottom: 15px;
    }}
    
    p {{
      font-size: 1.1rem;
      margin-bottom: 18px;
      text-align: justify;
    }}
    
    .executive-summary {{
      background: #edf2f7;
      padding: 30px;
      border-left: 4px solid #4299e1;
      margin: 30px 0;
      font-size: 1.05rem;
    }}
    
    .section {{
      margin-bottom: 40px;
    }}
    
    ul, ol {{
      margin-left: 30px;
      margin-bottom: 20px;
    }}
    
    li {{
      font-size: 1.05rem;
      margin-bottom: 10px;
      line-height: 1.6;
    }}
    
    .glossary {{
      background: #f7fafc;
      padding: 25px;
      border-radius: 6px;
      margin-top: 40px;
    }}
    
    .glossary dt {{
      font-weight: 600;
      color: #2d3748;
      margin-top: 15px;
    }}
    
    .glossary dd {{
      margin-left: 20px;
      margin-bottom: 10px;
      color: #4a5568;
    }}
    
    @media print {{
      body {{ background: white; padding: 0; }}
      .container {{ box-shadow: none; padding: 40px; }}
    }}
  </style>
</head>
<body>
  <div class="container">
    <h1>[Paper Title]</h1>
    <div class="meta">
      <p><strong>Authors:</strong> [Author names if available]</p>
      <p><strong>Report Generated:</strong> [Date]</p>
    </div>
    
    <div class="executive-summary">
      <h2>Executive Summary</h2>
      <p>[Summary paragraph 1]</p>
      <p>[Summary paragraph 2]</p>
    </div>
    
    <div class="section">
      <h2>Background and Context</h2>
      <p>[Content...]</p>
    </div>
    
    <!-- More sections... -->
    
    <div class="glossary">
      <h2>Technical Terms Glossary</h2>
      <dl>
        <dt>Term 1</dt>
        <dd>Definition...</dd>
      </dl>
    </div>
  </div>
</body>
</html>
```

STYLE GUIDELINES:
- Clear, professional academic language
- Avoid excessive jargon; define technical terms
- Use active voice where possible
- Include specific examples and data
- Maintain objectivity while highlighting significance
- Smooth transitions between sections
- 1000-1500 words total

**JSON OUTPUT FORMAT:**
- Escape all quotes with backslash (\\")
- Use \\n for new lines
- Ensure valid JSON structure
- Make the design clean and professional!

Generate the complete HTML research report now as valid JSON:
"""

