"""
Quiz generation prompt template.
Generates assessment questions to test understanding.
"""

QUIZ_PROMPT = """You are an expert educational assessment designer specializing in creating effective quizzes for academic content.

Given the following academic paper, create a comprehensive quiz that tests understanding at multiple levels, from basic comprehension to critical analysis.

PAPER CONTENT:
{paper_content}

TASK:
Create a 10-12 question quiz covering the key aspects of the paper, including:
- Multiple choice questions (7-9 questions)
- True/False questions (2-3 questions)
- Short answer questions (1 question)

REQUIREMENTS:
1. Questions should span Bloom's Taxonomy levels:
   - Remember: Recall facts and basic concepts
   - Understand: Explain ideas and concepts
   - Apply: Use information in new situations
   - Analyze: Draw connections and distinguish between ideas
   - Evaluate: Justify decisions and critique ideas
2. Multiple choice: One clearly correct answer, 3-4 plausible distractors
3. Distractors should reflect common misconceptions or partial understanding
4. Mix difficulty levels: 40% basic, 40% intermediate, 20% advanced
5. Cover all major sections of the paper
6. Include questions about methodology, findings, and implications
7. Avoid trivial or overly specific questions

OUTPUT FORMAT:
Provide the quiz in JSON format:

```json
{{
  "quiz": {{
    "title": "Quiz: [Paper Title]",
    "description": "Assessment covering key concepts from the research paper",
    "total_questions": 10,
    "questions": [
      {{
        "id": 1,
        "type": "multiple_choice",
        "difficulty": "basic",
        "bloom_level": "remember",
        "question": "What was the primary research question addressed in this study?",
        "options": [
          "Option A (correct answer)",
          "Option B (plausible distractor)",
          "Option C (plausible distractor)",
          "Option D (plausible distractor)"
        ],
        "correct_answer": "A",
        "explanation": "Brief explanation of why this is correct and why other options are wrong.",
        "hint": "Think about the main objective stated in the abstract.",
        "points": 1
      }},
      {{
        "id": 2,
        "type": "true_false",
        "difficulty": "intermediate",
        "bloom_level": "understand",
        "question": "The researchers used a randomized controlled trial design.",
        "correct_answer": true,
        "explanation": "Explanation of the answer with reference to the methodology section.",
        "points": 1
      }},
      {{
        "id": 3,
        "type": "short_answer",
        "difficulty": "advanced",
        "bloom_level": "analyze",
        "question": "Explain how the findings of this study challenge or support previous research in this field.",
        "sample_answer": "A comprehensive sample answer showing what a good response would include.",
        "grading_rubric": "Key points that should be included in the answer.",
        "points": 3
      }},
      ...
    ]
  }}
}}
```

QUESTION TYPES AND DISTRIBUTION:

Multiple Choice (60-75%):
- Test understanding of key concepts
- Assess ability to apply knowledge
- Check comprehension of methodology and results
- Require analysis of implications

True/False (15-25%):
- Verify understanding of key facts
- Check for common misconceptions
- Test comprehension of relationships

Short Answer (10-15%):
- Require synthesis of multiple concepts
- Assess critical thinking
- Evaluate ability to explain in own words

DIFFICULTY LEVELS:
- Basic (40%): Direct recall or recognition from the paper
- Intermediate (40%): Requires understanding and application
- Advanced (20%): Requires analysis, synthesis, or evaluation

STYLE GUIDELINES:
- Questions should be clear and unambiguous
- Avoid "trick" questions
- Distractors should be plausible but clearly wrong
- Explanations should educate, not just indicate correct answers
- Cover breadth of paper while focusing on key insights
- Use proper academic language
- Ensure questions are fair and answerable from the paper content

Generate the complete quiz in JSON format now:
"""
