"""
Presentation generation prompt template.
Generates complete HTML+CSS presentation with custom design.
"""

PRESENTATION_PROMPT = """You are an expert presentation designer and web developer who creates stunning, interactive HTML presentations for academic research.

Given the following academic paper, create a COMPLETE, STANDALONE HTML presentation with custom CSS styling that effectively communicates the research in a visually engaging way.

PAPER CONTENT:
{paper_content}

TASK:
Create a 10-15 slide HTML presentation (like reveal.js or a modern slide deck) that:
1. Tells the research story clearly and engagingly
2. Has a unique visual design tailored to the paper's topic
3. Uses modern web design techniques (gradients, animations, responsive layouts)
4. Includes appropriate slides: title, problem, methodology, results, conclusion
5. Is interactive and can be navigated with arrow keys or click

OUTPUT FORMAT:
Return valid JSON with complete HTML:

```json
{{
  "html_content": "<!DOCTYPE html>\\n<html lang=\\"en\\">\\n<head>...</head>\\n<body>...</body>\\n</html>"
}}
```

CRITICAL REQUIREMENTS:
1. **Complete HTML Document**: Full HTML5 from <!DOCTYPE> to </html>
2. **Embedded CSS**: All styles in <style> tag, no external files
3. **Slide Navigation**: Include JavaScript for keyboard/click navigation
4. **Responsive Design**: Must work on different screen sizes
5. **Modern Aesthetics**: Use gradients, shadows, smooth transitions
6. **Self-Contained**: No CDN links, no external dependencies
7. **Professional Typography**: Clear, readable fonts

DESIGN GUIDELINES BY TOPIC:
- **AI/ML/Computing**: Tech-forward with blues, purples, cyans, geometric patterns
- **Biology/Medical**: Organic colors (greens, teals), clean layouts
- **Physics/Engineering**: Structured, precise with navy, orange, technical feel
- **Data Science**: Vibrant multi-color palettes, chart-inspired designs

SLIDE STRUCTURE:
- Slide 1: Title slide with compelling header and subtitle
- Slide 2-3: Problem/Background with context and motivation
- Slide 4: Research Question (centered, impactful)
- Slide 5-6: Methodology (visual workflow/process)
- Slide 7-9: Key Findings/Results (data visualizations, comparisons)
- Slide 10: Implications/Applications
- Slide 11: Conclusion/Key Takeaways
- Slide 12: Thank You / Q&A

HTML STRUCTURE TEMPLATE:
```html
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>[Paper Title]</title>
  <style>
    * {{ margin: 0; padding: 0; box-sizing: border-box; }}
    
    body {{
      font-family: 'Inter', 'Segoe UI', sans-serif;
      background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
      overflow: hidden;
    }}
    
    .presentation {{
      width: 100vw;
      height: 100vh;
      position: relative;
    }}
    
    .slide {{
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      display: none;
      padding: 60px;
      background: white;
    }}
    
    .slide.active {{
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      animation: slideIn 0.5s ease-out;
    }}
    
    @keyframes slideIn {{
      from {{ opacity: 0; transform: translateY(30px); }}
      to {{ opacity: 1; transform: translateY(0); }}
    }}
    
    /* Custom styles for different slide types */
    .slide.title {{
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
    }}
    
    .slide h1 {{ font-size: 3.5rem; margin-bottom: 20px; }}
    .slide h2 {{ font-size: 2.5rem; margin-bottom: 20px; color: #333; }}
    .slide p {{ font-size: 1.3rem; line-height: 1.6; }}
    
    /* Navigation controls */
    .controls {{
      position: fixed;
      bottom: 30px;
      right: 30px;
      display: flex;
      gap: 10px;
    }}
    
    .nav-btn {{
      background: rgba(0,0,0,0.3);
      color: white;
      border: none;
      padding: 15px 20px;
      cursor: pointer;
      border-radius: 5px;
      font-size: 18px;
    }}
    
    .nav-btn:hover {{
      background: rgba(0,0,0,0.5);
    }}
    
    .progress-bar {{
      position: fixed;
      bottom: 0;
      left: 0;
      height: 4px;
      background: #667eea;
      transition: width 0.3s;
    }}
  </style>
</head>
<body>
  <div class="presentation">
    <!-- Slide 1: Title -->
    <div class="slide title active" data-slide="1">
      <h1>[Compelling Title]</h1>
      <p class="subtitle">[Subtitle/Key Insight]</p>
    </div>
    
    <!-- Slide 2-12: Add more slides here -->
    <div class="slide" data-slide="2">
      <h2>The Problem</h2>
      <p>[Problem description]</p>
    </div>
    
    <!-- ... more slides ... -->
  </div>
  
  <div class="controls">
    <button class="nav-btn" onclick="prevSlide()">← Prev</button>
    <button class="nav-btn" onclick="nextSlide()">Next →</button>
  </div>
  
  <div class="progress-bar" id="progress"></div>
  
  <script>
    let currentSlide = 1;
    const totalSlides = document.querySelectorAll('.slide').length;
    
    function showSlide(n) {{
      const slides = document.querySelectorAll('.slide');
      if (n > totalSlides) currentSlide = totalSlides;
      if (n < 1) currentSlide = 1;
      
      slides.forEach(slide => slide.classList.remove('active'));
      slides[currentSlide - 1].classList.add('active');
      
      updateProgress();
    }}
    
    function nextSlide() {{
      currentSlide++;
      if (currentSlide > totalSlides) currentSlide = totalSlides;
      showSlide(currentSlide);
    }}
    
    function prevSlide() {{
      currentSlide--;
      if (currentSlide < 1) currentSlide = 1;
      showSlide(currentSlide);
    }}
    
    function updateProgress() {{
      const progress = (currentSlide / totalSlides) * 100;
      document.getElementById('progress').style.width = progress + '%';
    }}
    
    // Keyboard navigation
    document.addEventListener('keydown', (e) => {{
      if (e.key === 'ArrowRight' || e.key === ' ') nextSlide();
      if (e.key === 'ArrowLeft') prevSlide();
    }});
    
    updateProgress();
  </script>
</body>
</html>
```

**IMPORTANT DESIGN REQUIREMENTS:**
1. Each slide should be unique and visually interesting
2. Use appropriate colors based on the research field
3. Include visual elements (gradients, shapes, icons using emoji/unicode)
4. Keep text concise - slides should be scannable
5. Add smooth transitions between slides
6. Make the design modern and professional
7. Ensure good contrast for readability

**JSON OUTPUT FORMAT:**
- Escape all quotes with backslash (\\")
- Use \\n for new lines
- Ensure valid JSON structure
- Be CREATIVE - make the design match the paper's theme!

Generate the complete HTML presentation now as valid JSON:
"""

