"""
Mental Map (Mind Map) generation prompt template.
Generates a structured mind map representation of the paper.
"""

MENTAL_MAP_PROMPT = """You are an expert in knowledge visualization and mind mapping for academic content.

Given the following academic paper, create a comprehensive mind map structure that visually organizes the key concepts, relationships, and hierarchy of information.

PAPER CONTENT:
{paper_content}

TASK:
Create a detailed mind map structure that captures:
- Central topic/research question
- Major themes and subtopics
- Key concepts and their relationships
- Hierarchical organization of ideas
- Important findings and conclusions

REQUIREMENTS:
1. Use a clear hierarchical structure (central node → main branches → sub-branches → details)
2. Identify 4-8 main branches representing major themes
3. Each main branch should have 2-6 sub-branches
4. Include specific details, data points, or examples as leaf nodes
5. Show connections between related concepts across different branches
6. Use concise phrases (3-7 words) for each node
7. Indicate the type of relationship where applicable (causes, supports, contradicts, etc.)

OUTPUT FORMAT:
Provide the mind map in a structured text format that can be easily converted to visual diagrams:

CENTRAL NODE: [Main research topic/question]

BRANCH 1: [Main theme]
  └─ Sub-branch 1.1: [Subtopic]
     └─ Detail: [Specific point]
     └─ Detail: [Specific point]
  └─ Sub-branch 1.2: [Subtopic]
     └─ Detail: [Specific point]
  [CONNECTION to Branch 3, Sub-branch 3.2]: [Relationship type]

BRANCH 2: [Main theme]
  └─ Sub-branch 2.1: [Subtopic]
     └─ Detail: [Specific point]
  ...

Also provide a Markdown format version suitable for Markmap visualization.
Use standard Markdown headers (#, ##, ###) for hierarchy and list items (-) for details.

```markdown
# [Central Research Topic]

## [Main Theme 1]
- [Subtopic 1.1]
  - [Detail]
  - [Detail]
- [Subtopic 1.2]

## [Main Theme 2]
- [Subtopic 2.1]
...
```

STYLE GUIDELINES:
- Keep labels concise and informative
- Group related concepts together
- Use clear hierarchical levels
- Indicate cross-connections that show how ideas relate
- Highlight key findings or novel contributions
- Make the structure easy to scan visually

Generate the complete mind map now:
"""
