"""
Infographic generation prompt template.
Generates complete HTML+CSS infographics with creative designs.
"""

INFOGRAPHIC_PROMPT = """You are an expert information designer and web developer who creates stunning, interactive infographics for academic research papers.

Given the following academic paper, create a complete, standalone HTML infographic that visually communicates the key insights, methodology, results, and impact of the research.

PAPER CONTENT:
{paper_content}

YOUR TASK:
Create a complete HTML file with embedded CSS that presents the research as a visually engaging infographic. The infographic should:

1. **Extract Key Information**:
   - Main research question or problem
   - Proposed solution or methodology
   - Key findings and results
   - Important metrics, comparisons, or statistics
   - Impact and significance

2. **Design Philosophy**:
   - Create a UNIQUE, creative design for each paper - DO NOT use templates
   - The design should reflect the paper's theme (e.g., AI/ML topics use tech-inspired designs, medical research uses clean/clinical styles)
   - Use modern web design techniques: gradients, glassmorphism, animations, data visualizations
   - Be visually stunning and professional
   - Make complex information easily digestible through visual hierarchy

3. **Layout Options** (choose the most appropriate):
   - **Vertical scrolling infographic**: Timeline-style, sections flow from top to bottom
   - **Comparison layout**: Side-by-side panels showing before/after, traditional vs. novel approach
   - **Process/Pipeline visualization**: Show methodology as a flow diagram
   - **Data dashboard**: If the paper has many statistics, present them as cards/widgets
   - **Story-driven**: Narrative structure with visual storytelling elements

4. **Visual Elements to Include**:
   - Eye-catching header with the research title
   - Icons, emojis, or SVG illustrations relevant to the content
   - Data visualizations (use CSS for simple charts, bars, or creative representations)
   - Color-coded sections for different aspects (problem, method, results, impact)
   - Statistics presented in large, bold numbers with context
   - Responsive design that works on mobile and desktop

5. **Design Requirements**:
   - Use vibrant, thematic color palettes (not generic red/blue/green)
   - Implement smooth transitions or subtle animations
   - Modern typography from Google Fonts
   - Clean, organized visual hierarchy
   - Glassmorphism, gradients, or modern design trends
   - Non-academic audiences should be able to understand it

OUTPUT FORMAT:
You MUST respond with valid JSON in this exact structure:

```json
{{
  "html_content": "<!DOCTYPE html><html>...complete HTML file with embedded CSS...</html>"
}}
```

CRITICAL REQUIREMENTS:
- The `html_content` field MUST contain a complete, valid HTML document
- All CSS must be embedded in a <style> tag - NO external stylesheets
- The HTML must be self-contained and work when opened directly in a browser
- Be creative with the design - each infographic should look unique
- Do NOT use lorem ipsum or placeholder content - extract real information from the paper
- The design should WOW the viewer

DESIGN INSPIRATION:
- Modern data journalism (The Pudding, Reuters Graphics)
- Tech company infographics (Stripe, Vercel design philosophies)
- Award-winning information design
- Premium web design trends (2024+)

Generate the complete HTML infographic now:
"""

