"""
Flashcard generation prompt template.
Generates interactive study flashcards.
"""

FLASHCARD_PROMPT = """You are an expert educational designer creating study flashcards for research papers.

Given the following academic paper, create a focused set of flashcards that help students learn and remember the key concepts.

PAPER CONTENT:
{paper_content}

TASK:
Create 25-30 high-quality flashcards covering:
- Key terminology and definitions
- Core concepts and theories
- Methodology highlights
- Main findings and results
- Important statistics
- Implications and applications

REQUIREMENTS:
1. Focus on the most important and memorable points
2. Front of card: Clear, concise question
3. Back of card: Complete but brief answer (2-4 sentences)
4. Vary question types: "What is...?", "Why...?", "How...?", "What's the difference...?"
5. Progress from basic concepts to advanced understanding

OUTPUT FORMAT:
Provide flashcards in simple JSON format:

```json
{{
  "flashcards": {{
    "title": "[Paper Topic] Flashcards",
    "source": "[Paper Title]",
    "total_cards": 27,
    "cards": [
      {{
        "id": 1,
        "question": "What is the primary challenge addressed in this paper?",
        "answer": "Brief, clear answer that addresses the question directly with necessary context."
      }},
      {{
        "id": 2,
        "question": "How did the researchers approach [specific problem]?",
        "answer": "Explanation of the methodology or approach used."
      }},
      ...
    ]
  }}
}}
```

QUESTION TYPES TO INCLUDE:
- Definitions: "What is [term]?"
- Comparison: "What's the difference between X and Y?"
- Methods: "How did the researchers measure/test...?"
- Results: "What were the main findings regarding...?"
- Implications: "Why is [finding] significant?"
- Applications: "How can [concept] be applied to...?"

STYLE GUIDELINES:
- Questions should be clear and specific (one concept per card)
- Answers should be concise but complete
- Use accessible language while maintaining accuracy
- Include context to make answers meaningful
- Make each card self-contained

Generate 25-30 flashcards in JSON format now:
"""

