"""
Data Table generation prompt template.
Extracts and formats key data tables from research papers.
"""

DATATABLE_PROMPT = """You are an expert data analyst who extracts structured tables from academic papers.

Given the following academic paper, identify and extract the MOST IMPORTANT data table that contains key experimental results, performance metrics, or comparative data.

PAPER CONTENT:
{paper_content}

TASK:
Extract the single most informative table from the paper. This should be a table that contains:
- Experimental results
- Performance comparisons
- Key metrics and measurements
- OR comparative analysis

If multiple important tables exist, choose the one with the most critical findings.

REQUIREMENTS:
1. Extract the actual table structure from the paper
2. Preserve column headers exactly as they appear
3. Include all data rows
4. Maintain units of measurement (MB, μJ, %, etc.)
5. Preserve scientific notation (10³, 10⁵, etc.)
6. Keep special symbols (±, ×, μ, etc.)
7. Add a descriptive title for the table
8. Include footnotes/sources if present in the original

OUTPUT FORMAT:
Provide the table in simple JSON format:

```json
{{
  "datatable": {{
    "title": "Exact title describing the table content",
    "subtitle": "Based on [source/section name if applicable]",
    "description": "Brief 1-sentence description of what this table shows",
    "headers": [
      "Column1 Name",
      "Column2 Name (Unit)",
      "Column3 Name",
      ...
    ],
    "rows": [
      ["Row1Col1", "Row1Col2", "Row1Col3", ...],
      ["Row2Col1", "Row2Col2", "Row2Col3", ...],
      ...
    ],
    "footer": "Notes, sources, or footnotes from the original table"
  }}
}}
```

SPECIAL FORMATTING RULES:
- Use HTML entities for special characters:
  - Superscripts: 10³ → "10³" (use Unicode superscripts)
  - Subscripts: H₂O → "H₂O" (use Unicode subscripts)
  - Greek letters: μ, α, β, γ, δ, ε, θ, λ, π, σ, ω (use Unicode)
  - Math symbols: ±, ×, ÷, ≤, ≥, ≈, ∞
  - Arrows: →, ←, ↑, ↓
- Keep values with units together: "50.66 μJ", "0.36 MB"
- Preserve ± notation: "96.42 ± 0.03"
- Use scientific notation: "4.25 × 10⁵"

EXAMPLE (based on your screenshot):
```json
{{
  "datatable": {{
    "title": "Neural Network Performance Metrics for Human Activity Recognition",
    "subtitle": "Based on 1 source",
    "description": "Comparison of various neural network architectures for HAR tasks",
    "headers": [
      "Network Architecture",
      "Test Accuracy (%)",
      "Number of Parameters",
      "Memory Footprint (MB)",
      "Operations (FLOPs/SOPs)",
      "Energy Consumption (inferred)",
      "Deployment Hardware",
      "Source"
    ],
    "rows": [
      ["LSTM", "96.42 ± 0.03", "2,125,222", "8.50", "4,249.65 × 10⁵ (FLOPs)", "3199.99 μJ", "Intel Movidius Neural Compute Stick 2", "[1]"],
      ["sLMU", "94.51 ± 0.15", "91,200", "0.36", "99.91 × 10³ (SOPs)", "50.66 μJ", "Intel Loihi", "[1]"]
    ],
    "footer": "[1] Neuromorphic_HAR_Polito.pdf"
  }}
}}
```

COMMON ACADEMIC SYMBOLS TO USE:
- Superscripts: ⁰ ¹ ² ³ ⁴ ⁵ ⁶ ⁷ ⁸ ⁹ ⁺ ⁻ ⁼ ⁽ ⁾
- Subscripts: ₀ ₁ ₂ ₃ ₄ ₅ ₆ ₇ ₈ ₉ ₊ ₋ ₌ ₍ ₎
- Greek: α β γ δ ε ζ η θ ι κ λ μ ν ξ π ρ σ τ υ φ χ ψ ω
- Math: ± × ÷ √ ∞ ≈ ≠ ≤ ≥ ∑ ∏ ∫ ∂
- Arrows: → ← ↑ ↓ ↔ ⇒ ⇐

Extract the most important table from the paper now:
"""

