"""
Audio generation prompt template.
Generates a conversational dialogue script for podcast/audio format.
"""

AUDIO_PROMPT = """You are an expert podcast producer. I need you to create a script for a "Deep Dive" style podcast where two hosts discuss an academic paper.

PAPER CONTENT:
{paper_content}

CHARACTERS:
1. "Host" (Male): The curious, enthusiastic layperson. He asks the "dumb" questions that the audience is thinking. He uses analogies, reacts with "Wow" or "No way", and drives the conversation forward.
2. "Guest" (Female): The academic expert. She is patient, articulate, and explains complex concepts clearly but without being condescending. She often says "Exactly" or "That's a great point".

TASK:
Create a lively, natural conversation script between these two.

REQUIREMENTS:
1. **Format**: JSON Array ONLY. NO markdown blocks (```json).
2. **Structure**: 
   - [Hook] Start with a surprising fact or question from the paper.
   - [Deep Dive] Explain the "Why" and "How" of the research.
   - [Implications] Why does this matter to the real world?
3. **Tone**: High energy, "NPR meets YouTube Explainer". It should NOT sound like reading a paper. Use interjections like "Wait, hang on...", "Okay, so you're saying...", "[laughs]".

OUTPUT FORMAT EXAMPLE:
[
  {{
    "speaker": "Host",
    "text": "Welcome back! Today we are talking about something that honestly blew my mind."
  }},
  {{
    "speaker": "Guest",
    "text": "I know, right? This paper changes how we think about deep learning."
  }},
  {{
    "speaker": "Host",
    "text": "Wait, really? I thought deep learning was already solved!"
  }}
]

Generate the JSON script now:
"""
