"""
Main entry point - Lightweight CLI for the content generation system.

For programmatic usage, import ContentAutoGenerator directly:
    from ContentAutoGenerator import ContentAutoGenerator
"""
import sys
import argparse

from ContentAutoGenerator import ContentAutoGenerator


def main():
    """Test configuration - 直接配置测试参数"""
    
    pdf_path = "/Users/wuyuxuan/Desktop/3700666.3700694.pdf"
    types = ["infographic"] 
    output_dir = "./outputs"
    llm_provider = "google"
    
    try:
        generator = ContentAutoGenerator(
            pdf_path=pdf_path,
            resource_types=types,
            output_dir=output_dir,
            llm_provider=llm_provider
        )
        
        generator.run()
        
    except FileNotFoundError as e:
        print(f"Error: {e}", file=sys.stderr)
        sys.exit(1)
    except KeyboardInterrupt:
        print("\nGeneration interrupted by user", file=sys.stderr)
        sys.exit(1)
    except Exception as e:
        print(f"Fatal error: {e}", file=sys.stderr)
        import traceback
        traceback.print_exc()
        sys.exit(1)


if __name__ == '__main__':
    main()
