"""
Upload routes - Handle file uploads.
"""

import os
import uuid
from flask import Blueprint, request, jsonify
from werkzeug.utils import secure_filename
from config import Config

upload_bp = Blueprint('upload', __name__)

ALLOWED_EXTENSIONS = {'png', 'jpg', 'jpeg', 'gif', 'webp', 'pdf', 'doc', 'docx', 'ppt', 'pptx', 'xls', 'xlsx', 'mp3', 'mp4', 'mov', 'wav'}
UPLOAD_FOLDER = Config.UPLOAD_FOLDER

def allowed_file(filename):
    return '.' in filename and \
           filename.rsplit('.', 1)[1].lower() in ALLOWED_EXTENSIONS

@upload_bp.route('/upload', methods=['POST'])
def upload_file():
    """
    Upload a file.
    Expects 'file' in multipart/form-data.
    Optional 'folder' param (default 'common').
    Returns {'url': '/folder/uuid.ext'}
    """
    if 'file' not in request.files:
        return jsonify({'error': 'No file part'}), 400
    
    file = request.files['file']
    
    if file.filename == '':
        return jsonify({'error': 'No selected file'}), 400
        
    if file and allowed_file(file.filename):

        # Flattened structure: Save directly to UPLOAD_FOLDER
        save_dir = UPLOAD_FOLDER
        os.makedirs(save_dir, exist_ok=True)
        
        # Generate UUID filename
        ext = file.filename.rsplit('.', 1)[1].lower()
        new_filename = f"{uuid.uuid4()}.{ext}"
        
        file.save(os.path.join(save_dir, new_filename))
        
        # Return filename only (as per new DB schema)
        url = new_filename
        return jsonify({'url': url}), 201
        
    return jsonify({'error': 'File type not allowed'}), 400
