"""
Database connection utility module.
"""

import psycopg2
from psycopg2.extras import RealDictCursor
from config import Config


def get_db_connection():
    """
    Create and return a database connection.
    
    Returns:
        psycopg2.connection: Database connection object.
    """
    conn = psycopg2.connect(
        host=Config.DB_HOST,
        port=Config.DB_PORT,
        user=Config.DB_USER,
        password=Config.DB_PASSWORD,
        database=Config.DB_NAME,
        cursor_factory=RealDictCursor
    )
    return conn
