import { createBrowserRouter, Navigate } from 'react-router-dom';
import { MainLayout } from '../layouts';
import Publication from '../pages/Publication';
import { UseCases, UseCasesFilters } from '../pages/UseCases';
import TeamMember from '../pages/TeamMember';
import Hardware from '../pages/Hardware';
import Tools from '../pages/Tools';

const router = createBrowserRouter([
    {
        path: '/',
        element: <MainLayout />,
        children: [
            {
                index: true,
                element: <Navigate to="/publication" replace />,
            },
            {
                path: 'publication',
                element: <Publication />,
            },
            {
                path: 'use-cases',
                element: <UseCases />,
            },
            {
                path: 'use-cases/filters',
                element: <UseCasesFilters />,
            },
            {
                path: 'team-member',
                element: <TeamMember />,
            },
            {
                path: 'hardware',
                element: <Hardware />,
            },
            {
                path: 'tools',
                element: <Tools />,
            },
        ],
    },
]);

export default router;
