import React from 'react';
import styles from './Placeholder.module.css';

interface PlaceholderProps {
    title: string;
}

const Placeholder: React.FC<PlaceholderProps> = ({ title }) => {
    return (
        <div className={styles.placeholder}>
            <div className={styles.placeholder__icon}>
                <svg viewBox="0 0 24 24">
                    <path d="M12 2v4M12 18v4M4.93 4.93l2.83 2.83M16.24 16.24l2.83 2.83M2 12h4M18 12h4M4.93 19.07l2.83-2.83M16.24 7.76l2.83-2.83" />
                </svg>
            </div>
            <h2 className={styles.placeholder__title}>{title}</h2>
            <p className={styles.placeholder__subtitle}>This page is under development</p>
        </div>
    );
};

export default Placeholder;
