import React from 'react';
import styles from './Dashboard.module.css';

const Dashboard: React.FC = () => {
    const stats = [
        { label: 'Total Users', value: '1,234', change: '+12%' },
        { label: 'Active Sessions', value: '567', change: '+8%' },
        { label: 'Data Records', value: '45,678', change: '+24%' },
        { label: 'Reports Generated', value: '89', change: '+5%' },
    ];

    return (
        <div className={styles.dashboard}>
            <div className={styles.dashboard__welcome}>
                <h1 className={styles['dashboard__welcome-title']}>Welcome to Admin Panel!</h1>
                <p className={styles['dashboard__welcome-subtitle']}>
                    Manage your database and view system information here.
                </p>
            </div>

            <h2 className={styles.dashboard__title}>Overview</h2>

            <div className={styles.dashboard__stats}>
                {stats.map((stat, index) => (
                    <div key={index} className={styles['dashboard__stat-card']}>
                        <div className={styles['dashboard__stat-label']}>{stat.label}</div>
                        <div className={styles['dashboard__stat-value']}>{stat.value}</div>
                        <div className={styles['dashboard__stat-change']}>
                            <span>↑</span>
                            <span>{stat.change} from last month</span>
                        </div>
                    </div>
                ))}
            </div>
        </div>
    );
};

export default Dashboard;
