import React from 'react';
import { Outlet } from 'react-router-dom';
import Header from '../components/Header';
import Sidebar from '../components/Sidebar';
import styles from './MainLayout.module.css';

const MainLayout: React.FC = () => {
    return (
        <div className={styles.layout}>
            <Sidebar />
            <Header />
            <main className={styles.layout__main}>
                <div className={styles.layout__content}>
                    <Outlet />
                </div>
            </main>
        </div>
    );
};

export default MainLayout;
