# 《中小学校设计规范》GB50099-2011

**住房和城乡建设部**  
上传时间：2025-02-18  
实施时间：2012-01-01

## 目录
1. [总 则](#1-总-则)
2. [术 语](#2-术-语)
3. [基本规定](#3-基本规定)
4. [场地和总平面](#4-场地和总平面)
    4.1. [场 地](#41-场-地)
    4.2. [用 地](#42-用-地)
    4.3. [总 平 面](#43-总-平-面)
5. [教学用房及教学辅助用房](#5-教学用房及教学辅助用房)
    5.1. [一般规定](#51-一般规定)
    5.2. [普通教室](#52-普通教室)
    5.3. [科学教室、实验室](#53-科学教室实验室)
    5.4. [史地教室](#54-史地教室)
    5.5. [计算机教室](#55-计算机教室)
    5.6. [语言教室](#56-语言教室)
    5.7. [美术教室、书法教室](#57-美术教室书法教室)
    5.8. [音乐教室](#58-音乐教室)
    5.9. [舞蹈教室](#59-舞蹈教室)
    5.10. [体育建筑设施](#510-体育建筑设施)
    5.11. [劳动教室、技术教室](#511-劳动教室技术教室)
    5.12. [合班教室](#512-合班教室)
    5.13. [图 书 室](#513-图-书-室)
    5.14. [学生活动室](#514-学生活动室)
    5.15. [体质测试室](#515-体质测试室)
    5.16. [心理咨询室](#516-心理咨询室)
    5.17. [德育展览室](#517-德育展览室)
    5.18. [任课教师办公室](#518-任课教师办公室)
6. [行政办公用房和生活服务用房](#6-行政办公用房和生活服务用房)
    6.1. [行政办公用房](#61-行政办公用房)
    6.2. [生活服务用房](#62-生活服务用房)
7. [主要教学用房及教学辅助用房面积指标和净高](#7-主要教学用房及教学辅助用房面积指标和净高)
    7.1. [面积指标](#71-面积指标)
    7.2. [净 高](#72-净-高)
8. [安全、通行与疏散](#8-安全通行与疏散)
    8.1. [建筑环境安全](#81-建筑环境安全)
    8.2. [疏散通行宽度](#82-疏散通行宽度)
    8.3. [校园出入口](#83-校园出入口)
    8.4. [校园道路](#84-校园道路)
    8.5. [建筑物出入口](#85-建筑物出入口)
    8.6. [走 道](#86-走-道)
    8.7. [楼 梯](#87-楼-梯)
    8.8. [教室疏散](#88-教室疏散)
9. [室内环境](#9-室内环境)
    9.1. [空气质量](#91-空气质量)
    9.2. [采 光](#92-采-光)
    9.3. [照 明](#93-照-明)
    9.4. [噪声控制](#94-噪声控制)
10. [建筑设备](#10-建筑设备)
    10.1. [采暖通风与空气调节](#101-采暖通风与空气调节)
    10.2. [给水排水](#102-给水排水)
    10.3. [建筑电气](#103-建筑电气)
    10.4. [建筑智能化](#104-建筑智能化)
[本规范用词说明](#本规范用词说明)
[引用标准名录](#引用标准名录)

---

## 1 总 则

**1.0.1** 为使中小学校建设满足国家规定的办学标准，适应建筑安全、适用、经济、绿色、美观的需要，制定本规范。

**1.0.2** 本规范适用于城镇和农村中小学校(含非完全小学)的新建、改建和扩建项目的规划和工程设计。

**1.0.3** 中小学校设计应遵守下列原则：
1. 满足教学功能要求；
2. 有益于学生身心健康成长；
3. 校园本质安全，师生在学校内全过程安全。校园具备国家规定的防灾避难能力；
4. 坚持以人为本、精心设计、科技创新和可持续发展的目标，满足保护环境、节地、节能、节水、节材的基本方针；并应满足有利于节约建设投资，降低运行成本的原则。

**1.0.4** 中小学校的设计除应符合本规范的规定外，尚应符合国家现行有关标准的规定。

## 2 术 语

**2.0.1** 完全小学 elementary school
对儿童、少年实施初等教育的场所，共有6个年级，属义务教育。

**2.0.2** 非完全小学 lower elementary school
对儿童实施初等教育基础教育阶段的场所，设1年级～4年级，属义务教育。

**2.0.3** 初级中学 junior secondary school
对青、少年实施初级中等教育的场所，共有3个年级，属义务教育。

**2.0.4** 高级中学 senior secondary school
对青年实施高级中等教育的场所，共有3个年级。

**2.0.5** 完全中学 secondary school
对青、少年实施中等教育的场所，共有6个年级，含初级中学和高级中学教育的学校。其中，1年级～3年级属义务教育。

**2.0.6** 九年制学校 9-year school
对儿童、青少年连续实施初等教育和初级中等教育的学校，共有9个年级，其中完全小学6个年级，初级中学3个年级。属义务教育。

**2.0.7** 中小学校 school
泛指对青、少年实施初等教育和中等教育的学校，包括完全小学、非完全小学、初级中学、高级中学、完全中学、九年制学校等各种学校。

**2.0.8** 安全设计 safety design
安全设计应包括教学活动的安全保障、自然与人为灾害侵袭下的防御备灾条件、救援疏散时师生的避难条件等。

**2.0.9** 本质安全 intrinsic safety
本质安全是从内在赋予系统安全的属性，由于去除各种早期危险及潜在隐患，从而能保证系统与设施可靠运行。

**2.0.10** 避难疏散场所 disaster shelter for evacuation
用作发生意外灾害时受灾人员疏散的场地和建筑。

**2.0.11** 学校可比总用地 comparable floor area for school
校园中除环形跑道外的用地，与学生总人数成比例增减。

**2.0.12** 学校可比容积率 comparable floor area ratio for school
校园中各类建筑地上总建筑面积与学校可比总用地面积的比值。

**2.0.13** 风雨操场 sports ground with roof
有顶盖的体育场地，包括有顶无围护墙的场地和有顶有围护墙的场馆。

## 3 基本规定

**3.0.1** 各类中小学校建设应确定班额人数，并应符合下列规定：
1. 完全小学应为每班45人，非完全小学应为每班30人；
2. 完全中学、初级中学、高级中学应为每班50人；
3. 九年制学校中1年级～6年级应与完全小学相同，7年级～9年级应与初级中学相同。

**3.0.2** 中小学校建设应为学生身心健康发育和学习创造良好环境。

**3.0.3** 接受残疾生源的中小学校，除应符合本规范的规定外，还应按照现行行业标准《城市道路和建筑物无障碍设计规范》JGJ 50的有关规定设置无障碍设施。

**3.0.4** 校园内给水排水、电力、通信及供热等基础设施应与中小学校主体建筑同步建设，并宜先行施工。

**3.0.5** 中小学校设计应满足国家有关校园安全的规定，并应与校园应急策略相结合。安全设计应包括校园内防火、防灾、安防设施、通行安全、餐饮设施安全、环境安全等方面的设计。

**3.0.6** 由当地政府确定为避难疏散场所的学校应按国家和地方相关规定进行设计。

**3.0.7** 多个学校校址集中或组成学区时，各校宜合建可共用的建筑和场地。分设多个校址的学校可依教学及其他条件的需要，分散设置或在适中的校园内集中建设可共用的建筑和场地。

**3.0.8** 中小学校建设应符合环境保护的要求，宜按绿色校园、绿色建筑的有关要求进行设计。

**3.0.9** 在改建、扩建项目中宜充分利用原有的场地、设施及建筑。

**3.0.10** 中小学校设计应与当地气候、地理环境、社会、经济、技术的发展水平、民族习俗及传统相适应。

**3.0.11** 环境设计、建筑的造型及装饰设计应朴素、安全、实用。

## 4 场地和总平面

### 4.1 场 地

**4.1.1** 中小学校应建设在阳光充足、空气流动、场地干燥、排水通畅、地势较高的宜建地段。校内应有布置运动场地和提供设置基础市政设施的条件。

**4.1.2** 中小学校严禁建设在地震、地质塌裂、暗河、洪涝等自然灾害及人为风险高的地段和污染超标的地段。校园及校内建筑与污染源的距离应符合对各类污染源实施控制的国家现行有关标准的规定。

**4.1.3** 中小学校建设应远离殡仪馆、医院的太平间、传染病院等建筑。与易燃易爆场所间的距离应符合现行国家标准《建筑设计防火规范》GB 50016的有关规定。

**4.1.4** 城镇完全小学的服务半径宜为500m，城镇初级中学的服务半径宜为1000m。

**4.1.5** 学校周边应有良好的交通条件，有条件时宜设置临时停车场地。学校的规划布局应与生源分布及周边交通相协调。与学校毗邻的城市主干道应设置适当的安全设施，以保障学生安全跨越。

**4.1.6** 学校教学区的声环境质量应符合现行国家标准《民用建筑隔声设计规范》GB 50118的有关规定。学校主要教学用房设置窗户的外墙与铁路路轨的距离不应小于300m，与高速路、地上轨道交通线或城市主干道的距离不应小于80m。当距离不足时，应采取有效的隔声措施。

**4.1.7** 学校周界外25m范围内已有邻里建筑处的噪声级不应超过现行国家标准《民用建筑隔声设计规范》GB 50118有关规定的限值。

**4.1.8** 高压电线、长输天然气管道、输油管道严禁穿越或跨越学校校园；当在学校周边敷设时，安全防护距离及防护措施应符合相关规定。

### 4.2 用 地

**4.2.1** 中小学校用地应包括建筑用地、体育用地、绿化用地、道路及广场、停车场用地。有条件时宜预留发展用地。

**4.2.2** 中小学校的规划设计应合理布局，合理确定容积率，合理利用地下空间，节约用地。

**4.2.3** 中小学校的规划设计应提高土地利用率，宜以学校可比容积率判断并提高土地利用效率。

**4.2.4** 中小学校建筑用地应包括以下内容：
1. 教学及教学辅助用房、行政办公和生活服务用房等全部建筑的用地；有住宿生学校的建筑用地应包括宿舍的用地；建筑用地应计算至台阶、坡道及散水外缘；
2. 自行车库及机动车停车库用地；
3. 设备与设施用房的用地。

**4.2.5** 中小学校的体育用地应包括体操项目及武术项目用地、田径项目用地、球类用地和场地间的专用甬路等。设400m环形跑道时，宜设8条直跑道。

**4.2.6** 中小学校的绿化用地宜包括集中绿地、零星绿地、水面和供教学实践的种植园及小动物饲养园。
1. 中小学校应设置集中绿地。集中绿地的宽度不应小于8m。
2. 集中绿地、零星绿地、水面、种植园、小动物饲养园的用地应按各自的外缘围合的面积计算。
3. 各种绿地内的步行甬路应计入绿化用地。
4. 铺栽植被达标的绿地停车场用地应计入绿化用地。
5. 未铺栽植被或铺栽植被不达标的体育场地不宜计入绿化用地。
6. 绿地的日照及种植环境宜结合教学、植物多样化等要求综合布置。

**4.2.7** 中小学校校园内的道路及广场、停车场用地应包括消防车道、机动车道、步行道、无顶盖且无植被或植被不达标的广场及地上停车场。用地面积计量范围应界定至路面或广场、停车场的外缘。校门外的缓冲场地在学校用地红线以内的面积应计量为学校的道路及广场、停车场用地。

### 4.3 总 平 面

**4.3.1** 中小学校的总平面设计应包括总平面布置、竖向设计及管网综合设计。总平面布置应包括建筑布置、体育场地布置、绿地布置、道路及广场、停车场布置等。

**4.3.2** 各类小学的主要教学用房不应设在四层以上，各类中学的主要教学用房不应设在五层以上。

**4.3.3** 普通教室冬至日满窗日照不应少于2h。

**4.3.4** 中小学校至少应有1间科学教室或生物实验室的室内能在冬季获得直射阳光。

**4.3.5** 中小学校的总平面设计应根据学校所在地的冬夏主导风向合理布置建筑物及构筑物，有效组织校园气流，实现低能耗通风换气。

**4.3.6** 中小学校体育用地的设置应符合下列规定：
1. 各类运动场地应平整，在其周边的同一高程上应有相应的安全防护空间。
2. 室外田径场及足球、篮球、排球等各种球类场地的长轴宜南北向布置。长轴南偏东宜小于20°，南偏西宜小于10°。
3. 相邻布置的各体育场地间应预留安全分隔设施的安装条件。
4. 中小学校设置的室外田径场、足球场应进行排水设计。室外体育场地应排水通畅。
5. 中小学校体育场地应采用满足主要运动项目对地面要求的材料及构造做法。
6. 气候适宜地区的中小学校宜在体育场地周边的适当位置设置洗手池、洗脚池等附属设施。

**4.3.7** 各类教室的外窗与相对的教学用房或室外运动场地边缘间的距离不应小于25m。

**4.3.8** 中小学校的广场、操场等室外场地应设置供水、供电、广播、通信等设施的接口。

**4.3.9** 中小学校应在校园的显要位置设置国旗升旗场地。

## 5 教学用房及教学辅助用房

### 5.1 一般规定

**5.1.1** 中小学校的教学及教学辅助用房应包括普通教室、专用教室、公共教学用房及其各自的辅助用房。

**5.1.2** 中小学校专用教室应包括下列用房：
1. 小学的专用教室应包括科学教室、计算机教室、语言教室、美术教室、书法教室、音乐教室、舞蹈教室、体育建筑设施及劳动教室等，宜设置史地教室；
2. 中学的专用教室应包括实验室、史地教室、计算机教室、语言教室、美术教室、书法教室、音乐教室、舞蹈教室、体育建筑设施及技术教室等。

**5.1.3** 中小学校的公共教学用房应包括合班教室、图书室、学生活动室、体质测试室、心理咨询室、德育展览室等及任课教师办公室。

**5.1.4** 中小学校的普通教室与专用教室、公共教学用房间应联系方便。教师休息室宜与普通教室同层设置。各专用教室宜与其教学辅助用房成组布置。教研组教师办公室宜设在其专用教室附近或与其专用教室成组布置。

**5.1.5** 中小学校的教学用房及教学辅助用房应设置的给水排水、供配电及智能化等设施除符合本章规定外，还应符合本规范第10章的规定。

**5.1.6** 中小学校的教学用房及教学辅助用房宜多学科共用。

**5.1.7** 中小学校教学用房及教学辅助用房中，隔墙的设置及水、暖、气、电、通信等各种设施的管网布线宜适应教学空间调整的需求。

**5.1.8** 各教室前端侧窗窗端墙的长度不应小于1.00m。窗间墙宽度不应大于1.20m。

**5.1.9** 教学用房的窗应符合下列规定：
1. 教学用房中，窗的采光应符合现行国家标准《建筑采光设计标准》GB/T 50033的有关规定，并应符合本规范第9.2节的规定；
2. 教学用房及教学辅助用房的窗玻璃应满足教学要求，不得采用彩色玻璃；
3. 教学用房及教学辅助用房中，外窗的可开启窗扇面积应符合本规范第9.1节及第10.1节通风换气的规定；
4. 教学用房及教学辅助用房的外窗在采光、保温、隔热、散热和遮阳等方面的要求应符合国家现行有关建筑节能标准的规定。

**5.1.10** 炎热地区的教学用房及教学辅助用房中，可在内外墙设置可开闭的通风窗。通风窗下沿宜设在距室内楼地面以上0.10m～0.15m高度处。

**5.1.11** 教学用房的门应符合下列规定：
1. 除音乐教室外，各类教室的门均宜设置上亮窗；
2. 除心理咨询室外，教学用房的门扇均宜附设观察窗。

**5.1.12** 教学用房的地面应有防潮处理。在严寒地区、寒冷地区及夏热冬冷地区，教学用房的地面应设保温措施。

**5.1.13** 教学用房的楼层间及隔墙应进行隔声处理；走道的顶棚宜进行吸声处理。隔声、吸声的要求应符合现行国家标准《民用建筑隔声设计规范》GB 50118的有关规定。

**5.1.14** 教学用房及学生公共活动区的墙面宜设置墙裙，墙裙高度应符合下列规定：
1. 各类小学的墙裙高度不宜低于1.20m；
2. 各类中学的墙裙高度不宜低于1.40m；
3. 舞蹈教室、风雨操场墙裙高度不应低于2.10m。

**5.1.15** 教学用房内设置黑板或书写白板及讲台时，其材质及构造应符合下列规定：
1. 黑板的宽度应符合下列规定：
    1) 小学不宜小于3.60m；
    2) 中学不宜小于4.00m；
2. 黑板的高度不应小于1.00m；
3. 黑板下边缘与讲台面的垂直距离应符合下列规定：
    1) 小学宜为0.80m～0.90m；
    2) 中学宜为1.00m～1.1Om；
4. 黑板表面应采用耐磨且光泽度低的材料；
5. 讲台长度应大于黑板长度，宽度不应小于0.80m，高度宜为0.20m。其两端边缘与黑板两端边缘的水平距离分别不应小于0.40m。

**5.1.16** 主要教学用房应配置的教学基本设备及设施应符合表5.1.16的规定。

**5.1.17** 安装视听教学设备的教室应设置转暗设施。

### 5.2 普通教室

**5.2.1** 普通教室内单人课桌的平面尺寸应为0.60m×0.40m。

**5.2.2** 普通教室内的课桌椅布置应符合下列规定：
1. 中小学校普通教室课桌椅的排距不宜小于0.90m，独立的非完全小学可为0.85m；
2. 最前排课桌的前沿与前方黑板的水平距离不宜小于2.20m；
3. 最后排课桌的后沿与前方黑板的水平距离应符合下列规定：
    1) 小学不宜大于8.00m；
    2) 中学不宜大于9.00m；
4. 教室最后排座椅之后应设横向疏散走道；自最后排课桌后沿至后墙面或固定家具的净距不应小于1.10m；
5. 中小学校普通教室内纵向走道宽度不应小于0.60m，独立的非完全小学可为0.55m；
6. 沿墙布置的课桌端部与墙面或壁柱、管道等墙面突出物的净距不宜小于0.15m；
7. 前排边座座椅与黑板远端的水平视角不应小于30°。

**5.2.3** 普通教室内应为每个学生设置一个专用的小型储物柜。

### 5.3 科学教室、实验室

**5.3.1** 科学教室和实验室均应附设仪器室、实验员室、准备室。

**5.3.2** 科学教室和实验室的桌椅类型和排列布置应根据实验内容及教学模式确定，并应符合下列规定：
1. 实验桌平面尺寸应符合表5.3.2的规定；
2. 实验桌的布置应符合下列规定：
    1) 双人单侧操作时，两实验桌长边之间的净距不应小于0.60m；四人双侧操作时，两实验桌长边之间的净距不应小于1.30m；超过四人双侧操作时，两实验桌长边之间的净距不应小于1.50m；
    2) 最前排实验桌的前沿与前方黑板的水平距离不宜小于2.50m；
    3) 最后排实验桌的后沿与前方黑板之间的水平距离不宜大于11.00m；
    4) 最后排座椅之后应设横向疏散走道；自最后排实验桌后沿至后墙面或固定家具的净距不应小于1.20m；
    5) 双人单侧操作时，中间纵向走道的宽度不应小于0.70m；四人或多于四人双向操作时，中间纵向走道的宽度不应小于0.90m；
    6) 沿墙布置的实验桌端部与墙面或壁柱、管道等墙面突出物间宜留出疏散走道，净宽不宜小于0.60m；另一侧有纵向走道的实验桌端部与墙面或壁柱、管道等墙面突出物间可不留走道，但净距不宜小于0.15m；
    7) 前排边座座椅与黑板远端的最小水平视角不应小于30°。

#### Ⅰ 科学教室

**5.3.3** 除符合本规范第5.3.1条规定外，科学教室并宜在附近附设植物培养室，在校园下风方向附设种植园及小动物饲养园。

**5.3.4** 冬季获得直射阳光的科学教室应在阳光直射的位置设置摆放盆栽植物的设施。

**5.3.5** 科学教室内实验桌椅的布置可采用双人单侧的实验桌平行于黑板布置，或采用多人双侧实验桌成组布置。

**5.3.6** 科学教室内应设置密闭地漏。

#### Ⅱ 化学实验室

**5.3.7** 化学实验室宜设在建筑物首层。除符合本规范第5.3.1条规定外，化学实验室并应附设药品室。化学实验室、化学药品室的朝向不宜朝西或西南。

**5.3.8** 每一化学实验桌的端部应设洗涤池；岛式实验桌可在桌面中间设通长洗涤槽。每一间化学实验室内应至少设置一个急救冲洗水嘴，急救冲洗水嘴的工作压力不得大于0.01MPa。

**5.3.9** 化学实验室的外墙至少应设置2个机械排风扇，排风扇下沿应在距楼地面以上0.10m～0.15m高度处。在排风扇的室内一侧应设置保护罩，采暖地区应为保温的保护罩。在排风扇的室外一侧应设置挡风罩。实验桌应有通风排气装置，排风口宜设在桌面以上。药品室的药品柜内应设通风装置。

**5.3.10** 化学实验室、药品室、准备室宜采用易冲洗、耐酸碱、耐腐蚀的楼地面做法，并装设密闭地漏。

#### Ⅲ 物理实验室

**5.3.11** 当学校配置2个及以上物理实验室时，其中1个应为力学实验室。光学、热学、声学、电学等实验可共用同一实验室，并应配置各实验所需的设备和设施。

**5.3.12** 力学实验室需设置气垫导轨实验桌，在实验桌一端应设置气泵电源插座；另一端与相邻桌椅、墙壁或橱柜的间距不应小于0.90m。

**5.3.13** 光学实验室的门窗宜设遮光措施。内墙面宜采用深色。实验桌上宜设置局部照明。特色教学需要时可附设暗室。

**5.3.14** 热学实验室应在每一实验桌旁设置给水排水装置，并设置热源。

**5.3.15** 电学实验室应在每一个实验桌上设置一组包括不同电压的电源插座，插座上每一电源宜设分开关，电源的总控制开关应设在教师演示桌处。

**5.3.16** 物理实验员室宜具有设置钳台等小型机修装备的条件。

#### Ⅳ 生物实验室

**5.3.17** 除符合本规范第5.3.1条规定外，生物实验室还应附设药品室、标本陈列室、标本储藏室，宜附设模型室，并宜在附近附设植物培养室，在校园下风方向附设种植园及小动物饲养园。标本陈列室与标本储藏室宜合并设置，实验员室、仪器室、模型室可合并设置。

**5.3.18** 当学校有2个生物实验室时，生物显微镜观察实验室和解剖实验室宜分别设置。

**5.3.19** 冬季获得直射阳光的生物实验室应在阳光直射的位置设置摆放盆栽植物的设施。

**5.3.20** 生物显微镜观察实验室内的实验桌旁宜设置显微镜储藏柜。实验桌上宜设置局部照明设施。

**5.3.21** 生物解剖实验室的给水排水设施可集中设置，也可在每个实验桌旁分别设置。

**5.3.22** 生物标本陈列室和标本储藏室应采取通风、降温、隔热、防潮、防虫、防鼠等措施，其采光窗应避免直射阳光。

**5.3.23** 植物培养室宜独立设置，也可以建在平屋顶上或其他能充分得到日照的地方。种植园的肥料及小动物饲养园的粪便均不得污染水源和周边环境。

#### Ⅴ 综合实验室

**5.3.24** 当中学设有跨学科的综合研习课时，宜配置综合实验室。综合实验室应附设仪器室、准备室；当化学、物理、生物实验室均在邻近布置时，综合实验室可不设仪器室、准备室。

**5.3.25** 综合实验室内宜沿侧墙及后墙设置固定实验桌，其上装设给水排水、通风、热源、电源插座及网络接口等设施。实验室中部宜设100m²开敞空间。

#### Ⅵ 演示实验室

**5.3.26** 演示实验室宜按容纳1个班或2个班设置。

**5.3.27** 演示实验室课桌椅的布置应符合下列规定：
1. 宜设置有书写功能的座椅，每个座椅的最小宽度宜为0.55m；
2. 演示实验室中，桌椅排距不应小于0.90m；
3. 演示实验室纵向走道宽度不应小于0.70m；
4. 边演示边实验的阶梯式实验室中，阶梯的宽度不宜小于1.35m；
5. 边演示边实验的阶梯式实验室的纵向走道应有便于仪器药品车通行的坡道，宽度不应小于0.70m。

**5.3.28** 演示实验室宜设计为阶梯教室，设计视点应定位于教师演示实验台桌面的中心，每排座位宜错位布置，隔排视线升高值宜为0.12m。

**5.3.29** 演示实验室内最后排座位之后，应设横向疏散走道，疏散走道宽度不应小于0.60m，净高不应小于2.20m。

### 5.4 史地教室

**5.4.1** 史地教室应附设历史教学资料储藏室、地理教学资料储藏室和陈列室或陈列廊。

**5.4.2** 史地教室的课桌椅布置方式宜与普通教室相同。并宜在课桌旁附设存放小地球仪等教具的小柜。教室内可设标本展示柜。在地质灾害多发地区附近的学校，史地教室标本展示柜应与墙体或楼板有可靠的固定措施。

**5.4.3** 史地教室设置简易天象仪时，宜设置课桌局部照明设施。

**5.4.4** 史地教室内应配置挂镜线。

### 5.5 计算机教室

**5.5.1** 计算机教室应附设一间辅助用房供管理员工作及存放资料。

**5.5.2** 计算机教室的课桌椅布置应符合下列规定：
1. 单人计算机桌平面尺寸不应小于0.75m×0.65m。前后桌间距离不应小于0.70m；
2. 学生计算机桌椅可平行于黑板排列；也可顺侧墙及后墙向黑板成半围合式排列；
3. 课桌椅排距不应小于1.35m；
4. 纵向走道净宽不应小于0.70m；
5. 沿墙布置计算机时，桌端部与墙面或壁柱、管道等墙面突出物间的净距不宜小于0.15m。

**5.5.3** 计算机教室应设置书写白板。

**5.5.4** 计算机教室宜设通信外网接口，并宜配置空调设施。

**5.5.5** 计算机教室的室内装修应采取防潮、防静电措施，并宜采用防静电架空地板，不得采用无导出静电功能的木地板或塑料地板。当采用地板采暖系统时，楼地面需采用与之相适应的材料及构造做法。

### 5.6 语言教室

**5.6.1** 语言教室应附设视听教学资料储藏室。

**5.6.2** 中小学校设置进行情景对话表演训练的语言教室时，可采用普通教室的课桌椅，也可采用有书写功能的座椅。并应设置不小于20m²的表演区。

**5.6.3** 语言教室宜采用架空地板。不架空时，应铺设可敷设电缆槽的地面垫层。

### 5.7 美术教室、书法教室

#### Ⅰ 美术教室

**5.7.1** 美术教室应附设教具储藏室，宜设美术作品及学生作品陈列室或展览廊。

**5.7.2** 中学美术教室空间宜满足一个班的学生用画架写生的要求。学生写生时的座椅为画凳时，所占面积宜为2.15m²/生；用画架时所占面积宜为2.50m²/生。

**5.7.3** 美术教室应有良好的北向天然采光。当采用人工照明时，应避免眩光。

**5.7.4** 美术教室应设置书写白板，宜设存放石膏像等教具的储藏柜。在地质灾害多发地区附近的学校，教具储藏柜应与墙体或楼板有可靠的固定措施。

**5.7.5** 美术教室内应配置挂镜线，挂镜线宜设高低两组。

**5.7.6** 美术教室的墙面及顶棚应为白色。

**5.7.7** 当设置现代艺术课教室时，其墙面及顶棚应采取吸声措施。

#### Ⅱ 书法教室

**5.7.8** 小学书法教室可兼作美术教室。

**5.7.9** 书法教室可附设书画储藏室。

**5.7.10** 书法条案的布置应符合下列规定：
1. 条案的平面尺寸宜为1.50m×0.60m，可供2名学生合用；
2. 条案宜平行于黑板布置；条案排距不应小于1.20m；
3. 纵向走道宽度不应小于0.70m。

**5.7.11** 书法教室内应配置挂镜线，挂镜线宜设高低两组。

### 5.8 音乐教室

**5.8.1** 音乐教室应附设乐器存放室。

**5.8.2** 各类小学的音乐教室中，应有1间能容纳1个班的唱游课，学生边唱边舞所占面积不应小于2.40m²。

**5.8.3** 音乐教室讲台上应布置教师用琴的位置。

**5.8.4** 中小学校应有1间音乐教室能满足合唱课教学的要求，宜在紧接后墙处设置2排～3排阶梯式合唱台，每级高度宜为0.20m，宽度宜为0.60m。

**5.8.5** 音乐教室应设置五线谱黑板。

**5.8.6** 音乐教室的门窗应隔声。墙面及顶棚应采取吸声措施。

### 5.9 舞蹈教室

**5.9.1** 舞蹈教室宜满足舞蹈艺术课、体操课、技巧课、武术课的教学要求，并可开展形体训练活动。每个学生的使用面积不宜小于6m²。

**5.9.2** 舞蹈教室应附设更衣室，宜附设卫生间、浴室和器材储藏室。

**5.9.3** 舞蹈教室应按男女学生分班上课的需要设置。

**5.9.4** 舞蹈教室内应在与采光窗相垂直的一面墙上设通长镜面，镜面含镜座总高度不宜小于2.10m，镜座高度不宜大于0.30m。镜面两侧的墙上及后墙上应装设可升降的把杆，镜面上宜装设固定把杆。把杆升高时的高度应为0.90m；把杆与墙间的净距不应小于0.40m。

**5.9.5** 舞蹈教室宜设置带防护网的吸顶灯。采暖等各种设施应暗装。

**5.9.6** 舞蹈教室宜采用木地板。

**5.9.7** 当学校有地方或民族舞蹈课时，舞蹈教室设计宜满足其特殊需要。

### 5.10 体育建筑设施

**5.10.1** 体育建筑设施包括风雨操场、游泳池或游泳馆。体育建筑设施的位置应邻近室外体育场，并宜便于向社会开放。

#### Ⅰ 风雨操场

**5.10.2** 风雨操场应附设体育器材室，也可与操场共用一个体育器材室，并宜附设更衣室、卫生间、浴室。教职工与学生的更衣室、卫生间、淋浴室应分设。

**5.10.3** 当风雨操场无围护墙时，应避免眩光影响。有围护墙的风雨操场外窗无避免眩光的设施时，窗台距室内地面高度不宜低于2.10m。窗台高度以下的墙面宜为深色。

**5.10.4** 根据运动占用空间的要求，应在风雨操场内预留各项目之间设置安全分隔的设施。

**5.10.5** 风雨操场内，运动场地的灯具等应设护罩。悬吊物应有可靠的固定措施。有围护墙时，在窗的室内一侧应设护网。

**5.10.6** 风雨操场的楼、地面构造应根据主要运动项目的要求确定，不宜采用刚性地面。固定运动器械的预埋件应暗设。

**5.10.7** 当风雨操场兼作集会场所时，宜进行声学处理。

**5.10.8** 风雨操场通风设计应符合本规范第9.1.3条的规定，应采用自然通风；当自然通风不满足要求时，宜设机械通风或空调。

**5.10.9** 体育器材室的门窗及通道应满足搬运体育器材的需要。

**5.10.10** 体育器材室的室内应采取防虫、防潮措施。

#### Ⅱ 游泳池、游泳馆

**5.10.11** 中小学校的游泳池、游泳馆均应附设卫生间、更衣室，宜附设浴室。

**5.10.12** 中小学校泳池宜为8泳道，泳道长宜为50m或25m。

**5.10.13** 中小学校游泳池、游泳馆内不得设置跳水池，且不宜设置深水区。

**5.10.14** 中小学校泳池入口处应设置强制通过式浸脚消毒池，池长不应小于2.00m，宽度应与通道相同，深度不宜小于0.20m。

**5.10.15** 泳池设计应符合国家现行标准《建筑给水排水设计规范》GB 50015及《游泳池给水排水工程技术规程》CJJ 122的有关规定。

### 5.11 劳动教室、技术教室

**5.11.1** 小学的劳动教室和中学的技术教室应根据国家或地方教育行政主管部门规定的教学内容进行设计，并应设置教学内容所需要的辅助用房、工位装备及水、电、气、热等设施。

**5.11.2** 中小学校内有油烟或气味发散的劳动教室、技术教室应设置有效的排气设施。

**5.11.3** 中小学校内有振动或发出噪声的劳动教室、技术教室应采取减振减噪、隔振隔噪声措施。

**5.11.4** 部分劳动课程、技术课程可以利用普通教室或其他专用教室。高中信息技术课可以在计算机教室进行，但其附属用房宜加大，以配置扫描仪、打印机等相应的设备。

### 5.12 合班教室

**5.12.1** 各类小学宜配置能容纳2个班的合班教室。当合班教室兼用于唱游课时，室内不应设置固定课桌椅，并应附设课桌椅存放空间。兼作唱游课教室的合班教室应对室内空间进行声学处理。

**5.12.2** 各类中学宜配置能容纳一个年级或半个年级的合班教室。

**5.12.3** 容纳3个班及以上的合班教室应设计为阶梯教室。

**5.12.4** 阶梯教室梯级高度依据视线升高值确定。阶梯教室的设计视点应定位于黑板底边缘的中点处。前后排座位错位布置时，视线的隔排升高值宜为0.12m。

**5.12.5** 合班教室宜附设1间辅助用房，储存常用教学器材。

**5.12.6** 合班教室课桌椅的布置应符合下列规定：
1. 每个座位的宽度不应小于0.55m，小学座位排距不应小于0.85m，中学座位排距不应小于0.90m；
2. 教室最前排座椅前沿与前方黑板间的水平距离不应小于2.50m，最后排座椅的前沿与前方黑板间的水平距离不应大于18.00m；
3. 纵向、横向走道宽度均不应小于0.90m，当座位区内有贯通的纵向走道时，若设置靠墙纵向走道，靠墙走道宽度可小于0.90m，但不应小于0.60m；
4. 最后排座位之后应设宽度不小于0.60m的横向疏散走道；
5. 前排边座座椅与黑板远端间的水平视角不应小于30°。

**5.12.7** 当合班教室内设置视听教学器材时，宜在前墙安装推拉黑板和投影屏幕（或数字化智能屏幕），并应符合下列规定：
1. 当小学教室长度超过9.00m，中学教室长度超过10.00m时，宜在顶棚上或墙、柱上加设显示屏；学生的视线在水平方向上偏离屏幕中轴线的角度不应大于45°，垂直方向上的仰角不应大于30°；
2. 当教室内，自前向后每6.00m～8.00m设1个显示屏时，最后排座位与黑板间的距离不应大于24.00m；学生座椅前缘与显示屏的水平距离不应小于显示屏对角线尺寸的4倍～5倍，并不应大于显示屏对角线尺寸的10倍～11倍；
3. 显示屏宜加设遮光板。

**5.12.8** 教室内设置视听器材时，宜设置转暗设备，并宜设置座位局部照明设施。

**5.12.9** 合班教室墙面及顶棚应采取吸声措施。

### 5.13 图 书 室

**5.13.1** 中小学校图书室应包括学生阅览室、教师阅览室、图书杂志及报刊阅览室、视听阅览室、检录及借书空间、书库、登录、编目及整修工作室。并可附设会议室和交流空间。

**5.13.2** 图书室应位于学生出入方便、环境安静的区域。

**5.13.3** 图书室的设置应符合下列规定：
1. 教师与学生的阅览室宜分开设置，使用面积应符合本规范表7.1.1的规定；
2. 中小学校的报刊阅览室可以独立设置，也可以在图书室内的公共交流空间设报刊架，开架阅览；
3. 视听阅览室的设置应符合下列规定：
    1) 使用面积应符合本规范表7.1.1的规定；
    2) 视听阅览室宜附设资料储藏室，使用面积不宜小于12.00m²；
    3) 当视听阅览室兼作计算机教室、语言教室使用时，阅览桌椅的排列应符合本规范第5.5节及第5.6节的规定；
    4) 视听阅览室宜采用防静电架空地板，不得采用无导出静电功能的木地板或塑料地板；当采用地板采暖系统时，楼地面需采用与之相适应的构造做法；
4. 书库使用面积宜按以下规定计算后确定：
    1) 开架藏书量约为400册/m²～500册/m²；
    2) 闭架藏书量约为500册/m²～600册/m²；
    3) 密集书架藏书量约为800册/m²～1200册/m²；
5. 书库应采取防火、降温、隔热、通风、防潮、防虫及防鼠的措施；
6. 借书空间除设置师生个人借阅空间外，还应设置检录及班级集体借书的空间。借书空间的使用面积不宜小于10.00m²。

### 5.14 学生活动室

**5.14.1** 学生活动室供学生兴趣小组使用。各小组宜在相关的专用教室中开展活动，各活动室仅作为服务、管理工作和储藏用。

**5.14.2** 学生活动室的数量及面积宜依据学校的规模、办学特色和建设条件设置。面积应依据活动项目的特点确定。

**5.14.3** 学生活动室的水、电、气、冷、热源及设备、设施应根据活动内容的需要设置。

### 5.15 体质测试室

**5.15.1** 体质测试室宜设在风雨操场或医务室附近。并宜设为相通的2间。体质测试室宜附设可容纳一个班的等侯空间。

**5.15.2** 体质测试室应有良好的天然采光和自然通风。

### 5.16 心理咨询室

**5.16.1** 心理咨询室宜分设为相连通的2间，其中有一间宜能容纳沙盘测试，其平面尺寸不宜小于4.00m×3.40m。心理咨询室可附设能容纳1个班的心理活动室。

**5.16.2** 心理咨询室宜安静、明亮。

### 5.17 德育展览室

**5.17.1** 德育展览室的位置宜设在校门附近或主要教学楼入口处，也可设在会议室、合班教室附近，或在学生经常经过的走道处附设展览廊。

**5.17.2** 德育展览室可与其他展览空间合并或连通。

**5.17.3** 德育展览室的面积不宜小于60.00m²。

### 5.18 任课教师办公室

**5.18.1** 任课教师的办公室应包括年级组教师办公室和各课程教研组办公室。

**5.18.2** 年级组教师办公室宜设置在该年级普通教室附近。课程有专用教室时，该课程教研组办公室宜与专用教室成组设置。其他课程教研组可集中设置于行政办公室或图书室附近。

**5.18.3** 任课教师办公室内宜设洗手盆。

## 6 行政办公用房和生活服务用房

### 6.1 行政办公用房

**6.1.1** 行政办公用房应包括校务、教务等行政办公室、档案室、会议室、学生组织及学生社团办公室、文印室、广播室、值班室、安防监控室、网络控制室、卫生室(保健室)、传达室、总务仓库及维修工作间等。

**6.1.2** 主要行政办公用房的位置应符合下列规定：
1. 校务办公室宜设置在与全校师生易于联系的位置，并宜靠近校门；
2. 教务办公室宜设置在任课教师办公室附近；
3. 总务办公室宜设置在学校的次要出入口或食堂、维修工作间附近；
4. 会议室宜设在便于教师、学生、来客使用的适中位置；
5. 广播室的窗应面向全校学生做课间操的操场；
6. 值班室宜设置在靠近校门、主要建筑物出入口或行政办公室附近；
7. 总务仓库及维修工作间宜设在校园的次要出入口附近，其运输及噪声不得影响教学环境的质量和安全。

**6.1.3** 中小学校设计应依据使用和管理的需要设安防监控中心。安防工程的设置应符合现行国家标准《安全防范工程技术规范》GB 50348的有关规定。

**6.1.4** 网络控制室宜设空调。

**6.1.5** 网络控制室内宜采用防静电架空地板，不得采用无导出静电功能的木地板或塑料地板。当采用地板采暖时，楼地面需采用相适应的构造。

**6.1.6** 卫生室(保健室)的设置应符合下列规定：
1. 卫生室(保健室)应设在首层，宜临近体育场地,并方便急救车辆就近停靠；
2. 小学卫生室可只设1间，中学宜分设相通的2间，分别为接诊室和检查室，并可设观察室；
3. 卫生室的面积和形状应能容纳常用诊疗设备，并能满足视力检查的要求；每间房间的面积不宜小于15m²；
4. 卫生室宜附设候诊空间，候诊空间的面积不宜小于20m²；
5. 卫生室(保健室)内应设洗手盆、洗涤池和电源插座；
6. 卫生室(保健室)宜朝南。

### 6.2 生活服务用房

**6.2.1** 中小学校生活服务用房应包括饮水处、卫生间、配餐室、发餐室、设备用房，宜包括食堂、淋浴室、停车库(棚)。寄宿制学校应包括学生宿舍、食堂、浴室。

#### Ⅰ 饮水处

**6.2.2** 中小学校的饮用水管线与室外公厕、垃圾站等污染源间的距离应大于25.00m。

**6.2.3** 教学用建筑内应在每层设饮水处，每处应按每40人～45人设置一个饮水水嘴计算水嘴的数量。

**6.2.4** 教学用建筑每层的饮水处前应设置等侯空间，等候空间不得挤占走道等疏散空间。

#### Ⅱ 卫 生 间

**6.2.5** 教学用建筑每层均应分设男、女学生卫生间及男、女教师卫生间。学校食堂宜设工作人员专用卫生间。当教学用建筑中每层学生少于3个班时，男、女生卫生间可隔层设置。

**6.2.6** 卫生间位置应方便使用且不影响其周边教学环境卫生。

**6.2.7** 在中小学校内，当体育场地中心与最近的卫生间的距离超过90.00m时，可设室外厕所。所建室外厕所的服务人数可依学生总人数的15％计算。室外厕所宜预留扩建的条件。

**6.2.8** 学生卫生间卫生洁具的数量应按下列规定计算：
1. 男生应至少为每40人设1个大便器或1.20m长大便槽；每20人设1个小便斗或0.60m长小便槽；女生应至少为每13人设1个大便器或1.20m长大便槽；
2. 每40人～45人设1个洗手盆或0.60m长盥洗槽：
3. 卫生间内或卫生间附近应设污水池。

**6.2.9** 中小学校的卫生间内，厕位蹲位距后墙不应小于0.30m。

**6.2.10** 各类小学大便槽的蹲位宽度不应大于0.18m。

**6.2.11** 厕位间宜设隔板，隔板高度不应低于1.20m。

**6.2.12** 中小学校的卫生间应设前室。男、女生卫生间不得共用一个前室。

**6.2.13** 学生卫生间应具有天然采光、自然通风的条件，并应安置排气管道。

**6.2.14** 中小学校的卫生间外窗距室内楼地面1.70m以下部分应设视线遮挡措施。

**6.2.15** 中小学校应采用水冲式卫生间。当设置旱厕时，应按学校专用无害化卫生厕所设计。

#### Ⅲ 浴 室

**6.2.16** 宜在舞蹈教室、风雨操场、游泳池(馆)附设淋浴室。教师浴室与学生浴室应分设。

**6.2.17** 淋浴室墙面应设墙裙，墙裙高度不应低于2.10m。

#### Ⅳ 食 堂

**6.2.18** 食堂与室外公厕、垃圾站等污染源间的距离应大于25.00m。

**6.2.19** 食堂不应与教学用房合并设置，宜设在校园的下风向。厨房的噪声及排放的油烟、气味不得影响教学环境。

**6.2.20** 寄宿制学校的食堂应包括学生餐厅、教工餐厅、配餐室及厨房。走读制学校应设置配餐室、发餐室和教工餐厅。

**6.2.21** 配餐室内应设洗手盆和洗涤池，宜设食物加热设施。

**6.2.22** 食堂的厨房应附设蔬菜粗加工和杂物、燃料、灰渣等存放空间。各空间应避免污染食物，并宜靠近校园的次要出入口。

**6.2.23** 厨房和配餐室的墙面应设墙裙，墙裙高度不应低于2.10m。

#### Ⅴ 学生宿舍

**6.2.24** 学生宿舍不得设在地下室或半地下室。

**6.2.25** 宿舍与教学用房不宜在同一栋建筑中分层合建，可在同一栋建筑中以防火墙分隔贴建。学生宿舍应便于自行封闭管理，不得与教学用房合用建筑的同一个出入口。

**6.2.26** 学生宿舍必须男女分区设置，分别设出入口，满足各自封闭管理的要求。

**6.2.27** 学生宿舍应包括居室、管理室、储藏室、清洁用具室、公共盥洗室和公共卫生间，宜附设浴室、洗衣房和公共活动室。

**6.2.28** 学生宿舍宜分层设置公共盥洗室、卫生间和浴室。盥洗室门、卫生间门与居室门间的距离不得大于20.00m。当每层寄宿学生较多时可分组设置。

**6.2.29** 学生宿舍每室居住学生不宜超过6人。居室每生占用使用面积不宜小于3.00m²。当采用单层床时，居室净高不宜低于3.00m；当采用双层床时，居室净高不宜低于3.10m；当采用高架床时，居室净高不宜低于3.35m。
> 注：居室面积指标内未计入储藏空间所占面积。

**6.2.30** 学生宿舍的居室内应设储藏空间，每人储藏空间宜为0.30m³～0.45m³，储藏空间的宽度和深度均不宜小于0.60m。

**6.2.31** 学生宿舍应设置衣物晾晒空间。当采用阳台、外走道或屋顶晾晒衣物时，应采取防坠落措施。

#### Ⅵ 设备用房

**6.2.32** 设备用房包括变电室、配电室、锅炉房、通风机房、燃气调压箱、网络机房、消防水池等。中小学校建设应充分利用社会协作条件设置，减少设备用房的建设。

## 7 主要教学用房及教学辅助用房面积指标和净高

### 7.1 面积指标

**7.1.1** 主要教学用房的使用面积指标应符合表7.1.1的规定。

**表7.1.1 主要教学用房的使用面积指标(㎡/每座)**

| 房间名称 | 小学（㎡/每座） | 中学（㎡/每座） | 备注 |
| :--- | :---: | :---: | :--- |
| 普通教室 | 1.36 | 1.39 | — |
| 科学教室 | 1.78 | — | — |
| 实验室 | — | 1.92 | — |
| 综合实验室 | — | 2.88 | — |
| 演示实验室 | — | 1.44 | 若容纳 2 个班，则指标为 1.20 |
| 史地教室 | — | 1.92 | — |
| 计算机教室 | 2.00 | 1.92 | — |
| 语言教室 | 2.00 | 1.92 | — |
| 美术教室 | 2.00 | 1.92 | — |
| 书法教室 | 2.00 | 1.92 | — |
| 音乐教室 | 1.70 | 1.64 | — |
| 舞蹈教室 | 2.14 | 3.15 | 宜和体操教室共用 |
| 合班教室 | 0.89 | 0.90 | — |
| 学生阅览室 | 1.80 | 1.90 | — |
| 教师阅览室 | 2.30 | 2.30 | — |
| 视听阅览室 | 1.80 | 2.00 | — |
| 报刊阅览室 | 1.80 | 2.30 | 不可集中设置 |

> 注：
> 1. 表中指标是按完全小学每班45人、各类中学每班50人排布测定的每个学生所需使用面积；如果班级人数定额不同时需进行调整，但学生的全部座位均必须在“黑板可视线”范围以内；
> 2. 体育建筑设施、劳动教室、技术教室、心理咨询室未列人此表，另行规定；
> 3. 任课教师办公室未列人此表，应按每位教师使用面积不小于5.0㎡计算。

**7.1.2** 体育建筑设施的使用面积应按选定的体育项目确定。

**7.1.3** 劳动教室和技术教室的使用面积应按课程内容的工艺要求、工位要求、安全条件等因素确定。

**7.1.4** 心理咨询室的使用面积要求应符合本规范第5.16节的规定。

**7.1.5** 主要教学辅助用房的使用面积不宜低于表7.1.5的规定。

**表7.1.5 主要教学辅助用房的使用面积指标(㎡/每间)**

| 房间名称 | 小学（㎡/每间） | 中学（㎡/每间） | 备注 |
| :--- | :---: | :---: | :--- |
| 普通教室教师休息室 | (3.50) | (3.50) | 指标为使用面积/每位使用教师 |
| 实验员室 | 12.00 | 12.00 | — |
| 仪器室 | 18.00 | 24.00 | — |
| 药品室 | 18.00 | 24.00 | — |
| 准备室 | 18.00 | 24.00 | — |
| 标本陈列室 | 42.00 | 42.00 | 可陈列在能封闭管理的走道内 |
| 历史资料室 | 12.00 | 12.00 | — |
| 地理资料室 | 12.00 | 12.00 | — |
| 计算机教室资料室 | 24.00 | 24.00 | — |
| 语言教室资料室 | 24.00 | 24.00 | — |
| 美术教室教具室 | 24.00 | 24.00 | 可将部分教具置于美术教室内 |
| 乐器室 | 24.00 | 24.00 | — |
| 舞蹈教室更衣室 | 12.00 | 12.00 | — |

> 注：除注明者外，指标为每室最小面积，当部功能移人走道或教室时，指标作相应调整。

### 7.2 净 高

**7.2.1** 中小学校主要教学用房的最小净高应符合表7.2.1的规定。

**表7.2.1 主要教学用房的最小净高(m)**

| 教室 | 小学（m） | 初中（m） | 高中（m） |
| :--- | :---: | :---: | :---: |
| 普通教室、史地、美术、音乐教室 | 3.00 | 3.05 | 3.10 |
| 舞蹈教室 | 4.50 | 4.50 | 4.50 |
| 科学教室、实验室、计算机教室、<br>劳动教室、技术教室、合班教室 | 3.10 | 3.10 | 3.10 |
| 阶梯教室 | 最后一排（楼地面最高处）距顶棚<br>或上方突出物最小距离为2.20m | 最后一排（楼地面最高处）距顶棚<br>或上方突出物最小距离为2.20m | 最后一排（楼地面最高处）距顶棚<br>或上方突出物最小距离为2.20m |

**7.2.2** 风雨操场的净高应取决于场地的运动内容。各类体育场地最小净高应符合表7.2.2的规定。

**表7.2.2 各类体育场地的最小净高(m)**

| 体育场地 | 田径 | 篮球 | 排球 | 羽毛球 | 乒乓球 | 体操 |
| :--- | :---: | :---: | :---: | :---: | :---: | :---: |
| 最小净高（m） | 9 | 7 | 7 | 9 | 4 | 6 |

> 注：田径场地可减少部分项目降低净高。

## 8 安全、通行与疏散

### 8.1 建筑环境安全

**8.1.1** 中小学校应装设周界视频监控、报警系统。有条件的学校应接入当地的公安机关监控平台。中小学校安防设施的设置应符合现行国家标准《安全防范工程技术规范》GB 50348的有关规定。

**8.1.2** 中小学校建筑设计应符合现行国家标准《建筑抗震设计规范》GB 50011、《建筑设计防火规范》GB 50016的有关规定。

**8.1.3** 学校设计所采用的装修材料、产品、部品应符合现行国家标准《建筑内部装修设计防火规范》GB 50222、《民用建筑工程室内环境污染控制规范》GB 50325的有关规定及国家有关材料、产品、部品的标准规定。

**8.1.4** 体育场地采用的地面材料应满足环境卫生健康的要求。

**8.1.5** 临空窗台的高度不应低于0.90m。

**8.1.6** 上人屋面、外廊、楼梯、平台、阳台等临空部位必须设防护栏杆，防护栏杆必须牢固，安全，高度不应低于1.10m。防护栏杆最薄弱处承受的最小水平推力应不小于1.5kN/m。

**8.1.7** 以下路面、楼地面应采用防滑构造做法，室内应装设密闭地漏；
1. 疏散通道；
2. 教学用房的走道；
3. 科学教室、化学实验室、热学实验室、生物实验室、美术教室、书法教室、游泳池(馆)等有给水设施的教学用房及教学辅助用房；
4. 卫生室(保健室)、饮水处、卫生间、盥洗室、浴室等有给水设施的房间。

**8.1.8** 教学用房的门窗设置应符合下列规定：
1. 疏散通道上的门不得使用弹簧门、旋转门、推拉门、大玻璃门等不利于疏散通畅、安全的门；
2. 各教学用房的门均应向疏散方向开启，开启的门扇不得挤占走道的疏散通道；
3. 靠外廊及单内廊一侧教室内隔墙的窗开启后，不得挤占走道的疏散通道，不得影响安全疏散；
4. 二层及二层以上的临空外窗的开启扇不得外开。

**8.1.9** 在抗震设防烈度为6度或6度以上地区建设的实验室不宜采用管道燃气作为实验用的热源。

### 8.2 疏散通行宽度

**8.2.1** 中小学校内，每股人流的宽度应按0.60m计算。

**8.2.2** 中小学校建筑的疏散通道宽度最少应为2股人流，并应按0.60m的整数倍增加疏散通道宽度。

**8.2.3** 中小学校建筑的安全出口、疏散走道、疏散楼梯和房间疏散门等处每100人的净宽度应按表8.2.3计算。同时，教学用房的内走道净宽度不应小于2.40m，单侧走道及外廊的净宽度不应小于1.80m。

**表8.2.3 安全出口、疏散走道、疏散楼梯和房间疏散门每100人的净宽度(m)**

| 所在楼层位置 | 耐火等级<br>一、二级 | 耐火等级<br>三级 | 耐火等级<br>四级 |
| :--- | :---: | :---: | :---: |
| 地上一、二层 | 0.70 | 0.80 | 1.05 |
| 地上三层 | 0.80 | 1.05 | — |
| 地上四、五层 | 1.05 | 1.30 | — |
| 地下一、二层 | 0.80 | — | — |

**8.2.4** 房间疏散门开启后，每樘门净通行宽度不应小于0.90m。

### 8.3 校园出入口

**8.3.1** 中小学校的校园应设置2个出入口。出入口的位置应符合教学、安全、管理的需要，出入口的布置应避免人流、车流交叉。有条件的学校宜设置机动车专用出入口。

**8.3.2** 中小学校校园出入口应与市政交通衔接，但不应直接与城市主干道连接。校园主要出入口应设置缓冲场地。

### 8.4 校园道路

**8.4.1** 校园内道路应与各建筑的出入口及走道衔接，构成安全、方便、明确、通畅的路网。

**8.4.2** 中小学校校园应设消防车道。消防车道的设置应符合现行国家标准《建筑设计防火规范》GB 50016的有关规定。

**8.4.3** 校园道路每通行100人道路净宽为0.70m，每一路段的宽度应按该段道路通达的建筑物容纳人数之和计算，每一路段的宽度不宜小于3.00m。

**8.4.4** 校园道路及广场设计应符合国家现行标准的有关规定。

**8.4.5** 校园内人流集中的道路不宜设置台阶。设置台阶时，不得少于3级。

### 8.5 建筑物出入口

**8.5.1** 校园内除建筑面积不大于200m²，人数不超过50人的单层建筑外，每栋建筑应设置2个出入口。非完全小学内，单栋建筑面积不超过500m²，且耐火等级为一、二级的低层建筑可只设1个出入口。

**8.5.2** 教学用房在建筑的主要出入口处宜设门厅。

**8.5.3** 教学用建筑物出入口净通行宽度不得小于1.40m，门内与门外各1.50m范围内不宜设置台阶。

**8.5.4** 在寒冷或风沙大的地区，教学用建筑物出入口应设挡风间或双道门。

**8.5.5** 教学用建筑物的出入口应设置无障碍设施，并应采取防止上部物体坠落和地面防滑的措施。

**8.5.6** 停车场地及地下车库的出入口不应直接通向师生人流集中的道路。

### 8.6 走 道

**8.6.1** 教学用建筑的走道宽度应符合下列规定：
1. 应根据在该走道上各教学用房疏散的总人数，按照本规范表8.2.3的规定计算走道的疏散宽度；
2. 走道疏散宽度内不得有壁柱、消火栓、教室开启的门窗扇等设施。

**8.6.2** 中小学校的建筑物内，当走道有高差变化应设置台阶时，台阶处应有天然采光或照明，踏步级数不得少于3级，并不得采用扇形踏步。当高差不足3级踏步时，应设置坡道。坡道的坡度不应大于1:8，不宜大于1:12。

### 8.7 楼 梯

**8.7.1** 中小学校建筑中疏散楼梯的设置应符合现行国家标准《民用建筑设计通则》GB 50352、《建筑设计防火规范》GB 50016和《建筑抗震设计规范》GB 50011的有关规定。

**8.7.2** 中小学校教学用房的楼梯梯段宽度应为人流股数的整数倍。梯段宽度不应小于1.20m，并应按0.60m的整数倍增加梯段宽度。每个梯段可增加不超过0.15m的摆幅宽度。

**8.7.3** 中小学校楼梯每个梯段的踏步级数不应少于3级，且不应多于18级,并应符合下列规定：
1. 各类小学楼梯踏步的宽度不得小于0.26m，高度不得大于0.15m；
2. 各类中学楼梯踏步的宽度不得小于0.28m，高度不得大于0.16m；
3. 楼梯的坡度不得大于30°。

**8.7.4** 疏散楼梯不得采用螺旋楼梯和扇形踏步。

**8.7.5** 楼梯两梯段间楼梯井净宽不得大于0.11m，大于0.11m时，应采取有效的安全防护措施。两梯段扶手间的水平净距宜为0.10m～0.20m。

**8.7.6** 中小学校的楼梯扶手的设置应符合下列规定：
1. 楼梯宽度为2股人流时，应至少在一侧设置扶手；
2. 楼梯宽度达3股人流时，两侧均应设置扶手；
3. 楼梯宽度达4股人流时，应加设中间扶手，中间扶手两侧的净宽均应满足本规范第8.7.2条的规定；
4. 中小学校室内楼梯扶手高度不应低于0.90m，室外楼梯扶手高度不应低于1.10m；水平扶手高度不应低于1.10m；
5. 中小学校的楼梯栏杆不得采用易于攀登的构造和花饰；杆件或花饰的镂空处净距不得大于0.11m；
6. 中小学校的楼梯扶手上应加装防止学生溜滑的设施。

**8.7.7** 除首层及顶层外，教学楼疏散楼梯在中间层的楼层平台与梯段接口处宜设置缓冲空间，缓冲空间的宽度不宜小于梯段宽度。

**8.7.8** 中小学校的楼梯两相邻梯段间不得设置遮挡视线的隔墙。

**8.7.9** 教学用房的楼梯间应有天然采光和自然通风。

### 8.8 教室疏散

**8.8.1** 每间教学用房的疏散门均不应少于2个，疏散门的宽度应通过计算；同时，每樘疏散门的通行净宽度不应小于0.90m。当教室处于袋形走道尽端时，若教室内任一处距教室门不超过15.00m，且门的通行净宽度不小于1.50m时，可设1个门。

**8.8.2** 普通教室及不同课程的专用教室对教室内桌椅间的疏散走道宽度要求不同，教室内疏散走道的设置应符合本规范第5章对各教室设计的规定。

## 9 室内环境

### 9.1 空气质量

**9.1.1** 中小学校建筑的室内空气质量应符合现行国家标准《室内空气质量标准》GB／T18883及《民用建筑工程室内环境污染控制规范》GB 50325的有关规定。

**9.1.2** 中小学校教学用房的新风量应符合现行国家标准《公共建筑节能设计标准》GB 50189 的有关规定。

**9.1.3** 当采用换气次数确定室内通风量时，各主要房间的最小换气次数应符合表9.1.3的规定。

**表9.1.3 各主要房间的最小换气次数标准**

| 房间名称 | 房间名称 | 换气次数（次/h） |
| :--- | :--- | :---: |
| 普通教室 | 小学 | 2.5 |
| 普通教室 | 初中 | 3.5 |
| 普通教室 | 高中 | 4.5 |
| 实验室 | 实验室 | 3.0 |
| 风雨操场 | 风雨操场 | 3.0 |
| 厕所 | 厕所 | 10.0 |
| 保健室 | 保健室 | 2.0 |
| 学生宿舍 | 学生宿舍 | 2.5 |

**9.1.4** 中小学校设计中必须对建筑及室内装修所采用的建材、产品、部品进行严格择定，避免对校内空气造成污染。

### 9.2 采 光

**9.2.1** 教学用房工作面或地面上的采光系数不得低于表9.2.1的规定和现行国家标准《建筑采光设计标准》GB/T 50033的有关规定。在建筑方案设计时，其采光窗洞口面积应按不低于表9.2.1窗地面积比的规定估算。

**表9.2.1 教学用房工作面或地面上的采光系数标准和窗地面积比**

| 房间名称 | 规定采光系数<br>的平面 | 采光系数最低值<br>（%） | 窗地面积比 |
| :--- | :--- | :---: | :--- |
| 普通教室、史地教室、<br>美术教室、书法教室、<br>语言教室、音乐教室、<br>合班教室、阅览室 | 课桌面 | 2.0 | 1∶5.0 |
| 科学教室、实验室 | 实验桌面 | 2.0 | 1∶5.0 |
| 计算机教室 | 机台面 | 2.0 | 1∶5.0 |
| 舞蹈教室、风雨操场 | 地面 | 2.0 | 1∶5.0 |
| 办公室、保健室 | 地面 | 2.0 | 1∶5.0 |
| 饮水处、厕所、淋浴 | 地面 | 0.5 | 1∶10.0 |
| 走道、楼梯间 | 地面 | 1.0 | — |

> 注：表中所列采光系数值适用于我国Ⅲ类光气候区，其他光气候区应将表中的采光系数值乘以相应的光气候系数。光气候系数应符合现行国家标准《建筑采光设计标准》GB/T 50033 的有关规定。

**9.2.2** 普通教室、科学教室、实验室、史地、计算机、语言、美术、书法等专用教室及合班教室、图书室均应以自学生座位左侧射入的光为主。教室为南向外廊式布局时，应以北向窗为主要采光面。

**9.2.3** 除舞蹈教室、体育建筑没施外，其他教学用房室内各表面的反射比值应符合表9.2.3的规定，会议室、卫生室(保健室)的室内各表面的反射比值宜符合表9.2.3的规定。

**表9.2.3 教学用房室内各表面的反射比值**

| 表面部位 | 反射比 |
| :--- | :--- |
| 顶棚 | 0.70～0.80 |
| 前墙 | 0.50～0.60 |
| 地面 | 0.20～0.40 |
| 侧墙、后墙 | 0.70～0.80 |
| 课桌面 | 0.25～0.45 |
| 黑板 | 0.10～0.20 |

### 9.3 照 明

**9.3.1** 主要用房桌面或地面的照明设计值不应低于表9.3.1的规定，其照度均匀度不应低于0.7且不应产生眩光。

**表9.3.1 教学用房的照明标准**

| 房间名称 | 规定照度<br>的平面 | 维持平均照度<br>(lx) | 统一眩光值<br>UGR | 显色指数<br>Ra |
| :--- | :--- | :---: | :---: | :---: |
| 普通教室、史地教室、<br>书法教室、音乐教室、<br>语言教室、合班教室、<br>阅览室 | 课桌面 | 300 | 19 | 80 |
| 科学教室、实验室 | 实验桌面 | 300 | 19 | 80 |
| 计算机教室 | 机台面 | 300 | 19 | 80 |
| 舞蹈教室 | 地面 | 300 | 19 | 80 |
| 美术教室 | 课桌面 | 500 | 19 | 90 |
| 风雨操场 | 地面 | 300 | — | 65 |
| 办公室、保健室 | 桌面 | 300 | 19 | 80 |
| 走道、楼梯间 | 地面 | 100 | — | — |

**9.3.2** 主要用房的照明功率密度值及对应照度值应符合表9.3.2的规定及现行国家标准《建筑照明设计标准》GB 50034的有关规定。

**表9.3.2 教学用房的照明功率密度值及对应照度值**

| 房间名称 | 照明功率密度（W/㎡）<br>现行值 | 照明功率密度（W/㎡）<br>目标值 | 对应照度值<br>（lx） |
| :--- | :---: | :---: | :---: |
| 普通教室、史地教室、书法教室、<br>音乐教室、语言教室、合班教室、<br>阅览室 | 11 | 9 | 300 |
| 科学教室、实验室、舞蹈教室 | 11 | 9 | 300 |
| 有多媒体设施的教室 | 11 | 9 | 300 |
| 美术教室 | 18 | 15 | 500 |
| 办公室、保健室 | 11 | 9 | 300 |

### 9.4 噪声控制

**9.4.1** 教学用房的环境噪声控制值应符合现行国家标准《民用建筑隔声设计规范》GB 50118的有关规定。

**9.4.2** 主要教学用房的隔声标准应符合表9.4.2的规定。

**表9.4.2 主要教学用房的隔声标准**

| 房间名称 | 空气声隔声标准<br>（dB） | 顶部楼板撞击声隔声单值<br>评价量（dB） |
| :--- | :---: | :---: |
| 语言教室、阅览室 | ≥50 | ≤65 |
| 普通教室、实验室等与<br>不产生噪声的房间之间 | ≥45 | ≤75 |
| 普通教室、实验室等与<br>产生噪声的房间之间 | ≥50 | ≤65 |
| 音乐教室等<br>产生噪声的房间之间 | ≥45 | ≤65 |

**9.4.3** 教学用房的混响时间应符合现行国家标准《民用建筑隔声设计规范》GB 50118的有关规定。

## 10 建筑设备

### 10.1 采暖通风与空气调节

**10.1.1** 中小学校建筑的采暖通风与空气调节系统的设计应满足舒适度的要求，并符合节约能源的原则。

**10.1.2** 中小学校的采暖与空调冷热源形式应根据所在地的气候特征、能源资源条件及其利用成本，经技术经济比较确定。

**10.1.3** 采暖地区学校的采暖系统热源宜纳入区域集中供热管网。无条件时宜设置校内集中采暖系统。非采暖地区，当舞蹈教室、浴室、游泳馆等有较高温度要求的房间在冬季室温达不到规定温度时，应设置采暖设施。

**10.1.4** 中小学校热环境设计中，当具备条件时，应进行技术经济比较，优先利用可再生能源作为冷热源。

**10.1.5** 中小学校的集中采暖系统应以热水为供热介质，其采暖设计供水温度不宜高于85℃。

**10.1.6** 中小学校的采暖系统应实现分室控温：宜有分区或分层控制手段。

**10.1.7** 中小学校内各种房间的采暖设计温度不应低于表10.1.7的规定。

**10.1.8** 中小学校的通风设计应符合下列规定：
1. 应采取有效的通风措施，保证教学、行政办公用房及服务用房的室内空气中C02的浓度不超过0.15％；
2. 当采用换气次数确定室内通风量时，其换气次数不应低于本规范表9.1.3的规定；
3. 在各种有效通风设施选择中，应优先采用有组织的自然通风设施；
4. 采用机械通风时，人员所需新风量不应低于表10.1.8的规定。

**表10.1.8 主要房间人员所需新风量**

| 房间名称 | 人均新风量(m³/(h·人)) |
| :--- | :---: |
| 普通教室 | 19 |
| 化学、物理、生物实验室 | 20 |
| 语言、计算机教室、艺术类教室 | 20 |
| 合班教室 | 16 |
| 保健室 | 38 |
| 学生宿舍 | 10 |

> 注：人均新风量是指人均生理所需新风量与排除建筑污染所需新风量之和，其中单位面积排除建筑污染所需新风量按1.1m³/(h·m²)计算。

**10.1.9** 除化学、生物实验室外的其他教学用房及教学辅助用房的通风应符合下列规定：
1. 非严寒与非寒冷地区全年，严寒与寒冷地区除冬季外应优先采用开启外窗的自然通风方式；
2. 严寒与寒冷地区于冬季,条件允许时，应采用排风热回收型机械通风方式；其新风量不应低于本规范表10.1.8的规定
3. 严寒与寒冷地区于冬季采用自然通风方式时，应符合下列规定：
    1) 宜在外围护结构的下部设置进风口；
    2) 在内走道墙上部设置排风口或在室内设附墙排风道此时排风口应贴近各层顶棚设置，并应可调节；
    3) 进风口面积不应小于房间面积的1/60；当房间采用散热器采暖时，进风口宜设在进风能被散热器直接加热的部位；
    4) 当排风口设于内走道时，其面积不应小于房间面积的1/30；当设置附墙垂直排风道时，其面积应通过计算确定；
    5) 进、排风口面积与位置宜结合建筑布局经自然通风分析计算确定。

**10.1.10** 化学与生物实验室、药品储藏室、准备室的通风设计应符合下列规定：
1. 应采用机械排风通风方式。排风量应按本规范表10.1确定；最小通风效率应为75％。各教室排风系统及通风柜排风系统均应单独设置。
2. 补风方式应优先采用自然补风，条件不允许时，可采用机械补风。
3. 室内气流组织应根据实验室性质确定,化学实验室宜采用下排风。
4. 强制排风系统的室外排风口宜高于建筑主体，其最低点应高于人员逗留地面2.50m以上。
5. 进、排风口应设防尘及防虫鼠装置，排风口应采用防雨雪进入、抗风向干扰的风口形式。

**10.1.11** 在夏热冬暖、夏热冬冷等气候区中的中小学校，当教学用房、学生宿舍不设空调且在夏季通过开窗通风不能达到基本热舒适度时，应按下列规定设置电风扇：
1. 教室应采用吊式电风扇。各类小学中，风扇叶片距地面高度不应低于2.80m；各类中学中，风扇叶片距地面高度不应低于3.00m。
2. 学生宿舍的电风扇应有防护网。

**10.1.12** 计算机教室、视听阅览室及相关辅助用房宜设空调系统。

**10.1.13** 中小学校的网络控制室应单独设置空调设施，其温、湿度应符合现行国家标准《电子信息系统机房设计规范》GB 50174的有关规定。

### 10.2 给水排水

**10.2.1** 中小学校应设置给水排水系统，并选择与其等级和规模相适应的器具设备。

**10.2.2** 中小学校的用水定额、给水排水系统的选择，应符合现行国家标准《建筑给水排水设计规范》GB 50015的有关规定。

**10.2.3** 中小学校的生活用水水质应符合现行国家标准《生活饮用水卫生标准》GB 5749的有关规定。

**10.2.4** 在寒冷及严寒地区的中小学校中，教学用房的给水引入管上应设泄水装置。有可能产生冰冻部位的给水管道应有防冻措施。

**10.2.5** 当化学实验室绐水水嘴的工作压力大于0.02MPa，急救冲洗水嘴的工作压力大于0.01MPa时，应采取减压措施。

**10.2.6** 中小学校的二次供水系统及自备水源应遵循安全卫生、节能环保的原则，并应符合国家现行标准的有关规定。

**10.2.7** 中小学校的用水器具和配件应采用节水性能良好、坚固耐用，且便于管理维修的产品。室内消火栓箱不宜采用普通玻璃门。

**10.2.8** 实验室化验盆排水口应装设耐腐蚀的挡污箅，排水管道应采用耐腐蚀管材。

**10.2.9** 中小学校的植物栽培园、小动物饲养园和体育场地应设洒水栓及排水设施。

**10.2.10** 中小学校建筑应根据所在地区的生活习惯，供应开水或饮用净水。当采用管道直饮水时，应符合现行行业标准《管道直饮水系统技术规程》CJJ 110的有关规定。

**10.2.11** 中小学校应根据所在地的自然条件、水资源情况及经济技术发展水平，合理设置雨水收集利用系统。雨水利用工程应符合现行国家标准《建筑与小区雨水利用工程技术规范》GB 50400的有关规定。

**10.2.12** 中小学校应按当地有关规定配套建设中水设施。当采用中水时，应符合现行国家标准《建筑中水设计规范》GB 50336的有关规定。

**10.2.13** 化学实验室的废水应经过处理后再排入污水管道。食堂等房间排出的含油污水应经除油处理后再排入污水管道。

### 10.3 建筑电气

**10.3.1** 中小学校应设置安全的供电设施和线路。

**10.3.2** 中小学校的供、配电设计应符合下列规定：
1. 中小学校内建筑的照明用电和动力用电应设总配电装置和总电能计量装置。总配电装置的位置宜深入或接近负荷中心，且便于进出线。
2. 中小学校内建筑的电梯、水泵、风机、空调等设备应设电能计量装置并采取节电措施。
3. 各幢建筑的电源引入处应设置电源总切断装置和可靠的接地装置，各楼层应分别设置电源切断装置。
4. 中小学校的建筑应预留配电系统的竖向贯通井道及配电设备位置。
5. 室内线路应采用暗线敷设。
6. 配电系统支路的划分应符合以下原则：
    1) 教学用房和非教学用房的照明线路应分设不同支路；
    2) 门厅、走道、楼梯照明线路应设置单独支路；
    3) 教室内电源插座与照明用电应分设不同支路；
    4) 空调用电应设专用线路。
7. 教学用房照明线路支路的控制范围不宜过大，以2个～3个教室为宜。
8. 门厅、走道、楼梯照明线路宜集中控制。
9. 采用视听教学器材的教学用房，照明灯具宜分组控制。

**10.3.3** 学校建筑应设置人工照明装置，并应符合下列规定：
1. 疏散走道及楼梯应设置应急照明灯具及灯光疏散指示标志。
2. 教室黑板应设专用黑板照明灯具，其最低维持平均照度应为500lx，黑板面上的照度最低均匀度宜为0.7。黑板灯具不得对学生和教师产生直接眩光。
3. 教室应采用高效率灯具，不得采用裸灯。灯具悬挂高度距桌面的距离不应低于1.70m。灯管应采用长轴垂直于黑板的方向布置。
4. 坡地面或阶梯地面的合班教室，前排灯不应遮挡后排学生视线，并不应产生直接眩光。

**10.3.4** 教室照明光源宜采用显色指数Ra大于80的细管径稀土三基色荧光灯。对识别颜色有较高要求的教室，宜采用显色指数Ra大于90的高显色性光源；有条件的学校，教室宜选用无眩光灯具。

**10.3.5** 中小学校照明在计算照度时，维护系数宜取0.8。

**10.3.6** 教学及教学辅助用房电源设置应符合下列规定：
1. 各教室的前后墙应各设置一组电源插座；每组电源插座均应为220V二孔、三孔安全型插座。
2. 教室内设置视听教学器材时，应配置接线电源。
3. 各实验室内，教学用电应设置专用线路，并应有可靠的接地措施。电源侧应设置短路保护、过载保护措施的配电装置。
4. 科学教室、化学实验室、物理实验室应设置直流电源线路和交流电源线路。
5. 物理实验室内，教师演示桌处应设置三相380V电源插座。
6. 电学实验室的实验桌及计算机教室的微机操作台应设置电源插座。综合实验室的电源插座宜设在靠墙的固定实验桌上。总用电控制开关均应设置在教师演示桌内。
7. 化学实验室内，当实验桌上设置机械排风设施时，排风机应设专用动力电源，其控制开关宜设置在教师实验桌内。

**10.3.7** 行政和生活服务用房的电气设计应符合下列规定：
1. 保健室、食堂的餐厅、厨房及配餐空间应设置电源插座及专用杀菌消毒装置。
2. 教学楼内饮水器处宜设置专用供电电源装置。
3. 学生宿舍居室用电宜设置电能计量装置。电能计量装置宜设置在居室外，并应设置可同时断开相线和中性线的电器装置。
4. 盥洗室、淋浴室应设置局部等电位联结装置。

**10.3.8** 中小学校的电源插座回路、电开水器电源、室外照明电源均应设置剩余电流动作保护器。

### 10.4 建筑智能化

**10.4.1** 中小学校的智能化系统应包括计算机网络控制室、视听教学系统、安全防范监控系统、通信网络系统、卫星接收及有线电视系统、有线广播及扩声系统等。

**10.4.2** 中小学校智能化系统的机房设置应符合下列规定：
1. 智能化系统的机房不应设在卫生间、浴室或其他经常可能积水场所的正下方，且不宜与上述场所相贴邻；
2. 应预留智能化系统的设备用房及线路敷设通道。

**10.4.3** 智能化系统的机房宜铺设架空地板、网络地板，机房净高不宜小于2.50m。

**10.4.4** 中小学校应根据使用需要设置视听教学系统。

**10.4.5** 中小学校视听教学系统应包括控制中心机房设备和各教室内视听教学设备。

**10.4.6** 中小学校视听教学系统组网宜采用专业的线缆。

**10.4.7** 中小学校广播系统的设计应符合下列规定：
1. 教学用房、教学辅助用房和操场应根据使用需要，分别设置广播支路和扬声器。室内扬声器安装高度不应低于2．40m。
2. 播音系统中兼作播送作息音响信号的扬声器应设置在走道及其他场所。
3. 广播线路敷设宜暗敷设。
4. 广播室内应设置广播线路接线箱，接线箱宜暗装，并预留与广播扩音设备控制盘连接线的穿线暗管。
5. 广播扩音设备的电源侧，应设置电源切断装置。

**10.4.8** 学校建筑智能化设计应符合现行国家标准《智能建筑设计标准》GB/T 50314的有关规定。

## 本规范用词说明

1. 为便于在执行本规范条文时区别对待，对要求严格程度不同的用词说明如下：
    1) 表示很严格，非这样做不可的用词：
    正面词采用“必须”，反面词采用“严禁”；
    2) 表示严格，在正常情况均应这样做的用词：
    正面词采用“应”，反面词采用“不应”或“不得”；
    3) 表示允许稍有选择，在条件许可时首先应这样做的用词：
    正面词采用“宜”，反面词采用“不宜”；
    4) 表示有选择，在一定条件下可以这样做的用词，采用“可”。
2. 本规范中指明应按其他有关标准、规范执行的写法为：
“应符合……的规定”或“应按……执行”。

## 引用标准名录

1. 《建筑抗震设计规范》GB 50011
2. 《建筑设计防火规范》GB 50016
3. 《建筑采光设计标准》GB／T 50033
4. 《建筑照明设计标准》GB 50034
5. 《民用建筑隔声设计规范》GB 50118
6. 《电子信息系统机房设计规范》GB 50174
7. 《公共建筑节能设计标准》GB 50189
8. 《建筑内部装修设计防火规范》GB 50222
9. 《智能建筑设计标准》GB／T 50314
10. 《民用建筑工程室内环境污染控制规范》GB 50325
11. 《建筑中水设计规范》GB 50336
12. 《安全防范工程技术规范》GB 50348
13. 《民用建筑设计通则》GB 50352
14. 《建筑与小区雨水利用工程技术规范》GB 50400
15. 《生活饮用水卫生标准》GB 5749
16. 《室内空气质量标准》GB／T18883
17. 《城市道路和建筑物无障碍设计规范》JGJ 50
18. 《管道直饮水系统技术规程》CJJ 110
19. 《游泳池给水排水工程技术规程》CJJ 122