# 《住宅设计规范》 GB 50096-2011

**住房和城乡建设部**  
上传时间： 2025-09-10  
实施时间： 2012-08-01

## 目录

1. [前言](#前言)
2. [1 总则](#1-总则)
3. [2 术语](#2-术语)
4. [3 基本规定](#3-基本规定)
5. [4 技术经济指标计算](#4-技术经济指标计算)
6. [5 套内空间](#5-套内空间)
    - [5.1 套型](#51-套型)
    - [5.2 卧室、起居室 ( 厅 )](#52-卧室起居室-厅)
    - [5.3 厨房](#53-厨房)
    - [5.4 卫生间](#54-卫生间)
    - [5.5 层高和室内净高](#55-层高和室内净高)
    - [5.6 阳台](#56-阳台)
    - [5.7 过道、贮藏空间和套内楼梯](#57-过道贮藏空间和套内楼梯)
    - [5.8 门窗](#58-门窗)
7. [6 共用部分](#6-共用部分)
    - [6.1 窗台、栏杆和台阶](#61-窗台栏杆和台阶)
    - [6.2 安全疏散出口](#62-安全疏散出口)
    - [6.3 楼梯](#63-楼梯)
    - [6.4 电梯](#64-电梯)
    - [6.5 走廊和出入口](#65-走廊和出入口)
    - [6.6 无障碍设计要求](#66-无障碍设计要求)
    - [6.7 信报箱](#67-信报箱)
    - [6.8 共用排气道](#68-共用排气道)
    - [6.9 地下室和半地下室](#69-地下室和半地下室)
    - [6.10 附建公共用房](#610-附建公共用房)
8. [7 室内环境](#7-室内环境)
    - [7.1 日照、天然采光、遮阳](#71-日照天然采光遮阳)
    - [7.2 自然通风](#72-自然通风)
    - [7.3 隔声、降噪](#73-隔声降噪)
    - [7.4 防水、防潮](#74-防水防潮)
    - [7.5 室内空气质量](#75-室内空气质量)
9. [8 建筑设备](#8-建筑设备)
    - [8.1 一般规定](#81-一般规定)
    - [8.2 给水排水](#82-给水排水)
    - [8.3 采暖](#83-采暖)
    - [8.4 燃气](#84-燃气)
    - [8.5 通风](#85-通风)
    - [8.6 空调](#86-空调)
    - [8.7 电气](#87-电气)
10. [本规范用词说明](#本规范用词说明)

---

## 前言

中华人民共和国国家标准  
住宅设计规范  
Design code for residential buildings  
GB 50096-2011  

主编部门：中华人民共和国住房和城乡建设部  
批准部门：中华人民共和国住房和城乡建设部  
施行日期： 2012 年 8 月 1 日  

中华人民共和国住房和城乡建设部公告  
第 1093 号  

### 关于发布国家标准《住宅设计规范》的公告

现批准 《住宅设计规范》为国家标准，编号为 GB 50096-2011 ，自 2012 年 8 月 1 日起实施。其中，第 5.1.1 、 5.3.3 、 5.4.4 、 5.5.2 、 5.5.3 、 5.6.2 、 5.6.3 、 5.8.1 、 6.1.1 、 6.1.2 、 6.1.3 、 6. 2.1 、 6.2.2 、 6.2.3 、 6.2.4 、 6.2.5 、 6.3.1 、 6.3.2 、 6.3.5 、 6.4. 1 、 6.4.7 、 6.5.2 、 6.6.1 、 6.6.2 、 6.6.3 、 6.6.4 、 6.7.1 、 6.9.1 、 6.9.6 、 6.10.1 、 6.10.4 、 7.1.1 、 7.1.3 、 7.1.5 、 7.2.1 、 7.2.3 、 7.3.1 、 7.3.2 、 7.4.1 、 7.4.2 、 7.5.3 、 8.1.1 、 8.1. 2 、 8.1.3 、 8.1.4 、 8.1.7 、 8.2.1 、 8.2.2 、 8.2.6 、 8.2.10 、 8.2.11 、 8.2.12 、 8.3.2 、 8.3.3 、 8.3.4 、 8.3.6 、 8.3.12 、 8.4.1 、 8.4.3 、 8.4.4 、 8.5.3 、 8.7.3 、 8.7.4 、 8.7.5 、 8.7.9 条为强制性条文，必须严格执行。原《住宅设计规范》 GB 50096-1999 （ 2003 年版）同时废止。

本规范由我部标准定额研究所组织中国建筑工业出版社出版发行。

中华人民共和国住房和城乡建设部  
2011 年 7 月 26 日

#### 根据此新规标识废止

《 GB55015-2021 建筑节能与可再生能源利用通用规范》

---------------------------------------------------------------

《住宅设计规范》  
GB 50096-2011  
自 2022 年 4 月 1 日起废止的条文  
第 7.1.5 、 7.2.3 、 8.1.4(2) 、 8.3.2 、 8.3.4 、 8.3.12 条。

#### 根据此新规标识废止

《 GB 55016-2021 建筑环境诵用规范》

------------------------------------------------------------

《住宅设计规范》  
GB 50096-2011  
自 2022 年 4 月 1 日起废止的条文  
第 7.3.1 条  
第 7.4.1 条  
第 7.4.2 条  
第 7.5.3 条

#### 根据此新规标识废止

《 GB 55019-2021 建筑与市政工程无障碍通用规范》

---------------------------------------------------------------------

《住宅设计规范》  
GB 50096-2011  
自 2022 年 4 月 1 日起废止的条文  
第 6.6.2 条  
第 6.6.4 条

### 前言

本规范是根据住房和城乡建设部《关于印发 <2008 年工程建设标准规范制订、修订计划（第一批） > 的通知》（建标 [2008]102 ）号的要求，中国建筑设计研究院会同有关单位共同对《住宅设计规范》 GB 50096-1999 （ 2003 年版）进行修订而成。

本规范在修订过程中，修订组广泛调查研究，认真总结实践经验，参考有关国际标准和国外先进标准，并在充分征求意见的基础上，经多次讨论修改，最后经审查定稿。

本规范共分 8 章，主要技术内容是：总则；术语；基本规定；技术经济指标计算；套内空间；共用部分；室内环境；建筑设备。

本规范修订的主要内容是：
1. 修订了住宅套型分类及各房间最小使用面积，技术经济指标计算，楼、电梯及信报箱的设置等；
2. 增加了术语；
3. 扩展了节能、室内环境、建筑设备和排气道的内容。

本规范中以黑体字标志的条文为强制性条文，必须严格执行。

本规范由住房和城乡建设部负责管理和对强制性条文的解释，由中国建筑设计研究院负责具体技术内容的解释。本规范在执行过程中如发现需要修改和补充之处，请将意见和有关资料寄送中国建筑设计研究院国家住宅工程中心（北京市西城区车公庄大街 19 号，邮政编码： 100044 ），以供今后修订时参考。

## 1 总则

**1.0.1** 为保障城镇居民的基本住房条件和功能质量，提高城镇住宅设计水平，使住宅设计满足安全、卫生、适用、经济等性能要求，制定本规范。

> **条文说明**  
> 1．0．1 城镇住宅建设量大面广，关系到广大城镇居民的切身利益，同时，住宅建设要求投入大量资金、土地和建材等资源，如何根据我国国情合理地使用有限的资金和资源，以满足广大人民对住房的要求，保障居民最低限度的居住条件，提高城镇住宅功能质量，使住宅设计符合适用、安全、卫生、经济等基本要求，是制定本规范的目的。 《住宅设计规范》 GB 50096-1999( 以下简称 原规范 ) 自 1999 年起施行至今已超过 10 年， 2003 年 版完成 局部修订，执行至今也已有 7 年，在我国住房商品化的全过程中发挥了巨大作用。但是，随着我国住房市场快速发展，住宅品质有了很大变化，部分条文已不适应当前情况，需要修改并补充新的内容；近年来新颁布或修订的相关法规，在表述和指标方面有所发展变化，需要对本规范的相应条文进行调整，避免执行中的矛盾；为落实国家建设节能省地型住宅的要求，贯彻高度重视民生与住房保障问题的精神，本规范也应进行修订，正确引导中小套型住宅设计与开发建设。 本次修订扩充了原来各章节的内容，修改了部分经济技术指标的低限要求和计算方法，以便进一步保证住宅设计质量，促进城镇住宅建设健康发展。

**1.0.2** 本规范适用于全国城镇新建、改建和扩建住宅的建筑设计。

> **条文说明**  
> 1．0．2 目前我国城镇住宅形式多样，但基本功能及安全、卫生要求是一样的，本规范对这些设计的基本要求作了明确的规定，故本规范适用于全国城镇新建、改建和扩建的各种类型的住宅设计。

**1.0.3** 住宅设计必须执行国家有关方针、政策和法规，遵守安全卫生、环境保护、节约用地、节约能源资源等有关规定。

> **条文说明**  
> 1．0．3 住宅建设关系到民生以及社会和谐，国家对住宅建设非常重视，制定了一系列方针政策和法规，住宅设计时必须严格贯彻执行。本条阐述了住宅设计的基本原则，重点突出了保证安全卫生、节约资源、保护环境的要求，住宅设计时必须统筹考虑，全面协调，在我国城镇住宅建设可持续发展方面发挥其应有的作用。

**1.0.4** 住宅设计除应符合本规范外，尚应符合国家现行有关标准的规定。

> **条文说明**  
> 1．0．4 住宅设计涉及建筑、结构、防火、热工、节能、隔声、采光、照明、给排水、暖通空调、电气等各种专业，各专业已有规范规定的内容，除必要的重申外，本规范不再重复，因此设计时除执行本规范外，尚应符合国家现行的有关标准的规定。主要有： 《民用建筑设计通则》 GB 50352 《建筑设计防火规范》 GB 50016 《高层民用建筑设计防火规范》 GB 50045 《住宅建筑规范》 GB 50368 《城市居住区规划设计规范》 GB 50180 《建筑工程建筑面积计算规范》 GB/T 50353 《安全防范工程技术规范》 GB 50348 《建筑抗震设计规范》 GB 50011 《建筑采光设计标准》 GB/T 50033 《民用建筑隔声设计规范》 GB 50118 《住宅信报箱工程技术规范》 GB 50631 《民用建筑工程室内环境污染控制规范》 GB 50325 《城镇燃气设计规范》 GB 50028 《建筑给水排水设计规范》 GB 50015 《城市道路和建筑物无障碍设计规范》 JGJ 50 《严寒和寒冷地区居住建筑节能设计标准》 JGJ 26 《夏热冬冷地区居住建筑节能设计标准》 JGJ 134 《夏热冬暖地区居住建筑节能设计标准》 JGJ 75 《电梯主要参数及轿厢、井道、机房的型式与尺寸》 GB/T 7025．1

## 2 术语

**2.0.1** 住宅 residential building  
供家庭居住使用的建筑。

> **条文说明**  
> 2．0．1 本定义提出了住宅的两个关键概念： “ 家庭 ” 和 “ 房子 ” 。申明 “ 房子 ” 的设计规范主要是按照 “ 家庭 ” 的居住使用要求来规定的。未婚的或离婚后的单身男女以及孤寡老人作为家庭的特殊形式，居住在普通住宅中时，其居住使用要求与普通家庭是一致的。作为特殊人群，居住在单身公寓或老年公寓时，则应另行考虑其特殊居住使用要求，在《住宅设计规范》 GB 50096 中不需予以特别考虑。因为除了有《住宅设计规范》 GB 50096 外，还有《老年人居住建筑标准》 GB/T 50340 和《宿舍建筑设计规范》 JGJ 36 ，这也是公寓和宿舍设计可以不执行《住宅设计规范》 GB 50096 的原因之一。 由于本规范的条文没有出现 ” 公寓 ” 一词，所以本规范没有对公寓进行定义，但是规范执行中经常有关于如何区别 “ 住宅 ” 和 “ 公寓 ” 的疑问，在此作以下说明： 公寓一般指为特定人群提供独立或半独立居住使用的建筑，通常以栋为单位配套相应的公共服务设施。 公寓经常以其居住者的性质冠名，如学生公寓、运动员公寓、专家公寓、外交人员公寓，青年公寓、老年公寓等。公寓中的居住者的人员结构相对住宅中的家庭结构简单，而且在使用周期中较少发生变化。住宅的设施配套标准是以家庭为单位配套的，而公寓一般以栋为单位甚至可以以楼群为单位配套。例如，不必每套公寓设厨房、卫生间，客厅等空间，而且可以采用共用空调、热水供应等计量系统。但是不同公寓之间的某些标准差别很大，如老年公寓在电梯配置、无障碍设计、医疗和看护系统等方面的要求，要比运动员公寓高得多。目前，我国尚未编制通用的公寓设计标准。

**2.0.2** 套型 dwelling unit  
由居住空间和厨房、卫生间等共同组成的基本住宅单位

**2.0.3** 居住空间 habitable space  
卧室、起居室 ( 厅 ) 的统称。

**2.0.4** 卧室 bed room  
供居住者睡眠、休息的空间。

**2.0.5** 起居室 ( 厅 ) living room  
供居住者会客、娱乐、团聚等活动的空间。

**2.0.6** 厨房 kitchen  
供居住者进行炊事活动的空间。

**2.0.7** 卫生间 bathroom  
供居住者进行便溺、洗浴、盥洗等活动的空间。

**2.0.8** 使用面积 usable area  
房间实际能使用的面积，不包括墙、柱等结构构造的面积。

**2.0.9** 层高 storey height  
上下相邻两层楼面或楼面与地面之间的垂直距离。

**2.0.10** 室内净高 interior net storey height  
楼面或地面至上部楼板底面或吊顶底面之间的垂直距离。

**2.0.11** 阳台 balcony  
附设于建筑物外墙设有栏杆或栏板，可供人活动的空间。

**2.0.12** 平台 terrace  
供居住者进行室外活动的上人屋面或由住宅底层地面伸出室外的部分。

> **条文说明**  
> 2．0．12 本条所指的平台是住宅里常见的上人屋面，或由住宅底层地面伸出的供人们室外活动的平台。不同于楼梯平台、设备平台、非上人屋面等情况。

**2.0.13** 过道 passage  
住宅套内使用的水平通道。

**2.0.14** 壁柜 cabinet  
建筑室内与墙壁结合而成的落地贮藏空间。

**2.0.15** 凸窗 bay-window  
凸出建筑外墙面的窗户。

> **条文说明**  
> 2．0．15 凸窗既作为窗，在设计和使用时就应有别于地板 ( 楼板 ) 的延伸，也就是说不能把地板延伸出去而仍称之为凸窗。凸窗的窗台应只是墙面的一部分且距地面应有一定高度。凸窗的窗台防护高度要求与普通窗台一样，应按本规范的相关规定进行设计。

**2.0.16** 跃层住宅 duplex apartment  
套内空间跨越两个楼层且设有套内楼梯的住宅。

> **条文说明**  
> 2．0．16 跃层住宅的主要特征就是一户人家的户内居住面积跨越两层楼面，此时连接上下层的楼梯就是户内楼梯，在楼梯的设计及消防要求上均有别于公共楼梯。跃层住宅可以位于楼房的下部、中部，也可设置于顶层。

**2.0.17** 自然层数 natural storeys  
按楼板、地板结构分层的楼层数。

**2.0.18** 中间层 middle-floor  
住宅底层、入口层和最高住户入口层之间的楼层。

**2.0.19** 架空层 open floor  
仅有结构支撑而无外围护结构的开敞空间层。

**2.0.20** 走廊 gallery  
住宅套外使用的水平通道。

**2.0.21** 联系廊 inte-unit gallery  
联系两个相邻住宅单元的楼、电梯间的水平通道。

**2.0.22** 住宅单元 residential building unit  
由多套住宅组成的建筑部分，该部分内的住户可通过共用楼梯和安全出口进行疏散。

**2.0.23** 地下室 basement  
室内地面低于室外地平面的高度超过室内净高的 1／2 的空间。

**2.0.24** 半地下室 semi-basement  
室内地面低于室外地平面的高度超过室内净高的 1／3 ，且不超过 1／2 的空间。

**2.0.25** 附建公共用房 accessory assembly occupancy building  
附于住宅主体建筑的公共用房，包括物业管理用房、符合噪声标准的设备用房、中小型商业用房、不产生油烟的餐饮用房等。

**2.0.26** 设备层 mechanical floor  
建筑物中专为设置暖通、空调、给水排水和电气的设备和管道施工人员进入操作的空间层。

## 3 基本规定

**3.0.1** 住宅设计应符合城镇规划及居住区规划的要求，并应经济、合理、有效地利用土地和空间。

> **条文说明**  
> 3．0．1 本规范只对住宅单体工程设计作出规定，但住宅与居住区规划密不可分，住宅的日照、朝向、层数、防火等与规划的布局、建筑密度、建筑容积率、道路系统、竖向设计等都有内在的联系。我国人口多土地少，合理节约用地是住宅建设中日益突出的重要课题。通过住宅单体设计和群体布置中的节地措施，可显著提高土地利用率，因此必须在设计时给予充分重视。

**3.0.2** 住宅设计应使建筑与周围环境相协调，并应合理组织方便、舒适的生活空间。

> **条文说明**  
> 3．0．2 通过住宅设计，使 “ 人、建筑、环境 ” 三要素紧密联系在一起，共同形成一个良好的居住环境。同时因地制宜地创造可持续发展的生态环境，为居住区创造既便于邻里交往又赏心悦目的生活环境，是满足人居住活动中生理、心理的双重需要。

**3.0.3** 住宅设计应以人为本，除应满足一般居住使用要求外，尚应根据需要满足老年人、残疾人等特殊群体的使用要求。

> **条文说明**  
> 3．0．3 住宅是供人使用的，因此住宅设计处处要以人为本。本条文要求住宅设计在满足一般居住者的使用要求外，还要兼顾老年人、残疾人等特殊群体的使用要求。

**3.0.4** 住宅设计应满足居住者所需的日照、天然采光、通风和隔声的要求。

> **条文说明**  
> 3．0．4 居住者大部分时间是在住宅室内度过的，因此使住宅室内具有良好的通风、充足的日照、明亮的采光和安静私密的声环境是住宅设计的重要任务。

**3.0.5** 住宅设计必须满足节能要求，住宅建筑应能合理利用能源。宜结合各地能源条件，采用常规能源与可再生能源结合的供能方式。

> **条文说明**  
> 3．0．5 节能、环保是一件关乎国计民生的大事，世界各国都相当关注。我国政府高度重视资源环境问题，实施可持续发展战略，把节约资源、保护环境作为基本国策，努力建设资源节约型和环境友好型社会。随着我国城镇化步伐的加快，人民生活水平的持续提高，对住宅功能、舒适度等方面的要求越来越高，如果延续传统的建设模式，我国的土地、能源、资源和环境都将难以承受。因此住宅设计要注意满足节能要求，并合理利用能源，各地住宅建设可根据当地能源条件，积极采用常规能源与可再生能源结合的供能系统与设备。

**3.0.6** 住宅设计应推行标准化、模数化及多样化，并应积极采用新技术、新材料、新产品，积极推广工业化设计、建造技术和模数应用技术。

> **条文说明**  
> 3．0．6 我国住宅建筑量大面广，工业化与产业化是住宅发展的趋势，只有推行建筑主体、建筑设备与建筑构配件的标准化、模数化，才能适应工业化生产。目前建筑新技术、新产品、新材料层出不穷，国家正在实行住宅产业现代化的政策，提高住宅产品质量。因此，住宅设计人员有责任在设计中积极采用新技术、新材料、新产品。

**3.0.7** 住宅的结构设计应满足安全、适用和耐久的要求。

> **条文说明**  
> 3．0．7 随着住房市场的发展，住宅建筑的形式也不断创新，对住宅结构设计也提出了更高的要求。本条要求住宅设计在保证结构安全、可靠的同时，要满足建筑功能需求，使住宅更加安全、适用、耐久。

**3.0.8** 住宅设计应符合相关防火规范的规定，并应满足安全疏散的要求。

> **条文说明**  
> 3．0．8 进入 21 世纪以来，全球城市火灾问题日益严重，其中居民住宅火灾发生率显著增加。住宅火灾不仅威胁人民生命安全，造成严重经济损失，而且给家庭带来巨大伤害，影响社会和谐稳定。因此，住宅设计符合防火要求是最重要且基本的要求之一，具有重要意义。住宅防火设计的主要依据是《建筑设计防火规范》 GB 50016 和《高层民用建筑设计防火规范》 GB 50045 。除防火之外。避震、防空、突发事件等的安全疏散要求也要予以满足。

**3.0.9** 住宅设计应满足设备系统功能有效、运行安全、维修方便等基本要求，并应为相关设备预留合理的安装位置。

> **条文说明**  
> 3．0．9 本条要求建筑设计专业和建筑设备设计的各专业进行协作设计，综合考虑建筑设备和管线的配置，并提供必要的设置空间和检修条件。同时要求建筑设备设计也要树立建筑空间合理布局的整体观念。

**3.0.10** 住宅设计应在满足近期使用要求的同时，兼顾今后改造的可能。

> **条文说明**  
> 3．0．10 住宅物质寿命一般不少于 50 年，而生活水平的提高，家庭结构的变化，人口老龄化的趋势，新技术和产品的不断涌现，又会对住宅提出各种新的功能要求，这将会导致对旧住宅的更新改造。如果在设计时充分考虑建筑和居住者全生命周期的使用需求，兼顾当前使用和今后改造的可能，将大大延长住宅的使用寿命，比新建住宅节省大量投资和材料

## 4 技术经济指标计算

**4.0.1** 住宅设计应计算下列技术经济指标： 
—— 各功能空间使用面积 (m²) ； 
—— 套内使用面积 (m²／套) ； 
—— 套型阳台面积 (m²／套) ； 
—— 套型总建筑面积 (m²／套) ； 
—— 住宅楼总建筑面积 (m²) 。

> **条文说明**  
> 4．0．1 在住宅设计阶段计算的各项技术经济指标，是住宅从计划、规划到施工、管理各阶段技术文件的重要组成部分。本条要求计算的 5 项主要经济指标，必须在设计中明确计算出来并标注在图纸中。本次修编由原规范的 7 项经济指标简化为 5 项，并对其计算方法进行了部分修改，其主要目的是避免矛盾、体现公平、统一标准，反映客观实际。

**4.0.2** 计算住宅的技术经济指标，应符合下列规定： 
1. 各功能空间使用面积应等于各功能空间墙体内表面所围合的水平投影面积； 
2. 套内使用面积应等于套内各功能空间使用面积之和； 
3. 套型阳台面积应等于套内各阳台的面积之和；阳台的面积均应按其结构底板投影净面积的一半计算； 
4. 套型总建筑面积应等于套内使用面积、相应的建筑面积和套型阳台面积之和； 
5. 住宅楼总建筑面积应等于全楼各套型总建筑面积之和。

> **条文说明**  
> 4．0．2 住宅设计经济指标的计算方法有多种，本条要求采用统一的计算规则，这有利于方案竞赛、工程投标、工程立项、报建、验收、结算以及销售、管理等各环节的工作，可有效避免各种矛盾。本次修编针对本条的修改主要为以下几个方面。  
> 1 原规范的 “ 各功能空间使用面积 ” 和 “ 套内使用面积 ” 两项指标的概念及其计算方法受到广大设计人员的普遍认同，本次修编未作修改。  
> 2 本次修编取消了原规范中 “ 住宅标准层使用面积系数 ” 这项指标。该指标过去主要用于方案设计阶段的指标比较，其结果与工程设计实践中以栋为单位计算建筑面积存在一定误差。因此，本次不再继续使用。  
> 3 根据现行国家标准《建筑工程建筑面积计算规范》 GB／T 50353 中有关阳台面积计算方法，对原规范中套型阳台面积的计算方法进行了修改，明确规定其计算方法为：无论阳台为凹阳台、凸阳台、封闭阳台和不封闭阳台均按其结构底板投影净面积一半计算。  
> 4 本次修编明确了套型总建筑面积的构成要素是套内使用面积、相应的建筑面积和套型阳台面积，保证了住宅楼总建筑面积与全楼各套型总建筑面积之和不会产生数值偏差。 “ 套型总建筑面积 ” 不同于原规范中的 “ 套型建筑面积 ” 指标，原规范中 “ 套型建筑面积 ” 反映的是标准层各种要素的计算结果；本次修编的 “ 套型总建筑面积 ” 反映的是整栋楼各种要素的计算结果。  
> 5 本次修编增加了 “ 住宅楼总建筑面积 ” 这项指标，便于规划设计工作中经济指标的计算和数值的统一。

**4.0.3** 套内使用面积计算，应符合下列规定： 
1. 套内使用面积应包括卧室、起居室 ( 厅 ) 、餐厅、厨房、卫生间、过厅、过道、贮藏室、壁柜等使用面积的总和； 
2. 跃层住宅中的套内楼梯应按自然层数的使用面积总和计入套内使用面积； 
3. 烟囱、通风道、管井等均不应计入套内使用面积； 
4. 套内使用面积应按结构墙体表面尺寸计算；有复合保温层时，应按复合保温层表面尺寸计算； 
5. 利用坡屋顶内的空间时，屋面板下表面与楼板地面的净高低于 1.20m 的空间不应计算使用面积，净高在 1.20m ～ 2.10m 的空间应按 1／2 计算使用面积，净高超过 2.10m 的空间应全部计入套内使用面积；坡屋顶无结构顶层楼板，不能利用坡屋顶空间时不应计算其使用面积； 
6. 坡屋顶内的使用面积应列入套内使用面积中。

> **条文说明**  
> 4．0．3 套内使用面积计算是计算住宅设计技术经济指标的基础，本条明确规定了计算范围：  
> 1 套内使用面积指每套住宅户门内独自使用的面积，包括卧室、起居室 ( 厅 ) 、餐厅、厨房、卫生间、过厅、过道、贮藏室等各种功能空间，以及壁柜等使用空间的面积。根据本规范 2．0．14 条，壁柜定义为 “ 建筑室内与墙壁结合而成的落地贮藏空间 ” ，因此其使用面积应只计算落地部分的净面积，并计入套内使用面积。套型阳台面积单独计算，不列入套内使用面积之中。  
> 2 跃层住宅的套内使用面积包括其室内楼梯，并将其按自然层数计入使用面积；  
> 3 本条规定烟囱、排气道、管井等均不计入使用面积，反映了使用面积是住户真正能够使用的面积。该条规定，尤其对厨房、卫生间等小空间面积分析时更具准确性，能够正确反映设计的合理性。  
> 4 正常的墙体按结构体表面尺寸计算使用面积，粉刷层可以简略。遇有各种复合保温层时，要将复合层视为结构墙体厚度扣除后再计算。  
> 5 利用坡屋顶内作为使用空间时，对低于 1．20m 净高的不予计入使用面积；对 1．20m ～ 2．10m 的计入 1／2 ；超过 2．10m 全部计入。坡屋顶无结构顶层楼板，不能利用坡屋顶空间时不计算其使用面积。  
> 6 本次修编对原条文进行了修改，本条规定将坡屋顶内的使用面积列入套内使用面积中，加大了计算比值，将利用坡屋顶所获得的使用面积惠及全楼各套型，更好地体现公平性。同时，可以准确计算出参与公共面积分摊后的该套型总建筑面积。

**4.0.4** 套型总建筑面积计算，应符合下列规定： 
1. 应按全楼各层外墙结构外表面及柱外沿所围合的水平投影面积之和求出住宅楼建筑面积，当外墙设外保温层时，应按保温层外表面计算； 
2. 应以全楼总套内使用面积除以住宅楼建筑面积得出计算比值； 
3. 套型总建筑面积应等于套内使用面积除以计算比值所得面积，加上套型阳台面积。

> **条文说明**  
> 4．0．4 原规范没有要求计算套型的总建筑面积，不能直观地反映一套住宅所涵盖的建筑面积到底是多少，本次修编对此给予明确：  
> 1 原规范的套型面积计算方法是利用住宅标准层使用面积系数反求套型建筑面积，其计算参数以标准层为计算参数。本次修编以住宅整栋楼建筑面积为计算参数，该参数包括了本栋住宅楼地上的全部住宅建筑面积，但不包括本栋住宅楼的套型阳台面积总和，这样更能够体现准确性和合理性，保证各套型总建筑面积之和与住宅楼总建筑面积一致。 本栋住宅楼地上全部住宅建筑面积包括了供本栋住宅楼使用的地上机房和设备用房建筑面积，以及当住宅和其他功能空间处于同一建筑物内时，供本栋住宅楼使用的单元门厅和相应的交通空间建筑面积，不包括本栋住宅楼地下室和半地下室建筑面积。  
> 2 本次修编以全楼总套内使用面积除以住宅楼建筑面积 ( 包括本栋住宅楼地上的全部住宅建筑面积，但不包括本栋住宅楼的套型阳台面积 ) ，得出一个用来计算套型总建筑面积的计算比值。与原规范采用的住宅标准层使用面积系数含义不同，该计算比值相当于全楼的使用面积系数，采用该计算比值可避免同一套型出现不同建筑面积的现象。  
> 3 利用计算比值的计算方法明确了套型总建筑面积为套内使用面积、通过计算比值反算出的相应的建筑面积和套型阳台面积之和。

**4.0.5** 住宅楼的层数计算应符合下列规定： 
1. 当住宅楼的所有楼层的层高不大于 3.00m 时，层数应按自然层数计； 
2. 当住宅和其他功能空间处于同一建筑物内时，应将住宅部分的层数与其他功能空间的层数叠加计算建筑层数。当建筑中有一层或若干层的层高大于 3.00m 时，应对大于 3.00m 的所有楼层按其高度总和除以 3.00m 进行层数折算，余数小于 1.50m 时，多出部分不应计入建筑层数，余数大于或等于 1.50m 时，多出部分应按 1 层计算； 
3. 层高小于 2.20m 的架空层和设备层不应计入自然层数； 
4. 高出室外设计地面小于 2.20m 的半地下室不应计入地上自然层数。

> **条文说明**  
> 4．0．5 本条规定了住宅楼层数的计算依据，主要用于明确住宅楼的层数，便于执行本规范的相关规定。  
> 1 本条规定考虑到与现行相关防火规范和现行国家标准《住宅建筑规范》 GB 50368 的衔接，以层数作为衡量高度的指标，并对层高较大的楼层规定了计算和折算方法。建筑层数应包括住宅部分的层数和其他功能空间的层数。住宅建筑的高度和面积直接影响到火灾时建筑内人员疏散的难易程度、外部救援的难易程度以及火灾可能导致财产损失的大小，住宅建筑的防火与疏散，因此要求与建筑高度和面积直接相关联。对不同建筑高度和建筑面积的住宅区别对待，可解决安全性和经济性的矛盾。  
> 2 本条考虑到与现行国家标准《房产测量规范 第 1 单元：房产测量规定》 GB／T 17986．1 的衔接，规定了高出室外地坪小于 2．20m 的半地下室和层高小于 2．20m 的架空层和设备层不计入自然层数。

## 5 套内空间

### 5.1 套型

**5.1.1** 住宅应按套型设计，每套住宅应设卧室、起居室 ( 厅 ) 、厨房和卫生间等基本功能空间。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 5.1.1 住宅按套型设计是指每套住宅的分户界限应明确，必须独门独户，每套住宅至少包含卧室、起居室 ( 厅 ) 、厨房和卫生间等基本功能空间。本条要求将这些基本功能空间设计于户门之内。不得与其他套型共用或合用。这里要进一步说明的是：基本功能空间不等于房间，没有要求独立封闭，有时不同的功能空间会部分地重合或相互 “ 借用 ” 。当起居功能空间和卧室功能空间合用时，称为兼起居的卧室。

**5.1.2** 套型的使用面积应符合下列规定： 
1. 由卧室、起居室 ( 厅 ) 、厨房和卫生间等组成的套型，其使用面积不应小于 30m² ； 
2. 由兼起居的卧室、厨房和卫生间等组成的最小套型，其使用面积不应小于 22m² 。

> **条文说明**  
> 5.1.2 本次修编删除了原规范对住宅套型的分类。经过对原规范一类套型最小使用面积的论证和适当减小，重新规定了套型最小使用面积分别不应小于 30m² 和 22m² ，主要依据如下：  
> 1 本条明确了设计规范主要是按照 “ 家庭 ” 的居住使用要求来规定的。本条规定的低限标准为统一要求，不因地区气候条件、墙体材料等不同而有差异。  
> 2 套型最小使用面积，不应是各个最小房间面积的简单组合。即使在工程设计理论和实践中，可能设计出更小的套型，但是这种套型是不能满足最低使用要求的。 此外，未婚的或离婚后的单身男女以及孤寡老人作为家庭的特殊形式，居住在普通住宅中时，其居住使用要求与普通家庭是一致的。作为特殊人群，居住在单身公寓或老年公寓时。则应另行考虑其特殊居住使用要求，由其他相关规范作出规定。  
> 3 原规范规定的由卧室、起居室 ( 厅 ) 、厨房和卫生间等组成的住宅套型，虽然组成空间数不变，但因为综合考虑我国中小套型住房建设的国策，以及住宅部品技术产业化、集成化和家电设备技术更新等因素，各种住宅部品及家电尺寸有所减小，对各功能空间尺度的要求也相应减小。所以将原规范规定不应小于 34m² 下调为不应小于 30m² 。其具体测算方法是：  
> 4 明确了基本功能空间不等于房间，没有要求独立封闭，有时不同的功能空间会部分地重合或相互 “ 借用 ” 。当起居功能空间和卧室功能空间合用时，称为兼起居的卧室等概念以后，提出了采用兼起居的卧室的最小套型，不应小于 22m² 。其具体测算方法是：

### 5.2 卧室、起居室 ( 厅 )

**5.2.1** 卧室的使用面积应符合下列规定： 
1. 双人卧室不应小于 9m² ； 
2. 单人卧室不应小于 5m² ；   
3. 兼起居的卧室不应小于 12m² 。

> **条文说明**  
> 5．2．1 卧室的最小面积是根据居住人口、家具尺寸及必要的活动空间确定的。 原规范规定双人卧室不小于 10m² 。单人卧室不小于 6m² ，本次修编分别减小为 9m² 和 5m² 。其依据为：  
> 1 本规范综合考虑我国中小套型住房建设的国策，以及住宅部品技术产业化、集成化和家电设备技术更新等因素，各种住宅部品及家电尺寸有所减小，对各功能空间尺度的要求也相应减小。所以将原规范规定的双人及单人卧室的使用面积分别减小 1m² 。  
> 2 在小套型住宅设计中，允许采用一种兼有起居活动功能空间和睡眠功能空间为一室的 “ 卧室 ” ，这种兼起居的卧室需要在双人卧室的面积基础上至少增加一组沙发和摆设一个小餐桌的面积 (3m² ) 才能保证家具的布置，所以规定兼起居的卧室为 12m² 。

**5.2.2** 起居室 ( 厅 ) 的使用面积不应小于 10m² 。

> **条文说明**  
> 5．2．2 起居室 ( 厅 ) 是住宅套型中的基本功能空间，由于本规范 5．2．1 第 1 款的条文说明所列的原因，将起居室 ( 厅 ) 的使用面积最小值由原规范的 12m² 减小为 10m² 。

**5.2.3** 套型设计时应减少直接开向起居厅的门的数量。起居室 ( 厅 ) 内布置家具的墙面直线长度宜大于 3m 。

> **条文说明**  
> 5．2．3 起居室 ( 厅 ) 的主要功能是供家庭团聚、接待客人、看电视之用，常兼有进餐、杂物、交通等作用。除了应保证一定的使用面积以外，应减少交通干扰，厅内门的数量如果过多，不利于沿墙面布置家具。根据低限度尺度研究结果， 3m 以上直线墙面保证可布置一组沙发，使起居室 ( 厅 ) 中能有一相对稳定的使用空间。

**5.2.4** 无直接采光的餐厅、过厅等，其使用面积不宜大于 10m² 。

> **条文说明**  
> 5．2．4 较大的套型中，起居室 ( 厅 ) 以外的过厅或餐厅等可无直接采光，但其面积不能太大，否则会降低居住生活标准。

### 5.3 厨房

**5.3.1** 厨房的使用面积应符合下列规定： 
1. 由卧室、起居室 ( 厅 ) 、厨房和卫生间等组成的住宅套型的厨房使用面积，不应小于 4.0m² ； 
2. 由兼起居的卧室、厨房和卫生间等组成的住宅最小套型的厨房使用面积，不应小于 3.5m² 。

> **条文说明**  
> 5.3.1 本次修编厨房的使用面积不再进行分类规定，而是规定其使用面积分别不应小于 4m² 和 3．5m² 。其依据是：根据对全国新建住宅小区的调查统计，厨房使用面积普遍能达到 4m² 以上，所以本次修编对由卧室、起居室 ( 厅 ) 、厨房和卫生间等组成的住宅套型的厨房使用面积未进行修改，仍明确其最小使用面积为 4m2 。 对由兼起居的卧室、厨房和卫生间等组成的住宅套型的厨房面积则规定为 3．5m² 。

**5.3.2** 厨房宜布置在套内近入口处。

> **条文说明**  
> 5．3．2 厨房布置在套内近入口处，有利于管线布置及厨房垃圾清运，是套型设计时达到洁污分区的重要保证，应尽量做到。

**5.3.3** 厨房应设置洗涤池、案台、炉灶及排油烟机、热水器等设施或为其预留位置。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 5．3．3 厨房应设置洗涤池、案台、炉灶及排油烟机等设施或为其预留位置，才能保证住户正常炊事功能要求。现行国家标准《城镇燃气设计规范》 GB 50028 规定，设有直排式燃具的室内容积热负荷指标超过 0．207kW／m³ 时，必须设置有效的排气装置，一个双眼灶的热负荷约为 (8 ～ 9)kW ，厨房体积小于 39m³ 时，体积热负荷就超过 0．207kW／m³ 。一般住宅厨房的体积均达不到 39m³ ( 约大于 16m² ) ，因此均必须设置排油烟机等机械排气装置。

**5.3.4** 厨房应按炊事操作流程布置。排油烟机的位置应与炉灶位置对应，并应与排气道直接连通。

> **条文说明**  
> 5．3．4 厨房设计时若不按操作流程合理布置，住户实际使用时或改造时都将带来极大不便。排油烟机的位置只有与炉灶位置对应并与排气道直接连通，才能最有效地发挥排气效能。

**5.3.5** 单排布置设备的厨房净宽不应小于 1.50m ；双排布置设备的厨房其两排设备之间的净距不应小于 0.90m 。

> **条文说明**  
> 5．3．5 单排布置的厨房，其操作台最小宽度为 0．50m ，考虑操作人下蹲打开柜门、抽屉所需的空间或另一人从操作人身后通过的极限距离，要求最小净宽为 1．50m 。双排布置设备的厨房，两排设备之间的距离按人体活动尺度要求，不应小于 0．90m 。

### 5.4 卫生间

**5.4.1** 每套住宅应设卫生间，应至少配置便器、洗浴器、洗面器三件卫生设备或为其预留设置位置及条件。三件卫生设备集中配置的卫生间的使用面积不应小于 2.50m² 。

> **条文说明**  
> 5.4.1 本次修编不再进行分类和规定设置卫生间的个数，仅规定了每套住宅应配置的卫生设备的种类和件数，强调至少应配置便器、洗浴器、洗面器三件卫生设备或为其预留设置位置及条件，以保证基本生活需求。 本次修编明确规定集中配置便器、洗浴器、洗面器三件卫生设备的卫生间使用面积不应小于 2.50m² ，比原规范规定数值减小 0.5m² 。其修改依据是：由于住宅集成化技术的不断成熟，设备成套技术的不断推广，提高了卫生间面积的利用效率。

**5.4.2** 卫生间可根据使用功能要求组合不同的设备。不同组合的空间使用面积应符合下列规定： 
1. 设便器、洗面器时不应小于 1.80m² ； 
2. 设便器、洗浴器时不应小于 2.00m² ； 
3. 设洗面器、洗浴器时不应小于 2.00m² ； 
4. 设洗面器、洗衣机时不应小于 1．80m² ； 
5. 单设便器时不应小于 1.10m² 。

> **条文说明**  
> 5.4.2 本条规定了卫生设备分室设置时几种典型设备组合的最小使用面积。卫生间设计时除应符合本条规定外，还应符合本规范 5.4.1 条对每套住宅卫生设备种类和件数的规定。为适应卫生间成套设备集成技术和卫生设备组合多样化的要求，本次修编增加了两种空间划分类型，并规定了最小使用面积。由不同设备组合而成的卫生间，其最小面积的规定依据是：以卫生设备低限尺度以及卫生活动空间计算最低面积；对淋浴空间和盆浴空间作综合考虑，不考虑便器使用与淋浴活动的空间借用；卫生间面积要适当考虑无障碍设计要求和为照顾儿童使用时留有余地。

**5.4.3** 无前室的卫生间的门不应直接开向起居室 ( 厅 ) 或厨房。

> **条文说明**  
> 5.4.3 无前室的卫生间，其门直接开向厅或厨房的这种布置方法问题突出，诸如 “ 交通干扰 ” 、 “ 视线干扰 ” 、 “ 不卫生 ” 等，本条规定要求杜绝出现这种设计。

**5.4.4** 卫生间不应直接布置在下层住户的卧室、起居室 ( 厅 ) 、厨房和餐厅的上层。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 5.4.4 卫生间的地面防水层，因施工质量差而发生漏水的现象十分普遍，同时管道噪声、水管冷凝水下滴等问题也很严重。因此，本条规定不得将卫生间直接布置在下层住户的卧室、起居室 ( 厅 ) 、厨房和餐厅的上层。

**5.4.5** 当卫生间布置在本套内的卧室、起居室 ( 厅 ) 、厨房和餐厅的上层时，均应有防水和便于检修的措施。

> **条文说明**  
> 5.4.5 在跃层住宅设计中允许将卫生间布置在本套内的卧室、起居室 ( 厅 ) 、厨房或餐厅的上层，尽管在使用上无可非议，对其他套型也毫无影响，但因布置了多种设备和管线，容易损坏或漏水，所以本条要求采取防水和便于检修的措施，减少或消除对下层功能空间的不良影响。

**5.4.6** 每套住宅应设置洗衣机的位置及条件。

> **条文说明**  
> 5.4.6 洗衣为基本生活需求，洗衣机是普遍使用的家用设备，属于卫生设备，通常设置在卫生间内。但是在实际使用中有时设置在阳台、厨房、过道等位置。本条文强调，在住宅设计时，应明确设计出洗衣机的位置及专用给排水接口和电插座等条件。

### 5.5 层高和室内净高

**5.5.1** 住宅层高宜为 2.80m 。

> **条文说明**  
> 5．5．1 把住宅层高控制在 2．80m 以下，不仅是控制投资的问题，更重要的是关系到住宅节地、节能、节水、节材和环保。把层高相对统一，在当前住宅产业化发展的初期阶段很有意义，例如对发展住宅专用电梯、通风排气竖管、成套橱柜等均有现实意义，有一个明确的层高，这类产品的主要参数就可以确定。 2．80m 层高的规定，在全国执行已有多年，对于普通住宅更需进一步要求控制层高，以便节能。

**5.5.2** 卧室、起居室 ( 厅 ) 的室内净高不应低于 2.40m ，局部净高不应低于 2.10m ，且局部净高的室内面积不应大于室内使用面积的 1／3 。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 5．5．2 卧室和起居室 ( 厅 ) 是住宅套内活动最频繁的空间，也是大型家具集中的场所，本条要求其室内净高不低于 2．40m ，以保证基本使用要求。在国际上，把室内净高定位 2．40m 的国家很多，如：美国、英国、日本和我国的香港地区，参照这些国家和地区的标准，室内净高定为 2．40m 是可行的。 另外，据对空气洁净度测试的有关资料分析，不同层高的住宅中，冬季室内空气中的 C02 的浓度值没有明显变化。 卧室、起居室 ( 厅 ) 的室内局部净高不应低于 2．10m ，是指室内梁底处的净高、活动空间上部吊柜的柜底与地面的距离等，只有控制在 2．10m 或以上，才能保证居民的基本活动并具有安全感。 在一间房间中，当低于 2．40m 、高于 2．10m 的梁和吊柜等局部净高的室内面积超过房间面积的 1／3 时，会严重影响使用功能。因此要求这种局部净高的室内面积不应大于室内使用面积的 1／3 。

**5.5.3** 利用坡屋顶内空间作卧室、起居室 ( 厅 ) 时，至少有 1／2 的使用面积的室内净高不应低于 2.10m 。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 5．5．3 利用坡屋顶内空间作为各种活动空间的设计受到普遍欢迎。根据人体工程学原理，居住者在坡屋顶内空间活动时动作相对收敛，所谓 “ 身在屋檐下哪能不低头 ” ，因此，室内净高要求略低于普通房间的净高要求。但是利用坡屋顶内空间作卧室、起居室 ( 厅 ) 时，仍然应有一定的高度要求，特别是需要直立活动的部位，如果净高低于 2．10m 的空间超过一半时，使用困难。 坡屋顶内空间的使用面积不同于房间地板面积。在执行本规范第 5．2．1 条和 5．2．2 条关于卧室、起居室 ( 厅 ) 的最低使用面积规定时，需要根据本规范第 4．0．3 条第 5 款 “ 利用坡屋顶内的空间时，屋面板下表面与楼板地面的净高低于 1．20m 的空间不计算使用面积，净高在 1．20m ～ 2．10m 的空间按 1／2 计算使用面积，净高超过 2．10m 的空间全部计入套内使用面积 ” 的规定，保证卧室、起居室 ( 厅 ) 的最小使用面积标准符合要求。

**5.5.4** 厨房、卫生间的室内净高不应低于 2.20m 。

> **条文说明**  
> 5．5．4 厨房和卫生间人流交通较少，室内净高可比卧室和起居室 ( 厅 ) 低。但有关燃气设计安装规范要求厨房不低于 2．20m ；卫生间从空气容量、通风排气的高度要求等考虑也不应低于 2．20m 。另外从厨、卫设备的发展看，室内净高低于 2．20m 不利于设备及管线的布置。

**5.5.5** 厨房、卫生间内排水横管下表面与楼面、地面净距不得低于 1.90m ，且不得影响门、窗扇开启。

> **条文说明**  
> 5．5．5 厨房、卫生间面积较小，顶板下的排水横管即使靠墙设置，其管底 ( 特别是存水弯 ) 的底部距楼、地面净距若太低，常常造成碰撞并且妨碍门、窗户开启。本条对此作出相关规定。

### 5.6 阳台

**5.6.1** 每套住宅宜设阳台或平台。

> **条文说明**  
> 5．6．1 阳台是室内与室外之间的过渡空间，在城镇居住生活中发挥了越来越重要的作用。本条要求每套住宅宜设阳台，住宅底层和退台式住宅的上人屋面层可设平台。

**5.6.2** 阳台栏杆设计必须采用防止儿童攀登的构造，栏杆的垂直杆件间净距不应大于 0.11m ，放置花盆处必须采取防坠落措施。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 5.6.2 阳台是儿童活动较多的地方，栏杆（包括栏板的局部栏杆）的垂直杆件间距若设计不当，容易造成事故。根据人体工程学原理，栏杆垂直净距应小于 0.11m ，才能防止儿童钻出。同时为防止因栏杆上放置花盆儿坠落伤人，本条要求可搁置花盆的栏杆必须采取防止坠落措施。

**5.6.3** 阳台栏板或栏杆净高，六层及六层以下不应低于 1.05m ；七层及七层以上不应低于 1.10m 。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 5.6.3 阳台栏杆的防护高度是根据人体重心稳定和心理要求确定的，应随建筑高度增高而增高。阳台（包括封闭阳台）栏杆或栏板的构造一般与窗台不同，且人站在阳台前比站在窗前有更加靠近悬崖的眩晕感，如图 1 所示，人体距离建筑外边沿的距离 b 明显小于 a ，其重心稳定性和心理安全要求更高。所以本条规定阳台栏杆的净高不应按窗台高度设计。 此外，强调封闭阳台栏杆的高度不同于窗台高度的另一理由是本规范相关条文一致性的需要。封闭阳台也是阳台，本规范在 “ 面积计算 ” 、 “ 采光、通风窗地比指标要求 ” 、 “ 隔声要求 ” 、 “ 节能要求 ” 、 “ 日照间距 ” 等方面的规定，都是不同于对窗户的规定的。 本次修编还对原规范中关于建筑层数的定义进行了修改，使之与现行国家标准《住宅建筑规范》 GB 50368 相一致，在本条文中不再出现 “ 高层住宅 ” 、 “ 中高层住宅 ” 等词。

**5.6.4** 封闭阳台栏板或栏杆也应满足阳台栏板或栏杆净高要求。七层及七层以上住宅和寒冷、严寒地区住宅宜采用实体栏板。

> **条文说明**  
> 5．6．4 七层及七层以上住宅以及寒冷、严寒地区住宅的阳台采用实体栏板，可以防止冷风从阳台灌入室内，还可防止物品从过高处的栏杆缝隙处坠落伤人。

**5.6.5** 顶层阳台应设雨罩，各套住宅之间毗连的阳台应设分户隔板。

> **条文说明**  
> 5．6．5 由于住宅部品生产技术的不断成熟，现在已有大量成熟的晾衣部品，在其安装时不会造成漏水、滴水现象。实态调查表明，居民多数将施工过程中安装的晒衣架拆除，造成浪费。所以本次修编不再要求 “ 设置晾晒衣物的设施 ” 。 顶层住宅阳台若没有雨罩，就会给晾晒衣物带来不便。同时，阳台上的雨水、积水容易流入室内，故规定顶层阳台应设置雨罩。 各套住宅之间毗邻的阳台分隔板是套与套之间明确的分界线，对居民的领域感起保证作用，对安全防范也有重要作用，在设计时明确分隔，可减少管理上的矛盾。

**5.6.6** 阳台、雨罩均应采取有组织排水措施，雨罩及开敞阳台应采取防水措施。

> **条文说明**  
> 5．6．6 实态调查表明，由于阳台及雨罩排水组织不当，造成上下层的干扰十分严重，如上层浇花、冲洗阳台而弄脏下层晾晒的衣服甚至浇淋到他人身上的事故常常引发邻里矛盾，故阳台、雨罩均应做有组织排水。本次修编将本条修改为 “ 应采取防水措施 ” ，主要是针对容易漏水的关键节点要求采取防水措施。

**5.6.7** 当阳台设有洗衣设备时应符合下列规定： 
1. 应设置专用给、排水管线及专用地漏，阳台楼、地面均应做防水； 
2. 严寒和寒冷地区应封闭阳台，并应采取保温措施。

> **条文说明**  
> 5．6．7 当阳台设置洗衣机设备时，为方便使用要求设置专用给排水管线、接口和插座等，并要求设置专用地漏，减少溢水的可能。在这种情况下，阳台是用水较多的地方。如出现洗衣设备跑漏水现象，容易造成阳台漏水。所以，本条规定该类阳台楼地面应做防水。为防止严寒和寒冷地区冬季将给排水管线冻裂。本条规定应封闭阳台，并应采取保温措施，防止以上现象的发生。

**5.6.8** 当阳台或建筑外墙设置空调室外机时，其安装位置应符合下列规定： 
1. 应能通畅地向室外排放空气和自室外吸入空气； 
2. 在排出空气一侧不应有遮挡物； 
3. 应为室外机安装和维护提供方便操作的条件； 
4. 安装位置不应对室外人员形成热污染。

> **条文说明**  
> 5．6．8 当阳台设置空调室外机时，如安装措施不当，会降低空调室外机排热效果，降低制冷工效，会对居民在阳台上的正常活动以及对室外和其他住户环境造成影响。因此，本条对阳台或建筑外墙空调室外机的设置作出了具体规定。其中本条第 2 款规定在排出空气一侧不应有遮挡物，不包括百叶。但空调室外机所设置的百叶仅是装饰物，叶片间距太小，会影响空调室外机散热，因此在满足一定的视线遮挡效果时，叶片间距越大越好。

### 5.7 过道、贮藏空间和套内楼梯

**5.7.1** 套内入口过道净宽不宜小于 1.20m ；通往卧室、起居室 ( 厅 ) 的过道净宽不应小于 1.00m ；通往厨房、卫生间、贮藏室的过道净宽不应小于 0.90m 。

> **条文说明**  
> 5．7．1 套内入口的过道，常起门斗的作用，既是交通要道，又是更衣、换鞋和临时搁置物品的场所，是搬运大型家具的必经之路。在大型家具中沙发、餐桌、钢琴等尺度较大，本条规定在一般情况下，过道净宽不宜小于 1．20m 。 通往卧室、起居室 ( 厅 ) 的过道要考虑搬运写字台、大衣柜等的通过宽度，尤其在入口处有拐弯时，门的两侧应有一定余地，故本条规定该过道不应小于 1．00m 。通往厨房、卫生间、贮藏室的过道净宽可适当减小，但也不应小于 0．90m 。

**5.7.2** 套内设于底层或靠外墙、靠卫生间的壁柜内部应采取防潮措施。

> **条文说明**  
> 5．7．2 套内合理设置贮藏空间或位置对提高居室空间利用率，使室内保持整洁起到很大作用。居住实态调查资料表明，套内壁柜常因通风防潮不良造成贮藏物霉烂，本条规定对设置于底层或靠外墙、靠卫生间等容易受潮的壁柜应采取防潮措施。

**5.7.3** 套内楼梯当一边临空时，梯段净宽不应小于 0.75m ；当两侧有墙时，墙面之间净宽不应小于 0.90m ，并应在其中一侧墙面设置扶手。

> **条文说明**  
> 5．7．3 套内楼梯一般在两层住宅和跃层内作垂直交通使用。本条规定套内楼梯的净宽，当一边临空时，其净宽不应小于 0．75m ；当两侧有墙面时，墙面之间净宽不应小于 0．90m( 见图 2) ，此规定是搬运家具和日常手提东西上下楼梯最小宽度。 此外，当两侧有墙时，为确保居民特别是老人、儿童上下楼梯的安全，本条规定应在其中一侧墙面设置扶手。

**5.7.4** 套内楼梯的踏步宽度不应小于 0.22m ；高度不应大于 0.20m ，扇形踏步转角距扶手中心 0.25m 处，宽度不应小于 0.22m 。

> **条文说明**  
> 5．7．4 扇形楼梯的踏步宽度离内侧扶手中心 0．25m 处的踏步宽度不应小于 0．22m ，是考虑人上下楼梯时，脚踏扇形踏步的部位，如图 2 所示。

### 5.8 门窗

**5.8.1** 窗外没有阳台或平台的外窗，窗台距楼面、地面的净高低于 0.90m 时，应设置防护设施。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**5.8.2** 当设置凸窗时应符合下列规定： 
1. 窗台高度低于或等于 0.45m 时，防护高度从窗台面起算不应低于 0.90m ； 
2. 可开启窗扇窗洞口底距窗台面的净高低于 0.90m 时，窗洞口处应有防护措施。其防护高度从窗台面起算不应低于 0.90m ； 
3. 严寒和寒冷地区不宜设置凸窗。

> **条文说明**  
> 5．8．2 本条规定的依据是：  
> 1 窗台净高低于或等于 0．45m 的凸窗台面，容易造成无意识攀登，其有效防护高度应从凸窗台面起算，高度不应低于净高 0．90m ；  
> 2 实态调查表明，当出现可开启窗扇执手超出一般成年人正常站立所能触及的范围，就会出现攀登至凸窗台面关闭窗扇的情况，如可开启窗扇窗洞口底距凸窗台面的净高小于 0．90m ，容易发生坠落事故。所以本条规定可开启窗扇窗洞口底距窗台面的净高低于 0．90m 时，窗洞口处应有防护措施，其防护高度从窗台面起算不应低于 0．90m ；  
> 3 实态调查表明，严寒和寒冷地区凸窗的挑板或两侧壁板，在实际工程中由于施工困难，普遍未采取保温措施，会形成热桥，对节能非常不利。所以本条规定严寒和寒冷地区不宜设置凸窗。

**5.8.3** 底层外窗和阳台门、下沿低于 2.00m 且紧邻走廊或共用上人屋面上的窗和门，应采取防卫措施。

> **条文说明**  
> 5．8．3 从安全防范和满足住户安全感的角度出发，底层住宅的外窗和阳台门均应有一定防卫措施，紧邻走廊或共用上人屋面的窗和门同样是安全防范的重点部位，应有防卫措施。

**5.8.4** 面临走廊、共用上人屋面或凹口的窗，应避免视线干扰，向走廊开启的窗扇不应妨碍交通。

> **条文说明**  
> 5．8．4 住宅凹口的窗和面临走廊、共用上人屋面的窗常因设计不当，引起住户的强烈不满，本条规定采取措施避免视线干扰。面向走廊的窗、窗扇不应向走廊开启，否则应保证一定高度或加大走廊宽度，以免妨碍交通。

**5.8.5** 户门应采用具备防盗、隔声功能的防护门。向外开启的户门不应妨碍公共交通及相邻户门开启。

> **条文说明**  
> 5．8．5 为保证居住的安全性，本次修编明确规定住宅户门应具备防盗、隔声功能。住宅实态调查发现，由于原规范中 “ 安全防卫门 ” 概念模糊未明确其应具有防盗功能，普遍被住户加装一层防盗门，而加装的防盗门只能向外开启，妨碍楼梯间的交通，本条规定设计时就应将防盗、隔声功能集于一门。 一般的住宅户门总是内开启的，既可避免妨碍楼梯间的交通，又可避免相邻近的户门开启时之间发生碰撞。本条规定外开时不应妨碍交通，一般可采用加大楼梯平台、控制相邻户门的距离、设大小门扇、入口处设凹口等措施，以保证安全疏散。

**5.8.6** 厨房和卫生间的门应在下部设置有效截面积不小于 0.02㎡的固定百叶，也可距地面留出不小于 30mm 的缝隙。

> **条文说明**  
> 5．8．6 为保证有效的排气，应有足够的进风通道，当厨房和卫生间的外窗关闭或暗卫生间无外窗时，必需通过门进风。本条规定主要参照了《城镇燃气设计规范》 GB 50028 对设有直接排气式或烟道排气式燃气热水器房间的规定。厨房排油烟机的排气量一般为 300m³／h ～ 500m³／h ，有效进风截面积不小于 0．02㎡，相当于进风风速 4m／s ～ 7m／s ，由于排油烟机有较大风压，基本可以满足要求。卫生间排风机的排气量一般为 80m³／h ～ 100m³／h 。虽风压较小，但有效进风截面积不小于 0．02㎡，相当于进风风速 1．1m／s ～ 1．4m／s ，也可以满足要求。

**5.8.7** 各部位门洞的最小尺寸应符合表 5.8.7 的规定。

| 类别 | 洞口宽度 (m) | 洞口高度 (m) |
| :--- | :--- | :--- |
| 共用外门 | 1.20 | 2.00 |
| 户 ( 套 ) 门 | 1.00 | 2.00 |
| 起居室 ( 厅 ) 门 | 0.90 | 2.00 |
| 卧室门 | 0.90 | 2.00 |
| 厨房门 | 0.80 | 2.00 |
| 卫生间门 | 0.70 | 2.00 |
| 阳台门 ( 单扇 ) | 0.70 | 2.00 |

> **注：**  
> 1 表中门洞口高度不包括门上亮子高度，宽度以平开门为准。  
> 2 洞口两侧地面有高低差时，以高地面为起算高度。

> **条文说明**  
> 5. 8．7 本次修编根据住宅实态调查数据仅将户门洞口宽度增大为 1．00m ，其余未作改动。住宅各部位门洞的最小尺寸是根据使用要求的最低标准结合普通材料构造提出的，未考虑门的材料构造过厚或有特殊要求。

## 6 共用部分

### 6.1 窗台、栏杆和台阶

**6.1.1** 楼梯间、电梯厅等共用部分的外窗，窗外没有阳台或平台，且窗台距楼面、地面的净高小于 0．90m 时，应设置防护设施。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.1.2** 公共出入口台阶高度超过 0．70m 并侧面临空时，应设置防护设施，防护设施净高不应低于 1．05m 。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.1.3** 外廊、内天井及上人屋面等临空处的栏杆净高，六层及六层以下不应低于 1．05m ，七层及七层以上不应低于 1．10m 。防护栏杆必须采用防止儿童攀登的构造，栏杆的垂直杆件间净距不应大于 0．11m 。放置花盆处必须采取防坠落措施。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.1.4** 公共出入口台阶踏步宽度不宜小于 0．30m ，踏步高度不宜大于 0．15m ，并不宜小于 0．10m ，踏步高度应均匀一致，并应采取防滑措施。台阶踏步数不应少于 2 级，当高差不足 2 级时，应按坡道设置；台阶宽度大于 1．80m 时，两侧宜设置栏杆扶手，高度应为 0．90m 。

> **条文说明**  
> 6．1．4 公共出入口的台阶是老年人、儿童等摔伤事故的多发地点，本条对台阶踏步宽度、高度等作出的相关规定，保证了老人、儿童行走在公共出入口时的安全。

### 6.2 安全疏散出口

**6.2.1** 十层以下的住宅建筑，当住宅单元任一层的建筑面积大于 650m² ，或任一套房的户门至安全出口的距离大于 15m 时，该住宅单元每层的安全出口不应少于 2 个。

**6.2.2** 十层及十层以上且不超过十八层的住宅建筑，当住宅单元任一层的建筑面积大于 650m² ，或任一套房的户门至安全出口的距离大于 10m 时，该住宅单元每层的安全出口不应少于 2 个。

**6.2.3** 十九层及十九层以上的住宅建筑，每层住宅单元的安全出口不应少于 2 个。

**6.2.4** 安全出口应分散布置，两个安全出口的距离不应小于 5m 。

**6.2.5** 楼梯间及前室的门应向疏散方向开启。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.2.6** 十层以下的住宅建筑的楼梯间宜通至屋顶，且不应穿越其他房间。通向平屋面的门应向屋面方向开启。

> **条文说明**  
> 6．2．6 对于住宅建筑，根据实际疏散需要，规定设置的楼梯间能通向屋面，并强调楼梯间通屋顶的门要易于开启，而不应采取上锁或钉牢等不易打开的做法，以利于人员的安全疏散。

**6.2.7** 十层及十层以上的住宅建筑，每个住宅单元的楼梯均应通至屋顶，且不应穿越其他房间。通向平屋面的门应向屋面方向开启。各住宅单元的楼梯间宜在屋顶相连通。但符合下列条件之一的，楼梯可不通至屋顶： 
1. 十八层及十八层以下，每层不超过 8 户、建筑面积不超过 650m² ，且设有一座共用的防烟楼梯间和消防电梯的住宅； 
2. 顶层设有外部联系廊的住宅。

> **条文说明**  
> 6．2．7 十层及十层以上的住宅建筑，除条文里规定的两种情况外，每个住宅单元的楼梯间均应通至屋顶，各住宅单元的楼梯间宜在屋顶相连通，以便于疏散到屋顶的人，能够经过另一座楼梯到达室外，及时摆脱灾害威胁。对于楼层层数不同的单元，则不在本条的规定范围内，其安全疏散设计则应执行其他规范。

### 6.3 楼梯

**6.3.1** 楼梯梯段净宽不应小于 1.10m ，不超过六层的住宅，一边设有栏杆的梯段净宽不应小于 1.00m 。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.3.2** 楼梯踏步宽度不应小于 0．26m ，踏步高度不应大于 0．175m 。扶手高度不应小于 0．90m 。楼梯水平段栏杆长度大于 0．50m 时，其扶手高度不应小于 1．05m 。楼梯栏杆垂直杆件间净空不应大于 0．11m 。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.3.3** 楼梯平台净宽不应小于楼梯梯段净宽，且不得小于 1．20m 。楼梯平台的结构下缘至人行通道的垂直高度不应低于 2．00m 。入口处地坪与室外地面应有高差，并不应小于 0．10m 。

> **条文说明**  
> 6．3．3 楼梯平台净宽系指墙面装饰面至扶手中心之间的水平距离。实际调查证明，楼梯平台的宽度是影响搬运家具的主要因素，如平台上有暖气片，配电箱等凸出物时，平台宽度要从凸出面起算。楼梯平台的结构下缘至人行通道的垂直高度系指结构梁 ( 板 ) 的装饰面至地面装饰面的垂直距离。调查中发现有的住宅入口楼梯平台的垂直高度在 1．90m 左右，行人经过时容易碰头，很不安全。 规定入口处地坪与室外设计地坪的高差不应小于 0．10m ，第一是考虑到建筑物本身的沉陷；第二是为了保证雨水不会侵入室内。当住宅建筑带有半地下室、地下室时，更要严防雨水倒灌。此外，本条对楼梯平台净宽、楼梯平台的结构下缘至人行通道的垂直高度都作出了相关规定。

**6.3.4** 楼梯为剪刀梯时，楼梯平台的净宽不得小于 1．30m 。

> **条文说明**  
> 6. 3．4 我国目前大多数住宅的剪刀梯平台普遍过于狭窄，日常搬运大型家具困难，特别是急救时担架难以水平回转；高层建筑虽有电梯，但往往一栋楼只有一部能容纳普通担架，需要通过联系廊和疏散楼梯搬运伤病员。因此，本条文从保障居民生命安全的角度，要求住宅剪刀梯休息平台进深加大到 1．30m 。

**6.3.5** 楼梯井净宽大于 0．11m 时，必须采取防止儿童攀滑的措施。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

### 6.4 电梯

**6.4.1** 属下列情况之一时，必须设置电梯： 
1. 七层及七层以上住宅或住户入口层楼面距室外设计地面的高度超过 16m 时； 
2. 底层作为商店或其他用房的六层及六层以下住宅，其住户入口层楼面距该建筑物的室外设计地面高度超过 16m 时； 
3. 底层做架空层或贮存空间的六层及六层以下住宅，其住户入口层楼面距该建筑物的室外设计地面高度超过 16m 时； 
4. 顶层为两层一套的跃层住宅时，跃层部分不计层数，其顶层住户入口层楼面距该建筑物室外设计地面的高度超过 16m 时。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.4.2** 十二层及十二层以上的住宅，每栋楼设置电梯不应少于两台，其中应设置一台可容纳担架的电梯。

> **条文说明**  
> 6．4．2 十二层及十二层以上的住宅，每栋楼设置电梯不应少于两台，主要考虑到其中的一台电梯进行维修时，居民可通过另一部电梯通行。住宅要适应多种功能需要，因此，电梯的设置除考虑日常人流垂直交通需要外，还要考虑保障病人安全、能满足紧急运送病人的担架乃至较大型家具等需要。

**6.4.3** 十二层及十二层以上的住宅每单元只设置一部电梯时，从第十二层起应设置与相邻住宅单元联通的联系廊。 联系廊可隔层设置，上下联系廊之间的间隔不应超过五层。联系廊的净宽不应小于 1．10m ，局部净高不应低于 2．00m 。

**6.4.4** 十二层及十二层以上的住宅由二个及二个以上的住宅单元组成。且其中有一个或一个以上住宅单元未设置可容纳担架的电梯时，应从第十二层起设置与可容纳担架的电梯联通的联系廊。 联系廊可隔层设置，上下联系廊之间的间隔不应超过五层。联系廊的净宽不应小于 1．10m ，局部净高不应低于 2．00m 。

> **条文说明**  
> 6．4．3 、 6．4．4 十二层及十二层以上的住宅每个住宅单元只设置一部电梯时，在电梯维修期间，会给居民带来极大不便，只能通过联系廊或屋顶连通的方式从其他单元的电梯通行。当一栋楼只有一部能容纳担架的电梯时，其他单元只能通过联系廊到达这电梯运输担架。在两个住宅单元之间设置联系廊并非推荐做法，只是一种过渡做法。在实际操作中，联系廊的设计会带来视线干扰、安全防范、使部分居室厨房失去自然通风和直接采光等问题，此种设置电梯的方法虽较经济，但属低水平。所以，理想的方案是设置两台电梯，且其中一台可以容纳担架。 对于一栋十二层的住宅，各单元联通的屋面可以视为联系廊；对于一栋十八层的住宅，联系廊的设置可有两种方案：方案一，在十二层设置第一个联系廊，根据联系廊的间隔不能超过五层的规定，十七层必须设置第二个联系廊；方案二，在十四层设置第一个联系廊，各单元的联通屋面即可以视为第二个联系廊。 近来，有些一梯两户的方案将十二层以上相邻单元的两户住宅北阳台连通，这种做法也能起到紧急疏散的目的，但需要相关住户之间认可。这种做法从设计上不属于联系廊的做法。

**6.4.5** 七层及七层以上住宅电梯应在设有户门和公共走廊的每层设站。住宅电梯宜成组集中布置。

> **条文说明**  
> 6．4．5 为了使用方便，高层住宅电梯应在设有户门或公共走廊的每层设站。隔一层或更多层设站的方式，既不合理，对居民也不公平。

**6.4.6** 候梯厅深度不应小于多台电梯中最大轿箱的深度，且不应小于 1．50m 。

> **条文说明**  
> 6．4．6 电梯是人们使用频繁和理想的垂直通行设施，根据国家标准《电梯主参数及轿厢、井道、机房的型式与尺寸》 GB／T7025．1 的规定： “ 单台电梯或多台并列成排布置的电梯，候梯厅深度不应小于最大的轿箱深度 ” 。近几年来部分六层及以下住宅设置了电梯，电梯厅的深度不小于 1．50m ，即可满足载重量为 630kg 的电梯对候梯厅深度的要求。

**6.4.7** 电梯不应紧邻卧室布置。当受条件限制，电梯不得不紧邻兼起居的卧室布置时，应采取隔声、减振的构造措施。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

### 6.5 走廊和出入口

**6.5.1** 住宅中作为主要通道的外廊宜作封闭外廊，并应设置可开启的窗扇。走廊通道的净宽不应小于 1．20m ，局部净高不应低于 2．00m 。

> **条文说明**  
> 6．5．1 外廊是指居民日常必经之主要通道，不包括单元之间的联系廊等辅助外廊。从调查来看，严寒和寒冷地区由于气候寒冷、风雪多，外廊型住宅都做成封闭外廊 ( 有的外廊在墙上开窗户，也有的做成玻璃窗全封闭的挑廊 ) ；另夏热冬冷地区，因冬季很冷，风雨较多，设计标准也规定设封闭外廊。故本条规定在住宅中作为主要通道的外廊宜做封闭外廊。由于沿外廊一侧通常布置厨房、卫生间，封闭外廊需要良好通风，还要考虑防火排烟，故规定封闭外廊要有能开启的窗扇或通风排烟设施。

**6.5.2** 位于阳台、外廊及开敞楼梯平台下部的公共出入口，应采取防止物体坠落伤人的安全措施。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.5.3** 公共出入口处应有标识，十层及十层以上住宅的公共出入口应设门厅。

> **条文说明**  
> 6．5．3 在住宅建筑设计中，有的对出入口门头处理很简单，各栋住宅出入口没有自己的特色，形成千篇一律，以至于住户不易识别自己的家门。本条规定要求出入口设计上要有醒目的标识，包括建筑装饰、建筑小品、单元门牌编号等。按照防火规范的规定，十层及十层以上定为高层住宅，其入口人流相对较大，同时信报箱等公共设施需要一定的布置空间，因此对十层及十层以上住宅作出了设置入口门厅的规定。

### 6.6 无障碍设计要求

**6.6.1** 七层及七层以上的住宅，应对下列部位进行无障碍设计： 
1. 建筑入口；   
2. 入口平台； 
3. 候梯厅； 
4. 公共走道。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.6.2** 住宅入口及入口平台的无障碍设计应符合下列规定： 
1. 建筑入口设台阶时，应同时设置轮椅坡道和扶手； 
2. 坡道的坡度应符合表 6．6．2 的规定；    
3. 供轮椅通行的门净宽不应小于 0．8m ；   
4. 供轮椅通行的推拉门和平开门，在门把手一侧的墙面，应留有不小于 0．5m 的墙面宽度；   
5. 供轮椅通行的门扇，应安装视线观察玻璃、横执把手和关门拉手，在门扇的下方应安装高 0．35m 的护门板；   
6. 门槛高度及门内外地面高差不应大于 0.015m ，并应以斜坡过渡。 （自 2022 年 4 月 1 日起废止该条， ▶▶ 点击查看：新规 《建筑与市政工程无障碍通用规范》 GB 55019-2021 ）

**6.6.3** 七层及七层以上住宅建筑入口平台宽度不应小于 2．00m ，七层以下住宅建筑入口平台宽度不应小于 1．50m 。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.6.4** 供轮椅通行的走道和通道净宽不应小于 1．20m 。 （自 2022 年 4 月 1 日起废止该条， ▶▶ 点击查看： 新规 《建筑与市政工程无障碍通用规范》 GB 55019-2021 ）

### 6.7 信报箱

**6.7.1** 新建住宅应每套配套设置信报箱。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 6.7.1 目前全国有些地区的住宅信报箱发展滞后，安装率低，使得人们的基本通信权利无法得到保障。自 2009 年 10 月 1 日起施行的《中华人民共和国邮政法》在第二章第十条对信报箱的设置提出了具体要求。同年，住房和城乡建设部发布建标 [2009]88 号文，开始组织《住宅信报箱工程技术规范》的编制工作，该规范已经批准发布，编号为 GB 50631-2010 。本规范编制组与《住宅信报箱工程技术规范》编制组协调后，新增了本节内容。信报箱作为住宅的必备设施，其设置应满足每套住宅均有信报箱的基本要求。

**6.7.2** 住宅设计应在方案设计阶段布置信报箱的位置。信报箱宜设置在住宅单元主要入口处。

> **条文说明**  
> 6.7.2 在住宅设计时，根据信报箱的安装形式留出必要的安装空间，能避免后期安装时占用消防通道和对建筑结构造成破坏。将信报箱设置于地面层主要步行入口处，既方便投递、保证邮件安全，又便于住户收取。

**6.7.3** 设有单元安全防护门的住宅，信报箱的投递口应设置在门禁以外。当通往投递口的专用通道设置在室内时，通道净宽应不小于 0.60m 。

> **条文说明**  
> 6.7.3 根据实态调查，大多数住宅楼的门禁系统将邮递员拒之门外，造成了投递到户的困难。因此要求将信报箱设置在门禁系统外。同时要求充分考虑信报箱使用空间尺度，满足信报投递、收取等功能需求。

**6.7.4** 信报箱的投取信口设置在公共通道位置时，通道的净宽应从信报箱的最外缘起算。

> **条文说明**  
> 6.7.4 通道的净宽系指通道墙面装饰面至信报箱表面的最外缘的水平距离。因此，当通道墙面及信报箱上有局部突出物时，仍要求保证通道的净宽。

**6.7.5** 信报箱的设置不得降低住宅基本空间的天然采光和自然通风标准。

> **条文说明**  
> 6.7.5 信报箱的设置，无论在住宅室内或室外，都需要避免遮挡住宅基本空间的门窗洞口。

**6.7.6** 信报箱设计应选用信报箱定型产品，产品应符合国家有关标准。选用嵌墙式信报箱时应设计洞口尺寸和安装、拆卸预埋件位置。

> **条文说明**  
> 6.7.6 信报箱的质量受使用材料、加工工艺等因素的影响，其使用年限、防火等级、抗震等差别很大，因此要求选用符合国家现行有关标准规定的定型产品。由于嵌入式信报箱需与墙体结合，设计时应根据选用的产品种类，生产厂家提供的安装说明文件，预留安装条件。

**6.7.7** 信报箱的设置宜利用共用部位的照明，但不得降低住宅公共照明标准。

> **条文说明**  
> 6.7.7 信报箱可借用公共照明，但不能遮挡公共照明。

**6.7.8** 选用智能信报箱时，应预留电源接口。

> **条文说明**  
> 6.7.8 智能信报箱需要连接电源，因此必须预留电源接口，既避免给后期安装带来不便并增加成本，又不会影响室内美观和结构安全。

### 6.8 共用排气道

**6.8.1** 厨房宜设共用排气道，无外窗的卫生间应设共用排气道。

> **条文说明**  
> 6．8．1 我国的城镇住宅大多数是集合式住宅，密度高、排气量大，采用共用竖向排气系统更有利于高空排放，减少污染。

**6.8.2** 厨房、卫生间的共用排气道应采用能够防止各层回流的定型产品，并应符合国家有关标准。排气道断面尺寸应根据层数确定，排气道接口部位应安装支管接口配件，厨房排气道接口直径应大于 150mm ，卫生间排气道接口直径应大于 80mm 。

> **条文说明**  
> 6．8．2 为保证排气道的工程质量，要求选择排气道产品时特别注意其排气量、防回流构造、严密性等性能指标。我国目前住宅使用的共用排气道，一般是竖向排气道，利用各层住户的排油烟机向管道增压排气。由于各层住户的排油烟机输出压力不相等，容易产生上下层之间的回流。因此，应采用能够防止各层回流的定型产品。同时，层数越多的住宅，要求排气道的截面越大，如果排气管道截面太小，竖向排气道中的压力大于支管压力，也容易产生回流。因此，断面尺寸应根据层数确定。排气道支管及其接口直径太小，会造成管道局部压力过大，产生回流。所以提出最小直径要求。

**6.8.3** 厨房的共用排气道应与灶具位置相邻，共用排气道与排油烟机连接的进气口应朝向灶具方向。

> **条文说明**  
> 6．8．3 在进行厨房设计以及排气道安装时，需正确安排共用排气道的位置和接口方向，以保证排气管的正确接入和排气顺畅。

**6.8.4** 厨房的共用排气道与卫生间的共用排气道应分别设置。

> **条文说明**  
> 6．8．4 厨房和卫生间的烟气性质不同，合用排气道会互相串味。另外，由于厨房和卫生间气体成分不同，分别设置也可避免互相混合产生的危险

**6.8.5** 竖向排气道屋顶风帽的安装高度不应低于相邻建筑砌筑体。排气道的出口设置在上人屋面、住户平台上时，应高出屋面或平台地面 2m ；当周围 4m 之内有门窗时，应高出门窗上皮 0．6m 。

> **条文说明**  
> 6．8．5 风帽既要满足气流排放的要求，又要避免产生排气道进水造成的渗、漏等现象。如在可上人屋面或邻近门窗位置设置竖向通风道的出口，可能对周围环境产生影响，本条参考了对排水通气管的有关规定，对出口高度提出要求。

### 6.9 地下室和半地下室

**6.9.1** 卧室、起居室 ( 厅 ) 、厨房不应布置在地下室；当布置在半地下室时，必须对采光、通风、日照、防潮、排水及安全防护采取措施，并不得降低各项指标要求。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.9.2** 除卧室、起居室 ( 厅 ) 、厨房以外的其他功能房间可布置在地下室，当布置在地下室时，应对采光、通风、防潮、排水及安全防护采取措施。

> **条文说明**  
> 6．9．2 住宅建筑小地下室及半地下室可以布置其他如贮藏间、卫生间、娱乐室等房间。

**6.9.3** 住宅的地下室、半地下室做自行车库和设备用房时，其净高不应低于 2．00m 。

> **条文说明**  
> 6．9．3 住宅的地下车库和设备用房，其净高至少应与公共走廊净高相等，所以不能低于 2．00m 。

**6.9.4** 当住宅的地上架空层及半地下室做机动车停车位时，其净高不应低于 2．20m 。

> **条文说明**  
> 6．9．4 当住宅地上架空层及半地下室做机动车停车位时，应符合行业标准《汽车库建筑设计规范》 JGJ 100 的相关规定。考虑到住宅的空间特性，以及住宅周围以停放的小型汽车为主，本条规定参照了《汽车库建筑设计规范》 JGJ 100 中对小型汽车的净空的规定。

**6.9.5** 地上住宅楼、电梯间宜与地下车库连通，并宜采取安全防盗措施。

> **条文说明**  
> 6．9．5 考虑到住户使用方便，便于搬运家具等大件物品，地上住宅楼、电梯宜与地下车库相连通。此外，目前从地下室进入住户层的门安全监控不够健全，存在安全隐患，因此要求采取防盗措施。

**6.9.6** 直通住宅单元的地下楼、电梯间入口处应设置乙级防火门，严禁利用楼、电梯间为地下车库进行自然通风。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.9.7** 地下室、半地下室应采取防水、防潮及通风措施。采光井应采取排水措施。

> **条文说明**  
> 6．9．7 住宅的地下室包括车库，储存间，一般含有污水和采暖系统的干管，采取防水措施必不可少。此外，采光井、采光天窗处，都要做好防水排水措施，防止雨水倒流进入地下室。

### 6.10 附建公共用房

**6.10.1** 住宅建筑内严禁布置存放和使用甲、乙类火灾危险性物品的商店、车间和仓库，以及产生噪声、振动和污染环境卫生的商店、车间和娱乐设施。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**6.10.2** 住宅建筑内不应布置易产生油烟的餐饮店，当住宅底层商业网点布置有产生刺激性气味或噪声的配套用房，应做排气、消声处理。

> **条文说明**  
> 6．10．2 住宅建筑内布置易产生油烟的餐饮店，使住宅内进出人员复杂，其营业时间与居民的生活作息习惯矛盾较大，不便管理，且产生的气味及噪声也对临近住户产生不良影响，因此，本条作出了相关规定。

**6.10.3** 水泵房、冷热源机房、变配电机房等公共机电用房不宜设置在住宅主体建筑内，不宜设置在与住户相邻的楼层内，在无法满足上述要求贴临设置时，应增加隔声减振处理。

> **条文说明**  
> 6．10．3 水泵房、冷热源机房，变配电机房等公共机电用房都会产生较大的噪声，故不宜设置于住户相邻楼层内，也不宜设置在住宅主体建筑内；当受到条件限制必须设置在主体建筑内时，可设置在架空楼层或不与住宅套内房间直接相邻的空间内，并需作好减振、隔声措施，其隔声性能应符合本规范第 7．3．1 条和第 7．3．2 条的要求。

**6.10.4** 住户的公共出入口与附建公共用房的出入口应分开布置。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

## 7 室内环境

### 7.1 日照、天然采光、遮阳

**7.1.1** 每套住宅应至少有一个居住空间能获得冬季日照。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**7.1.2** 需要获得冬季日照的居住空间的窗洞开口宽度不应小于 0．60m 。

**7.1.3** 卧室、起居室 ( 厅 ) 、厨房应有直接天然采光。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**7.1.4** 卧室、起居室 ( 厅 ) 、厨房的采光系数不应低于 1％；当楼梯间设置采光窗时，采光系数不应低于 0．5％。

**7.1.5** 卧室、起居室 ( 厅 ) 、厨房的采光窗洞口的窗地面积比不应低于 1／7 。 （自 2022 年 4 月 1 日起废止该条， ▶▶ 点击查看：新规 《建筑节能与可再生能源利用通用规范》 GB55015-2021 ）

**7.1.6** 当楼梯间设置采光窗时，采光窗洞口的窗地面积比不应低于 1／12 。

> **条文说明**  
> 7．1．4 ～ 7．1．6 由于居住者对于卧室、起居室 ( 厅 ) 、厨房、楼梯间等不同空间的采光需求不同，条文对住宅中不同的空间分别提出了不同要求，条文中对于楼梯间采光系数和窗地面积比的要求是以设置采光窗为前提的。 住宅采光以 “ 采光系数 ” 最低值为标准，条文中采光系数的规定为最低值。采光系数的计算位置以及计算方法等相关规定按现行国标《建筑采光设计标准》 GB／T 50033 执行。条文中采光系数和窗地面积比值是按 Ⅲ 类光气候区单层普通玻璃钢窗为计算标准，其他光气候区或采用其他类型窗的采光系数最低值和窗地面积比按现行国家标准《建筑采光设计标准》 GB／T 50033 执行。 用采光系数评价住宅是否获得了足够的天然采光比较科学，但由于采光系数需要通过直接测量或复杂的计算才能得到。在一般情况下，住宅各房间的采光系数与窗地面积比密切相关，为了与《住宅建筑规范》相关条款的协调，本条文中给出了 ‘ 采光系数 ’ 的同时，也规定了窗地面积比的限值。

**7.1.7** 采光窗下沿离楼面或地面高度低于 0．50m 的窗洞口面积不应计入采光面积内，窗洞口上沿距地面高度不宜低于 2．00m 。

> **条文说明**  
> 7．1．7 由于在原规范中，该条文以表格 “ 注 ” 的方式表达，要求不够明确，因此，本次修编时将相关要求编入了条文。

**7.1.8** 除严寒地区外，居住空间朝西外窗应采取外遮阳措施，居住空间朝东外窗宜采取外遮阳措施。当采用天窗、斜屋顶窗采光时，应采取活动遮阳措施。

> **条文说明**  
> 7．1．8 住宅采用侧窗采光时，西向或东向外窗采取外遮阳措施能有效减少夏季射入室内的太阳辐射对夏季空调负荷的影响和避免眩光，因此条文中作了相关规定。同时在制定本条款时，还参考了《民用建筑热工设计规范》 GB 50176 以及寒冷地区、夏热冬冷地区和夏热冬暖地区相关 “ 居住建筑节能设计标准 ” 对于外窗遮阳的规定和把握尺度，因此条文中的相关规定是最低要求，设计时可执行相应的国家标准或地方标准。 由于住宅采用天窗，斜屋顶窗采光时，太阳辐射更为强烈，夏季空调负荷也将更大，同时兼顾采光和遮阳要求，活动的遮阳装置效果会比较好。因此条文作了相关规定。

### 7.2 自然通风

**7.2.1** 卧室、起居室 ( 厅 ) 、厨房应有自然通风。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 7．2．1 卧室和起居室 ( 厅 ) 具有自然通风条件是居住者的基本需求。通过对夏热冬暖地区典型城市的气象数据进行分析，从 5 月到 10 月，有的地区室外平均温度不高于 28 ℃ 的天数占每月总天数高达 60 ％～ 70 ％，最热月也能达到 10 ％左右，对应时间段的室外风速大多能达到 1．5m／s 左右。当室外温度不高于 28 ℃ 时，室内良好的自然通风，能保证室内人员的热舒适性，减少房间空调设备的运行时间，节约能源，同时也可以有效改善室内空气质量，有助于健康。因此，本条文对卧室和起居室 ( 厅 ) 作了相关规定。 由于厨房具有自然通风条件可以保证炊事人员基本操作时和炊事用可燃气体泄露时所需的通风换气。根据居住实态调查结果分析， 90 ％以上的住户仅在炒菜时启动排油烟机，其他作业如煮饭、烧水等基本靠自然通风，因此，条文对厨房作了相关规定。

**7.2.2** 住宅的平面空间组织、剖面设计、门窗的位置、方向和开启方式的设置，应有利于组织室内自然通风。单朝向住宅宜采取改善自然通风的措施。

> **条文说明**  
> 7．2．2 室内外之间自然通风既可以是相对外墙窗之间形成的对流的穿堂风，也可以是相邻外墙窗之间形成的流通的转角风。将室外风引入室内，同时将室内空气引导至室外，需要合理的室内平面设计、室内空间合理的组织以及门窗位置与大小的精细化设计。因此，本条文提出了相关要求。 当住宅设计条件受限制，不得已采用单朝向住宅套型时，可以采取户门上方设通风窗，下方设通风百叶等有效措施，最大限度地保证卧室、起居室 ( 厅 ) 内良好的自然通风条件。在实践过程中，有的单朝向住宅安装了带有通风口的防盗门或防盗户门，这样也可以通过开启门上的通风口，在不同的时间段获得较好的自然通风，改善室内环境。当单朝向住宅户门一侧为防火墙和防火门时，在户门或防火墙上开设自然通风口有一定困难，因此，对于单朝向住宅改善自然通风的措施，要求的尺度确定为 “ 宜 ” 。

**7.2.3** 每套住宅的自然通风开口面积不应小于地面面积的 5％。 （自 2022 年 4 月 1 日起废止该条， ▶▶ 点击查看： 新规 《建筑节能与可再生能源利用通用规范》 GB55015-2021 ）

> **条文说明**  
> 7．2．3 本条规定是对整套住宅总的自然通风开口面积的要求，与《住宅建筑规范》 GB 50368 相关规定一致。使用时，既要保证整套住宅总的自然通风开口面积，也要保证有自然通风要求房间的自然通风开口面积。

**7.2.4** 采用自然通风的房间，其直接或间接自然通风开口面积应符合下列规定： 
1. 卧室、起居室 ( 厅 ) 、明卫生间的直接自然通风开口面积不应小于该房间地板面积的 1／20 ；当采用自然通风的房间外设置阳台时，阳台的自然通风开口面积不应小于采用自然通风的房间和阳台地板面积总和的 1／20 ； 
2. 厨房的直接自然通风开口面积不应小于该房间地板面积的 1／10 ，并不得小于 0．60m² ；当厨房外设置阳台时，阳台的自然通风开口面积不应小于厨房和阳台地板面积总和的 1／10 ，并不得小于 0．60m² 。

> **条文说明**  
> 7．2．4 本条文基本为原规范的保留条文。条文中通风开口面积是最低要求。为避免有自然通风要求房间开向室外的自然通风开口面积或开向阳台的自然通风开口面积不够，影响自然通风效果，条文对有自然通风要求房间的直接自然通风开口面积提出了要求；同时为避免设置在有自然通风要求房间外的阳台或封闭阳台的外窗的自然通风开口面积不够，影响自然通风效果，条文对阳台或封闭阳台外窗的自然通风开口面积也提出了要求。

### 7.3 隔声、降噪

**7.3.1** 卧室、起居室 ( 厅 ) 内噪声级，应符合下列规定：   
1. 昼间卧室内的等效连续 A 声级不应大于 45dB ；   
2. 夜间卧室内的等效连续 A 声级不应大于 37dB ；   
3. 起居室 ( 厅 ) 的等效连续 A 声级不应大于 45dB 。 （自 2022 年 4 月 1 日起废止该条， ▶▶ 点击查看： 新规 《建筑环境通用规范》 GB 55016-2021 ）

> **条文说明**  
> 7．3．1 本条文规定的室内允许噪声级标准是在关窗条件下测量的指标，包括了对起居室 ( 厅 ) 的等效连续 A 声级的在昼间和夜间的要求。 住宅应给居住者提供一个安静的室内生活环境，但是在现代城镇中，尤其是大中城市中，大部分住宅的室外环境均比较嘈杂，特别是邻近主要街道的住宅，交通噪声的影响较为严重。同时住宅的内部各种设备机房动力设备的振动会传递到住宅房间，动力设备振动所产生的低频噪声也会传递到住宅房间，这都会严重影响居住质量。特别是动力设备的振动产生的低频噪声往往难以完全消除。因此，住宅设计时，不仅针对室外环境噪声要采取有效的隔声和防噪声措施，而且卧室、起居室 ( 厅 ) 也要布置在远离可能产生噪声的设备机房 ( 如水泵房、冷热机房等 ) 的位置，且做到结构相互独立也是十分必要的措施。

**7.3.2** 分户墙和分户楼板的空气声隔声性能应符合下列规定： 
1. 分隔卧室、起居室 ( 厅 ) 的分户墙和分户楼板，空气声隔声评价量 ( R w ＋ C) 应大于 45dB ； 
2. 分隔住宅和非居住用途空间的楼板，空气声隔声评价量 ( R w ＋ C tr ) 应大于 51dB 。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 7．3．2 为便于设计人员在设计中选择相应的构造、部品、产品和做法，条文中规定的分户墙和分户楼板的空气声隔声性能指标是计权隔声量＋粉红噪声频谱修正量 ( Rw ＋ C) ，该指标是实验室测量的空气声隔声性能。条文中规定的分隔住宅和非住宅用途空间的楼板空气声隔声性能指标是计权隔声量＋交通噪声频谱修正量 ( Rw ＋ Ctr) ，该指标也是实验室测量的空气声隔声性能。

**7.3.3** 卧室、起居室 ( 厅 ) 的分户楼板的计权规范化撞击声压级宜小于 75dB 。当条件受到限制时，分户楼板的计权规范化撞击声压级应小于 85dB ，且应在楼板上预留可供今后改善的条件。

> **条文说明**  
> 7．3．3 原规范采用的计权标准化撞击声压级标准是现场综合各种因素后的现场测量指标，设计人员在设计时采用计权标准化撞击声压级标准设计难以把握最终的隔声效果。为便于设计人员在设计中选择相应的构造，部品、产品和做法，条文中对楼板的撞击声隔声性能采用了计权规范化撞击声压级作为控制指标，该指标是实验室测量值。

**7.3.4** 住宅建筑的体形、朝向和平面布置应有利于噪声控制。在住宅平面设计时，当卧室、起居室 ( 厅 ) 布置在噪声源一侧时，外窗应采取隔声降噪措施；当居住空间与可能产生噪声的房间相邻时，分隔墙和分隔楼板应采取隔声降噪措施；当内天井、凹天井中设置相邻户间窗口时，宜采取隔声降噪措施。

> **条文说明**  
> 7．3．4 本条文中所指噪声源为室外噪声。条文中所指隔声降噪措施为加大窗间距、设置隔声窗、设置隔声板等措施。在住宅设计时，居住空间与可能产生噪声的房间相邻布置，分隔墙或楼板采取隔声降噪措施十分必要。同时卧室与卫生间相邻布置时，排水管道、卫生器具等设备设施在使用时也会产生很大噪声，因此除选用噪声更小的产品外，将排水管道、卫生器具等设备设施布置在远离卧室一侧会对减少噪声起到较好的作用。

**7.3.5** 起居室 ( 厅 ) 不宜紧邻电梯布置。受条件限制起居室 ( 厅 ) 紧邻电梯布置时，必须采取有效的隔声和减振措施。

> **条文说明**  
> 7．3．5 由于电梯机房设备产生的噪声以及电梯井道内产生的振动和撞击声对住户有很大干扰，因此在住宅设计时尽量避免起居室 ( 厅 ) 紧邻电梯井道和电梯机房布置十分必要。当受条件限制起居室 ( 厅 ) 紧邻电梯井道、电梯机房布置时，需要采取提高电梯井壁隔声量的有效的隔声、减振技术措施，需要采取提高电梯机房与起居室 ( 厅 ) 之间隔墙和楼板隔声量的有效的隔声、减振技术措施，需要采取电梯轨道和井壁之间设置减振垫等有效的隔声、减振技术措施。

### 7.4 防水、防潮

**7.4.1** 住宅的屋面、地面、外墙、外窗应采取防止雨水和冰雪融化水侵入室内的措施。 （自 2022 年 4 月 1 日起废止该条， ▶▶ 点击查看： 新规 《建筑环境通用规范》 GB 55016-2021 ）

> **条文说明**  
> 7．4．1 防止渗漏是住宅建筑屋面、外墙、外窗的基本要求。为防止渗漏，在设计、施工、使用阶段均应采取相应措施。住宅防水不仅仅地下室要采取措施，地上也要采取措施，原规范仅在共用部分对地下室和半地下室有防水要求，不够全面。此次规范修编与《住宅建筑规范》 GB 50368 协调，加入了相关规定。

**7.4.2** 住宅的屋面和外墙的内表面在设计的室内温度、湿度条件下不应出现结露。 （自 2022 年 4 月 1 日起废止该条， ▶▶ 点击查看： 新规 《建筑环境通用规范》 GB 55016-2021 ）

> **条文说明**  
> 7．4．2 住宅室内表面 ( 屋面和外墙的内表面 ) 长时间的结露会滋生霉菌，对居住者的健康造成有害的影响。室内表面出现结露最直接的原因是表面温度低于室内空气的露点温度。另外，表面空气的不流通也助长了结露现象的发生。因此，住宅设计时，要核算室内表面可能出现的最低温度是否高于露点温度，并尽量避免通风死角。但是，要杜绝内表面的结露现象有时非常困难。例如，在我国南方的雨季，空气非常潮湿，空气所含的水蒸气接近饱和，除非紧闭门窗，空气经除湿后再送入室内，否则短时间的结露现象是不可避免的。因此，本条规定在 “ 设计的室内温度、湿度条件下 ”( 即在正常条件下 ) 不应出现结露。

### 7.5 室内空气质量

**7.5.1** 住宅室内装修设计宜进行环境空气质量预评价。

**7.5.2** 在选用住宅建筑材料、室内装修材料以及选择施工工艺时，应控制有害物质的含量。

**7.5.3** 住宅室内空气污染物的活度和浓度应符合表 7．5．3 的规定。 （自 2022 年 4 月 1 日起废止该条， ▶▶ 点击查看： 新规 《建筑环境通用规范》 GB 55016-2021 ）

> **条文说明**  
> 7．5．1 ～ 7．5．3 因使用的室内装修材料、施工辅助材料以及施工工艺不合规范，造成建筑物建成后室内环境污染长期难以消除，是目前较为普遍的问题。为杜绝此类问题，严格按照《民用建筑工程室内环境污染控制规范》 GB 50325 和现行国家标准关于室内建筑装饰装修材料有害物质限量的相关规定，选用合格的装修材料及辅助材料十分必要。同时，鼓励选用比国家标准更健康环保的材料，鼓励改进施工工艺。 保障室内空气质量是一个综合性的问题，其中设计阶段是一个关键环节。第 7．5．1 条、 7．5．2 条和 7．5．3 条这三个条款存在相互的逻辑关系，第 7．5．1 条是设计阶段要进行的工作，第 7．5．2 条是工作内容中要关注的几个主要方面。 第 7．5．3 条是工作的目标。第 7．5．3 条的控制标准摘自《民用建筑工程室内环境污染控制规范》 GB 50325 的相关规定。 调查表明，室内空气污染物中主要的有毒有害气体 ( 氨气污染除外 ) 一般是装修材料及其辅料和家具等释放出的，其中，板材、涂料、油漆以及各种胶粘剂均释放出甲醛气体、非甲烷类挥发性有机气体。氨气主要来源于混凝土外加剂中，其次源于室内装修材料中的添加剂和增白剂。同时由于使用的建筑材料、施工辅助材料以及施工工艺不合规范，也会使建筑室内环境的污染长期难以消除。 另外，室内装修时，即使使用的各种装修材料均满足各自的污染物环保标准，但是如果过度装修使装修材料中的污染大量累积时，室内空气污染物浓度依然会超标。为解决这一问题，在室内装修设计阶段及主体建筑设计阶段进行室内环境质量预评价十分必要。 预评价时可综合考虑室内装修设计方案和空间承载量、装修材料的使用量、建筑材料、施工辅助材料、施工工艺、室内新风量等诸多影响室内空气质量的因素，对最大限度能够使用的各种装修材料的数量作出预算，也可根据工程项目设计方案的内容，分析和预测该工程项目建成后存在的危害室内环境质量因素的种类和危害程度，并提出科学、合理和可行的技术对策，作为工程项目改善设计方案和项目建筑材料供应的主要依据，从而根据预评价的结果调整装修设计方案。 其次，住宅室内空气污染物中的氡主要来源于无机建筑材料和建筑物地基 ( 土壤和岩石 ) 。对于室内氡的污染，只要建筑材料和装修材料符合国家限值要求，由建筑材料和装修材料释放出的氡，就不会使其含量超过规定限值。然而建筑物地基 ( 土壤和岩石 ) 中的氡会长期通过地下室外墙和地板的缝隙向室内渗透，因此科学的选址以及环境评价十分重要。同时在建筑物地基有氡污染的地区，建筑物地板和地下室外墙的设计可以采取一些隔绝和建立主动或被动式的通风系统等措施防止土壤中的氡进入建筑内部

## 8 建筑设备

### 8.1 一般规定

**8.1.1** 住宅应设置室内给水排水系统。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**8.1.2** 严寒和寒冷地区的住宅应设置采暖设施。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**8.1.3** 住宅应设置照明供电系统。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．1．1 ～ 8．1．3 给水排水系统、严寒和寒冷地区的住宅采暖设施和照明供电系统，是有利于居住者身体健康的最基本居住生活设施，是现代居家生活的重要组成部分，因此规定应予设置。

**8.1.4** 住宅计量装置的设置应符合下列规定：   
1. 各类生活供水系统应设置分户水表； （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）   
2. 设有集中采暖 ( 集中空调 ) 系统时，应设置分户热计量装置； （自 2022 年 4 月 1 日起废止该条， ▶▶ 点击查看： 新规 《建筑节能与可再生能源利用通用规范》 GB55015-2021 ）    
3. 设有燃气系统时，应设置分户燃气表； （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）   
4. 设有供电系统时，应设置分户电能表。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．1．4 按户分别设置计量仪表是节能节水的重要措施。设置的分户水表包括冷水表、中水表、集中热水供应时的热水表、集中直饮水供应时的水表等。 根据现行行业标准《供热计量技术规程》 JGJ 173 ，对于集中采暖和集中空调的居住建筑，其水系统提供的热量既可以按楼栋设置热量表作为热量结算点，楼内住户按户进行热量分摊，每户需有相应的装置作为对整栋楼的耗热量进行户间分摊的依据；也可以在每户安装热量表作为热量结算点。无论是按户分摊还是每户安装热量表结算，均统称为分户热计量。

**8.1.5** 机电设备管线的设计应相对集中、布置紧凑、合理使用空间。

> **条文说明**  
> 8．1．5 建筑设备设计应有建筑空间合理布局的整体观念。设计时首先由建筑设计专业按本规范第 3．0．9 条要求综合考虑建筑设备和管线的配置，并提供必要的空间条件，尤其是公共管道和设备、阀门等部件的设置空间和管理检修条件，以及强弱电竖井等。 需要建筑设计预留安装位置的户内机电设备有：采用地板采暖时的分集水器、燃气热水器、分户设置的燃气采暖炉或制冷设备、户配电箱、家居配线箱等。

**8.1.6** 设备、仪表及管线较多的部位，应进行详细的综合设计，并应符合下列规定： 
1. 采暖散热器、户配电箱、家居配线箱、电源插座、有线电视插座、信息网络和电话插座等，应与室内设施和家具综合布置； 
2. 计量仪表和管道的设置位置应有利于厨房灶具或卫生间卫生器具的合理布局和接管； 
3. 厨房、卫生间内排水横管下表面与楼面、地面净距应符合本规范第 5．5．5 条的规定； 
4. 水表、热量表、燃气表、电能表的设置应便于管理。

> **条文说明**  
> 8．1．6 本条提出了应进行详细综合设计的主要部位和需进行综合布置的主要设施。 计量仪表的选择和安装的原则是安全可靠、便于读表、检修和减少扰民。需人工读数的仪表 ( 如分户计量的水表、热计量表、电能表等 ) 一般设置在户外。对设置在户内的仪表 ( 如厨房燃气表、厨房卫生间等就近设置生活热水立管的热水表等 ) 可考虑优先采用可靠的远传电子计量仪表，并注意其位置有利于保证安全，且不影响其他器具或家具的布置及房间的整体美观。

**8.1.7** 下列设施不应设置在住宅套内，应设置在共用空间内： 
1. 公共功能的管道，包括给水总立管、消防立管、雨水立管、采暖 ( 空调 ) 供回水总立管和配电和弱电干线 ( 管 ) 等，设置在开敞式阳台的雨水立管除外； 
2. 公共的管道阀门、电气设备和用于总体调节和检修的部件，户内排水立管检修口除外； 
3. 采暖管沟和电缆沟的检查孔。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．1．7 公共的管道和设备、部件如设置在住宅套内，不仅占用套内空间的面积、影响套内空间的使用，住户装修时往往将管道等加以隐蔽，给维修和管理带来不便，且经常发生无法进入户内进行维护的实例，因此本条规定不应设置在住宅套内。 雨水立管指建筑物屋面等公共部位的雨水排水管，不包括仅为各户敞开式阳台服务的各层共用雨水立管。屋面雨水管如设置在室内 ( 包括封闭阳台和卫生间或厨房的管井内 ) ，使公共共用管道占据了某些住户的室内空间，下雨时还有噪声扰民等问题，因此规定不应设置在住宅套内。但考虑到为减少首层地面下的水平雨水管坡度占据的空间，往往需要在靠建筑物外墙就近排出室外，且敞开式阳台已经不属于室内，对住户影响不大，因此将设置在此处的屋面公共雨水立管排除在规定之外。当阳台设置屋面雨水管时，还应注意按《建筑给水排水设计规范》 GB 50015 的规定单独设置，不能与阳台雨水管合用。 当给水、生活热水采用远传水表或 IC 水表时，立管设置在套内卫生间或厨房。但立管检修阀一般设置在共用部分 ( 例如管道层的横管上 ) ，而不设置在套内立管的部分。 采暖 ( 空调 ) 系统用于总体调节和检修的部件设置举例如下：环路检修阀门设置在套外公共部分；立管检修阀设置在设备层或管沟内；共用立管的分户独立采暖系统，与共用立管相连接的各分户系统的入口装置 ( 检修调节阀、过滤器、热量表等 ) 设置在公共管井内。 配电干线、弱电干线 ( 管 ) 和接线盒设置在电气管井中便于维护和检修。当管线较少或没有条件设置电气管井时，宜将电气立管和设备设置在共用部分的墙体上，确有困难时，可在住宅的分户墙内设置电气暗管和暗箱，但箱体的门或接线盒应设置在共用部分的空间内。 采暖管沟和电缆沟的检查孔不得设置在套内，除考虑维修和管理因素外，还考虑了安全问题。

**8.1.8** 水泵房、冷热源机房、变配电室等公共机电用房应采用低噪声设备，且应采取相应的减振、隔声、吸声、防止电磁干扰等措施。

> **条文说明**  
> 8．1．8 设置在住宅楼内的机电设备用房产生的噪声、振动、电磁干扰，对住户的休息和生活影响很大，也是居民投诉的热点。本规范的第 6．10．3 条也有相关规定。

### 8.2 给水排水

**8.2.1** 住宅各类生活供水系统水质应符合国家现行有关标准的规定。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**8.2.2** 入户管的供水压力不应大于 0．35MPa 。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

**8.2.3** 套内用水点供水压力不宜大于 0．20MPa ，且不应小于用水器具要求的最低压力。

> **条文说明**  
> 8．2．2 、 8．2．3 入户管的给水压力的最大限值规定为 0．35MPa ，为强制性条文，与现行国家标准《住宅建筑规范》 GB 50368 一致，并严于现行国家标准《建筑给水排水设计规范》 GB 50015 的相关规定。推荐用水器具规定的最低压力不宜大于 0．20MPa ，与现行国家标准《民用建筑节水设计标准》 GB 50555 一致，其目的都是要通过限制供水的压力，避免无效出流状况造成水的浪费。超过压力限值，则要根据条文规定的严格程度采取系统分区、支管减压等措施。 提出最低给水水压的要求，是为了确保居民正常用水条件，可根据《建筑给水排水设计规范》 GB 50015 提供的卫生器具最低工作压力确定。

**8.2.4** 住宅应设置热水供应设施或预留安装热水供应设施的条件。生活热水的设计应符合下列规定： 
1. 集中生活热水系统配水点的供水水温不应低于 45 ℃ ； 
2. 集中生活热水系统应在套内热水表前设置循环回水管； 
3. 集中生活热水系统热水表后或户内热水器不循环的热水供水支管，长度不宜超过 8m 。

> **条文说明**  
> 8．2．4 住宅设置热水供应设施，以满足居住者洗浴的需要，是提高生活水平的必要措施，也是居住者的普遍要求。由于热源状况和技术经济条件不尽相同，可采用多种加热方式和供应系统，如：集中热水供应系统、分户燃气热水器、太阳能热水器和电热水器等。当不设计热水供应系统时，也需预留安装热水供应设施的条件，如预留安装热水器的位置、预留管道、管道接口、电源插座等。条件适宜时，可设计太阳能热水系统或为安装太阳能热水设施预留接口条件。 配水点水温是指打开用水龙头约 15s 内的得到的水温。为避免使用热水时需要放空大量冷水而造成水和能源的浪费，集中生活热水系统应在分户热水表前设置循环加热系统，无循环的供水支管长度不宜超过 8m ，这与协会标准《小区集中生活热水供应设计规程》 CECS 222—2007 的规定一致，但略有放宽 ( 该规程认为不循环支管的长度应控制在 5m ～ 7m) 。当热水用水点距水表或热水器较远时，需采取其他措施，例如：集中热水供水系统在用水点附近增加热水和回水立管并设置热水表；户内采用燃气热水器时，在较远的卫生间预留另设电热水器的条件，或设置户内热水循环系统。循环水泵控制可以采用用水前手动控制或定时控制方式。

**8.2.5** 卫生器具和配件应采用节水型产品。管道、阀门和配件应采用不易锈蚀的材质。

> **条文说明**  
> 8．2．5 采用节水型卫生器具和配件是住宅节水的重要措施。节水型卫生器具和配件包括：总冲洗用水量不大于 6L 的坐便器，两档式便器水箱及配件，陶瓷片密封水龙头、延时水嘴、红外线节水开关、脚踏阀等。住宅内不得使用明令淘汰的螺旋升降式铸铁水龙头、铸铁截止阀、进水阀低于水面的卫生洁具水箱配件、上导向直落式便器水箱配件等。建设部公告第 218 号《关于发布〈建设部推广应用和限制禁止使用技术〉的公告》中规定：对住宅建筑，推广应用节水型坐便器 ( 不大于 6L) ，禁止使用冲水量大于等于 9L 的坐便器。 管道、阀门和配件应采用铜质等不易锈蚀的材料，以保证检修时能及时可靠关闭，避免渗漏。

**8.2.6** 厨房和卫生间的排水立管应分别设置。排水管道不得穿越卧室。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．2．6 为防止卫生间排水管道内的污浊有害气体串至厨房内，对居住者卫生健康造成影响。因此本条规定当厨房与卫生间相邻布置时，不应共用一根排水立管，而应分别设置各自的立管。 为避免排水管道漏水、噪声或结露产生凝结水影响居住者卫生健康，损坏财产，因此排水管道 ( 包括排水立管和横管 ) 均不得穿越卧室空间。

**8.2.7** 排水立管不应设置在卧室内，且不宜设置在靠近与卧室相邻的内墙； 当必须靠近与卧室相邻的内墙时，应采用低噪声管材。

> **条文说明**  
> 8．2．7 排水立管的设置位置需避免噪声对卧室的影响，本条规定排水立管不应布置在卧室内，也包含利用卧室空间设置排水立管管井的情况。普通塑料排水管噪声较大，有消声功能的管材指橡胶密封圈柔性接口机制的排水铸铁管、双壁芯层发泡塑料排水管、内螺旋消声塑料排水管等。

**8.2.8** 污废水排水横管宜设置在本层套内；当敷设于下一层的套内空间时，其清扫口应设置在本层，并应进行夏季管道外壁结露验算和采取相应的防止结露的措施。 污废水排水立管的检查口宜每层设置。

> **条文说明**  
> 8．2．8 推荐住宅的污废水排水横管设置于本层套内以及每层设置污废水排水立管的检查口，是为了检修和疏通管道时避免影响下层住户。同层排水系统的具体做法，可参考协会标准《建筑同层排水系统技术规程》 CECS 247—2008 。 排水横管必须敷设于下一层套内空间时，只有采取相应的技术措施，才能在排水管道发生堵塞时，在本层内疏通，而不影响下层住户，例如可采用能代替浴缸存水弯、并可在本层清掏的多通道地漏等。此外，有些地区在有些季节会出现管道外壁结露滴水，需采取防止的措施。

**8.2.9** 设置淋浴器和洗衣机的部位应设置地漏，设置洗衣机的部位宜采用能防止溢流和干涸的专用地漏。洗衣机设置在阳台上时，其排水不应排入雨水管。

> **条文说明**  
> 8．2．9 本条规定了必须设置地漏的部位和对洗衣机地漏的性能的要求。洗衣机设置在阳台上时，如洗衣废水排入阳台雨水管，雨水管在首层地面排至散水，漫流至室外地面或绿地，会造成污染、影响植物的生长。

**8.2.10** 无存水弯的卫生器具和无水封的地漏与生活排水管道连接时，在排水口以下应设存水弯；存水弯和有水封地漏的水封高度不应小于 50mm 。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．2．10 在工程实践中，尤其是二次装修的住宅工程，经常忽略洗盆等卫生器具存水弯的设置。实际上，在设计中即便采用无水封的直通地漏 ( 包括密封型地漏 ) 时，也需在下部设置存水弯。本条针对此问题强调了存水弯的设置，并针对污水管内臭味外溢的常见现象，强调无论是有水封的地漏，还是管道设置的存水弯，都要保证水封高度不小于 50mm 。

**8.2.11** 地下室、半地下室中低于室外地面的卫生器具和地漏的排水管，不应与上部排水管连接，应设置集水设施用污水泵排出。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．2．11 低于室外地面的卫生间器具和地漏的排水管，不与上部排水管合并而设置集水设施，用污水泵单独排出，是为了确保当室外排水管道满流或发生堵塞时不造成倒灌。

**8.2.12** 采用中水冲洗便器时，中水管道和预留接口应设明显标识。坐便器安装洁身器时，洁身器应与自来水管连接，严禁与中水管连接。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．2．12 使用中水冲厕具有很好的节水效益。我国水资源短缺的形势非常严峻，缺水城镇的住宅应推广使用中水冲厕。中水的水质要求低于生活饮用水，因此为了保障用水安全，在中水管道上和预留接口部位应设明显标识，主要是为了防止洁身器用水与中水管误接，对健康产生不良影响。

**8.2.13** 排水通气管的出口，设置在上人屋面、住户平台上时，应高出屋面或平台地面 2．00m ；当周围 4．00m 之内有门窗时，应高出门窗上口 0．60m 。

> **条文说明**  
> 8．2．13 在有错层设计的住宅时，顶层住户有可上人的平台或其窗下为下一层的屋面，如这些位置设置排水通气管的出口，可能对住户环境产生影响，实践中有不少为此问题而投诉的实例。本条参考了《建筑给水排水设计规范》 GB 50015 对排水通气管的有关规定，增加了对顶层用户平台通气管要求，对其出口高度作出了规定。

### 8.3 采暖

**8.3.1** 严寒和寒冷地区的住宅宜设集中采暖系统。夏热冬冷地区住宅采暖方式应根据当地能源情况，经技术经济分析，并根据用户对设备运行费用的承担能力等因素确定。

> **条文说明**  
> 8．3．1 “ 采暖设施 ” 包括集中采暖系统和分户或分室设置的采暖系统或采暖设备。 “ 集中采暖 ” 系指热源和散热设备分别设置，由集中热源通过管道向各个建筑物或各户供给热量的采暖方式。 严寒和寒冷地区以城市热网、区域供热厂、小区锅炉房或单幢建筑物锅炉房为热源的集中采暖方式，从节能、采暖质量、环保、消防安全和住宅的卫生条件等方面，都是严寒和寒冷地区采暖方式的主体。即使某些地区具备设置燃油或燃用天然气分散式采暖方式的条件，但除较分散的低层住宅以外，仍推荐采用集中采暖系统。 夏热冬冷地区的采暖要求引自《夏热冬冷地区居住建筑节能设计标准》 JGJ 134 。该区域冬季湿冷、夏季酷热，随着经济发展，人民生活水平的不断提高，对采暖的需求逐年上升。对于居住建筑选择设计集中采暖 ( 空调 ) 系统方式，还是分户采暖 ( 空调 ) 方式，应根据当地能源、环保等因素，通过仔细的技术经济分析来确定。同时，因为该地区的居民采暖所需设备及运行费用全部由居民自行支付，所以，还应考虑用户对设备及运行费用的承担能力。因此，没有对该地区设置采暖设施作出硬性规定，但最低标准是按本规范第 8．6．1 条的规定，在主要房间预留设置分体式空调器的位置和条件，空调器一般具有制热供暖功能，较适合用于夏热冬冷地区供暖。

**8.3.2** 除电力充足和供电政策支持，或建筑所在地无法利用其他形式的能源外，严寒和寒冷地区、夏热冬冷地区的住宅不应设计直接电热作为室内采暖主体热源。 （自 2022 年 4 月 1 日起废止该条， ▶▶ 点击查看： 新规 《建筑节能与可再生能源利用通用规范》 GB55015-2021 ）

> **条文说明**  
> 8．3．2 本条引自《严寒和寒冷地区居住建筑节能设计标准》 JGJ 26 和《夏热冬冷地区居住建筑节能设计标准》 JGJ 134 。直接电热采暖，与采用以电为动力的热泵采暖，以及利用电网低谷时段的电能蓄热、在电网高峰或平峰时段采暖有较大区别。 用高品位的电能直接转换为低品位的热能进行采暖，热效率较低，不符合节能原则。火力发电不仅对大气环境造成严重污染，还产生大量温室气体 (CO2) ，对保护地球、抑制全球气候变暖不利，因此它并不是清洁能源。 严寒、寒冷、夏热冬冷地区采暖能耗占有较高比例。因此，应严格限制应用直接电热进行集中采暖的方式。但并不限制居住者在户内自行配置电热采暖设备，也不限制卫生间等设置 “ 浴霸 ” 等非主体的临时电采暖设施。

**8.3.3** 住宅采暖系统应采用不高于 95 ℃ 的热水作为热媒，并应有可靠的水质保证措施。热水温度和系统压力应根据管材、室内散热设备等因素确定。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．3．3 住宅采暖系统包括集中热源和各户设置分散热源的采暖系统，不包括以电能为热源的分散式采暖设备。采用散热器或地板辐射采暖，以不高于 95 ℃ 的热水作为采暖热媒，从节能、温度均匀、卫生和安全等方面，均比直接采用高温热水和蒸汽合理。 长期以来，热水采暖系统中管道、阀门、散热器经常出现被腐蚀、结垢和堵塞现象。尤其是住宅设置热计量表和散热器恒温控制阀后，对水质的要求更高。除热源系统的水质处理外，对于住宅室内采暖系统的水质保证措施，主要是指建筑物采暖入口和分户系统入口设置过滤设备、采用塑料管材时对管材的阻气要求等。 金属管材、热塑性塑料管、铝塑复合管等，其可承受的长期工作温度和允许工作压力均不相同，不同类型的散热器能够承受的压力也不同。采用低温辐射地板采暖时，从卫生、塑料管材寿命和管壁厚度等方面考虑，要求的水温要低于散热器采暖系统。因此，采暖系统的热水温度和系统压力应根据各种因素综合确定。

**8.3.4** 住宅集中采暖的设计，应进行每一个房间的热负荷计算。 （自 2022 年 4 月 1 日起废止该条， ▶▶ 点击查看： 新规 《建筑节能与可再生能源利用通用规范》 GB55015-2021 ）

> **条文说明**  
> 8．3．4 根据《严寒和寒冷地区居住建筑节能设计标准》 JGJ 26 的有关规定，本条特别强调房间的热负荷计算，是为了避免采用估算数值作为集中采暖系统施工图的依据，导致房间的冷热不均、建设费用和能源的浪费。同时，负荷计算结果还可为管道水力平衡计算提供依据。

**8.3.5** 住宅集中采暖的设计应进行室内采暖系统的水力平衡计算，并应通过调整环路布置和管径，使并联管路 ( 不包括共同段 ) 的阻力相对差额不大于 15％；当不满足要求时，应采取水力平衡措施。

> **条文说明**  
> 8．3．5 系统的热力失匀和水力失调是影响房间舒适和采暖系统节能的关键。本条强调进行水力平衡计算，力求通过调整环路布置和管径达到系统水力平衡。当确实不能满足水力平衡要求时，也应通过计算才能正确选用和设置水力平衡装置。 水力平衡措施除调整环路布置和管径外，还包括设置平衡装置 ( 包括静态平衡阀和动态平衡阀等 ) ，这些要根据工程标准、系统特性正确选用，并在适当的位置正确设置，例如当设置两通恒温控制阀的双管系统为变流量系统时，各并联支环路就不应采用自力式流量控制阀 ( 也称定流量阀或动态平衡阀 ) 。

**8.3.6** 设置采暖系统的普通住宅的室内采暖计算温度，不应低于表 8. 3. 6 的规定。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．3．6 本条规定了采暖最低计算温度，根据《住宅建筑规范》 GB 50368 ，本条为强制性条文。其中楼梯间和走廊温度，为有采暖设施时的计算数值，如不采暖则无最低计算温度要求。根据《严寒和寒冷地区居住建筑节能设计标准》 JGJ 26 ， 严寒 (A) 区和严寒 (B) 区楼梯间宜采暖。

| 用房 | 温度 ( ℃ ) |
| :--- | :--- |
| 卧室、起居室 ( 厅 ) 和卫生间 | 18 |
| 厨房 | 15 |
| 设采暖的楼梯间和走廊 | 14 |

**8.3.7** 设有洗浴器并有热水供应设施的卫生间宜按沐浴时室温为 25 ℃ 设计。

> **条文说明**  
> 8．3．7 随着生活水平的提高，经常的热水供应 ( 包括集中热水供应和设置燃气或电热水器 ) 在有洗浴器的卫生间越来越普遍，沐浴时室温应相应提高，因此推荐有洗浴器的卫生间室温能够达到浴室温度。但如按 25 ℃ 设置热水采暖设施，不沐浴时室温偏高，既不舒适也不节能。当采用散热器采暖时，可利用散热器支管的恒温控制阀随时调节室温。当采用低温热水地面辐射采暖时，由于采暖地板热惰性较大，难以快速调节室温，且设计室温过高、负荷过大，加热管也难以敷设。因此，可以按一般卧室室温要求设计热水采暖设施，另设置 “ 浴霸 ” 等电暖设施在沐浴时临时使用。

**8.3.8** 套内采暖设施应配置室温自动调控装置。

> **条文说明**  
> 8．3．8 套内采暖设施配置室温自动调控装置是节能和保证舒适的重要手段之一。这与《严寒和寒冷地区居住建筑节能设计标准》 JGJ 26 和《供热计量技术规程》 JGJ 173 的相关规定一致。根据户内采暖系统的类型、分户热计量 ( 分摊 ) 方式和调控标准。可选择分室温控或分户总体温控两种方法。 对于散热器采暖，除户内采用具有整体控温功能的通断时间面积法进行分户热计量 ( 分摊 ) 外，一般采用在每组散热器设置恒温控制阀 ( 又称温控阀，恒温器等 ) 的方式。恒温控制阀是一种自力式调节控制阀，可自主调节室温，满足不同人群的舒适要求，同时可以利用房间内获得的自由热，实现自动恒温功能。安装恒温控制阀不仅保持了适宜的室温，同时达到节能目的。 对于热水地面辐射供暖系统，各环路的调控阀门一般集中在分水器处，在各房间设置自力式恒温控制阀较困难。一般可采用各房间设置温度控制器设定，监测室内温度，对各支路的电热阀进行控制，保持房间的设定温度；或选择在有代表性的部位 ( 如起居室 ) ，设置房间温度控制器，控制分水器前总进水管上的电动或电热两通阀的开度。

**8.3.9** 室内采用散热器采暖时，室内采暖系统的制式宜采用双管式；如采用单管式，应在每组散热器的进出水支管之间设置跨越管。

> **条文说明**  
> 8．3．9 条文中对室内采暖系统制式的推荐，与《严寒和寒冷地区居住建筑节能设计标准》 JGJ 26 的相关规定一致。 住宅集中采暖设置分户热计量设施时，一般采用共用立管的分户独立循环的双管或单管系统。采用散热器热分配计法等进行分户热计量时，可以采用垂直双管或单管系统。住宅各户设置独立采暖热源时，分户独立系统可以是水平双管或单管式。 无论何种形式，双管系统各组散热器的进出口温差大，恒温控制阀的调节性能好 ( 接近线性 ) ，而单管系统串联的散热器越多，各组散热器的进出口温差越小，恒温控制阀的调节性能越差 ( 接近快开阀 ) 。双管系统能形成变流量水系统，循环水泵可采用变频调节，有利于节能。设置散热器恒温控制阀时，双管系统应采用高阻力型可利于系统的水力平衡，因此，推荐采用双管式系统。 当采用单管系统时，为了改善恒温控制阀的调节性能，应设跨越管，减少散热器流量、增大温差。但减小流量使散热器平均温度降低，则需增加散热器面积，也是单管系统的缺点之一。单管系统本身阻力较大，各组散热器之间无水力平衡问题，因此采用散热器恒温控制阀时应采用低阻力型。

**8.3.10** 设计地面辐射采暖系统时，宜按主要房间划分采暖环路。

> **条文说明**  
> 8．3．10 地面辐射供暖系统推荐按主要房间划分地面辐射采暖的环路，与《严寒和寒冷地区居住建筑节能设计标准》 JGJ 26 的相关规定一致。其目的是能够对主要房间进行分室调节和温控。当采用发热电缆地面辐射采暖时，采暖环路则是指发热电缆回路。

**8.3.11** 应采用体型紧凑、便于清扫、使用寿命不低于钢管的散热器，并宜明装，散热器的外表面应刷非金属性涂料。

> **条文说明**  
> 8．3．11 要求采用体型紧凑的散热器，是为了少占用住宅户内的使用空间。为改善卫生条件，散热器要便于清扫。针对部分钢制散热器的腐蚀穿孔，在住宅中采用后造成漏水的问题，本条强调了采用散热器耐腐蚀的使用寿命，应不低于钢管。

**8.3.12** 采用户式燃气采暖热水炉作为采暖热源时，其热效率应符合现行国家标准《家用燃气快速热水器和燃气采暖热水炉能效限定值及能效等级》 GB 20665 中能效等级 3 级的规定值。 （自 2022 年 4 月 1 日起废止该条， ▶▶ 点击查看： 新规 《建筑节能与可再生能源利用通用规范》 GB55015-2021 ）

> **条文说明**  
> 8．3．12 本规范提出了户式燃气采暖热水炉设计选用时对热效率的要求，表 1 引自《家用燃气快速热水器和燃气采暖热水炉能效限定值及能效等级》 GB 20665 ，该标准第 4．2 条规定了热水器和采暖炉能效限定值为表 1 中能效等级的 3 级。

### 8.4 燃气

**8.4.1** 住宅管道燃气的供气压力不应高于 0．2MPa 。住宅内各类用气设备应使用低压燃气，其入口压力应在 0．75 倍～ 1．5 倍燃具额定范围内。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．4．1 本条引自现行国家标准《城镇燃气设计规范》 GB 50028 。

**8.4.2** 户内燃气立管应设置在有自然通风的厨房或与厨房相连的阳台内，且宜明装设置，不得设置在通风排气竖井内。

> **条文说明**  
> 8．4．2 考虑到除燃气灶外，热水器等用气设备也可能设置在厨房或与厨房相连的阳台内，因此，户内燃气立管设置在燃气灶和燃气设备旁可减少支管长度，要尽量避免穿越其他房间，对于保持户内美观和安全都有好处，实际工程也都如此，本条对此作出了相应规定。住宅立管明装设置是指不宜设置在不便于检查的水管管井等密闭空间内，更不允许设置在通风排气道内。如必须设置在水管管井内，管井还需设置燃气浓度监测报警设施等，见现行国家标准《城镇燃气设计规范》 GB 50028 。

**8.4.3** 燃气设备的设置应符合下列规定： 
1. 燃气设备严禁设置在卧室内； 
2. 严禁在浴室内安装直接排气式、半密闭式燃气热水器等在使用空间内积聚有害气体的加热设备； 
3. 户内燃气灶应安装在通风良好的厨房、阳台内； 
4. 燃气热水器等燃气设备应安装在通风良好的厨房、阳台内或其他非居住房间。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．4．3 本条根据现行国家标准《城镇燃气设计规范》 GB 50028 整理。考虑到浴室使用热水器时门窗较密闭，一旦有燃气发生泄漏等事故，难以及时发现，很不安全，因此浴室内不允许设置有可能积聚有害气体的设备。要求厨房等安装燃气设备的房间 “ 通风良好 ” ，是指能符合本规范第 5．3 节的规定，有直接采光和自然通风，且燃气灶和其他燃气设备能符合本规范第 8．5 节的规定。允许安装燃气设备的 “ 其他非居住房间 ” ，是指一些大户型住宅、别墅等为燃气设备等单独设置的、有与其他空间分隔的门、有自然通风且确实能保证无人居住的设备间等，不包括目前一般住宅中不能保证无人居住的起居室、餐厅以及与之相通的过道等。

**8.4.4** 住宅内各类用气设备的烟气必须排至室外。排气口应采取防风措施，安装燃气设备的房间应预留安装位置和排气孔洞位置；当多台设备合用竖向排气道排放烟气时，应保证互不影响。户内燃气热水器、分户设置的采暖或制冷燃气设备的排气管不得与燃气灶排油烟机的排气管合并接入同一管道。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．4．4 根据现行国家标准《城镇燃气设计规范》 GB 50028 的有关规定整理。

**8.4.5** 使用燃气的住宅，每套的燃气用量应根据燃气设备的种类、数量和额定燃气量计算确定，且应至少按一个双眼灶和一个燃气热水器计算。

> **条文说明**  
> 8．4．5 本条规定了住宅每套的燃气用量和最低设计燃气用量的确定原则，即使设有集中热水供应系统，也应预留住户选择采用单户燃气热水器的条件。

### 8.5 通风

**8.5.1** 排油烟机的排气管道可通过竖向排气道或外墙排向室外。当通过外墙直接排至室外时，应在室外排气口设置避风、防雨和防止污染墙面的构件。

> **条文说明**  
> 8．5．1 本条给出排油烟机排气的两种出路。通过外墙直接排至室外，可节省设置排气道的空间并不会产生各层互相串烟，但不同风向时可能倒灌，且对墙体可能有不同程度的污染，因此应采取相应措施。当通过共用排气道排出屋面时，本规范第 6．8．5 条另有规定。

**8.5.2** 严寒、寒冷、夏热冬冷地区的厨房，应设置供厨房房间全面通风的自然通风设施。

> **条文说明**  
> 8．5．2 房间 “ 全面通风 ” 是相对于炉灶排油烟机等 “ 局部排风 ” 而言。严寒地区、寒冷地区和夏热冬冷地区的厨房，在冬季关闭外窗和非炊事时间排油烟机不运转的条件下，应有向室外排除厨房内燃气或烟气的自然排气通路。厨房不开窗时全面通风装置应保证开启，因此应采用最安全和节能的自然通风。自然通风装置指有避风、防雨构造的外墙通风口或通风器等。

**8.5.3** 无外窗的暗卫生间，应设置防止回流的机械通风设施或预留机械通风设置条件。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．5．3 当卫生间不采用机械通风，仅设置自然通风的竖向通气道时，主要依靠室内外空气温差形成的热压，室外气温越低热压越大。但在室内气温低于室外气温的季节 ( 如夏季 ) ，就不能形成自然通风所需的作用力，因此要求设置机械通风设施或预留机械通风 ( 一般为排气扇 ) 条件。

**8.5.4** 以煤、薪柴、燃油为燃料进行分散式采暖的住宅，以及以煤、薪柴为燃料的厨房，应设烟囱；上下层或相邻房间合用一个烟囱时，必须采取防止串烟的措施。

> **条文说明**  
> 8．5．4 燃气设备的烟气排放，已经在本章第 8．4 节和本节作出了明确规定。煤、薪柴、燃油等燃烧时，产生气体更加有害，也需有排烟设施。除了在外墙上开洞通过设备的排烟管道直接向室外排放外，一般应设置竖向烟囱。 烟囱有两种做法：一种是每户独用一个排气孔道直出屋面， 这种做法比较安全，使用效果也较好，但占用面积较多；另一种做法是各层合用一个排气道，这种做法较省面积，但也可能串烟，发生事故。最好采用由主次烟气道组合的排气道，它占用面积较少，并能防止串烟。因此，本条规定必须采取防止串烟的措施。

### 8.6 空调

**8.6.1** 位于寒冷 (B 区 ) 、夏热冬冷和夏热冬暖地区的住宅，当不采用集中空调系统时，主要房间应设置空调设施或预留安装空调设施的位置和条件。

> **条文说明**  
> 8.6.1 随着人民生活水平的提高，包括北方寒冷 (B) 区在内，夏季使用空调设备已经非常普及，参考各地区居住建筑节能设计标准的有关条文，本条规定至少要在主要房间设置空调设施或预留设置空调设施的位置和条件。

**8.6.2** 室内空调设备的冷凝水应能有组织地排放。

> **条文说明**  
> 8.6.2 室内空调设备的冷凝水可以采用专用排水管或就近间接排入附近污水或雨水地面排水口（地漏）等方式，有组织地排放，以免无组织排放的凝水影响室外环境。

**8.6.3** 当采用分户或分室设置的分体式空调器时，室外机的安装位置应符合本规范第 5．6．8 条的规定。

> **条文说明**  
> 8.6.3 住宅内各用户对夏季空调的运行时间和全日间歇运行要求差距很大。采用分散式空调器的节能潜力较大，且机电一体化的分体式空调器（包括风管机和多联机）自动控制水平较高，根据有关调查研究，它比集中空调更加节能和控制灵活。另外，当采用集中空调系统分户计量时，还应考虑电价因素，以免给日后的物业管理造成难度。因此目前住宅采用分户或分室设置的分体式空调器较多。 室外机的安装位置直接涉及节能、安全。以及对室外和其他住户环境的影响问题，因此暖通专业应按本规范第 5.6.7 条的设置原则向建筑专业提出或校核建筑专业确定的空调室外机的设置位置，使其达到最佳。

**8.6.4** 住宅计算夏季冷负荷和选用空调设备时，室内设计参数宜符合下列规定： 
1. 卧室、起居室室内设计温度宜为 26 ℃ ； 
2. 无集中新风供应系统的住宅新风换气宜为 1 次／ h 。

> **条文说明**  
> 8.6.4 26 ℃ 和新风换气次数只是一个计算参数，在设备选择时计算空调负荷，在进行围护结构热工性能综合判断时用来计算空调能耗，并不等同于实际的室内热环境。实际的室温和通风换气是由住户自己控制的。

**8.6.5** 空调系统应设置分室或分户温度控制设施。

> **条文说明**  
> 8.6.5 室温控制是分户计量和保证舒适的前提。采用分室或分户温度控制可根据采用的空调方式确定。一般集中空调系统的风机盘管可以方便地设置室温控制设施，分体式空调器（包括多联机）的室内机也均具有能够实现分室温控的功能。风管机需调节各房间风量才能实现分室温控，有一定难度审因此，也可将温度传感器设置在有代表性房间或监测回风的平均温度，粗略地进行户内温度的整体控制。

### 8.7 电气

**8.7.1** 每套住宅的用电负荷应根据套内建筑面积和用电负荷计算确定，且不应小于 2．5kW 。

> **条文说明**  
> 8．7．1 每套住宅的用电负荷因套内建筑面积、建设标准、采暖 ( 或过渡季采暖 ) 和空调的方式、电炊、洗浴热水等因素而有很大的差别。本规范仅提出必须达到的下限值。每套住宅用电负荷中应包括：照明、插座，小型电器等，并为今后发展留有余地。考虑家用电器的特点，用电设备的功率因数按 0．9 计算。

**8.7.2** 住宅供电系统的设计，应符合下列规定： 
1. 应采用 TT 、 TN-C-S 或 TN-S 接地方式，并应进行总等电位联结； 
2. 电气线路应采用符合安全和防火要求的敷设方式配线，套内的电气管线应采用穿管暗敷设方式配线。导线应采用铜芯绝缘线，每套住宅进户线截面不应小于 10mm² ，分支回路截面不应小于 2．5mm² ； 
3. 套内的空调电源插座、一般电源插座与照明应分路设计，厨房插座应设置独立回路，卫生间插座宜设置独立回路； 
4. 除壁挂式分体空调电源插座外，电源插座回路应设置剩余电流保护装置； 
5. 设有洗浴设备的卫生间应作局部等电位联结； 
6. 每幢住宅的总电源进线应设剩余电流动作保护或剩余电流动作报警。

> **条文说明**  
> 8．7．2 本条强调了住宅供电系统设计的安全要求。  
> 1 在 TN 系统中，壁挂空调的插座回路可不设置剩余电流保护装置，但在 TT 系统中所有插座回路均应设置剩余电流保护装置。  
> 2 导线采用铜芯绝缘线，是指每套住宅的进户线和户内分支回路，对干线的选材末作规定。每套住宅进户线是限定每套住宅最大用电量的关键参数，综合考虑每套住宅的基本用电需求、适当留有发展余地、住宅进户线一般为暗管一次敷设到位难以改造等因素，提出每套住宅进户线的最小截面。  
> 3 住宅套内线路分路分类配线，是为了减小线路温升，满足用电需求、保证用电安全和减少电气火灾的危险。  
> 5 “ 总等电位联结 ” 是用来均衡电位，降低人体受到电击时的接触电压的，是接地保护的一项重要措施。 “ 局部等电位联结 ” ，是为了防止出现危险的接触电压。 局部等电位联结包括卫生间内金属给排水管、金属浴盆、金属采暖管以及建筑物钢筋网和卫生间电源插座的 PE 线，可不包括金属地漏、扶手、浴巾架、肥皂盒等孤立金属物。尽管住宅卫生间目前多采用铝塑管、 PPR 等非金属管，但考虑住宅施工中管材更换、住户二次装修等因素，还是要求设置局部等电位接地或预留局部等电位接地端子盒。  
> 6 为了避免接地故障引起的电气火灾，住宅建筑要采取可靠的措施。由于防火剩余电流动作值不宜大于 500mA ，为减少误报和误动作，设计中要根据线路容量、线路长短、敷设方式、空气湿度等因素，确定在电源进线处或配电干线的分支处设置剩余电流动作保护或报警装置。当住宅建筑物面积较小，剩余电流检测点较少时，可采用剩余电流动作保护装置或独立型防火剩余电流动作报警器。当有集中监测要求时，可将报警信号连至小区消防控制室。当剩余电流检测点较多时，也可采用电气火灾监控系统。

**8.7.3** 每套住宅应设置户配电箱，其电源总开关装置应采用可同时断开相线和中性线的开关电器。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．7．3 为保证安全和便于管理，本条对每套住宅的电源总断路器提出了相应要求。

**8.7.4** 套内安装在 1．80m 及以下的插座均应采用安全型插座。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．7．4 为了避免儿童玩弄插座发生触电危险，本条规定安装高度在 1．8m 及以下的插座采用安全型插座。

**8.7.5** 共用部位应设置人工照明，应采用高效节能的照明装置和节能控制措施。当应急照明采用节能自熄开关时，必须采取消防时应急点亮的措施。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．7．5 原规范规定公共部分照明采用节能自熄开关，以实现人在灯亮，人走灯灭，达到节电目的。但在应用中也出现了一些新问题：如夜间漆黑一片，对住户不方便；在设置安防摄像场所 ( 除采用红外摄像机外 ) ，达不到摄像机对环境的最低照度要求；较大声响会引起大面积公共照明自动点亮，如在夜间经常有重型货车通过时频繁亮灭，使灯具寿命缩短，也达不到节能效果；具体工程中，楼梯间、电梯厅有无外窗的条件也不相同。此外，应用于住宅建筑的节能光源的声光控制和应急启动技术也在不断发展和进步。因此，本条强调住宅公共照明要选择高效节能的照明装置和节能控制。设计中要具体分析，因地制宜，采用合理的节能控制措施，并且要满足消防控制的要求。

**8.7.6** 住宅套内电源插座应根据住宅套内空间和家用电器设置，电源插座的数量不应少于表 8．7．6 的规定。

> **条文说明**  
> 8．7．6 电源插座的设置应满足家用电器的使用要求，尽量减少移动插座的使用。 但住宅家用电器的种类和数量很多，因套内空间、面积等因素不同，电源插座的设置数量和种类差别也很大，我国尚未有统一的家用电器电源线长度的统一标准，难以统一规定插座之间的间距。为方便居住者安全用电，本条规定了电源插座的设置数量和部位的最低标准，这是对应本规范第 5．1．2 条的最小套型提出的。

| 空间 | 设置数盘和 内容 |
| :--- | :--- |
| 卧室 | 一个单相三线和一个单相二线的插座两组 |
| 兼起居的卧室 | 一个单相三线和一个单相二线的插座三组 |
| 起居室 ( 厅 ) | 一个单相三线和一个单相二线的插座三组 |
| 厨房 | 防溅水型一个单相三线和一个单相二线的插座两组 |
| 卫生间 | 防溅水型一个单相三线和一个单相二线的插座一组 |
| 布置洗衣机、冰箱排油烟机、排风机及预留家用空调器处 | 专用单相三线插座各一个 |

**8.7.7** 每套住宅应设有线电视系统、电话系统和信息网络系统，宜设置家居配线箱。有线电视、电话、信息网络等线路宜集中布线，并应符合下列规定： 
1. 有线电视系统的线路应预埋到住宅套内。每套住宅的有线电视进户线不应少于 1 根，起居室、主卧室、兼起居的卧室应设置电视插座； 
2. 电话通信系统的线路应预埋到住宅套内。每套住宅的电话通信进户线不应少于 1 根，起居室、主卧室、兼起居的卧室应设置电话插座； 
3. 信息网络系统的线路宜预埋到住宅套内。每套住宅的进户线不应少于 1 根，起居室、卧室或兼起居室的卧室应设置信息网络插座。

> **条文说明**  
> 8．7．7 住宅的信息网络系统可以单独设置，也可利用有线电视系统或电话系统来实现。三网融合是今后的发展方向， IPTV 、 ADSL 等技术可利用有线电视系统和电话系统来实现信息通信，住宅建筑电话通信系统的设置需与当地电信业务经营者提供的运营方式相结合。住宅建筑信息网络系统的设计要与当地信息网络的现有水平及发展规划相互协调一致，根据当地公共通信网络资源的条件决定是否与有线电视或电话通信系统合一。 每套住宅设置家居配线箱应是今后的发展方向，但对于较小住宅套型设置有电视、电话和信息网络线路即可，因此提出 “ 宜设置 ” 家居配线箱。

**8.7.8** 住宅建筑宜设置安全防范系统。

> **条文说明**  
> 8．7．8 根据《安全防范工程技术规范》 GB 50348 ，对于建筑面积在 50000m² 以上的住宅小区，要根据建筑面积、建设投资、系统规模、系统功能和安全管理要求等因素，设置基本型、提高型、先进型的安全防范系统。在有小区集中管理时，可根据工程具体情况，将呼救信号、紧急报警和燃气报警等纳入访客对讲系统。

**8.7.9** 当发生火警时，疏散通道上和出入口处的门禁应能集中解锁或能从内部手动解锁。 （自 2025 年 5 月 1 日起废止该条， 点击查看：新规 《住宅项目规范》 GB55038-2025 ）

> **条文说明**  
> 8．7．9 门禁系统必须满足紧急逃生时人员疏散的要求。当发生火警或需紧急疏散时，住宅楼疏散门的防盗门锁须能集中解除或现场顺疏散方向手动解除，使人员能迅速安全疏散。设有火灾自动报警系统或联网型门禁系统时，在确认火情后，须在消防控制室集中解除相关部位的门禁。当不设火灾自动报警系统或联网型门禁系统时，要求能在火灾时不需使用任何工具就能从内部徒手打开出口门，以便于人员的逃生。

## 本规范用词说明

1. 为便于在执行本规范条文时区别对待，对要求严格程度不同的用词，说明如下： 
    1) 表示很严格，非这样做不可的用词：   正面词采用 “ 必须 ” ，反面词采用 “ 严禁 ” ； 
    2) 表示严格，在正常情况下均应这样做的用词：   正面词采用 “ 应 ” ，反面词采用 “ 不应 ” 或 “ 不得 ” ； 
    3) 表示允许稍有选择，在条件许可时首先应这样做的用词：   正面词采用 “ 宜 ” ，反面词采用 “ 不宜 ” ； 
    4) 表示有选择，在一定条件下可以这样做的用词，采用 “ 可 ”。
2. 本规范中指明应按其他有关标准执行的写法为： “ 应符合 …… 的规定 ” 或 “ 应按 …… 执行 ”。