# 第二章 建筑防火设计的专家实务与性能化挑战（GB 50016 / GB 55037）

## 2.1 规范演进与设计范式的转变

随着《建筑防火通用规范》（GB 55037-2022）的实施，中国建筑防火设计体系进入了"全文强制"的新时代。传统的《建筑设计防火规范》（GB 50016-2014）虽然构建了基础框架，但在面对现代建筑的体量巨型化、功能复合化趋势时，往往显得捉襟见肘。专家普遍认为，对于占据市场90%的常规建筑，处方式规范足以应对；但对于剩余10%的复杂地标性建筑，必须引入性能化设计（Performance-Based Design）理念，通过专家论证来弥补规范的滞后性 ^1^。

### 2.1.1 "烟囱效应"与垂直蔓延的物理实质

专家在解读超高层建筑防火难点时，首要关注的是热压作用下的烟气流动。

- **物理机制**：高层建筑内部存在大量的竖向管井（电梯井、电缆井、排气道）。专家指出，一旦发生火灾，室内外温差导致的热压差会形成强烈的"烟囱效应"。据测算，在火灾工况下，烟气从底层蔓延至33层（约100米高度）仅需30秒左右 ^3^。

- **专家警示**：对于超过100米的超高层建筑，外部救援能力（消防云梯车通常仅能达到100米左右）基本失效。专家强调，此类建筑必须具备"自救"能力，即通过加强内部防火分隔、提高结构耐火极限和优化防排烟系统来控制火势 ^4^。

- **设计隐患**：专家在审查中发现，许多设计方案低估了竖向管井的密封难度。如果防火封堵材料（如防火泥、阻火包）施工不规范，或者在运营期间因检修被破坏，这些管井将成为致命的毒烟通道 ^4^。

## 2.2 真实案例深度剖析：上海中心大厦的性能化防火策略

上海中心大厦（632米）作为中国最高的建筑之一，其防火设计超出了常规规范的覆盖范围，成为专家运用性能化设计理念的经典范例 ^2^。

### 2.2.1 巨型中庭的烟气控制逻辑

上海中心拥有多个垂直叠加的空中大堂（中庭），这在给建筑带来通透感的同时，也带来了巨大的排烟挑战。

- **常规规范的局限**：GB 50016对于中庭排烟量的计算通常基于一定的体积或面积，但在60米甚至更高的超高大堂中，热烟气的行为变得极为复杂。

- **专家论证与模拟**：通过全尺寸热烟测试和数值模拟（CFD），专家发现，在大型中庭内，烟气上升速度可达2-3 m/s。然而，存在一个致命的"热障效应"（Thermal Barrier Effect）：如果火源功率较小但烟气量大，烟气在上升过程中冷却，可能在到达顶部排烟口之前就发生"层化"（Stratification），悬浮在半空中并开始横向蔓延，导致顶部排烟风机吸不到烟，而下部人员却被烟气笼罩 ^5^。

- **解决方案------"防烟走廊"**：针对这一难题，专家并未单纯增加排烟量，而是提出了"防烟走廊"概念。通过在核心筒周围设置加压送风的缓冲区，构建一道无形的空气墙，阻止中庭的高温烟气进入疏散楼梯间。模拟结果显示，这种设计能确保在ASET（可用安全疏散时间）内，疏散通道的能见度保持在15米以上，温度低于60℃ ^6^。

### 2.2.2 给水系统的超高压挑战与冗余设计

在600米高空灭火，水压是核心问题。

- **系统架构**：专家评审指出，传统的串联供水方式存在单点故障风险。上海中心采用了"双路供水、接力提升"的策略。126层至110层的顶层区域由专门的消防水泵供水，而中下部楼层则利用重力流，从中间避难层的消防水池供水。专家特别强调了"传输水箱"的容量冗余，确保在市政管网补水不及时的情况下，大楼仍有足够的初期灭火用水 ^2^。

- **运维痛点**：在后续的专家检测评估中，发现部分高压水泵在长时间运行后轴承温度偏高（超出正常值5℃），这提示了在超高层建筑中，极高的系统压力对设备耐久性提出了更高要求。专家建议，对于此类关键设备，必须建立比规范更严格的巡检周期 ^2^。

### 2.2.3 报警系统的误报控制

- **环境干扰**：专家在检测中发现，高层建筑的云端层（高空）由于气象条件复杂，且部分设备层通风不良，积尘和油烟容易导致感烟探测器误报。上海中心部分餐饮区域的误报率曾达到5%。

- **专家对策**：建议采用复合型探测器（感温+感烟+CO），并优化报警主机的逻辑算法（如双点确认），以减少"狼来了"效应导致的疏散恐慌 ^2^。

## 2.3 真实案例深度剖析：深圳平安金融中心（PAFC）

深圳平安金融中心在结构防火与辅助疏散方面提供了另一种专家思路 ^8^。

### 2.3.1 结构抗火的"定楼神针"

- **钢结构的软肋**：钢材在550℃以上强度会急剧下降。对于超高层建筑，一旦核心结构在火灾中失效，后果是毁灭性的。

- **专家方案**：PAFC采用了8根巨型钢骨混凝土柱。专家认为，混凝土的包覆不仅提供了结构刚度，更充当了绝佳的防火保护层。相比于单纯的防火涂料，混凝土保护层能确保结构在极端火灾下保持数小时的稳定性，为全楼疏散争取时间。专家评审要求其耐火极限必须远超规范基础值（3.0小时），通常设定为4.0小时甚至更长 ^8^。

### 2.3.2 "穿梭电梯"辅助疏散

- **传统观念的突破**：长期以来，中国规范严禁使用普通电梯进行火灾疏散。但对于百层高楼，完全依靠楼梯疏散体力消耗过大，甚至可能导致踩踏。

- **创新实践**：PAFC配置了6台特殊的"穿梭电梯"（Shuttle Elevators），专门用于将人员从避难层快速转运至地面。专家论证的核心在于这些电梯的供电可靠性、井道加压送风能力以及防水性能。这种"楼梯+电梯"的混合疏散模式，显著提高了整体疏散效率（RSET），是超高层建筑疏散设计的必由之路 ^8^。

## 2.4 大型商业综合体的运营期风险与专家治理

对于体量超过5万平方米的大型商业综合体，硬件设施只是基础，专家普遍认为"管理是最大的防火墙" ^1^。

### 2.4.1 "亚安全区"的商业化侵蚀

- **规范定义**：规范允许设置下沉式广场、避难走道等作为火灾时的临时避难区域（亚安全区）。

- **违规现状**：专家在检查中频繁发现，商业管理方为了追求坪效，将这些开敞空间出租用于举办展销会、搭建临时摊位。

- **专家定性**：这属于严重的"改变使用性质"。下沉广场不仅是疏散场地，更是排烟口。一旦搭建了售货亭或堆放了商品，不仅占据了疏散面积，更引入了新的火灾荷载。专家指出，特别是儿童游乐设施（海洋球、充气城堡），其材质多为易燃塑料，燃烧滴落物极易封锁疏散通道，必须"零容忍"清理 ^1^。

### 2.4.2 节日装饰的隐形杀手

- **案例教训**：沈阳万达广场售楼处火灾等案例表明，沙盘模型和节日装饰是极高风险点。

- **专家关注**：在圣诞、春节等节点，商场内部会悬挂大量聚氨酯泡沫装饰（雪花）、氢气球和塑料仿真树。

- **合规判定**：专家依据GB 50016及装修规范指出，中庭等高大空间内的装饰材料燃烧性能应达到B1级。然而市面上的装饰品多为易燃材料。专家建议，大型活动期间必须通过材料燃烧性能检测，严禁使用冷烟花，并要求加强现场看护 ^1^。

## 2.5 施工图审查中的常见防火疑难与专家裁量

在基于GB 50016的施工图审查（强条审查）环节，专家们积累了大量细致的判定规则，这些规则构成了"经验层"的重要组成部分 ^9^。

### 2.5.1 住宅户门间距的几何判定

- **规范条文**：GB 50016规定，相邻户门在"内转角"处距离不应小于一定数值，以防火势卷吸。

- **专家解析**：

  - **开敞与封闭之辩**：如果户门是通向开敞式外廊（Open Corridor）或入户花园，专家通常认为这属于"室外空间"，散热条件好，可不强制执行1.0米的间距要求。

  - **防火门折减**：如果其中一扇门升级为甲级或乙级防火门，专家通常允许间距限制放宽，因为防火门本身具备耐火隔热能力 ^9^。

### 2.5.2 避难层功能的纯粹性捍卫

- **开发商诉求**：在寸土寸金的超高层住宅中，开发商倾向于利用避难层剩余空间设置公寓或会所。

- **专家红线**：避难层必须保持"纯粹"。除设备间外，严禁布置任何住宅单元。对于跃层式住宅（Split-level），虽然物理上可能穿越避难层标高，但专家要求其**严禁在避难层开设门窗**。所有人员必须通过上下层的安全出口疏散，绝不能干扰避难层的独立性。这是为了防止由于住宅火灾直接波及避难层，导致"安全岛"失效 ^9^。

### 2.5.3 "三合一"前室的死局破解

- **定义**：将消防电梯前室与两部剪刀楼梯间的前室合并，形成"三合一"前室。

- **风险**：如果设计不当，该区域会成为唯一的逃生通道，一旦被烟气封锁，全层覆没。

- **专家对策**：

  - **户数限制**：专家严格限制共用此类前室的户数（通常不超过3户）。

  - **回廊机制**：如果户数较多，必须设置环形走道（Circular Corridor），确保每个住户都有双向逃生的可能，严禁出现袋形走道直接通向"三合一"前室的布局 ^9^。

### 2.5.4 住宅"安全房间"的选址

- **常见错误**：设计人员常将卫生间标注为"安全房间"（Safety Room）。

- **专家否决**：卫生间通常面积狭小且为了防水设有门槛，不利于无障碍进出。更关键的是，安全房间需要防火门，而卫生间需要经常通风，防火门常闭与卫生间日常使用相悖。专家推荐选择**主卧室**作为安全房间，因其开间大、不仅便于救援，且通常具备较好的外窗 ^9^。
