# 《建筑与市政工程无障碍通用规范 [附条文说明]》GB 55019-2021

**住房和城乡建设部**  
**更新时间：2025-05-17**  
**实施时间：2022-04-01**

## 目录
- 前言
- 1 总则
- 2 无障碍通行设施
  - 2.1 一般规定
  - 2.2 无障碍通道
  - 2.3 轮椅坡道
  - 2.4 无障碍出入口
  - 2.5 门
  - 2.6 无障碍电梯和升降平台
  - 2.7 楼梯和台阶
  - 2.8 扶手
  - 2.9 无障碍机动车停车位和上/落客区
  - 2.10 缘石坡道
  - 2.11 盲道
- 3 无障碍服务设施
  - 3.1 一般规定
  - 3.2 公共卫生间（厕所）和无障碍厕所
  - 3.3 公共浴室和更衣室
  - 3.4 无障碍客房和无障碍住房、居室
  - 3.5 轮椅席位
  - 3.6 低位服务设施
- 4 无障碍信息交流设施
- 5 无障碍设施施工验收和维护

## 前言

**中华人民共和国国家标准**  
**建筑与市政工程无障碍通用规范**  
**General codes for accessibility of buildings and municipal engineering projects**  
**GB 55019-2021**

**主编部门**：中华人民共和国住房和城乡建设部  
**批准部门**：中华人民共和国住房和城乡建设部  
**施行日期**：2022年4月1日

**中华人民共和国住房和城乡建设部公告**  
**2021年第174号**

住房和城乡建设部关于发布国家标准《建设与市政工程无障碍通用规范》的公告

现批准《建筑与市政工程无障碍通用规范》为国家标准，编号为GB 55019-2021，自2022年4月1日起实施。本规范为强制性工程建设规范，全部条文必须严格执行。现行工程建设标准相关强制性条文同时废止。现行工程建设标准中有关规定与本规范不一致的，以本规范的规定为准。

本规范在住房和城乡建设部门户网站公开，并由住房和城乡建设部标准定额研究所组织中国建筑出版传媒有限公司出版发行。

中华人民共和国住房和城乡建设部  
2021年9月8日

### 废止的现行工程建设标准相关强制性条文
1.  《无障碍设计规范》GB 50763-2012  
    第3.7.3（3、5）、4.4.5、6.2.4（5）、6.2.7（4）、8.1.4条（款）
2.  《无障碍设施施工验收及维护规范》GB 50624-2011  
    第3.1.12、3.1.14、3.14.8、3.15.8条
3.  《住宅设计规范》GB 50096-2011  
    第6.6.2、6.6.4条

### 前 言

为适应国际技术法规与技术标准通行规则，2016年以来，住房和城乡建设部陆续印发《深化工程建设标准化工作改革的意见》等文件，提出政府制定强制性标准、社会团体制定自愿采用性标准的长远目标，明确了逐步用全文强制性工程建设规范取代现行标准中分散的强制性条文的改革任务，逐步形成由法律、行政法规、部门规章中的技术性规定与全文强制性工程建设规范构成的“技术法规”体系。

**关于规范种类**。强制性工程建设规范体系覆盖工程建设领域各类建设工程项目，分为工程项目类规范（简称项目规范）和通用技术类规范（简称通用规范）两种类型。项目规范以工程建设项目整体为对象，以项目的规模、布局、功能、性能和关键技术措施等五大要素为主要内容。通用规范以实现工程建设项目功能性能要求的各专业通用技术为对象，以勘察、设计、施工、维修、养护等通用技术要求为主要内容。在全文强制性工程建设规范体系中，项目规范为主干，通用规范是对各类项目共性的、通用的专业性关键技术措施的规定。

**关于五大要素指标**。强制性工程建设规范中各项要素是保障城乡基础设施建设体系化和效率提升的基本规定，是支撑城乡建设高质量发展的基本要求。项目的规模要求主要规定了建设工程项目应具备完整的生产或服务能力，应与经济社会发展水平相适应。项目的布局要求主要规定了产业布局、建设工程项目选址、总体设计、总平面布置以及与规模相协调的统筹性技术要求，应考虑供给能力合理分布，提高相关设施建设的整体水平。项目的功能要求主要规定项目构成和用途，明确项目的基本组成单元，是项目发挥预期作用的保障。项目的性能要求主要规定建设工程项目建设水平或技术水平的高低程度，体现建设工程项目的适用性，明确项目质量、安全、节能、环保、宜居环境和可持续发展等方面应达到的基本水平。关键技术措施是实现建设项目功能、性能要求的基本技术规定，是落实城乡建设安全、绿色、韧性、智慧、宜居、公平、有效率等发展目标的基本保障。

**关于规范实施**。强制性工程建设规范具有强制约束力，是保障人民生命财产安全、人身健康、工程安全、生态环境安全、公众权益和公众利益，以及促进能源资源节约利用、满足经济社会管理等方面的控制性底线要求，工程建设项目的勘察、设计、施工、验收、维修、养护、拆除等建设活动全过程中必须严格执行，其中，对于既有建筑改造项目（指不改变现有使用功能），当条件不具备、执行现行规范确有困难时，应不低于原建造时的标准。与强制性工程建设规范配套的推荐性工程建设标准是经过实践检验的、保障达到强制性规范要求的成熟技术措施，一般情况下也应当执行。在满足强制性工程建设规范规定的项目功能、性能要求和关键技术措施的前提下，可合理选用相关团体标准、企业标准，使项目功能、性能更加优化或达到更高水平。推荐性工程建设标准、团体标准、企业标准要与强制性工程建设规范协调配套，各项技术要求不得低于强制性工程建设规范的相关技术水平。

强制性工程建设规范实施后，现行相关工程建设国家标准、行业标准中的强制性条文同时废止。现行工程建设地方标准中的强制性条文应及时修订，且不得低于强制性工程建设规范的规定。现行工程建设标准（包括强制性标准和推荐性标准）中有关规定与强制性工程建设规范的规定不一致的，以强制性工程建设规范的规定为准。

## 1 总则

**1.0.1** 为保障无障碍环境建设中无障碍设施的建设和运行维护，依据国家相关法律法规，制定本规范。

> **条文说明**
>
> 本条为本规范的编制目的。
>
> 根据国家保障残疾人、老年人的相关法律，本规范规定了建筑与市政工程中主要无障碍设施的重要功能、性能及安全性要求。
>
> 依据的国家相关法律法规主要包括：
>
> 根据《中华人民共和国残疾人保障法》第五十三条规定：“无障碍设施的建设和改造，应当符合残疾人的实际需要”。
>
> 根据《中华人民共和国老年人权益保障法》第六十四条规定：“国家制定无障碍设施工程建设标准。新建、改建和扩建道路、公共交通设施、建筑物、居住区等，应当符合国家无障碍设施工程建设标准。
>
> 各级人民政府和有关部门应当按照国家无障碍设施工程建设标准，优先推进与老年人日常生活密切相关的公共服务设施的改造。
>
> 无障碍设施的所有人和管理人应当保障无障碍设施正常使用。”
>
> 根据《中华人民共和国老年人权益保障法》第六十五条规定：“国家推动老年宜居社区建设，引导、支持老年宜居住宅的开发，推动和扶持老年人家庭无障碍设施的改造，为老年人创造无障碍居住环境。”
>
> 根据国务院《无障碍环境建设条例》第二条规定：“无障碍环境建设，是指为便于残疾人等社会成员自主安全地通行道路、出入相关建筑物、搭乘公共交通工具、交流信息、获得社区服务所进行的建设活动。”

**1.0.2** 新建、改建和扩建的市政和建筑工程的无障碍设施的建设和运行维护必须执行本规范。

> **条文说明**
>
> 本条为本规范的适用范围。当新建、改建和扩建的市政和建筑工程中需要设置无障碍设施时，无障碍设施的建设和运行维护必须执行本规范。

**1.0.3** 无障碍设施的建设和运行维护应遵循下列基本原则：
> 1.  满足残疾人、老年人等有需求的人使用，消除他们在社会生活上的障碍；
> 2.  保证安全性和便利性，兼顾经济、绿色和美观；
> 3.  保证系统性及无障碍设施之间有效衔接；
> 4.  从设计、选型、验收、调试和运行维护等环节保障无障碍通行设施、无障碍服务设施和无障碍信息交流设施的安全、功能和性能；
> 5.  无障碍信息交流设施的建设与信息技术发展水平相适应；
> 6.  各级文物保护单位根据需要在不破坏文物的前提下进行无障碍设施建设。

> **条文说明**
>
> 本条为本规范的建设和运行维护的基本原则。
>
> 第1款 根据国务院《无障碍环境建设条例》第三条规定：“无障碍环境建设应当遵循广泛受益的原则。”对于无障碍环境有需求的人包括：行动障碍者、视觉障碍者（盲人及低视力人群）、听觉障碍者（聋人及听力困难人群）、言语障碍者和精神障碍者，以及有同样需求的老人、儿童、病患、携带童车或行李等人群。
>
> 第2款 安全性和便利性为无障碍设施的基本建设原则，同时根据《中共中央国务院关于进一步加强城市规划建设管理工作的若干意见》中确立的“适用、经济、绿色、美观”的建筑方针，本款同时响应了以上要求。无障碍设施的安全性指应避免造成使用时的人身伤害，包括：无障碍设施地面应坚固、平整、防滑、不积水；无障碍设施应避免尖角、锐利边缘等措施。
>
> 第3款 目前在无障碍设施的建设中，不系统是普遍存在的问题，影响了无障碍设施的效用。不但一个项目中设置的无障碍设施之间应保证系统性，新建的无障碍设施和与其衔接的无障碍设施之间也应保证系统性。
>
> 第4款 根据国务院《无障碍环境建设条例》，参照与国外标准的对标，本规范将无障碍设施分为无障碍通行设施、无障碍服务设施和无障碍信息交流设施。只有在建设全过程各环节进行控制才能保证无障碍设施的实效。
>
> 第5款 信息技术发展迅速，同时各地的信息技术发展水平不同，无障碍信息交流设施的建设既要做到与时俱进，也要因地制宜，才能切实地发挥作用。
>
> 第6款 根据《中华人民共和国文物保护法》第一章第九条中规定：“基本建设、旅游发展必须遵守文物保护工作的方针，其活动不得对文物造成损害。”第二章第二十六条规定：“使用不可移动文物，必须遵守不改变文物原状的原则，负责保护建筑物及其附属文物的安全，不得损毁、改建、添建或者拆除不可移动文物。”当文物保护单位无法设置固定的无障碍设施时，可设置临时性的无障碍设施，以最大限度地满足无障碍需求。

**1.0.4** 工程建设所采用的技术方法和措施是否符合本规范要求，由相关责任主体判定。其中，创新性的技术方法和措施，应进行论证并符合本规范中有关性能的要求。

> **条文说明**
>
> 工程建设强制性规范是以工程建设活动结果为导向的技术规定，突出了建设工程的规模、布局、功能、性能和关键技术措施，但是，规范中关键技术措施不能涵盖工程规划建设管理采用的全部技术方法和措施，仅仅是保障工程性能的“关键点”，很多关键技术措施具有“指令性”特点，即要求工程技术人员去“做什么”，规范要求的结果是要保障建设工程的性能，因此，能否达到规范中性能的要求，以及工程技术人员所采用的技术方法和措施是否按照规范的要求去执行，需要进行全面的判定，其中，重点是能否保证工程性能符合规范的规定。
>
> 进行这种判定的主体应为工程建设的相关责任主体，这是我国现行法律法规的要求。《中华人民共和国建筑法》《建设工程质量管理条例》《民用建筑节能条例》等以及相关的法律法规，突出强调了工程监管、建设、规划、勘察、设计、施工、监理、检测、造价、咨询等各方主体的法律责任，既规定了首要责任，也确定了主体责任。在工程建设过程中，执行强制性工程建设规范是各方主体落实责任的必要条件，是基本的、底线的条件，有义务对工程规划建设管理采用的技术方法和措施是否符合本规范规定进行判定。
>
> 同时，为了支持创新，鼓励创新成果在建设工程中应用，当拟采用的新技术在工程建设强制性规范或推荐性标准中没有相关规定时，应当对拟采用的工程技术或措施进行论证，确保建设工程达到工程建设强制性规范规定的工程性能要求，确保建设工程质量和安全，并应满足国家对建设工程环境保护、卫生健康、经济社会管理、能源资源节约与合理利用等相关基本要求。
>
> 无障碍设施的建设和运行维护的合规性判定应以本规范第1.0.3条为原则。

## 2 无障碍通行设施

### 2.1 一般规定

**2.1.1** 城市开敞空间、建筑场地、建筑内部及其之间应提供连贯的无障碍通行流线。

> **条文说明**
>
> 本条为保障无障碍通行的原则性要求。本条中的城市开敞空间包括：城市道路、公共绿地、城市广场等建筑红线以外的城市室外环境。无障碍通行流线以无障碍通行设施构成，以方便各类有需要的人群通行为主要目的。
>
> 无障碍通道、轮椅坡道、无障碍出入口、无障碍电梯、升降平台、无障碍机动车停车位、无障碍小汽（客）车上客和落客区、缘石坡道、盲道是专门性的无障碍通行设施，以服务行动障碍者为主，同时兼顾各类有需要的人群。
>
> 门、楼梯、台阶和扶手是通用性的设施，本规范对其提出了侧重于无障碍方面的要求，仍需满足其他方面要求才能保证其安全性和适用性。本规范中的“满足无障碍要求的门”可方便包括乘轮椅者在内的残疾人和老年人使用；通过采取一些措施，楼梯和台阶可方便除乘轮椅者之外的行动障碍者和视觉障碍者使用；扶手对于各类有无障碍需求的人群都很重要。
>
> 无障碍通行流线上有高差处需用轮椅坡道、缘石坡道、无障碍电梯或升降平台处理，楼梯和台阶不是能够方便所有行动障碍者通行的设施。
>
> 在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

**2.1.2** 无障碍通行流线上的标识物、垃圾桶、座椅、灯柱、隔离墩、地灯和地面布线（线槽）等设施均不应妨碍行动障碍者的独立通行。固定在无障碍通道、轮椅坡道、楼梯的墙或柱面上的物体，突出部分大于100mm且底面距地面高度小于2.00m时，其底面距地面高度不应大于600mm，且应保证有效通行净宽。

> **条文说明**
>
> 本条为安全性要求。本条中的“行动障碍者的独立通行”指的是行动障碍者借助轮椅、拐杖等辅具，不需要别人帮助的通行。标识物、垃圾桶、座椅、灯柱、隔离墩等设施的设置应保证足够的无障碍通行净宽，同时避免通行中的磕碰、刮划等危险。地灯和地面布线（线槽）等地面的凸起物会影响轮椅和童车的通行。固定在无障碍通道、轮椅坡道、楼梯的墙或柱面上的物体包括标牌、电话、灭火器等可能对视觉障碍者造成危害的物体，如果这些物体底面距地面的高度不大于600mm，视觉障碍者可以用手杖感触到这些物体。在设计时将物体放在凹进的空间里也可以避免伤害。根据近些年实际情况，本条在现行标准条文基础上进行了调整。本条及本规范其他条文中的距地面高度均指距地面完成面的高度。

**2.1.3** 无障碍通行流线在临近地形险要地段处应设置安全防护设施，必要时应同时设置安全警示线。

> **条文说明**
>
> 本条为安全性要求。一般情况下无障碍通行流线应尽量避开地形险要的地段。在有观赏游览需求的山地、水面、下沉广场等容易发生跌落、倾覆、侧翻事故的地段，应设置护栏、挡台等形式的安全防护设施，必要时同时设置可以起到提示作用的警示线。本条在现行标准条文基础上进行了调整。

**2.1.4** 无障碍通行设施的地面应坚固、平整、防滑、不积水。

> **条文说明**
>
> 本条为安全性要求，综合了现行标准条文。

### 2.2 无障碍通道

**2.2.1** 无障碍通道上有地面高差时，应设置轮椅坡道或缘石坡道。

> **条文说明**
>
> 本条为功能性和安全性要求。地面的高差是行动障碍者通行的主要障碍，解决高差问题是无障碍通道的重要功能，而轮椅坡道和缘石坡道为解决此障碍的主要无障碍设施。针对路缘石的高差设置缘石坡道，其他高差设置轮椅坡道。轮椅坡道和缘石坡道的规定见本规范第2.3节和第2.10节。本条沿用现行标准条文。

**2.2.2** 无障碍通道的通行净宽不应小于1.20m，人员密集的公共场所的通行净宽不应小于1.80m。

> **条文说明**
>
> 本条为功能性和安全性要求。满足乘轮椅者通行和疏散是无障碍通道的重要功能。
>
> 本规范中的通行净宽具体为：无障碍通道、轮椅坡道等无障碍通行设施的两侧墙面外表皮或固定障碍物之间的水平净距离；门扇开启后，开启扇内侧边缘之间或者门框内缘与开启门扇内侧边缘之间的水平净距离；当设置扶手时，扶手截面内侧之间的水平净距离。
>
> 当通道的通行净宽不小于1.20m时，一般能容纳一辆轮椅和一个人侧身通行。通道的通行净宽不小于1.80m时，一般能容纳两辆轮椅正面相对通行。本条不适用于客房和住房。居室的套内和户内走廊。
>
> 本条中的人员密集的公共场所主要指：营业厅、观众厅、礼堂、电影院、剧院和体育场馆的观众厅，公共娱乐场所中出入大厅、舞厅，候机（车、船）厅及医院的门诊大厅等面积较大、同时间聚集人数较多的场所。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**2.2.3** 无障碍通道上的门洞口应满足轮椅通行，各类检票口、结算口等应设轮椅通道，通行净宽不应小于900mm。

> **条文说明**
>
> 本条为功能性要求。满足乘轮椅者通行是无障碍通道的重要功能。当设置门洞或检票口、结算口时，应设乘轮椅者能够通行的通道，同时这也给携带大件行李、推童车、视觉障碍等人士提供了更方便安全的通行条件。本条沿用现行标准条文。

**2.2.4** 无障碍通道上有井盖、箅子时，井盖、箅子孔洞的宽度或直径不应大于13mm，条状孔洞应垂直于通行方向。

> **条文说明**
>
> 本条为安全性要求。井盖、箅子的孔洞会对轮椅的通行和盲杖的使用带来不便和安全隐患，所以应尽量避免在无障碍通道上设置有孔洞的井盖、箅子。无法避免时，限定孔洞的宽度、直径和走向，是为了防止卡住盲杖或轮椅小轮，或盲杖滑出带来危险。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**2.2.5** 自动扶梯、楼梯的下部和其他室内外低矮空间可以进入时，应在净高不大于2.00m处采取安全阻挡措施。

> **条文说明**
>
> 本条为安全性要求。当自动扶梯、楼梯的下部以及各种室内外低矮空间能够进入时，头部的障碍是盲杖无法触碰到的，容易造成磕碰，所以需采取悬挂活动警示牌、地面围挡等方式进行提示。对于设置的安全阻挡措施，需避免其自身带来伤害。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整，相关条文整合入此原则性要求。

### 2.3 轮椅坡道

**2.3.1** 轮椅坡道的坡度和坡段提升高度应符合下列规定：
> 1.  横向坡度不应大于1：50，纵向坡度不应大于1：12，当条件受限且坡段起止点的高差不大于150mm时，纵向坡度不应大于1：10；
> 2.  每段坡道的提升高度不应大于750mm。

> **条文说明**
>
> 本条为功能性和安全性要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。
>
> 第1款 为了保证轮椅使用中的安全性和适用性，依据主要在建筑室内外使用的手动和电动轮椅的性能指标确定坡度要求。因为通用设计的要求，现在国际上对于轮椅坡道的要求有坡度更缓的趋势。
>
> 第2款 每段坡道的提升高度需考虑使用者的体力情况，每提升一定的高度需要设置一个平台提供短暂休息，否则容易造成因体力不支无法操作轮椅的情况，带来安全隐患。例如在轮椅坡道坡度为1：12时，每段坡道的提升高度不应大于750mm即水平长度不应大于9m，否则应设休息平台。

**2.3.2** 轮椅坡道的通行净宽不应小于1.20m。

> **条文说明**
>
> 本条为功能性要求。轮椅坡道需考虑到不同类型轮椅的使用。根据我国的轮椅相关产品标准，最宽的轮椅为普通机动轮椅，其宽度标准为小于或等于1.2m，而经常使用的电动和手动轮椅，其宽度标准为小于或等于780mm。根据近些年实际情况和未来辅具的发展趋势，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。本条不适用于客房和住房、居室的套内和户内坡道。

**2.3.3** 轮椅坡道的起点终点和休息平台的通行净宽不应小于坡道的通行净宽，水平长度不应小于1.50m，门扇开启和物体不应占用此范围空间。

> **条文说明**
>
> 本条为功能性要求。对轮椅坡道的起点、终点和休息平台的通行净宽的要求是为了保证无障碍通行的顺畅。乘轮椅者在进入坡道之前和行驶完成后，需要一段水平行驶用来调整轮椅，平台长度不小于1.50m，可满足乘轮椅者调整方向或者短暂休息。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。本条不适用于客房和住房、居住的套内和户内坡道。

**2.3.4** 轮椅坡道的高度大于300mm且纵向坡度大于1：20时，应在两侧设置扶手，坡道与休息平台的扶手应保持连贯。

> **条文说明**
>
> 本条为安全性要求。无论什么高度，一般行动上借助扶手会更为安全。但当轮椅坡道的高度不大于300mm或坡度不大于1：20时，大部分行动障碍者可以不借助扶手通行，考虑到不同的现实情况，不提出必须设置两侧扶手的要求。在条件允许时，鼓励轮椅坡道均设置两侧扶手。本条沿用现行标准条文。

**2.3.5** 设置扶手的轮椅坡道的临空侧应采取安全阻挡措施。

> **条文说明**
>
> 本条为安全性要求，沿用现行标准条文。设置扶手的轮椅坡道的临空侧采取的安全阻挡措施，可为以下做法中的至少一种：
>
> 1.  坡道面和平台面从扶手外边缘向外扩宽300mm；
> 2.  坡道和平台边缘设置高度不小于50mm的安全挡台；
> 3.  坡道和平台设置距离坡道面和平台面不大于100mm的斜向栏杆。

### 2.4 无障碍出入口

**2.4.1** 无障碍出入口应为下列3种出入口之一：
> 1.  地面坡度不大于1：20的平坡出入口；
> 2.  同时设置台阶和轮椅坡道的出入口；
> 3.  同时设置台阶和升降平台的出入口。

> **条文说明**
>
> 本条为功能性和安全性要求，规定了无障碍出入口的类型。本条沿用现行标准条文。
>
> 第1款 平坡出入口是通行最为便捷的无障碍出入口，体现了通用设计的原则，建议在工程中，特别是大型公共建筑中优先选用。无障碍出入口地面坡度不大于1：20时，等同于坡度不大于1：20的轮椅坡道，需满足本规范第2.3节的要求。
>
> 第2款 与平坡出入口相比，坡度大于1：20的轮椅坡道的坡度比较陡，对于部分行动障碍者来说，走轮椅坡道会比上台阶更加困难，此外，雨雪等气象条件下在轮椅坡道上滑倒的风险增大，因此在出入口同时设置台阶和轮椅坡道更加合理。
>
> 第3款 同时设置台阶和升降平台的做法主要适用于建筑出入口进行无障碍改造，因为场地条件有限而无法修建轮椅坡道时，可以采用占地面积小的升降平台以取代轮椅坡道的做法。一般的新建建筑及有条件的改造工程不提倡此种做法。

**2.4.2** 除平坡出入口外，无障碍出入口的门前应设置平台；在门完全开启的状态下，平台的净深度不应小于1.50m；无障碍出入口的上方应设置雨篷。

> **条文说明**
>
> 本条为功能性和安全性要求。无障碍出入口平台的深度不仅要满足轮椅的回转和通行，还要考虑其他人通行的安全和便利；入口上方设置雨篷既能够有效防止上空坠物，也能够在雨雪天气为出入的人群提供过渡空间，避免出入口地面湿滑带来的危险。本条沿用现行标准条文。

**2.4.3** 设置出入口闸机时，至少有一台开启后的通行净宽不应小于900mm，或者在紧邻闸机处设置供乘轮椅者通行的出入口，通行净宽不应小于900mm。

> **条文说明**
>
> 本条为功能性要求。满足轮椅通行是无障碍出入口的重要功能。当出入口设置闸机时，应设轮椅能够通行的通道，同时这也给携带大件行李、推童车、视觉障碍等人士提供了更方便安全的通行条件。本条在现行标准条文基础上进行了调整。

### 2.5 门

**2.5.1** 满足无障碍要求的门应可以被清晰辨认，并应保证方便开关和安全通过。

> **条文说明**
>
> 本条为性能要求，是对门能够满足无障碍要求的综合性能要求。满足无障碍要求的门可方便包括乘轮椅者在内的残疾人和老年人的使用。在无障碍通行流线上的门，无障碍电梯、无障碍厕所等有内部使用空间的无障碍设施的门，其他有无障碍需求的房间和空间的门，均需满足无障碍要求。本条在现行标准条文基础上进行了调整。

**2.5.2** 在无障碍通道上不应使用旋转门。

**2.5.3** 满足无障碍要求的门不应设挡块和门槛，门口有高差时，高度不应大于15mm，并应以斜面过渡，斜面的纵向坡度不应大于1：10。

> **条文说明**
>
> 本条为功能性和安全性要求。挡块和门槛会给行动障碍者带来通行困难甚至安全问题，对老年人带来跌倒风险。门内外要尽量做到水平，有高差时以斜面过渡，斜面的纵向坡度过陡也会带来跌倒风险，所以本条对其也提出了要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**2.5.4** 满足无障碍要求的手动门应符合下列规定：
> 1.  新建和扩建建筑的门开启后的通行净宽不应小于900mm，既有建筑改造或改建的门开启后的通行净宽不应小于800mm；
> 2.  平开门的门扇外侧和里侧均应设置扶手，扶手应保证单手握拳操作，操作部分距地面高度应为0.85m～1.00m；
> 3.  除防火门外，门开启所需的力度不应大于25N。

> **条文说明**
>
> 本条为功能性要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。第3款是根据近些年实际情况及参照国外标准增加的要求。
>
> 第1款 根据我国轮椅的相关产品标准，经常使用的电动和手动轮椅，其宽度标准为大于或等于780mm；根据对于辅具发展的调研，轮椅种类越来越多，有些轮椅的宽度更大。对于既有建筑改造或改建的建筑，考虑到可行性，保留现行标准条文中的800mm底线要求；对于新建或扩建的建筑，根据近些年实际情况和发展趋势，参考国外标准中的相关要求，将门开启后的通行净宽调整为900mm。
>
> 第2款 门扇里侧的执手为便于人进入后将门关上使用。考虑到部分手部残障者的使用，门执手需要满足能够用单手握拳进行操作，不需要紧抓、捏、旋转等需要手和手指配合，或者是手腕灵活转动才能完成的动作。球形门执手不能满足上述要求，常规做法是选择满足上述要求的杠杆式门执手。
>
> 第3款 手动门需要一定的力量才能完成开门的动作，考虑到上肢力量差的人群，作出本款规定。关于门的启闭力试验方法执行相关的标准规范。

**2.5.5** 满足无障碍要求的自动门应符合下列规定：
> 1.  开启后的通行净宽不应小于1.00m；
> 2.  当设置手动启闭装置时，可操作部件的中心距地面高度应为0.85m～1.00m。

> **条文说明**
>
> 本条为功能性要求。自动门便于残疾人、老年人、推童车者使用，因此公共场所的门应优先考虑采用自动门系统。自动门要考虑其安全性、通行的宽度，当设置手动启闭装置时要考虑其安装高度。手动启闭装置包括按钮、刷卡、密码锁等。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**2.5.6** 全玻璃门应符合下列规定：
> 1.  应选用安全玻璃或采取防护措施，并应采取醒目的防撞提示措施；
> 2.  开启扇左右两侧为玻璃隔断时，门应与玻璃隔断在视觉上显著区分开，玻璃隔断并应采取醒目的防撞提示措施；
> 3.  防撞提示应横跨玻璃门或隔断，距地面高度应为0.85m～1.50m。

> **条文说明**
>
> 本条为安全性要求。选用安全玻璃或采取防护措施是为了防止玻璃门破碎带来的伤害。防撞提示措施包括但不限于防撞提示标志，颜色要考虑背景光线条件变化的情况，能够使人易于察觉，宽度应覆盖完整的玻璃宽度，设置在人坐姿和站姿均能方便识别的高度范围内。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**2.5.7** 连续设置多道门时，两道门之间的距离除去门扇摆动的空间后的净间距不应小于1.50m。

> **条文说明**
>
> 本条为功能性要求。连续设置多道门时，门之间的距离要考虑乘轮椅者、推童车者等开关门和通过所需的空间。本条中的门扇摆动的空间为门扇从关闭到完全开启所占用的空间。本条不适用于客房和住房、居室的套内和户内门。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**2.5.8** 满足无障碍要求的安装有闭门器的门，从闭门器最大受控角度到完全关闭前10°的闭门时间不应小于3s。

> **条文说明**
>
> 本条为功能性和安全性要求。考虑到行动障碍人群移动缓慢的特点，作出本条规定。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

**2.5.9** 满足无障碍要求的双向开启的门应在可视高度部分安装观察窗，通视部分的下沿距地面高度不应大于850mm。

> **条文说明**
>
> 本条为功能性和安全性要求。对于双向开启的门，使用者需要看到其他使用者从反方向接近，为双方留出反应的时间，避免发生碰撞。观察窗的高度应该能够满足乘轮椅者以及身高矮小者的视野要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

### 2.6 无障碍电梯和升降平台

**2.6.1** 无障碍电梯的候梯厅应符合下列规定：
> 1.  电梯门前应设直径不小于1.50m的轮椅回转空间，公共建筑的候梯厅深度不应小于1.80m；
> 2.  呼叫按钮的中心距地面高度应为0.85m～1.10m，且距内转角处侧墙距离不应小于400mm，按钮应设置盲文标志；
> 3.  呼叫按钮前应设置提示盲道；
> 4.  应设置电梯运行显示装置和抵达音响。

> **条文说明**
>
> 本条为功能性要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。
>
> 第1款 电梯是包括乘轮椅者在内的行动障碍人群使用最为频繁和方便的垂直交通设施。乘轮椅者在到达候梯厅后，要转换位置和等候，因此候梯厅的深度净尺寸为1.80m比较合适。在空间相对局促时，候梯厅的深度也不应小于1.50m，以满足直径不小于1.50m的轮椅回转空间。
>
> 第2款 呼叫按钮应设置在能让乘轮椅者及其他行动障碍者易于触碰的位置。当呼叫按钮一侧有垂直墙面时，设置的位置需要距离墙面有一定的距离，以方便乘轮椅者进行操作。盲文标志不宜设置在按钮上，以避免误按。盲文应符合国家语言文字工作委员会、中国残疾人联合会发布的《国家通用盲文方案》的有关规定。
>
> 第3款 在呼叫按钮前设置提示盲道可以辅助视觉障碍者分辨呼叫按钮所在位置，方便其呼叫电梯。提示盲道尽量避开进出电梯的主要通路以保证乘轮椅者和老年人的通行顺畅。
>
> 第4款 为方便听觉障碍者辨别电梯停靠楼层和运行信息，设置显示装置对其进行提示；为方便视觉障碍者辨别电梯停靠楼层，设置抵达音响对其进行提示。

**2.6.2** 无障碍电梯的轿厢的规格应依据建筑类型和使用要求选用。满足乘轮椅者使用的最小轿厢规格，深度不应小于1.40m，宽度不应小于1.10m。同时满足乘轮椅者使用和容纳担架的轿厢，如采用宽轿厢，深度不应小于1.50m，宽度不应小于1.60m；如采用深轿厢，深度不应小于2.10m，宽度不应小于1.10m。轿厢内部设施应满足无障碍要求。

> **条文说明**
>
> 本条为功能性要求。在使用电梯时，乘轮椅者需要相对更大的空间。因此，无障碍电梯轿厢的尺寸应满足包括乘轮椅者在内人士的使用便利和安全。深度为1.40m、宽度为1.10m的小型梯，轮椅进入电梯后不能回转，只能正面进入倒退而出，或倒退进入正面而出，所以这个尺寸为底线性要求，在条件受限的情况下满足乘轮椅者的基本使用条件，具体项目应综合考虑急救和无障碍需求确定适合的轿厢尺寸。轿厢内部设施包括装置设备、内表面材料、扶手等应满足相关标准的无障碍要求。根据近些年实际情况，参考国内、外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**2.6.3** 无障碍电梯的电梯门应符合下列规定：
> 1.  应为水平滑动式门；
> 2.  新建和扩建建筑的电梯门开启后的通行净宽不应小于900mm，既有建筑改造或改建的电梯门开启后的通行净宽不应小于800mm；
> 3.  完全开启时间应保持不小于3s。

> **条文说明**
>
> 本条为功能性要求。本条中的电梯门包括楼层门和轿厢门。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**2.6.4** 公共建筑内设有电梯时，至少应设置1部无障碍电梯。

> **条文说明**
>
> 本条为功能性要求。考虑到公共建筑使用者的公共性，设置本条，并不意味着其他类型的建筑允许不设置无障碍电梯，其他类型建筑应满足相关标准的对于无障碍电梯设施的要求。本条沿用现行标准条文。

**2.6.5** 升降平台应符合下列规定：
> 1.  深度不应小于1.20m，宽度不应小于900mm，应设扶手、安全挡板和呼叫控制按钮，呼叫控制按钮的高度应符合本规范第2.6.1条的有关规定；
> 2.  应采用防止误入的安全防护措施；
> 3.  传送装置应设置可靠的安全防护装置。

> **条文说明**
>
> 本条为功能性和安全性要求。升降平台包括垂直升降平台和斜向升降平台，垂直升降平台在改造工程中因场地限制而应用较多。升降平台的下部、传送装置等易造成伤害的部位应采取围挡等形式的安全防护措施。第1款在现行标准条文基础上进行了调整，第2款、第3款涉及人身安全，沿用现行标准条文。

### 2.7 楼梯和台阶

**2.7.1** 视觉障碍者主要使用的楼梯和台阶应符合下列规定：
> 1.  距踏步起点和终点250mm～300mm处应设置提示盲道，提示盲道的长度应与梯段的宽度相对应；
> 2.  上行和下行的第一阶踏步应在颜色或材质上与平台有明显区别；
> 3.  不应采用无踢面和直角形突缘的踏步；
> 4.  踏步防滑条、警示条等附着物均不应突出踏面。

> **条文说明**
>
> 本条为安全性要求。视觉障碍者主要使用的楼梯和台阶一般位于老年人建筑、医疗建筑、康复建筑等视觉障碍者较多使用的建筑，以及肓人公园、盲人沙滩等服务于较多视觉障碍者的室外空间。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。本条第1款和第2款的规定是为了提示视觉障碍者所在位置接近有高差变化处。提示盲道的长度应与梯段的宽度相对应指的是以整块提示盲道砖连接覆盖梯段宽度，如梯段宽度为1.20m，提示盲道砖的宽度为250mm时，铺设4块盲道砖，提示盲道与梯段两侧边缘间距100mm。
>
> 第3款 无踢面楼梯易造成跌绊危险。踏步的前缘如有突出部分，应设计成圆弧形，不应设计成直角形，以防将拐杖头绊落和对鞋面刮碰。
>
> 第4款 踏步防滑条、警示条等附着物突出踏面易造成跌绊危险。本款要求不包括带防滑、警示功能的成品踏步砖的表面凸起。

**2.7.2** 行动障碍者和视觉障碍者主要使用的三级及三级以上的台阶和楼梯应在两侧设置扶手。

> **条文说明**
>
> 本条为安全性要求。行动障碍者和视觉障碍者主要使用的楼梯和台阶一般位于老年人建筑、医疗建筑、康复建筑等行动障碍者和视觉障碍者较多使用的建筑，以及残障人、老年人经常使用的室外空间。本条沿用现行标准条文。

### 2.8 扶 手

**2.8.1** 满足无障碍要求的单层扶手的高度应为850mm～900mm；设置双层扶手时，上层扶手高度应为850mm～900mm，下层扶手高度应为650mm～700mm。

> **条文说明**
>
> 本条为功能性要求。本条规定的扶手高度为踏步前缘垂直向上到扶手中心线的高度。本条沿用现行标准条文。

**2.8.2** 行动障碍者和视觉障碍者主要使用的楼梯、台阶和轮椅坡道的扶手应在全长范围内保持连贯。

> **条文说明**
>
> 本条为功能性和安全性要求。扶手的不连贯不但会带来使用的不便，而且可能造成使用扶手者突然失去支撑的安全隐患。行动障碍者和视觉障碍者主要使用的楼梯、台阶和轮椅坡道一般位于老年人建筑、医疗建筑、康复建筑等行动障碍者和视觉障碍者较多使用的建筑，以及残障人、老年人经常使用的室外空间。楼梯、台阶的全长范围指梯段和休息平台，轮椅坡道的全长范围指坡段和休息平台。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

**2.8.3** 行动障碍者和视觉障碍者主要使用的楼梯和台阶、轮椅坡道的扶手起点和终点处应水平延伸，延伸长度不应小于300mm；扶手末端应向墙面或向下延伸，延伸长度不应小于100mm。

> **条文说明**
>
> 本条为功能性和安全性要求。楼梯和台阶的扶手延伸长度的计算为：从第一级/最后一级踏步前缘开始算起。为了避免人们在使用扶手后突然感觉手臂滑下扶手而产生不安，将扶手的末端加以处理，以利于身体稳定。同时也是为了利于包括乘轮椅者在内的行动障碍者在刚开始借助扶手做上下楼梯、坡道等行动时的抓握或借力。本条沿用现行标准条文。

**2.8.4** 扶手应固定且安装牢固，形状和截面尺寸应易于抓握，截面的内侧边缘与墙面的净距离不应小于40mm。

> **条文说明**
>
> 本条为功能性和安全性要求。要求扶手固定是为了防止可转动等形式的非固定扶手在使用时带来的安全隐患。老年人、病弱者等人士经常将全身依靠扶手，所以扶手的安装必须足够牢固。一般情况下圆形扶手的直径或矩形扶手的截面宽度为30mm～50mm易于抓握。当扶手安装在墙上时，扶手的内侧与墙之间要有一定的距离，给手的抓握提供适当的空间。因关系到各类人群的安全和使用便利，扶手均应满足本条要求。根据近些年实际情况，参考国外标准中的相关要求，本条沿用现行标准条文。

**2.8.5** 扶手应与背景有明显的颜色或亮度对比。

> **条文说明**
>
> 本条为功能性要求，为了便于视觉障碍者辨认扶手的位置，扶手应与安装固定的背景墙面形成视觉的反差。因关系到各类人群的使用便利，扶手均应满足本条要求。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

### 2.9 无障碍机动车停车位和上/落客区

**2.9.1** 应将通行方便、路线短的停车位设为无障碍机动车停车位。

> **条文说明**
>
> 本条为功能性要求，为无障碍机动车停车位设置位置的指导原则。地面停车场中，应将距离建筑的无障碍出入口路线短、临近无障碍通道、通行方便的停车位设为无障碍机动车停车位。地上停车楼和地下停车库中，应将距离无障碍电梯路线短且通行方便的停车位设为无障碍机动车停车位。本条沿用现行标准条文。

**2.9.2** 无障碍机动车停车位一侧，应设宽度不小于1.20m的轮椅通道。轮椅通道与其所服务的停车位不应有高差，和人行通道有高差处应设置缘石坡道，且应与无障碍通道衔接。

> **条文说明**
>
> 本条为功能性要求。停车位一侧设置一定宽度的轮椅通道，是为了方便乘轮椅者由车辆转乘至轮椅。相邻的两个无障碍机动车停车位可共用一个轮椅通道。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**2.9.3** 无障碍机动车停车位的地面坡度不应大于1：50。

> **条文说明**
>
> 本条为功能性和安全性要求。对无障碍机动车停车位地面坡度的控制，目的在于当乘轮椅者从车辆转乘至轮椅时，轮椅能够稳定停放。本条沿用现行标准条文。

**2.9.4** 无障碍机动车停车位的地面应设置停车线、轮椅通道线和无障碍标志，并应设置引导标识。

> **条文说明**
>
> 本条为功能性要求。本条的目的是为引导使用者顺利找到无障碍机动车停车位。无障碍机动车停车位标志一般设在无障碍机动车停车位的地面停车线范围内。设置轮椅通道线是为了避免占用。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**2.9.5** 总停车数在100辆以下时应至少设置1个无障碍机动车停车位，100辆以上时应设置不少于总停车数1％的无障碍机动车停车位；城市广场、公共绿地、城市道路等场所的停车位应设置不少于总停车数2％的无障碍机动车停车位。

> **条文说明**
>
> 本条为关于无障碍机动车停车位基本配置数量的底线要求。计算采取进位原则，如240辆总停车数时，如按照1％的设置要求，应设置3个无障碍机动车停车位。本条参考现行标准相关条文的最低标准，为底线性要求。具体项目应根据需求确定合理的配置数量。

**2.9.6** 无障碍小汽（客）车上客和落客区的尺寸不应小于2.40m×7.00m，和人行通道有高差处应设置缘石坡道，且应与无障碍通道衔接。

> **条文说明**
>
> 本条为功能性要求。在交通客运场站、医院及其他客流集中的公共场所以及无障碍需求比较集中的设施的上客和落客区内设置无障碍小汽（客）车上客和落客区，便于乘轮椅者使用。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

### 2.10 缘石坡道

**2.10.1** 各种路口、出入口和人行横道处，有高差时应设置缘石坡道。

> **条文说明**
>
> 本条为功能性要求。高差为行动障碍者的主要障碍，解决高差问题为无障碍通行的重要功能。在各种路口、出入口和人行横道处，存在由于立缘石的设置产生高差的地方，而设置缘石坡道为解决此障碍的主要无障碍设施。本条沿用现行标准条文。

**2.10.2** 缘石坡道的坡口与车行道之间应无高差。

> **条文说明**
>
> 本条为功能性和安全性要求。缘石坡道的坡口与车行道之间做到无高差，便于行动障碍者、推童车者、携带行李者等人士的安全通行。本条规定的“无高差”首先指的是应设计为无高差，在施工时也应在满足相应施工验收标准的基础上尽量避免高差。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**2.10.3** 缘石坡道距坡道下口路缘石250mm～300mm处应设置提示盲道，提示盲道的长度应与缘石坡道的宽度相对应。

> **条文说明**
>
> 本条为功能性和安全性要求。在缘石坡道的坡道下口附近设置提示盲道时，提示盲道是设置在缘石坡道上，而不是设置在车行道上（图1）。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照我国香港、澳门地区标准以及国外标准增加了要求。
>
> 提示肓道的长度应与缘石坡道的宽度相对应指的是以整块提示盲道砖连接覆盖缘石坡道通长宽度，如图1所示，二面坡缘石坡道正面坡道宽度为1.2m，提示盲道砖的宽度为250mm时，铺设4块盲道砖，提示盲道与坡道两侧边缘间距100mm。

**2.10.4** 缘石坡道的坡度应符合下列规定：
> 1.  全宽式单面坡缘石坡道的坡度不应大于1：20；
> 2.  其他形式缘石坡道的正面和侧面的坡度不应大于1：12。

> **条文说明**
>
> 本条为功能性和安全性要求。缘石坡道的坡度需要满足一定条件，以避免坡道设置过陡造成使用时的安全隐患。由于全宽式单面坡缘石坡道的设置受人行道宽度的影响较小，因此规定全宽式单面坡缘石坡道的坡度不应大于1：20。本条沿用现行标准条文。

**2.10.5** 缘石坡道的宽度应符合下列规定：
> 1.  全宽式单面坡缘石坡道的坡道宽度应与人行道宽度相同；
> 2.  三面坡缘石坡道的正面坡道宽度不应小于1.20m；
> 3.  其他形式的缘石坡道的坡口宽度均不应小于1.50m。

> **条文说明**
>
> 本条为功能性要求。缘石坡道的宽度需要满足一定条件，以保证乘轮椅者和行人的通行。本条沿用现行标准条文。

**2.10.6** 缘石坡道顶端处应留有过渡空间，过渡空间的宽度不应小于900mm。

> **条文说明**
>
> 本条为功能性要求。缘石坡道顶端处需要留有一定的空间（图1），保证包括乘轮椅者在内的行人的滞留及安全通过。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照我国香港、澳门和国外标准增加了要求。

**2.10.7** 缘石坡道上下坡处不应设置雨水箅子。设置阻车桩时，阻车桩的净间距不应小于900mm。

> **条文说明**
>
> 本条为功能性要求。缘石坡道的设置需要考虑与其他设施的组配问题，如雨水箅子、阻车桩等，避免造成使用者的通行不便或障碍。这个问题在我国城市中比较普遍，造成了比较多的安全问题。根据近些年实际情况，本条在现行标准条文基础上进行了调整。

### 2.11 盲 道

**2.11.1** 盲道的铺设应保证视觉障碍者安全行走和辨别方向。

> **条文说明**
>
> 本条为功能性和安全性要求。为方便视觉障碍者的安全通行，人行道或其他场所的地面常采用铺设盲道的形式，使视觉障碍者通过盲杖触觉及脚感等方式，实现向前行走及辨别方向的目的。我国近些年的无障碍建设比较重视盲道的铺设，但是也产生了很多铺设不合理的情况。本条为关于盲道铺设的原则性要求。在我国现行标准中没有明确此要求，本条根据近些年实际情况增加了要求。

**2.11.2** 盲道铺设应避开障碍物，任何设施不得占用盲道。

> **条文说明**
>
> 本条为功能性和安全性要求。盲道不仅要达到引导及提示视觉障碍者通行的作用，更要起到保护视觉障碍者通行安全的目的，因此盲道在人行道的设置位置要避开树木（穴）、电线杆、拉线、变电箱等地面及地上部分的障碍物。盲道上也不得设置垃圾桶、消火栓等设施，非机动车的停放位置应避开盲道。本条沿用现行标准条文。

**2.11.3** 需要安全警示和提示处应设置提示肓道，其长度应与需安全警示和提示的范围相对应。行进盲道的起点、终点、转弯处，应设置提示盲道，其宽度不应小于300mm，且不应小于行进盲道的宽度。

> **条文说明**
>
> 本条为功能性和安全性要求。提示盲道具有警示危险和提示变化的作用，对于视觉障碍者的安全出行非常重要。需要安全警示和提示处包括需提示的门、视觉障碍者主要使用的楼梯和台阶的起止处、站台边缘及其他可能发生人身伤害或者需要提示定位的位置。“其长度应与需安全警示和提示的范围相对应”的含义参考本规范第2.10.3条条文说明。为了便于视觉障碍者能够辨识，提示盲道的宽度要满足一定的要求。本条在现行标准条文基础上进行了调整。

**2.11.4** 盲道应与相邻人行道铺面的颜色或材质形成差异。

> **条文说明**
>
> 本条为功能性和安全性要求。由于部分视觉障碍者能够辨别光线及色觉的反差，因此盲道的颜色或材质要与相邻人行道的铺面形成差异，便于视觉障碍者的发现及使用。盲道的颜色一般情况下采用中黄色。本条在现行标准条文基础上进行了调整。

## 3 无障碍服务设施

### 3.1 一般规定

**3.1.1** 通往无障碍服务设施的通道应为无障碍通道。

> **条文说明**
>
> 本条为功能性要求。通向无障碍服务设施的通道应符合本规范第2.2节无障碍通道的要求。本条为关于无障碍服务设施的原则性要求，在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

**3.1.2** 具有内部使用空间的无障碍服务设施的入口和室内空间应方便乘轮椅者进入和使用，内部应设轮椅回转空间，轮椅需要通行的区域通行净宽不应小于900mm。

> **条文说明**
>
> 本条为功能性要求。考虑到有些情况下保证直径1.50m的轮椅回转空间比较困难，所以本条要求至少提供能以各种形式满足乘轮椅者进行轮椅回转的空间，不但包括适合轮椅回转的平面布置，也包括利用家具、洁具下部的空间等方式。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**3.1.3** 具有内部使用空间的无障碍服务设施的门在紧急情况下应能从外面打开。

> **条文说明**
>
> 本条为安全性要求，保证使用者在使用无障碍服务设施发生意外时的救助。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**3.1.4** 具有内部使用空间的无障碍服务设施应设置易于识别和使用的救助呼叫装置。

> **条文说明**
>
> 本条为安全性要求。为避免使用者在使用无障碍服务设施发生意外时无法向外部求助，应设置救助呼叫装置以为使用者能够在紧急状况下向外发送求助信号提供条件。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**3.1.5** 无障碍服务设施的地面应坚固、平整、防滑、不积水。

> **条文说明**
>
> 本条为安全性要求，沿用现行标准条文。

**3.1.6** 无障碍服务设施内供使用者操控的照明、设备、设施的开关和调控面板应易于识别，距地面高度应为0.85m～1.10m。

> **条文说明**
>
> 本条为功能性要求。无障碍厕所、无障碍客房和无障碍住房、居室等无障碍设施的内部，墙面上布置的控制照明、空调等设备设施的开关和调控面板，在选择产品时应优先选择通用设计的产品，安装高度应考虑乘轮椅者及身材矮小者的使用需要。本条在现行标准条文基础上进行了调整。

**3.1.7** 无障碍服务设施内安装的部件应符合下列规定：
> 1.  应安装牢固；
> 2.  安全抓杆直径应为30mm～40mm，内侧与墙面的净距离不应小于40mm；
> 3.  低位挂衣钩、低位毛巾架、低位搁物架距地面高度不应大于1.20m。

> **条文说明**
>
> 本条为功能性和安全性要求。无障碍服务设施内安装的部件包括安全抓杆、多功能台、固定座位、低位置物部件等。根据近些年实际情况，参考国外标准中的相关要求，在现行标准条文基础上进行了调整。
>
> 第1款 无障碍服务设施内安装的部件大多用来支撑身体，安装不牢固易引起人身伤害。实际使用中折翻式安全抓杆、多功能台和固定座位的安全问题更严重，应考虑折翻的功能对于牢固性的影响。
>
> 第2款 安全抓杆设在坐便器、低位小便器、洗手盆、淋浴间、浴盆等的周围或内部，是行动障碍者保持身体平衡和进行移动不可缺少的安全保护措施。其形式有很多种，一般有水平、直立、L形等形式，以及固定、旋转、吊环等方式。
>
> 第3款 为满足乘轮椅者及身材矮小者的使用需要制定。

**3.1.8** 无障碍坐便器应符合下列规定：
> 1.  无障碍坐便器两侧应设置安全抓杆，轮椅接近坐便器一侧应设置可垂直或水平90°旋转的水平抓杆，另一侧应设置L形抓杆；
> 2.  轮椅接近无障碍坐便器一侧设置的可垂直或水平90°旋转的水平安全抓杆距坐便器的上沿高度应为250mm～350mm，长度不应小于700mm；
> 3.  无障碍坐便器另一侧设置的L形安全抓杆，其水平部分距坐便器的上沿高度应为250mm～350mm，水平部分长度不应小于700mm；其竖向部分应设置在坐便器前端150mm～250mm，竖向部分顶部距地面高度应为1.40m～1.60m；
> 4.  坐便器水箱控制装置应位于易于触及的位置，应可自动操作或单手操作；
> 5.  取纸器应设在坐便器的侧前方；
> 6.  在坐便器附近应设置救助呼叫装置，并应满足坐在坐便器上和跌倒在地面的人均能够使用。

> **条文说明**
>
> 本条为功能性和安全性要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。有长期使用者的居住建筑的户内或套内卫生间的坐便器可不执行本条要求，根据使用者情况进行具体处理。
>
> 第1款～第3款 这3款为坐便器两侧设置安全抓杆的要求。在坐便器的两侧安装安全抓杆 （图2～图4），供乘轮椅者从轮椅上转移到坐便器上以及拄拐杖者和下肢虚弱者在起立时使用。水平安全抓杆可做水平旋转90°或垂直旋转90°，在使用前将抓杆转到贴近墙面上，不占空间，待轮椅靠近坐便器后再将抓杆转过来，协助乘轮椅者从轮椅上转换到坐便器上。L形抓杆竖向部分一般与地面垂直，也可根据使用要求设置成非垂直的角度，位置在坐便器前端，便于使用者借助其拉起身体。
>
> 第5款 主要是考虑到弯腰、转身不方便的人士的使用。
>
> 第6款 如厕时更容易产生跌倒危险，所以在本规范第3.1.4条关于救助呼叫装置的原则性要求的基础上，本款强调了应在坐便器附近设置救助呼叫装置。可通过安装不同高度的救助呼叫按钮，或设置救助呼叫拉绳，满足坐在坐便器上和跌倒在地面的人均能够使用救助呼叫装置。

**3.1.9** 无障碍小便器应符合下列规定：
> 1.  小便器下口距地面高度不应大于400mm；
> 2.  应在小便器两侧设置长度为550mm的水平安全抓杆，距地面高度应为900mm；应在小便器上部设置支撑安全抓杆，距地面高度应为1.20m。

> **条文说明**
>
> 本条为功能性和安全性要求。本条沿用现行标准条文。
>
> 第1款 无障碍小便器设为低位小便器，方便乘轮椅者、身材矮小者等人群的使用，尤其落地式小便池为包括身材矮小者在内的各种体形的使用者提供更高的便利性。
>
> 第2款 无障碍小便器的两侧和上部设置安全抓杆（图5～图7），水平安全抓杆主要用于辅助抓扶撑起的动作；支撑安全抓杆主要供使用者将胸部靠住，使重心更为稳定，支撑安全抓杆距小便器后墙面的距离需根据小便器尺寸合理设置，宜与小便器下口前缘距墙距离一致，一般为250mm左右。

**3.1.10** 无障碍洗手盆应符合下列规定：
> 1.  台面距地面高度不应大于800mm，水嘴中心距侧墙不应小于550mm，其下部应留出不小于宽750mm、高650mm、距地面高度250mm范围内进深不小于450mm、其他部分进深不小于250mm的容膝容脚空间；
> 2.  应在洗手盆上方安装镜子，镜子反光面的底端距地面的高度不应大于1.00m；
> 3.  出水龙头应采用杠杆式水龙头或感应式自动出水方式。

> **条文说明**
>
> 本条为功能性要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。有长期使用者的居住建筑的户内或套内卫生间的洗手盆可不执行本条要求，根据使用者情况进行具体处理。
>
> 第1款 考虑到乘轮椅者在保持坐姿时可以触摸到的高度和最远点，台面的设置不应过高；考虑乘轮椅者需要占用较大的宽度，水嘴中心不应距侧墙过近；台面下设置可供乘轮椅者容膝容脚的空间，以保证乘轮椅者能够在坐姿时洗手和用水。容膝容脚空间的尺寸参见本规范第3.6.4条条文说明的图10。
>
> 第2款 乘轮椅者在使用面盆后，一般需倒退移动以远离面盆，设置镜子可协助乘轮椅者观察其背后的情况，避免在倒退时撞到他人。镜子的安装高度应能够同时满足站立和坐姿的人使用。
>
> 第3款 考虑到部分肢体不便者手部力量有限，杠杆式或感应式水龙头更便于其使用。

**3.1.11** 无障碍淋浴间应符合下列规定：
> 1.  内部空间应方便乘轮椅者进出和使用；
> 2.  淋浴间前应设便于乘轮椅者通行和转动的净空间；
> 3.  淋浴间坐台应安装牢固，高度应为400mm～450mm，深度应为400mm～500mm，宽度应为500mm～550mm；
> 4.  应设置L形安全抓杆，其水平部分距地面高度应为700mm～750mm，长度不应小于700mm，其垂直部分应设置在淋浴间坐台前端，顶部距地面高度应为1.40m～1.60m；
> 5.  控制淋浴的开关距地面高度不应大于1.00m；应设置一个手持的喷头，其支架高度距地面高度不应大于1.20m，淋浴软管长度不应小于1.50m。

> **条文说明**
>
> 本条为功能性和安全性要求。本条为对于无障碍淋浴间的基本要求。无障碍淋浴间有单独设置的，也有纳入卫生间（厕所）设置的，均应满足本条的要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。有长期使用者的居住建筑的户内或套内卫生间的淋浴间可不执行本条要求，根据使用者情况进行具体处理。
>
> 第1款 平面设计应根据淋浴设施的布局，考虑乘轮椅者进出和使用所需要的空间。
>
> 第2款 淋浴间前的净空间不但方便乘轮椅者的通行和使用，也便于照护人员协助不便者完成更衣等动作。
>
> 第3款 本款要求固定的浴间坐台的安装需牢固，可为折叠式。为了保证安全，一般情况下不宜使用移动座位。
>
> 第4款 本款中L形抓杆竖向部分一般应与地面垂直，以保证在湿滑环境里的使用安全。L形抓杆的垂直部分宜设置在浴间坐台前端200mm～300mm。
>
> 第5款 淋浴间中所安装的手持式淋浴喷头可方便乘轮椅者使用，根据具体情况确定是否设置固定式淋浴喷头。
>
> 无障碍淋浴间如图8、图9所示布置，使用较为合理。为避免喷头的立管影响安全抓杆的使用，可采用入墙式固定喷头的设置，或将安全抓杆适当远离其固定的墙面安装。也可设置可灵活调节高度的喷头，需可调节至不大于1.20m的高度。当将安全抓杆的竖杆用做手持喷头的支架时，需考虑竖杆的位置便于坐在浴间坐台上取放喷头。

**3.1.12** 无障碍盆浴间应符合下列规定：
> 1.  浴盆侧面应设不小于1500mm×800mm的净空间，和浴盆平行的一边的长度不应小于1.50m；
> 2.  浴盆距地面高度不应大于450mm；在浴盆一端设置方便进入和使用的坐台；
> 3.  应沿浴盆长边和洗浴坐台旁设置安全抓杆。

> **条文说明**
>
> 本条为功能性和安全性要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。有长期使用者的居住建筑的户内或套内卫生间的盆浴空间可不执行本条要求，根据使用者情况进行具体处理。
>
> 第1款 浴盆侧面的净空间不但方便乘轮椅者的通行和使用，也便于照护人员协助不便者完成更衣等动作。
>
> 第2款 浴盆高度考虑到满足乘轮椅者从轮椅上平滑地移动到浴盆中。
>
> 第3款 为防止在使用浴盆时发生滑倒设置安全抓杆，安全抓杆形式根据具体的情况合理确定。

**3.1.13** 无障碍厨房应符合下列规定：
> 1.  厨房设施和电器应方便乘轮椅者靠近和使用；
> 2.  操作台面距地面高度应为700mm～850mm，其下部应留出不小于宽750mm、高650mm、距地面高度250mm范围内进深不小于450mm、其他部分进深不小于250mm的容膝容脚空间；
> 3.  水槽应与工作台底部的操作空间隔开。

> **条文说明**
>
> 本条为功能性和安全性要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。有长期使用者的居住建筑的户内或套内厨房可不执行本条要求，根据使用者情况进行具体处理。
>
> 第1款 一般家庭内厨房的空间尺寸无法满足乘轮椅者的使用需要，在布置无障碍厨房时需要考虑乘轮椅者的通行、回转和使用高度。
>
> 第2款 无障碍厨房操作台面高度考虑到乘轮椅者的使用需要，根据具体使用要求确定合理数值。其下部设置容膝容脚空间，尺寸参见本规范第3.6.4条条文说明的图10，以保证乘轮椅者使用。
>
> 第3款 家庭的厨房中多安装不锈钢的水槽，一些乘轮椅者下肢没有知觉，为避免水槽中的热水造成烫伤，要求水槽与工作台底部的操作空间隔开。

### 3.2 公共卫生间（厕所）和无障碍厕所

**3.2.1** 满足无障碍要求的公共卫生间（厕所）应符合下列规定：
> 1.  女卫生间（厕所）应设置无障碍厕位和无障碍洗手盆，男卫生间（厕所）应设置无障碍厕位、无障碍小便器和无障碍洗手盆；
> 2.  内部应留有直径不小于1.50m的轮椅回转空间。

> **条文说明**
>
> 本条为功能性要求。本条中的公共卫生间（厕所）指男、女分设的供公众使用的卫生间（厕所）。本条沿用现行标准条文。无障碍厕位应符合本规范第3.2.2条的规定，无障碍小便器应符合本规范第3.1.9条的规定，无障碍洗手盆应符合本规范第3.1.10条的规定。

**3.2.2** 无障碍厕位应符合下列规定：
> 1.  应方便乘轮椅者到达和进出，尺寸不应小于1.80m×1.50m；
> 2.  如采用向内开启的平开门，应在开启后厕位内留有直径不小于1.50m的轮椅回转空间，并应采用门外可紧急开启的门闩；
> 3.  应设置无障碍坐便器。

> **条文说明**
>
> 本条为功能性和安全性要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。
>
> 第1款1.80m×1.50m的尺寸可提供乘轮椅者进入后调整角度和回转的空间，轮椅可在坐便器侧面靠近后平移就位。此尺寸要求不只限于面积要求，也要求了单边尺寸的最小值，例如2.00m×1.35m虽然和1.80m×1.50m面积一致，但也不满足本款要求。
>
> 第2款 无障碍厕位的门鼓励采用推拉门。如采用平开门，一般情况下应向外开启，便于紧急情况施救，如向内开启则内部应留有足够的净空间，并且门闩在门外可开启，以便于发生紧急情况时进入救助。
>
> 第3款 无障碍坐便器应符合本规范第3.1.8条的规定。

**3.2.3** 无障碍厕所应符合下列规定：
> 1.  位置应靠近公共卫生间（厕所），面积不应小于4.00m²，内部应留有直径不小于1.50m的轮椅回转空间；
> 2.  内部应设置无障碍坐便器、无障碍洗手盆、多功能台、低位挂衣钩和救助呼叫装置；
> 3.  应设置水平滑动式门或向外开启的平开门。

> **条文说明**
>
> 本条为功能性和安全性要求。本条中的无障碍厕所是指无性别区分、男女均可使用的小型无障碍厕所，因为可以在家属的陪同下进入，可方便各类人群的使用。本条中的无障碍厕所不包括无障碍客房及无障碍住房、居室内的无障碍卫生间。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。
>
> 第1款 无障碍厕所因内部设施较多，面积要大于无障碍厕位。
>
> 第2款 内部设施的设置考虑到不同使用者的主要需求。无障碍坐便器应符合本规范第3.1.8条的规定，无障碍洗手盆应符合本规范第3.1.10条的规定。
>
> 第3款使用者跌倒时有可能阻碍门向内打开从而影响救助，所以无障碍厕所不允许采用内开门。

**3.2.4** 公共建筑中的男、女公共卫生间（厕所），每层应至少分别设置1个满足无障碍要求的公共卫生间（厕所），或在男、女公共卫生间（厕所）附近至少设置1个独立的无障碍厕所。

> **条文说明**
>
> 本条为功能性要求，是公共建筑内配置无障碍卫生设施数量的底线性要求。在我国现行标准中没有明确此要求，对标发现国外标准大多有此要求，本条根据近些年实际情况及参照国外标准增加了要求。具体项目应根据需求确定合理的配置数量。

### 3.3 公共浴室和更衣室

**3.3.1** 满足无障碍要求的公共浴室应符合下列规定：
> 1.  应设置至少1个无障碍淋浴间或盆浴间和1个无障碍洗手盆；
> 2.  无障碍淋浴间的短边宽度不应小于1.50m，淋浴间前应设一块不小于1500mm×800mm的净空间，和淋浴间入口平行的一边的长度不应小于1.50m；
> 3.  淋浴间入口应采用活动门帘。

> **条文说明**
>
> 本条为功能性和安全性要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。
>
> 第1款 公共浴室的浴间有淋浴和盆浴两种，均应保证各自有一个无障碍浴间。无障碍淋浴间应符合本规范第3.1.11条的规定，无障碍盆浴间应符合本规范第3.1.12条的规定，无障碍洗手盆应符合本规范第3.1.10条的规定。
>
> 第2款 本款为对于公共浴室中单独的无障碍淋浴间的要求，不包括淋浴纳入无障碍卫生间（厕所）的情况。淋浴纳入无障碍卫生间（厕所）的情况参照本规范第3.4.4条的规定。
>
> 第3款 浴间的入口采用活动门帘既可以节省浴间面积，而且在紧急情况时便于进行救助。

**3.3.2** 无障碍更衣室应符合下列规定：
> 1.  乘轮椅者使用的储物柜前应设直径不小于1.50m的轮椅回转空间；
> 2.  乘轮椅者使用的座椅的高度应为400mm～450mm。

> **条文说明**
>
> 本条为功能性要求。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

### 3.4 无障碍客房和无障碍住房、居室

**3.4.1** 无障碍客房和无障碍住房、居室应设于底层或无障碍电梯可达的楼层，应设在便于到达、疏散和进出的位置，并应与无障碍通道连接。

> **条文说明**
>
> 本条为功能性要求。本条及本节其他各条为一般通用意义上的无障碍客房或无障碍住房、居室的要求。当项目建设要求提供一定比例的无障碍客房或无障碍住房、居室时，所提供的客房或住房、居室应满足本节各条要求。进行局部无障碍改造的客房或住房、居室不属于一般通用意义上的无障碍客房或无障碍住房、居室，可根据功能要求或长期使用者的要求具体处理。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**3.4.2** 人员活动空间应保证轮椅进出，内部应设轮椅回转空间。

> **条文说明**
>
> 本条为功能性要求。人员活动空间指的是人需要进入的厅、通道和房间，包括起居室（厅）、卧室、卫生间、厨房、阳台、走廊等。考虑到房间内保证直径1.50m的轮椅回转空间比较困难，所以本条要求提供能以各种形式满足乘轮椅者进行轮椅回转的空间，不但包括适合轮椅回转的平面布置，也包括利用家具、洁具等下部的空间。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**3.4.3** 主要人员活动空间应设置救助呼叫装置。

> **条文说明**
>
> 本条为安全性要求。本条为保障使用者在遇到紧急情况时能够得到及时救助。主要人员活动空间指的是人员会比较长时间停留的空间，包括起居室（厅）、卧室、卫生间、厨房等。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**3.4.4** 无障碍客房和无障碍住房、居室内应设置无障碍卫生间，并符合下列规定：
> 1.  应保证轮椅进出，内部应设轮椅回转空间；
> 2.  内部应设置无障碍坐便器、无障碍洗手盆、无障碍淋浴间或盆浴间、低位挂衣钩、低位毛巾架、低位搁物架和救助呼叫装置；
> 3.  应设置水平滑动式门或向外开启的平开门。

> **条文说明**
>
> 本条为功能性和安全性要求。无障碍客房和无障碍住房、居室内的无障碍卫生间，内部设施的设置考虑到不同使用者的主要需求。无障碍坐便器应符合本规范第3.1.8条的规定，无障碍洗手盆应符合本规范第3.1.10条的规定。不同于本规范第3.2.3条的无障碍厕所，无障碍客房和无障碍住房、居室内的无障碍卫生间往往将淋浴或盆浴纳入其内，其无障碍淋浴或盆浴区域应满足本规范第3.1.11条或第3.1.12条的规定。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**3.4.5** 无障碍客房和无障碍住房设置厨房时应为无障碍厨房。

> **条文说明**
>
> 本条为功能性要求。无障碍厨房应符合本规范第3.1.13条的规定。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

**3.4.6** 乘轮椅者上下床用的床侧通道宽度不应小于1.20m。

> **条文说明**
>
> 本条为功能性要求。本条为确保乘轮椅者能够在床与轮椅之间顺畅移动。本条沿用现行标准条文。

**3.4.7** 窗户可开启扇的执手或启闭开关距地面高度应为0.85m～1.00m，手动开关窗户操作所需的力度不应大于25N。

> **条文说明**
>
> 本条为功能性要求。考虑乘轮椅者及手部力量较弱的人的操作，窗户可开启扇的执手或设置自动或手动启闭系统时的开关距地高度应在一定范围内。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

**3.4.8** 无障碍住房的门禁和无障碍客房的门铃应同时满足听觉障碍者、视觉障碍者和言语障碍者使用。

> **条文说明**
>
> 本条为功能性要求，考虑了不同障碍者的使用需求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

### 3.5 轮椅席位

**3.5.1** 轮椅席位的观看视线不应受到遮挡，并不应遮挡他人视线。

> **条文说明**
>
> 本条为功能性要求，为设置轮椅席位的指导原则。进行观众厅视线设计时要考虑轮椅席位，保证席位之间相互不遮挡。当轮椅席位处可安装易于拆卸的固定座椅时，也要考虑不同使用状况的视线要求。本条沿用现行标准条文。

**3.5.2** 轮椅席位应设置在便于疏散的位置，并不应设置在公共通道范围内。

> **条文说明**
>
> 本条为功能性和安全性要求。本条规定了设置轮椅席位的位置，保证乘轮椅者能够及时疏散，同时不影响其他观众疏散。本条沿用现行标准条文。

**3.5.3** 轮椅席位区应通过无障碍通行设施与疏散出口、公共服务、卫生间、讲台等必要的功能空间和设施连接。

> **条文说明**
>
> 本条为功能性要求。乘轮椅者作为观众或需登台者，除了观众厅之外，可能需要使用到售票处、餐厅、休息厅等公共服务空间，需要去设置无障碍设施的公共卫生间（厕所）或无障碍厕所，也有可能需要登台演讲或表演等。应根据功能需求确保轮椅席位区与其他必要的空间或位置之间的无障碍连接。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

**3.5.4** 轮椅席位应符合下列规定：
> 1.  每个轮椅席位的净尺寸深度不应小于1.30m，宽度不应小于800mm；
> 2.  观众席为100座及以下时应至少设置1个轮椅席位；101座～400座时应至少设置2个轮椅席位；400座以上时，每增加200个座位应至少增设1个轮椅席位；
> 3.  在轮椅席位旁或邻近的座席处应设置1：1的陪护席位；
> 4.  轮椅席位的地面坡度不应大于1：50。

> **条文说明**
>
> 本条为功能性要求。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。
>
> 第1款 本条规定了轮椅席位的占地尺寸。一个轮椅席位的宽度（面向舞台或银幕）为800mm，是乘轮椅者的手臂推动轮椅时所需的最小宽度。考虑到轮椅从前方或后部进出轮椅席位时前后的移动空间，最小深度设为1.30m。前后通道不可占压轮椅席位的尺寸范围。
>
> 第2款 本款规定了设置轮椅席位数量比例的底线性要求。400座以上时，当不能被200整除时，不足200的部分也应设置1个轮椅席位。例如当为750座时，应设置4个轮椅席位。为了更经济有效地利用空间，当固定席位数量不能满足使用要求，且轮椅席位未被使用时，允许在轮椅席位处安装易于拆卸的固定座椅，拆卸后不可影响轮椅的使用。
>
> 第3款 考虑到乘轮椅者大多有人陪伴出行，所以设置陪护席位。若陪护席位无法设置在轮椅席位旁，也要尽可能在邻近处设置。
>
> 第4款 本款保证了轮椅安全停放。

### 3.6 低位服务设施

**3.6.1** 为公众提供服务的各类服务台均应设置低位服务设施，包括问询台、接待处、业务台、收银台、借阅台、行李托运台等。

> **条文说明**
>
> 本条为功能性要求。本条规定了低位服务设施的设置范围。本条沿用现行标准条文。

**3.6.2** 当设置饮水机、自动取款机、自动售票机、自动贩卖机等时，每个区域的不同类型设施应至少有1台为低位服务设施。

> **条文说明**
>
> 本条为功能性要求。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

**3.6.3** 低位服务设施前应留有轮椅回转空间。

> **条文说明**
>
> 本条为功能性要求。低位服务设施前的轮椅回转空间可利用低位服务设施下部的空间。根据近些年实际情况，参考国外标准中的相关要求，本条在现行标准条文基础上进行了调整。

**3.6.4** 低位服务设施的上表面距地面高度应为700mm～850mm，台面的下部应留出不小于宽750mm、高650mm、距地面高度250mm范围内进深不小于450mm、其他部分进深不小于250mm的容膝容脚空间。

> **条文说明**
>
> 本条为功能性要求，考虑了乘轮椅者使用。本条沿用现行标准条文。容膝容脚空间的尺寸参见图10。

## 4 无障碍信息交流设施

**4.0.1** 无障碍标识应纳入室内外环境的标识系统，应连续并清楚地指明无障碍设施的位置和方向。

> **条文说明**
>
> 本条为功能性和安全性要求。标识是在环境中，通过视觉、听觉、触觉或其他感知方式向使用者提供导向与识别功能的载体，标识系统为全部标识的总称。无障碍标识系统是为残疾人、老年人和其他有需求的人传递各种信息的标识系统，是城市、建筑等室内外环境的标识系统的必要组成部分，并且不能出现断点以至失去引导作用。一般情况下，概念性指称用“无障碍标识”这一用语，而具体的标识图案和实体用“无障碍标志”这一用语。本条在现行标准条文基础上进行了调整。

**4.0.2** 无障碍标志的安装位置和高度应保证从站立和座位的视觉角度都能够看见，并且不应被其他任何物品遮挡。

> **条文说明**
>
> 本条为功能性要求，无障碍标志包括通用的无障碍标志、无障碍设施标志和带指示方向的无障碍设施标志。要保障无障碍标志能够让不同高度的站立者、乘轮椅者都能看到。本条沿用现行标准条文。

**4.0.3** 无障碍设施处均应设置无障碍标识。

> **条文说明**
>
> 本条为功能性要求。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

**4.0.4** 对需要安全警示处，应同时提供包括视觉标识和听觉标识的警示标识。

> **条文说明**
>
> 本条为安全性要求。涉及人身安全的警示对于所有人都非常重要，对于视觉障碍、听觉障碍的人群，必须提供保证他们能够获得信息的警示标识。本条中的“需要安全警示处”包括禁止靠近或触碰的、并在一段时间内固定的地点和设施（如机房、设备、施工地点等），以及在一段时间内固定的可能发生人身伤害的位置。在保证视觉障碍、听觉障碍人群安全的原则下，临时性的保洁、维修、维护等，可以通过人员值守等管理手段替代听觉标识的作用；位于设备层、施工场地内等封闭管理的特定区域的机房、设备、施工地点等，可根据情况具体处理。本条在现行标准条文基础上进行了调整。

**4.0.5** 语音信息密集的公共场所和以声音为主要传播手段的公共服务应提供文字信息的辅助服务。

> **条文说明**
>
> 本条为功能性要求。依据《无障碍环境建设条例》第二十四条：“公共服务机构和公共场所应当创造条件为残疾人提供语音和文字提示、手语、肓文等信息交流服务。”语音信息密集的公共场所，如运动场馆、集会场所、教育机构、公共事务服务场所、交通枢纽场站等，提供文字信息辅助可以帮助听觉障碍者获得必要的信息。以声音为主要传播手段的公共服务，应提供字幕或文本服务。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

**4.0.6** 在以视觉信息为主的公共服务中，应提供听觉信息的辅助服务。

> **条文说明**
>
> 本条为功能性要求。依据《无障碍环境建设条例》第二十四条：“公共服务机构和公共场所应当创造条件为残疾人提供语音和文字提示、手语、盲文等信息交流服务。”在如查询、阅览、个人自助终端等以视觉信息为主的公共服务中，提供听觉信息的辅助服务可以帮助视觉障碍者获得必要的信息。听觉信息的辅助服务包括语音引导、文字转语音等。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。

**4.0.7** 公共场所中的网络通信设备部件应符合下列规定：
> 1.  低位电话、低位个人自助终端和低位台面计算机应符合本规范第3.6.4条的有关规定；
> 2.  每1组公用电话中，应至少设1部低位电话，听筒线长度不应小于600mm；应至少设1部电话具备免提对话、音量放大和助听耦合的功能；
> 3.  每1组个人自助终端中，应至少设1部低位个人自助终端；应至少设1部具备视觉和听觉两种信息传递方式的个人自助终端；
> 4.  供公众使用的计算机中，应至少提供1台低位台面计算机；应至少提供1台具备读屏软件和支持屏幕放大功能的计算机；应至少提供1台具备语音输入功能的计算机；支持可替换键盘的计算机不应少于20％。

> **条文说明**
>
> 本条为功能性要求。在我国现行标准中没有明确此要求，本条根据近些年实际情况及参照国外标准增加了要求。
>
> 第1款 低位电话、低位个人自助终端和低位台面计算机方便乘轮椅者使用。
>
> 第2款 免提对话功能是对手部力量弱的使用者的辅助，音量放大功能是对弱听者的辅助，助听耦合功能是对佩戴助听器者的辅助。
>
> 第3款 个人自助终端是指场所内布置用于查询、引导、简单业务实现等自助使用的终端设备。低位个人自助终端方便乘轮椅者使用。采用视觉和听觉两种信息传递方式，方便视觉障碍者和听觉障碍者的使用。
>
> 第4款 本款中供公众使用的计算机指公共服务设施中的电脑、网吧中的电脑等。屏幕放大功能是普遍的辅助功能，有些操作系统自带，也可以使用第三方软件实现更多辅助功能。对于文本信息的语音输入已经是非常成熟的技术。目前针对残疾人和老年人的辅助设备越来越多，比如盲文键盘、盲文点阵输出，残疾人和老年人可以使用已经熟悉的输入输出设备替换传统的键盘来操控计算机。

**4.0.8** 过街音响提示装置应符合下列规定：
> 1.  应保证视觉障碍者的通行安全，且有利于辨别方向；
> 2.  应在主要商业街、步行街和视觉障碍者集中区域周边道路的人行横道设置；
> 3.  应结合人行横道信号灯统一设置；
> 4.  应避免产生噪声污染；
> 5.  应设置开关功能。

> **条文说明**
>
> 本条为安全性和功能性要求，参照现行标准条文制定。
>
> 第1款 过街音响提示装置是目前比较成熟的辅助技术，主要安装于十字路口，需要同时兼顾两个不同方向的提示。因此其方向指示性是必要要求。
>
> 第2款 设置过街提示音响装置的地点，主要考虑人流量大或者需求集中的地方，其他地段不做强制要求。
>
> 第3款 过街音响提示装置与交通信号灯联动是为了保障提示信息正确。
>
> 第4款 本款没有提出定量要求，是考虑道路的噪声随时间变化比较大。对于夜晚比较安静的时候，过街音响提示装置的声音可能比较明显，可根据实际情况采取能够根据环境噪音改变音频和音量的智能过街音响，达到本款要求。
>
> 第5款 过街音响提示装置的声音可开可关，保证使用的灵活性。

## 5 无障碍设施施工验收和维护

**5.0.1** 工程竣工验收时，建设单位应组织对无障碍设施的系统性进行检查验收。

> **条文说明**
>
> 本条为无障碍设施系统性的检查验收要求。本条提出在工程竣工验收时对无障碍设施的系统性进行检查验收主要包括两个方面，一是在建设区域内全部无障碍设施验收合格的基础上，对区域内无障碍设施之间的有效衔接进行检查验收，二是对区域内无障碍通行流线与区域周边的道路、建筑物、广场绿地的无障碍衔接进行检查验收，确保区域内外无障碍通行流线的通畅、便利及可达。在我国现行标准中没有明确此要求，本条根据近些年实际情况增加了要求。

**5.0.2** 工程验收时，应对无障碍设施的地面防滑性能、扶手和安全抓杆的受力性能进行验收。

> **条文说明**
>
> 本条为无障碍设施安全性能的验收要求。残障人士、老年人等特殊群体，对地面抗滑适应能力弱，对扶手和安全抓杆的依赖程度大。防滑性能、扶手和安全抓杆的受力性能等涉及人身安全。本条沿用现行标准条文。
>
> 对无障碍设施的地面防滑性能、扶手和安全抓杆的受力性能应按照现行标准进行测试和验收。地面防滑性能按照表1进行现场检验。

**5.0.3** 对竣工验收交付使用的无障碍设施应明确维护责任人。

> **条文说明**
>
> 本条明确无障碍设施的维护主体。根据国务院《无障碍环境建设条例》第十七条规定：“无障碍设施的所有权人和管理人，应当对无障碍设施进行保护，有损毁或者故障及时进行维修，确保无障碍设施正常使用”。无障碍设施的缺损或占用直接影响其安全性、功能性和系统性，必须采取措施并及时修复，维护责任人为所有权人和管理人。本条沿用现行标准条文。

**5.0.4** 维护责任人应定期对无障碍设施进行检查，确保其符合安全性、功能性和系统性要求。

> **条文说明**
>
> 本条为无障碍设施检查要求。维护责任人应定期对无障碍设施进行检查，根据保证无障碍设施安全性、功能性和系统性的原则确定检查期限。本条沿用现行标准条文。

**5.0.5** 对安全性、功能性或系统性缺损的无障碍设施，维护责任人应及时进行维护，保证其正常使用。

> **条文说明**
>
> 本条为无障碍设施维护要求。无障碍设施的系统性维护指对区域内无障碍设施缺损或占用进行维护，以及对区域内无障碍设施与区域外无障碍设施的连接问题进行维护。本条沿用现行标准条文。

**5.0.6** 涉及人身安全的无障碍设施，因突发性事件引起功能缺损或因雨雪等原因造成防滑性能下降，维护责任人应采取应急维护措施。

> **条文说明**
>
> 本条为突发情况无障碍设施维护要求。涉及人身安全的无障碍设施因突发性事件引起功能缺损（如：轮椅坡道或扶手损坏、安全抓杆脱落、地面被油渍污染等）或因雨雪等原因造成防滑性能下降等，对残疾人、老年人等人士的伤害程度大，维护责任人应采取应急维护措施。例如：增设临时标志、完善使用功能、采取防滑措施等，并尽快进行全面修复处理。本条沿用现行标准条文。