# 《建筑环境通用规范》GB 55016-2021

**住房和城乡建设部**  
**更新时间：2025-05-20**  
**实施时间：2022-04-01**

[全文阅读](https://www.soujianzhu.cn/WinAppNew/Gfnr.aspx?id=503) [分节阅读](https://www.soujianzhu.cn/WinAppNew/Gfnr.aspx?id=503)

## 目录
- 前言
- 1 总则
- 2 建筑声环境
  - 2.1 一般规定
  - 2.2 隔声、吸声与消声设计
  - 2.3 隔振设计
  - 2.4 检测与验收
- 3 建筑光环境
  - 3.1 一般规定
  - 3.2 采光设计
  - 3.3 室内照明设计
  - 3.4 室外照明设计
  - 3.5 检测与验收
- 4 建筑热工
  - 4.1 一般规定
  - 4.2 保温设计
  - 4.3 防热设计
  - 4.4 防潮设计
  - 4.5 检测与验收
- 5 室内空气质量
  - 5.1 一般规定
  - 5.2 场地土壤氡控制
  - 5.3 材料控制
  - 5.4 检测与验收
- 附录A 声环境功能区分类
- 附录B 光气候区划
- 附录C 建筑气候区划
- 附录D 建筑热工设计区划

## 前言

中华人民共和国国家标准  
建筑环境通用规范  
General code for building environment  
GB 55016-2021

主编部门：中华人民共和国住房和城乡建设部  
批准部门：中华人民共和国住房和城乡建设部  
施行日期：2022年4月1日

中华人民共和国住房和城乡建设部公告  
2021年 第172号

住房和城乡建设部关于发布国家标准《建筑环境通用规范》的公告

现批准《建筑环境通用规范》为国家标准，编号为GB 55016-2021，自2022年4月1日起实施。本规范为强制性工程建设规范，全部条文必须严格执行。现行工程建设标准相关强制性条文同时废止。现行工程建设标准中有关规定与本规范不一致的，以本规范的规定为准。

本规范在住房和城乡建设部门户网站公开，并由住房和城乡建设部标准定额研究所组织中国建筑出版传媒有限公司出版发行。

中华人民共和国住房和城乡建设部  
2021年9月8日

### 废止的现行工程建设标准相关强制性条文

1.  《建筑采光设计标准》GB 50033-2013  
    第4.0.2、4.0.4、4.0.6条
2.  《住宅设计规范》GB 50096-2011  
    第7.3.1、7.4.1、7.4.2、7.5.3条
3.  《民用建筑隔声设计标准》GB 50118-2010  
    第4.1.1条
4.  《民用建筑热工设计规范》GB 50176-2016  
    第4.2.11、6.1.1、6.2.1、7.1.2条
5.  《民用建筑工程室内环境污染控制标准》GB 50325-2020  
    第3.1.1、3.1.2、3.6.1、4.1.1、4.2.4、4.2.5、4.2.6、4.3.1、4.3.6、5.2.1、5.2.3、5.2.5、5.2.6、5.3.3、5.3.6、6.0.4、6.0.14、6.0.23条
6.  《住宅建筑规范》GB 50368-2005  
    第3.1.8、7.1.1、7.1.4、7.1.6、7.2.3、7.3.1、7.3.2、7.4.1、10.1.3条
7.  《体育场馆照明设计及检测标准》JGJ 153-2016  
    第4.4.11条
8.  《体育建筑电气设计规范》JGJ 354-2014  
    第9.1.4（1）条（款）

### 关于规范种类

强制性工程建设规范体系覆盖工程建设领域各类建设工程项目，分为工程项目类规范（简称项目规范）和通用技术类规范（简称通用规范）两种类型。项目规范以工程建设项目整体为对象，以项目的规模、布局、功能、性能和关键技术措施等五大要素为主要内容。通用规范以实现工程建设项目功能性能要求的各专业通用技术为对象，以勘察、设计、施工、维修、养护等通用技术要求为主要内容。在全文强制性工程建设规范体系中，项目规范为主干，通用规范是对各类项目共性的、通用的专业性关键技术措施的规定。

### 关于五大要素指标

强制性工程建设规范中各项要素是保障城乡基础设施建设体系化和效率提升的基本规定，是支撑城乡建设高质量发展的基本要求。项目的规模要求主要规定了建设工程项目应具备完整的生产或服务能力，应与经济社会发展水平相适应。项目的布局要求主要规定了产业布局、建设工程项目选址、总体设计、总平面布置以及与规模相协调的统筹性技术要求，应考虑供给能力合理分布，提高相关设施建设的整体水平。项目的功能要求主要规定项目构成和用途，明确项目的基本组成单元，是项目发挥预期作用的保障。项目的性能要求主要规定建设工程项目建设水平或技术水平的高低程度，体现建设工程项目的适用性，明确项目质量、安全、节能、环保、宜居环境和可持续发展等方面应达到的基本水平。关键技术措施是实现建设项目功能、性能要求的基本技术规定，是落实城乡建设安全、绿色、韧性、智慧、宜居、公平、有效率等发展目标的基本保障。

### 关于规范实施

强制性工程建设规范具有强制约束力，是保障人民生命财产安全、人身健康、工程安全、生态环境安全、公众权益和公众利益，以及促进能源资源节约利用、满足经济社会管理等方面的控制性底线要求，工程建设项目的勘察、设计、施工、验收、维修、养护、拆除等建设活动全过程中必须严格执行，其中，对于既有建筑改造项目（指不改变现有使用功能），当条件不具备、执行现行规范确有困难时，应不低于原建造时的标准。与强制性工程建设规范配套的推荐性工程建设标准是经过实践检验的、保障达到强制性规范要求的成熟技术措施，一般情况下也应当执行。在满足强制性工程建设规范规定的项目功能、性能要求和关键技术措施的前提下，可合理选用相关团体标准、企业标准，使项目功能、性能更加优化或达到更高水平。推荐性工程建设标准、团体标准、企业标准要与强制性工程建设规范协调配套，各项技术要求不得低于强制性工程建设规范的相关技术水平。

强制性工程建设规范实施后，现行相关工程建设国家标准、行业标准中的强制性条文同时废止。现行工程建设地方标准中的强制性条文应及时修订，且不得低于强制性工程建设规范的规定。现行工程建设标准（包括强制性标准和推荐性标准）中有关规定与强制性工程建设规范的规定不一致的，以强制性工程建设规范的规定为准。

## 1 总则

### 1.0.1
为保障建筑环境安全健康，提高居住环境水平和工程质量，满足人民群众对建筑环境质量的要求，依据有关法律、法规，制定本规范。
> **条文说明**  
> 本规范编制的目的。本规范以保障建筑环境安全，提高居住环境水平和工程质量为目标，以满足生活与工作对环境的基本要求及经济社会管理基本要求为控制性底线要求，编制本规范。

### 1.0.2
新建、改建和扩建民用建筑及工业建筑中辅助办公类建筑的声环境、光环境、建筑热工及室内空气质量的设计、检测及验收必须执行本规范。
> **条文说明**  
> 本规范适用于新建、改建和扩建民用建筑，以及工业建筑中辅助办公建筑，规定了其声环境、光环境、建筑热工及室内空气质量应达到的通用性的控制底线要求及技术措施。本规范的内容不适用于生产工艺用房的建筑热工、防爆防火要求，以及战争、自然灾害等不可抗力条件下对建筑环境技术的要求。本规范技术措施要求也适用于既有建筑改造设计、检测及验收，除受客观条件限制无法实施的情况外，既有建筑改造后也应达到本规范底线技术要求。  
> 本规范仅规定了建筑热工的基本要求，其中建筑保温及隔热还应符合现行国家标准《建筑节能与可再生能源利用通用规范》GB 55015的有关规定，与供暖、通风与空气调节相关的热湿环境要求在现行国家标准《民用建筑供暖通风与空气调节通用规范》中规定。在室内空气质量方面，本规范仅针对建筑主体材料及装饰装修材料产生的空气污染物提出控制要求，新风量以及与通风净化相关的规定在现行国家标准《民用建筑供暖通风与空气调节通用规范》GB 55015中规定。  
> 有关电磁环境的相关技术措施在现行国家标准《建筑电气与智能化通用规范》中有相关规定；特殊洁净环境，如生物安全实验室等的基本要求在现行国家标准《民用建筑供暖通风与空气调节通用规范》中规定。

### 1.0.3
建筑环境应满足人体健康对声光热环境和空气质量的基本要求。
> **条文说明**  
> 本条规定了建筑室内环境保障的目标要求。

### 1.0.4
工程建设所采用的技术方法和措施是否符合本规范要求，由相关责任主体判定。其中，创新性的技术方法和措施，应进行论证并符合本规范中有关性能的要求。
> **条文说明**  
> 工程建设强制性规范是以工程建设活动结果为导向的技术规定，突出了建设工程的规模、布局、功能、性能和关键技术措施，但是，规范中关键技术措施不能涵盖工程规划建设管理采用的全部技术方法和措施，仅仅是保障工程性能的“关键点”，很多关键技术措施具有“指令性”特点，即要求工程技术人员去“做什么”，规范要求的结果是要保障建设工程的性能。因此，能否达到规范中性能的要求，以及工程技术人员所采用的技术方法和措施是否按照规范的要求去执行，需要进行全面的判定，其中，重点是能否保证工程性能符合规范的规定。  
> 进行这种判定的主体应为工程建设的相关责任主体，这是我国现行法律法规的要求。《中华人民共和国建筑法》《建设工程质量管理条例》《民用建筑节能条例》等以及相关的法律法规，突出强调了工程监管、建设、规划、勘察、设计、施工、监理、检测、造价、咨询等各方主体的法律责任，既规定了首要责任，也确定了主体责任。在工程建设过程中，执行强制性工程建设规范是各方主体落实责任的必要条件，是基本的、底线的条件，有义务对工程规划建设管理采用的技术方法和措施是否符合本规范规定进行判定。  
> 同时，为了支持创新，鼓励创新成果在建设工程中应用，当拟采用的新技术在工程建设强制性规范或推荐性标准中没有相关规定时，应当对拟采用的工程技术或措施进行论证，确保建设工程质量和安全，达到本规范规定的性能要求，并应满足国家对建设工程环境保护、卫生健康、经济社会管理、能源资源节约与合理利用等相关基本要求。

## 2 建筑声环境

### 2.1 一般规定

#### 2.1.1
民用建筑室内应减少噪声干扰，应采取隔声、吸声、消声、隔振等措施使建筑声环境满足使用功能要求。
> **条文说明**  
> 本条规定了建筑声学保障的目标要求。建筑的声环境关乎建筑使用者的舒适感、健康及安全。  
> 英国《建筑法规》的E部分就是有关声环境的内容。澳大利亚《建筑法规》的F5部分为：传声与隔声。在其对建筑的性能要求作规定的FP 5.1条、FP 5.2条、FP 5.4条、FP 5.5条中均提出了防止对房间使用者造成健康伤害或降低舒适感的要求。

#### 2.1.2
噪声与振动敏感建筑在2类或3类或4类声环境功能区时，应在建筑设计前对建筑所处位置的环境噪声、环境振动调查与测定。声环境功能区分类应符合本规范附录A的规定。
> **条文说明**  
> 根据《中华人民共和国环境噪声污染防治法》第五条：“地方各级人民政府在制定城乡建设规划时，应当充分考虑建设项目和区域开发、改造所产生的噪声对周围生活环境的影响，统筹规划，合理安排功能区和建设布局，防止或者减轻环境噪声污染。”  
> 噪声引起人烦躁，妨碍人们正常休息、学习和工作。长期处于高噪声环境会危害人体健康，可能引起听力损伤、生殖能力下降、高血压甚至心血管伤害。所以根据建筑类型将其设置在相宜的声环境，是建筑选址必须考虑的环境因素和遵循的原则，是保障建筑内使用者日常生活、工作、学习、睡眠等活动和身心健康的基本要求，避免出现因建筑选址不当，外部噪声偏高导致建设成本高企或建成后建筑内部噪声超标引发的公共安全事件。  
> 国家标准《声环境质量标准》GB 3096-2008第5.1条规定了各类声环境功能区昼间、夜间的环境噪声限值，如表1所示。  
> 国家标准《声环境质量标准》GB 3096-2008第5.4条规定：各类声环境功能区夜间突发噪声，其最大声级超过环境噪声限值的幅度不得高于15dB（A）。  
> 表1中的环境噪声限值为等效连续A声级，是一段时间内声音的能量平均值。  
> 表1中各类声环境功能区所对应的区域如下：0类声环境功能区指康复疗养区等特别需要安静的区域。1类声环境功能区指以居民住宅、医疗卫生、文化教育、科研设计、行政办公为主要功能，需要保持安静的区域。2类声环境功能区指以商业金融、集市贸易为主要功能，或者居住、商业、工业混杂，需要维护住宅安静的区域。3类声环境功能区指以工业生产、仓储物流为主要功能，需要防止工业噪声对周围环境产生严重影响的区域。4类声环境功能区指交通干线两侧一定距离之内，需要防止交通噪声对周围环境产生严重影响的区域，包括4a类和4b类两种类型。4a类为高速公路、一级公路、二级公路、城市快速路、城市主干路、城市次干路、城市轨道交通（地面段）、内河航道两侧区域；4b类为铁路干线两侧区域。  
> 2类、3类声环境功能区内设有工业，4类声环境功能区是交通干线两侧一定距离之内的区域。这些区域内环境噪声、环境振动可能较高。在建造民用建筑前对建筑所处位置的环境噪声、环境振动调查与测定，可使设计人员据此采取相应技术措施，保证建筑室内符合有关噪声、振动标准的规定。

#### 2.1.3
建筑物外部噪声源传播至主要功能房间室内的噪声限值及适用条件应符合下列规定：
1.  建筑物外部噪声源传播至主要功能房间室内的噪声限值应符合表2.1.3的规定；
2.  噪声限值应为关闭门窗状态下的限值；
3.  昼间时段应为6：00～22：00时，夜间时段应为22：00～次日6：00时。当昼间、夜间的划分当地另有规定时，应按其规定。

**表2.1.3 建筑物外部噪声源传播至主要功能房间室内的噪声限值**

| 房间的使用功能 | 噪声限值(等效声级 LAeq,T ，dB) | 噪声限值(等效声级 LAeq,T ，dB) |
| :--- | :--- | :--- |
|  | 昼间 | 夜间 |
| 睡眠 | 40 | 30 |
| 日常生活 | 40 | 40 |
| 阅读、自学、思考 | 35 | 35 |
| 教学、医疗、办公、会议 | 40 | 40 |

> 注：1 当建筑位于2类、3类、4类声环境功能区时，噪声限值可放宽5dB；  
> 2 夜间噪声限值应为夜间8h连续测得的等效声级 LAeq ，8h；  
> 3 当1h等效声级 LAeq ，1h能代表整个时段噪声水平时，测量时段可为1h。

> **条文说明**  
> 影响建筑主要功能房间室内噪声的因素主要分为两类，一类是建筑物外部噪声源通过建筑围护结构传播至室内，另一类是建筑物内部的建筑设备产生的振动与噪声传播至室内。本条主要规定建筑物外部噪声源传播至室内的噪声限值，降低此类噪声源对主要功能房间影响主要通过提高建筑外围护结构隔声性能来实现。  
> 目前，反映住宅、旅馆、学校、办公室等民用建筑室内受到噪声干扰的情况时有发生，造成矛盾纠纷，甚至提起诉讼。因此，对各种使用功能房间的室内噪声限值作规定，可使相应房间内具有适宜的声环境，还可使设计、施工、监理、验收、行政管理、司法仲裁等人员有所依据。  
> 本条对不同使用功能房间的室内噪声限值做出规定。各种使用功能房间的典型实例：  
> 用于睡眠的房间，如卧室；  
> 用于日常生活的房间，如起居室；  
> 用于阅读、自学、思考的房间，如阅览室；  
> 用于教学、医疗、办公、会议的房间，如教室、诊室、办公室、会议室。  
> 本条规定的各噪声限值是仅考虑建筑物外部噪声源情况传播至室内时，相应室内噪声测量得到的等效声级不能超过的数值，测量时，应排除其他噪声的干扰。等效声级的测量方法应依据国家标准《民用建筑隔声设计规范》GB 50118-2010的附录A。  
> 本规范中规定了房间关窗状态下的室内噪声限值。在室外噪声源增多、室外噪声较高（尤其是城市交通干线、高速公路、铁路、机场附近）的情况下，要求在开窗状态室内的噪声也较低是比较困难的。为减小室外噪声对房间内的干扰，增强房间外窗部位的隔声能力是从建筑本身所能采取的主要有效措施。虽然关窗可以降低室外噪声对室内的影响，但关窗也隔断了室内外的空气流通，不利于保持房间内的空气新鲜。所以，在规划、设计民用建筑时，仍应尽可能从平面布置方面采取防噪措施，争取实现在开窗状态下，房间内的噪声也能达到本规范中室内噪声限值的要求。  
> 根据《中华人民共和国环境噪声污染防治法》，昼间是指6：00-22：00之间的时段，夜间是指22：00～次日6：00之间的时段。由于我国幅员辽阔，跨越多个时区，有些地方政府考虑当地的时差、作息习惯而对昼间、夜间的划分另有规定。对于这种情况昼间和夜间时段所对应的时间应按照当地人民政府的规定。

#### 2.1.4
建筑物内部建筑设备传播至主要功能房间室内的噪声限值应符合表2.1.4的规定。

**表2.1.4 建筑物内部建筑设备传播至主要功能房间室内的声限值**

| 房间的使用功能 | 噪声限值(等效声级 LAeq,T ，dB) |
| :--- | :--- |
| 睡眠 | 33 |
| 日常生活 | 40 |
| 阅读、自学、思考 | 40 |
| 教学、医疗、办公、会议 | 45 |
| 人员密集的公共空间 | 55 |

> **条文说明**  
> 本条规定了建筑物内部建筑设备产生的振动和噪声传播至主要功能房间的室内噪声限值。各种使用功能房间的典型实例同第2.1.3条，其中人员密集的公共空间，指如医院入口大厅、候诊厅、铁路候车大厅、机场候机大厅等场所。对于不同类型建筑设备产生的噪声，应采取不同的降噪措施，例如：对于各类风机沿通风管道传播的噪声，应通过消声设计来降低其产生的噪声干扰；对于建筑设备产生振动随结构传播产生的结构噪声，应通过隔振设计来降低其产生的噪声干扰。对于有些设备或机房噪声，可能需要采用吸声、消声、隔声与隔振等综合降噪处理才能达到降低噪声的目的。  
> 本条规定的是建筑物内部的所有建筑设备传播至主要功能房间室内的噪声限值，是建筑设备通过各种传声途径（含空气声传播、撞击声传播、结构声传播）传播至主要功能房间室内的噪声总和。测量时，应排除建筑物外部噪声的干扰，可以通过改变测量时段，关闭其他声源，提高外围护结构隔声能力等来降低其他噪声的干扰。  
> 建筑设备通过建筑结构传播的结构噪声通常呈低频窄带特性，其主要对住宅建筑使用者夜间睡眠产生影响，不具备通用性，应在相应项目规范中进行规定，因此本规范未规定建筑设备结构噪声限值。

#### 2.1.5
主要功能房间室内的Z振级限值及适用条件应符合下列规定：
1.  主要功能房间室内的Z振级限值应符合表2.1.5的规定；
2.  昼间时段应为6：00～22：00时，夜间时段应为22：00～次日6：00时。当昼间、夜间的划分当地另有规定时，应按其规定。

**表2.1.5 主要功能房间室内的Z振级限值**

| 房间的使用功能 | Z振级 VLz (dB) | Z振级 VLz (dB) |
| :--- | :--- | :--- |
|  | 昼间 | 夜间 |
| 睡眠 | 78 | 75 |
| 日常生活 | 78 | 78 |

> **条文说明**  
> 不同区域、不同活动状态下，环境振动对人的影响程度不同。振动限值是以国际通用的振动评价量，结合我国对人体振动生理、心理状态的调查及研究确定的。该限值是保证人员生理、心理健康和基本舒适度要求，以及建筑室内环境必须满足的指标。  
> 建筑室内环境振动是室外振源与室内振源共同作用的总和。对于睡眠、学习、思考等需要安静、精力集中不被干扰的房间，振动源产生的结构噪声为低、中频窄带频率特性的有调声，能引发人员更大的烦恼度，必须加以限制，以保证建筑使用者最基本的舒适度要求。  
> 本条室内振动限值与现行国家标准《城市区域环境振动标准》GB 10070保持一致。虽然二者均以Z振级作为评价量，由于所用计权因子不同，在相同振动水平上两个标准在数值上相差约3dB。  
> 本条中规定的室内振动限值Z振级的测量，按照现行国家标准《住宅建筑室内振动限值及其测量方法标准》GB/T 50355规定的方法进行。

### 2.2 隔声、吸声与消声设计

#### 2.2.1
对噪声敏感房间的围护结构应做隔声设计。噪声敏感房间外围护结构的隔声性能应根据室外噪声情况和本规范表2.1.3中规定的噪声敏感房间的室内噪声限值确定。噪声敏感房间内围护结构的隔声性能应根据房间外噪声情况和本规范表2.1.4中规定的噪声敏感房间的室内噪声限值确定。
> **条文说明**  
> 用于睡眠、思考、学习等的噪声敏感房间要求室内噪声级较低，能够抵御外来噪声干扰。只有进行隔声设计，才能使噪声敏感房间的围护结构具有所需的隔声能力，因此设置此条文。  
> 噪声敏感房间对室内噪声有严格要求，通过对房间的围护结构进行隔声设计，才能保证从外部传入的噪声符合噪声敏感房间的规定。噪声敏感房间的具体实例，如：卧室、起居室、阅览室、办公室、会议室等。  
> 英国《建筑法规》的E部分、澳大利亚《建筑法规》的F5部分都将建筑隔声作为主要内容。各种建筑隔声标准、具体隔声构造措施占据了英国《建筑法规》E部分、澳大利亚《建筑法规》F5部分的大部分篇幅。本通用规范仅对建筑中噪声敏感房间、有噪声源房间的隔声提出原则性要求。针对各种建筑情形的隔声标准、具体隔声构造措施，由各项目规范根据不同需求作出相应规定。

#### 2.2.2
对有噪声源房间的围护结构应做隔声设计。有噪声源房间外围护结构的隔声性能应根据噪声源辐射噪声的情况和室外环境噪声限值确定。有噪声源房间内围护结构的隔声性能应根据噪声源辐射噪声的情况和本规范表2.1.4中规定的相邻房间的室内噪声限值或国家现行相关标准中的噪声限值确定。
> **条文说明**  
> 建筑内外均有限制噪声的要求，不允许噪声从噪声源所在房间透泄出来而造成干扰，必须对设有噪声源房间的围护结构进行隔声设计以控制噪声，因此设置此条文。  
> 噪声源发出的噪声对相邻房间、周围环境会造成干扰，对设有噪声源房间的围护结构进行隔声设计是避免噪声干扰的必要措施。有噪声源房间的具体实例，如：风机房、水泵房等。

#### 2.2.3
管线穿过有隔声要求的墙或楼板时，应采取密封隔声措施。
> **条文说明**  
> 在建筑中总会有各种管线穿过楼板或墙体，但由于设计或施工的原因，常常会在通过孔处出现缝隙或封堵不严的情况，致使房间难以达到隔声要求，因此设置此条文。  
> 墙或楼板上有孔隙，将使其隔声性能下降，隔声量的降低值与建筑构件本身的隔声性能有关，建筑构件的隔声性能越好，孔隙对建筑构件隔声性能的影响就越严重。  
> 澳大利亚《建筑法规》的FP 5.3条、FP 5.6条中均提出：当有管埋入、穿过楼板或墙，不得因此使楼板或墙的隔声能力达不到规定的标准。

#### 2.2.4
建筑内有减少反射声要求的空间，应做吸声设计。
> **条文说明**  
> 合理、有效的吸声设计是控制建筑声环境的必要因素。如果文化建筑、体育建筑、广电建筑、会议建筑、影院建筑内不进行吸声处理，则不能满足空间的使用要求；机场和车站候车大厅及工业厂房等空间不进行吸声处理，则有可能对人的听力健康有所损坏。不进行声环境的吸声设计，不仅人的健康受到损害，还会对环境造成污染，因此设置此条文。  
> 文化建筑一般包括音乐厅、歌剧院、多功能剧场及图书馆等，其中有声学要求的空间一般包括观众厅、舞台空间、声控室、阅览室等；体育建筑中有声学要求的空间一般包括比赛大厅、训练馆、声控室、评论员室、新闻发布厅等；广电建筑中有声学要求的空间一般包括录音棚、播音室、演播厅、音响控制室等；会议建筑中有声学要求的空间一般包括会议厅（室）、音响控制室等；影院建筑中有声学要求的空间一般包括放映大厅、控制室等。文化建筑、体育建筑、广电建筑、会议建筑、影院建筑内的空调机房等设备用房一般均应采取吸声降噪措施，因此空调机房等属于有噪声控制要求的空间。  
> 英国《建筑法规》E部分的第7部分给出了如何确定供单元房、用于居住房间内的人进出通过的走廊、楼梯间、建筑入口厅内应增加的吸声量。  
> 英国《建筑法规》E部分的第8部分要求，学校有关房间的混响时间应满足英国建筑公告93.《学校声学设计：性能标准》中规定的数值。

#### 2.2.5
吸声设计应根据不同建筑的类型与用途，采取相应的技术措施来控制混响时间、降低噪声、提高语言清晰度和消除音质缺陷。
> **条文说明**  
> 吸声设计必须根据不同建筑的类型和用途。如果不根据实际用途进行吸声设计，则不可能达到应有的效果，反而会造成环境资源的浪费，因此设置此条文。  
> 不同类型的建筑其吸声设计的目的有所不同，如在观众厅中主要是控制混响时间和消除声缺陷等；体育建筑比赛大厅中主要是降低混响时间、提高语言清晰度和消除声缺陷等；机场和车站候车大厅主要是降低噪声和提高语言清晰度等；而工业厂房中和空调机房中主要是降低噪声。

#### 2.2.6
吸声材料应符合相应功能建筑的防火、防水、防腐、环保和装修效果等要求。
> **条文说明**  
> 吸声材料是声环境工程中的重要组成部分，合理的选用材料是吸声工程中的关键，不仅关系到建筑的声环境，还关系到空间内的环保和防火的问题，因此设置此条文。  
> 吸声材料作为一种建筑和装修材料，除了满足声学要求外还应根据使用的环境满足其他相应的要求，为了保证所选用的吸声材料能正确的使用，特设定此条。所有吸声材料均应满足防火和环保的要求；观众厅、比赛大厅、阅览室、候车大厅等对装修要求比较高的空间，应尽可能满足装修效果的要求；游泳馆、冰上运动比赛馆等高潮湿的空间，应满足防水、防腐要求。  
> 英国《建筑法规》E部分的7.5条规定：所选择的吸声材料应符合《建筑法规B部分 防火安全》的要求。

#### 2.2.7
当通风空调系统送风口、回风口辐射的噪声超过所处环境的室内噪声限值，或相邻房间通过风管传声导致隔声达不到标准时，应采取消声措施。
> **条文说明**  
> 通风空调系统风机噪声通过通风管道传入房间，管道对风机噪声有一定衰减，但大多数情况下传入房间的噪声仍超过室内噪声限值，降低风机自身噪声功率往往受技术水平限制，因此，采取消声措施是必需的。  
> 防止毗邻房间通过风口、风管串声，当不能满足隔声要求时，也必须采取管道消声措施。

#### 2.2.8
通风空调系统消声设计时，应通过控制消声器和管道中的气流速度降低气流再生噪声。
> **条文说明**  
> 通风空调系统风速较大时，会产生较大的气流再生噪声。气流再生噪声叠加到原有风机噪声，使噪声级增大，降低消声效果。因此，必须控制气流再生噪声。在现行行业标准《风机用消声器技术条件》JB/T 6891中要求气流再生噪声低于降噪设计要求10dB（A），这样叠加基本可以忽略不计，本规范对气流再生噪声级不做规定，只控制进入房间的通风空调噪声总噪声级。

### 2.3 隔振设计

#### 2.3.1
当噪声与振动敏感建筑或设有对噪声、振动敏感房间的建筑物，附近有可觉察的固定振动源，或距建筑外轮廓线50m范围内有城市轨道交通地下线时，应对其建设场地进行环境振动测量。
> **条文说明**  
> 对于可能存在的环境振动干扰，只有了解、掌握准确的环境振动水平及振动特性，获得准确的环境振动参数，才能针对振动特点制定合理、有效、安全、经济的环境振动控制措施，达到、满足建筑使用正常的环境振动、噪声条件。  
> 根据对我国北京、上海、广州等部分城市轨道交通运行振动影响范围的研究及检测，轨道交通对沿线环境振动的影响主要由地下线路产生；当与地下线之间的距离超过50m后，环境振动基本达到现行国家标准《城市区域环境振动标准》GB 10070规定的“居民、文教区”即“1类”声环境功能区。因此，本条提出如距建筑50m范围内有轨道交通地下线路，需做环境振动测量。

#### 2.3.2
当噪声与振动敏感建筑或设有对噪声、振动敏感房间的建筑物的建设场地振动测量结果超过2类声环境功能区室外环境振动限值规定时，应对建筑整体或建筑内敏感房间采取隔振措施，并应符合本规范表2.1.3和表2.1.5的规定。
> **条文说明**  
> 将建筑振动问题前置是发达国家的通用做法，并经长期建筑声环境设计实践证明是最经济、可行、有效的方法，国内也有类似规定。生态环境部《环境影响评价技术导则-城市轨道交通》HJ 453-2018 “9.3振动防治对策”的一般原则规定：“坚持预防为主原则，合理规划轨道交通与邻近建筑的布局。振动防治措施应根据振动预测结果、振动环境保护目标、文物保护单位内的不可移动文物的特点，结合国家政策、经济、技术可行性提出振动污染防治措施和对策”。防治措施包括：振源控制、传播路径控制、建筑物控制。  
> 因此，建设项目方案设计阶段必须统筹考虑环境振动问题。当振动噪声敏感建筑的建设场地即建筑外部环境振动超标，可能对建筑功能、建筑内部环境造成振动噪声干扰时，需根据振源位置、场地振动特性和建筑结构类型、特点等，对建筑整体或建筑内噪声敏感房间采取经济合理的隔振技术措施，如建筑基础隔振，结合施工场地护坡桩设置隔振排桩；对建筑内振动、噪声敏感房间设计全浮筑“房中房”构造等恰当、有效的隔振措施。避免建成后噪声敏感建筑或噪声敏感房间振动、噪声超标，损害人员的身心健康，影响建筑、设备、设施的正常使用。  
> 制定隔振方案时，需同时考虑环境振动、背景噪声及建筑配套设备、设施的振动、噪声影响，使主要用房正常使用时，满足本规范表2.1.3与表2.1.5的室内噪声与振动限值规定。  
> 噪声与振动敏感建筑物指住宅、医院、学校、旅馆、办公场所等具有较高噪声与振动环境保护要求的建筑。噪声敏感房间指卧室、起居室、客房、阅览室、教室、病房、诊室、办公室、会议室（厅）、观众厅、录音室等需要保持安静的房间。振动敏感房间指卧室、起居室、客房、阅览室、教室、病房、诊室、办公室、会议室等振动环境保护要求较高的房间。

#### 2.3.3
对建筑物内部产生噪声与振动的设备或设施，当其正常运行对噪声、振动敏感房间产生干扰时，应对其基础及连接管线采取隔振措施，并应符合本规范表2.1.4和表2.1.5的规定。
> **条文说明**  
> 为建筑配套、运行噪声与振动较大的机电设备、设施，被设置于住宅、学校、医院、酒店、办公等同一建筑内部已成为常态。在建筑方案设计阶段，从建筑平、剖面布局上进行闹静分区、相对集中、合理布置，对建筑声环境的改善及机电设备的噪声、振动控制起到事半功倍的作用。将存在运行噪声、振动较大的机电设备设于噪声敏感房间上部，需由声学专业技术人员根据房间功能需求及设备振动噪声特性做专业噪声、振动控制设计，并准确实施，以降低建成后噪声敏感房间噪声、振动超标风险。  
> 制定建筑内部设备、设施的隔振方案时，需同时考虑环境振动、背景噪声、建筑外部配套设备、设施的振动、噪声影响，使主要用房正常使用时，满足表2.1.4和表2.1.5的室内噪声与振动限值规定。

#### 2.3.4
对建筑物外部具有共同基础并产生噪声与振动的室外设备或设施，当其正常运行对噪声、振动敏感房间产生干扰时，应对其基础及连接管线采取隔振措施，并应符合本规范表2.1.3和表2.1.5的规定。
> **条文说明**  
> 切断、降低影响建筑室内声环境的各种振动源通过建筑、结构振动传递的途径，避免室内振动以及固体传声引发室内噪声级超标。  
> 振动通过建筑结构基础、柱、梁、板及墙体在建筑内传递，与建筑结构刚性安装、固定、接触的设备及其连接管线的振动，均会引起建筑结构振动并产生结构噪声，造成敏感用房室内噪声超标。因此，需对振动传递的所有途径采取隔振措施方能达到室内噪声限值规定及功能使用要求。  
> 制定隔振方案时，需同时考虑环境振动、背景噪声及建筑配套设备、设施的振动、噪声影响，使主要用房正常使用时，满足本规范表2.1.4的室内噪声限值规定。

#### 2.3.5
设备或设施的隔振设计以及隔振器、阻尼器的配置，应经隔振计算后制定和选配。
> **条文说明**  
> 隔振设计方案必须根据隔振降噪目标，设备转速、荷载、扰力、运行方式等经隔振计算制定，方能保证隔振措施安全、有效。在已有的工程实践中，存在单纯以设备功率来制定隔振设计方案的错误做法。因隔振措施不当产生共振而导致设备、建筑安全风险。

### 2.4 检测与验收

#### 2.4.1
建筑声学工程竣工验收前，应进行竣工声学检测。
> **条文说明**  
> 声学工程的质量是否达到设计目标，是要通过最终的测试结果来考量的。由于声音科学的特点以及声波在建筑空间传播的复杂性，理论计算与客观参量可能会存在一定误差。因此竣工声学检测是保证工程质量的必要手段。  
> 英国《建筑法规》E部分的第1部分是：建筑竣工隔声检测。其中规定了对住宅、用于居住房间的空气声隔声性能、撞击声隔声性能进行现场检测的全过程。  
> 澳大利亚《建筑法规》的FV 5.1条指出，若要证实建筑中楼板的空气声隔声性能、撞击声隔声性能是否符合该法规的相关规定，需现场检测建筑中楼板，并规定了现场检测应依据的准。  
> 澳大利亚《建筑法规》的FV 5.2条指出，若要证实建筑中墙的空气声隔声性能是否符合该法规的相关规定，需现场检测建筑中的墙，并规定了现场检测应依据的标准。

#### 2.4.2
竣工声学检测应包括主要功能房间的室内噪声级、隔声性能及混响时间。
> **条文说明**  
> 检测项目应包括所建设声学工程类型相关的国家标准涉及的相关指标。  
> 室内噪声级检测应依据现行国家标准《民用建筑隔声设计标准》GB 50118的有关规定。  
> 隔声性能检测应依据现行国家标准《声学建筑和建筑构件隔声测量 第4部分：房间之间空气声隔声的现场测量》GB/T 19889.4、《声学 建筑和建筑构件隔声测量 第5部分：外墙构件和外墙空气声隔声的现场测量》GB/T 19889.5、《声学 建筑和建筑构件隔声测量 第7部分：楼板撞击声隔声的现场测量》GB/T 19889.7、《声学 建筑和建筑构件隔声测量 第14部分：特殊现场测量导则》GB/T 19889.14、《建筑隔声评价标准》GB/T 50121的有关规定。  
> 混响时间检测应依据现行国家标准《室内混响时间测量规范》GB/T 50076的有关规定。

## 3 建筑光环境

### 3.1 一般规定

#### 3.1.1
对光环境有要求的场所应进行采光和照明设计计算，并应符合本规范规定。
> **条文说明**  
> 根据“保障人身健康，以及促进能源资源节约利用”的要求，设置此条文。  
> 在设计阶段应对采光和人工照明效果进行设计计算，可有效保证工程质量，确保采光和照明光环境满足设计要求。

#### 3.1.2
光环境设计时应综合协调天然采光和人工照明；人员活动场所的光环境应满足视觉要求，其光环境水平应与使用功能相适应。
> **条文说明**  
> 建筑光环境应同时考虑天然采光和人工照明，各场所应提供足够的光环境水平来保证人身安全和不同的使用功能，在没有特殊说明的情况下，本规范规定的照度为参考平面上的维持平均照度。

#### 3.1.3
照明设置应符合下列规定：
1.  当下列场所正常照明供电电源失效时，应设置应急照明：
    1) 工作或活动不可中断的场所，应设置备用照明；
    2) 人员处于潜在危险之中的场所，应设置安全照明；
    3) 人员需有效辨认疏散路径的场所，应设置疏散照明。
2.  在夜间非工作时间值守或巡视的场所，应设置值班照明。
3.  需警戒的场所，应根据警戒范围的要求设置警卫照明。
4.  在可能危及航行安全的建（构）筑物上，应根据国家相关规定设置障碍照明。
> **条文说明**  
> 备用照明是在当正常照明因电源失效后，可能会造成爆炸、火灾和人身伤亡等严重事故的场所，或停止工作将造成很大影响或经济损失的场所而设的继续工作用的照明，或在发生火灾时为了保证消防作用能正常进行而设置的照明。  
> 安全照明是在正常照明因电源失效后，为确保处于潜在危险状态下的人员安全而设置的照明，如使用圆盘锯等作业场所。  
> 疏散照明是在正常照明因电源失效后，为了避免发生意外事故，而需要对人员进行安全疏散时，在出口和通道设置的指示出口位置及方向的疏散标志灯和为照亮疏散通道而设置的照明。  
> 值班照明是在非工作时间里，为需要夜间值守或巡视值班的车间、商店营业厅、展厅等场所提供的照明。它对照度要求不高，可以利用工作照明中能单独控制的一部分，也可利用应急照明，对其电源没有特殊要求。  
> 在重要的厂区、库区等有警戒任务的场所，为了防范的需要，应根据警戒范围的要求设置警卫照明。  
> 在飞行区域建设的高楼、烟囱、水塔以及在飞机起飞和降落的航道上等，对飞机的安全起降可能构成威胁，应按民航部门的规定，装设障碍标志灯；船舶在夜间航行时航道两侧或中间的建筑物、构筑物等，可能危及航行安全，应按交通部门有关规定，在有关建筑物、构筑物或障碍物上装设障碍标志灯。

#### 3.1.4
对人员可触及的光环境设施，当表面温度高于70℃时，应采取隔离保护措施。
> **条文说明**  
> 光环境设施包括采光设施（如导光管集光器）和人工照明设施。

#### 3.1.5
各种场所严禁使用防电击类别为0类的灯具。
> **条文说明**  
> 国家标准《灯具 第1部分：一般要求与试验》GB 7000.1-2015规定了灯具防电击分为0类、Ⅰ类、Ⅱ类和Ⅲ类。0类灯具已停止生产、销售和使用，因为这种灯具仅依靠基本绝缘来防护直接接触的电击，一旦绝缘失效，灯具外露可导电部分带电将导致电击危害。实际应用最多的是Ⅰ类灯具，Ⅰ类灯具除基本绝缘外，外露可导电部分应连接PE线以接地。而具有双层绝缘或加强绝缘的Ⅱ类灯具，和采用安全特低电压（SELV）供电的Ⅲ类灯具则使用较少，多用于局部照明（如台灯、工作灯、手提灯等）。

### 3.2 采光设计

#### 3.2.1
采光设计应根据建筑特点和使用功能确定采光等级。
> **条文说明**  
> 本条为采光设计的一般原则和基本要求，不同采光等级对应的采光有效进深及相应窗地面积比可参考表2，但不能简单作为设计依据。

#### 3.2.2
采光设计应以采光系数为评价指标，并应符合下列规定：
1.  采光等级与采光系数标准值应符合表3.2.2-1的规定。
2.  光气候区划应按本规范附录B确定。各光气候区的光气候系数应按表3.2.2-2确定。

**表3.2.2-1 采光等级与采光标准值**

| 采光等级 | 侧面采光 | 侧面采光 | 顶部采光 | 顶部采光 |
| :--- | :--- | :--- | :--- | :--- |
|  | 采光系数 标准值(%) | 室内天然光照度 标准值(1x) | 采光系数 标准值(%) | 室内天然光照度 标准值(1x) |
| Ⅰ | 5 | 750 | 5 | 750 |
| Ⅱ | 4 | 600 | 3 | 450 |
| Ⅲ | 3 | 450 | 2 | 300 |
| Ⅳ | 2 | 300 | 1 | 150 |
| Ⅴ | 1 | 150 | 0.5 | 75 |

> 注：表中所列采光系数标准值适用于我国Ⅲ类光气候区，其他光气候区的采光系数标准值应按本条第2款规定的光气候系数进行修正。

**表3.2.2-2 光气候系数**

| 光气候区类别 | Ⅰ类 | Ⅱ类 | Ⅲ类 | Ⅳ类 | Ⅴ类 |
| :--- | :--- | :--- | :--- | :--- | :--- |
| 光气候系数K | 0.85 | 0.90 | 1.00 | 1.10 | 1.20 |
| 室外天然光设计照度值(1x) | 18000 | 16500 | 15000 | 13500 | 12000 |

> **条文说明**  
> 本条按场所的采光等级、规定了各级相应的采光系数标准值和室内天然光照度值，采光系数标准值和室内天然光照度标准值应为参考平面上的平均值。  
> 我国地域广大，天然光状况相差甚远，若以相同的采光系数规定采光标准不尽合理，在室外取相同的临界照度时我国天然光丰富区较之天然光不足区全年室外平均总照度相差约为50％。为了充分利用天然光资源，取得更多的利用时数，对不同的光气候区应取不同的室外设计照度，即在保证一定室内照度的情况下，各地区规定不同的采光系数。

#### 3.2.3
对天然采光需求较高的场所，应符合下列规定：
1.  卧室、起居室和一般病房的采光等级不应低于Ⅳ级的要求；
2.  普通教室的采光等级不应低于Ⅲ级的要求；
3.  普通教室侧面采光的采光均匀度不应低于0.5。
> **条文说明**  
> 根据《建筑采光设计标准》GB 50033-2013的研究和实测调研，在窗地面积比为1/6时与采光等级Ⅳ级的采光系数标准要求有较好的对应关系，且根据实测调研，卧室、起居室（厅）的采光系数多数大于1/6。与窗地面积比相比，对卧室和起居室（厅）的采光系数标准值进行规定则更为准确地保障室内采光环境。对普通教室来说，营造舒适健康的教室采光环境，能够更好地保护学生视力，同时提高学习效率。病房里的病人与正常人相比非但活动空间很小，有的甚至失去行为能力，而且心理要承受巨大的压力，日光环境可以调节病人的昼夜和季节性的人体节律、接受紫外线、改善睡眠、减少压力、愉悦心情。  
> 根据2013年发布的“NDRC/UNDP/GEF中国逐步淘汰白炽灯、加快推广节能灯”项目中对《中小学绿色照明视觉环境评价要求》的研究成果，对普通教室侧面采光的采光均匀度提出要求。采光均匀度为采光区域的采光系数最低值与采光系数平均值的比值。

#### 3.2.4
长时间工作或停留的场所室内各表面的反射比应符合表3.2.4的规定。

**表3.2.4 反射比**

| 表面名称 | 反射比 |
| :--- | :--- |
| 顶棚 | 0.6~0.9 |
| 墙面 | 0.3~0.8 |
| 地面 | 0.1~0.5 |

> **条文说明**  
> 本条的目的在于使室内人员视野内亮度分布控制在眼睛能适应的水平上，良好平衡的适应亮度可以提高视觉敏锐度、对比灵敏度和眼睛的视功能效率，从而提升工作学习效率。视野内不同亮度分布也影响视觉舒适度，应当避免由于眼睛不断地适应调节引起视疲劳的过高或过低的亮度对比，因此应该合理设计室内各表面的反射比。本条一般房间主要是指长时间视觉工作或学习的房间或场所。

#### 3.2.5
长时间工作或停留的场所应设置防止产生直接眩光、反射眩光、映像和光幕反射等现象的措施。
> **条文说明**  
> 本条目的在于保证室内舒适健康天然光环境和提升室内人员的工作学习效率。

#### 3.2.6
博物馆展厅室内顶棚、地面、墙面应选择无光泽的饰面材料；对光敏感展品或藏品的存放区域不应有直射阳光，采光口应有减少紫外辐射、调节和限制天然光照度值及减少曝光时间的措施。
> **条文说明**  
> 光泽被定义为物体表面镜面反射能力与完全镜面反射能力的接近程度。对于镜面，入射光几乎全部沿镜面方向反射，对于“无光泽”表面，入射光在任何角度反射都一样，出现所谓漫反射现象。为确保展陈效果，博物馆展厅室内围护结构表面应选择非镜面反射材料，如亚光或无光表面等。  
> 直射阳光会产生直接眩光和光斑，还将导致厅内温度升高。天然光紫外线含量大，并随气候、时间变化。因而采光口应有减少紫外线辐射、调节和限制天然光照度值和减少曝光时间的构造措施。如采用可调节百叶窗、格栅、窗帘、防紫外线涂层玻璃等以利光环境的营造和藏品保存。对光敏感和特别敏感展品的展厅，不开放时采光口应能关闭，以控制藏品的曝光时间减至最少。

#### 3.2.7
主要功能房间采光窗的颜色透射指数不应低于80。
> **条文说明**  
> 与人工照明相比，天然采光的显色性是其一大优势。采光除保证采光的数量，即提高系统效率外，还应重视采光质量，其中显色性就是很重要的指标。我们通常以颜色透射指数作为评价指标，按照CIE的评价标准，可分为90、80、60、20各档，采光系统的显色性应达到优良。颜色透射指数的测试可按现行国家标准《建筑外窗采光性能分级及检测方法》 GB/T 11976的规定进行。

#### 3.2.8
建筑物设置玻璃幕墙时应符合下列规定：
1.  在居住建筑、医院、中小学校、幼儿园周边区域以及主干道路口、交通流量大的区域设置玻璃幕墙时，应进行玻璃幕墙反射光影响分析；
2.  长时间工作或停留的场所，玻璃幕墙反射光在其窗台面上的连续滞留时间不应超过30min；
3.  在驾驶员前进方向垂直角20°、水平角±30°、行车距离100m内，玻璃幕墙对机动车驾驶员不应造成连续有害反射光。
> **条文说明**  
> 玻璃幕墙有害反射光是光污染的一种形式，光污染产生的眩光会让人感到不舒服。周边设有玻璃幕墙时，玻璃幕墙的反射光照射在建筑窗台面，在与水平面夹角0°～45°的范围内的连续滞留时间不应超过30min。同时，应避免玻璃幕墙反射光对驾驶员的影响，减少相关事故发生的可能性。玻璃幕墙反射光影响可通过相应软件进行计算。  
> 长期工作或停留场所是指除走廊、楼梯间、门厅、电梯厅、卫生间等外的供人学习、工作、生活的主要功能场所。

### 3.3 室内照明设计

#### 3.3.1
室内照明设计应根据建筑使用功能和视觉作业要求确定照明水平、照明方式和照明种类。
> **条文说明**  
> 本条为照明设计的一般原则，室内照度水平应能满足使用功能的要求。照明水平包括照度、照度均匀度、眩光限制、闪烁与频闪限制、颜色质量等。

#### 3.3.2
灯具选择应满足场所环境的要求，并应符合下列规定：
1.  存在爆炸性危险的场所采用的灯具应有防爆保护措施；
2.  有洁净度要求的场所应采用洁净灯具，并应满足洁净场所的有关规定；
3.  有腐蚀性气体的场所采用的灯具应满足防腐蚀要求。
> **条文说明**  
> 各场所使用灯具时，应首先考虑场所环境的要求选择合适的灯具，包括防护等级、温湿度要求等。存在爆炸性的危险场所采用的灯具应符合现行国家标准《爆炸性环境 第1部分：设备 通用要求》GB 3836.1和《爆炸危险环境电力装置设计规范》GB 50058的规定；洁净室灯具应符合现行国家标准《洁净室灯具用技术要求》GB 24461的规定；不同腐蚀性物质的环境，灯具选择可参照现行国家标准《化工企业腐蚀环境电力设计规程》HG/T 20666的规定。

#### 3.3.3
光环境要求较高的场所，照度水平应符合下列规定：
1.  连续长时间视觉作业的场所，其照度均匀度不应低于0.6；
2.  教室书写板板面平均照度不应低于500 lx，照度均匀度不应低于0.8；
3.  手术室照度不应低于750 lx，照度均匀度不应低于0.7；
4.  对光特别敏感的展品展厅的照度不应大于50 lx，年曝光量不应大于50 klx·h；对光敏感的展品展厅的照度不应大于150lx，年曝光量不应大于360 klx·h。
> **条文说明**  
> 建筑照明应提供足够的照明来保证人身安全和不同的使用功能。对于展厅，由于紫外辐射易引起展品变褪色，而红外辐射使展品温度上升，使展品产生干化、变形、裂纹等。展品变褪色损害程度取决于受辐射的程度，曝光时间和辐射光的光谱特性及不同材料吸收辐射的能力和经受影响的能力，环境因素如高温、高湿和大气中各种活性气体亦可增加展品变褪色速度。光对展品的损害作用的大小与展品上的曝光量（照度与时间的乘积）成正比，为此应将曝光量限制在最小范围内。曝光量包括展览及非展览时的全部光照。照度均匀度是指照度最小值与平均值的比值。

#### 3.3.4
长时间视觉作业的场所，统一眩光值UGR不应高于19。
> **条文说明**  
> 各类照明场所的统一眩光值（UGR）是参照国际照明委员会（CIE）标准《室内工作场所照明（Lighting of Indoor Work Places）》CIE S 008/E-2001的规定制定。此计算方法根据CIE 117号出版物《室内照明的不舒适眩光（Discomfort Glare in Interior Lighting ）》（1995）和 CIE 147 号出版物《小光源、特大光源及复杂光源的眩光（Glare from small， large and complex sources）》（2002）的公式制定。

#### 3.3.5
长时间工作或停留的房间或场所，照明光源的颜色特性应符合下列规定：
1.  同类产品的色容差不应大于5SDCM；
2.  一般显色指数（Ra）不应低于80；
3.  特殊显色指数（R9）不应小于0。
> **条文说明**  
> 选用同类灯或灯具的颜色偏差应尽量小，以达到最佳照明效果。美国国家标准研究院（ANSI） C78.376《荧光灯的色度要求》要求的荧光灯的色容差小于4 SDCM，美国能源部（DOE）紧凑型荧光灯（CFL）能源之星要求的荧光灯的色容差小于7 SDCM，以及美国国家标准研究院（ANSI）C38.377 《固态照明产品的色度要求》的LED产品色容差小于7 SDCM，而我国现行国家标准《单端荧光灯 性能要求》GB/T 17262和《双端荧光灯 性能要求》GB/T 10682等均要求荧光灯光源色容差小于5 SDCM。根据国内已经完成的光源在照明项目的使用情况，色容差7 SDCM仍能够觉察出颜色偏差。因此，为提高照明质量，在本标准中规定长时间工作或停留的房间或场所照明色容差不应大于5 SDCM。  
> 一般显色指数与特殊显色指数是描述光源显色性的指标，其限值根据国际照明委员会（C1E）标准《室内工作场所照明（Lighting of Indoor Work Places）》CIE S 008/E-2001的规定制定，该标准R a 取值为90、80、60、40和20。此外，如果光谱中红色部分较为缺乏，会导致光源复现的色域大大减小，也会导致照明场景呆板、枯燥，从而影响照明环境质量。对于显示性不加限制势必会影响室内光环境质量，美国对用于室内照明的LED灯也限定其一般显色指数R a 不低于80，特殊显色指数R 9 不应为负数。

#### 3.3.6
儿童及青少年长时间学习或活动的场所应选用无危险类（RG0）灯具；其他人员长时间工作或停留的场所应选用无危险类（RG0）或1类危险（RG1）灯具或满足灯具标记的视看距离要求的2类危险（RG2）的灯具。
> **条文说明**  
> 根据现行国家标准《灯和灯系统的光生物安全性》GB/T 20145/CIE S 009/E：2002对灯具的分类，从光生物安全的角度可将灯分为四类，包括无危险类（RG0）、Ⅰ类危险（RG1）、Ⅱ类危险（RG2）和Ⅲ类危险（RG3）。  
> 1）无危险类 无危险类是指灯在标准极限条件下也不会造成任何光生物危害，满足此要求的灯应当满足以下条件：在8h（30000s）内不造成光化学紫外危害；在1000s内不造成近紫外危害；在10000s内不造成对视网膜蓝光危害；在10s内不造成对视网膜热危害；在1000s内不造成对眼睛的红外辐射危害。  
> 2）1类危险  
> 该分类是指在曝光正常条件限定下，灯不产生危害，满足此要求的灯应当满足以下条件：在10000s内不造成光化学紫外危害；在300s内不造成近紫外危害；在100s内不造成对视网膜蓝光危害；在10s内不造成对视网膜热危害；在100s内不造成对眼睛的红外辐射危害。  
> 3）2类危险  
> 该分类是指灯不产生对强光和温度的不适反应的危害，满足此要求的灯应当满足以下条件：在1000s内不造成光化学紫外危害；在100s内不造成近紫外危害；在0.25s内不造成对视网膜蓝光危害；在0.25s内不造成对视网膜热危害；在10s内不造成对眼睛的红外辐射危害。  
> 4）3类危险  
> 该分类是指灯在更短瞬间造成光生物危害，当限制量超过2类危险的要求时，即为3类危险。在进行照明设计时，应当根据使用功能的需求选择光生物安全性能满足要求的照明产品。  
> 与成人相比，儿童及青少年眼睛光谱透过率更高，也可能出现长时间盯视灯具的情况，为避免产生潜在光生物危害，应采用无危险类的灯具。  
> 国际电工委员会《IEC 62471方法应用于评价光源和灯具的蓝光危害》1EC 62788文件中也指出，单位光通的蓝光危害效应与光源相关色温具有较强的相关性，且光源相关色温越高其危害的可能性越大。

#### 3.3.7
各场所选用光源和灯具的闪变指数（ PstLM ）不应大于1；儿童及青少年长时间学习或活动的场所选用光源和灯具的频闪效应可视度（SVM）不应大于1.0。
> **条文说明**  
> 人眼可直接观察到的光的明暗波动可能导致视觉性能的下降，引起视觉疲劳甚至如癫痫、偏头痛等严重的健康问题。国际电工委员会（IEC）标准《一般照明用设备 电磁兼容抗扰度要求 第1部分：一种光闪烁计和电压波动抗扰度测试方法（Equipment for general lighting purposes-EMC immunity requirements-Part 1：An objective light flickermeter and voltage fluctuation immunity test method）》IEC TR 61547- 1：2017提出光源和灯具的可见闪烁可采用闪变指数（ P st LM ）进行评价，其数值等于1表示50％的实验者刚好感觉到闪烁。  
> 频闪效应是一种非直接可见频闪，频率范围在80Hz以上，可能引起身体不适及头痛，对人体健康有潜在的不良影响。国际照明委员会（CIE）于2016年提出了技术文件《随时间波动的照明系统的视觉现象——定义及测量模型（Visual Aspects of Time-Modulated Lighting Systems-Definitions and Measurement Models）》CIE TN 006：2016，该文件分别从基础研究和模型以及现有标准两个方面对评价频闪的方法和指标进行了梳理，并提出了频闪效应可视度（stroboscopic effect visibility measure），即SVM指标，SVM等于1.0是理论上可以感觉到的限值，也是欧盟法规中拟定的下一阶段目标。考虑到幼儿和中小学生的视力尚未发育成熟，需要更严格地控制频闪，因此本条规定中小学校、托儿所、幼儿园建筑主要功能房间采用的照明光源和灯具的SVM值不大于1.0，有助于保护儿童青少年的视力健康。本条适用于儿童青少年学习和长期停留的场所，如各类教室、阅览室、活动室、宿舍和寝室等。

#### 3.3.8
对辨色要求高的场所，照明光源的一般显色指数（Ra）不应低于90。
> **条文说明**  
> 展品照明要有良好的显色性，才能获得好的观赏效果。  
> 通常陈列绘画、彩色织物展品、藏画修理、文物复制室、标本制作室、化妆台、手术室、重症监护室、美术教室、美术制作室等场所对辨色要求较高，一般显色指数需要达到90以上。

#### 3.3.9
对光敏感及特别敏感的展品或藏品的存放区域，使用光源的紫外线相对含量应小于20μW/1m。
> **条文说明**  
> 由于紫外辐射易引起展品变褪色，而红外辐射使展品温度上升，使展品产生干化、变形、裂纹等。展品变褪色损害程度取决于受辐射的程度，曝光时间和辐射光的光谱特性及不同材料吸收辐射的能力和经受影响的能力，环境因素如高温、高湿和大气中各种活性气体亦可增加展品变褪色速度。光对展品的损害作用的大小与展品上的曝光量（照度与时间的乘积）成正比，为此应将曝光量限制在最小范围内。曝光量包括展览及非展览时的全部光照。一般荧光灯的紫外线相对含量为40μW/ lm ～250μW/1m，卤素灯的紫外线相对含量不大于130μW/1m，因此不能用于对光敏感及特别敏感展品的照明中。

#### 3.3.10
各场所设置的疏散照明、安全标识牌亮度和对比度应满足消防安全的要求。
> **条文说明**  
> 为确保紧急情况下人员安全有序疏散，各场所的疏散路径有必要设置疏散照明，其设置按照消防应急照明的要求执行。此外，建筑各类公共场所的安全标识牌得到了广泛的应用，为保证这些安全标识牌能够正常发挥作用，避免因看不清安全标识牌而带来的潜在危险，其应有足够的亮度和对比度并清晰可见。

#### 3.3.11
备用照明的照度标准值应符合下列规定：
1.  正常照明失效可能危及生命安全，需继续正常工作的医疗场所，备用照明应维持正常照明的照度；
2.  高危险性体育项目场地备用照明的照度不应低于该场所一般照明照度标准值的50％；
3.  除另有规定外，其他场所备用照明的照度值不应低于该场所一般照明照度标准值的10％。
> **条文说明**  
> 正常照明失效可能危及生命安全，需继续正常工作的医疗场所包括重症监护室、早产儿室、心血管造影检查室等；高危险性体育项目是指专业技术性强、危险性大、安全保障要求高的体育项目，如游泳、高山滑雪、自由式滑雪、单板滑雪、潜水、攀岩等。具体高危险性项目根据国务院批准的《高危险性体育项目目录》执行。 供消防作业及救援人员在火灾时继续工作场所的备用照明，应符合防火规范的有关规定。

#### 3.3.12
安全照明的照度标准值应符合下列规定：
1.  正常照明失效可能使患者处于潜在生命危险中的专用医疗场所，安全照明的照度应为正常照明的照度值；
2.  大型活动场地及观众席安全照明的平均水平照度值不应小于 20 lx；
3.  除另有规定外，其他场所安全照明的照度值不应低于该场所一般照明照度标准值的10％，且不应低于15 lx。
> **条文说明**  
> 正常照明出现故障时，安全照明是保证人员安全的重要手段。因此，应对场所的安全照明的照度值给出最低要求。正常照明失效可能使患者处于潜在生命危险中的专用医疗场所包括手术室、抢救室及类似场所。

### 3.4 室外照明设计

#### 3.4.1
室外公共区域照度值和一般显色指数应符合表3.4.1的规定。

**表3.4.1 室外公共区域照度值和一般显色指数**

| 场所 | 场所 | 平均水平 照度最低值 E h·av (lx) | 最小水平 照度 E h·min (lx) | 最小垂直 照度 E v·min (lx) | 最小半柱面 照度 E sc·min (lx) | 一般显色 指数最低值 |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| 道路 | 主要道路 | 15 | 3 | 5 | 3 | 60 |
| 道路 | 次要道路 | 10 | 2 | 3 | 2 | 60 |
| 道路 | 健身步道 | 20 | 5 | 10 | 5 | 60 |
| 活动场地 | 活动场地 | 30 | 10 | 10 | 5 | 60 |

> 注：水平照度的参考平面为地面，垂直照度和半柱面照度的计算点或测量点高度为1.5m。

> **条文说明**  
> 为确保室外公共活动区域的人员安全，降低潜在风险，各场所根据人流量、视觉活动特点及相应安全要求确定照度标准值和一般显色指数要求。

#### 3.4.2
园区道路、人行及非机动车道照明灯具上射光通比的最大值不应大于表3.4.2的规定值。

**表3.4.2 灯具上射光通比的最大允许值**

| 照明技术参数 | 应用条件 | 环境区域 | 环境区域 | 环境区域 | 环境区域 |
| :--- | :--- | :--- | :--- | :--- | :--- |
|  |  | E0 区、E1 区 | E2 区 | E3 区 | E4 区 |
| 上射光通比 | 灯具所处位置水平面以上的光通量 与灯具总光通量之比(%) | 0 | 5 | 15 | 25 |

> **条文说明**  
> 灯具的上射光通过大气散射使夜天空发亮，妨碍天文观测，另一方面对上射光进行限制也是为了使光充分照在被照场地上，有利于节能（表3）。

#### 3.4.3
当设置室外夜景照明时，对居室的影响应符合下列规定：
1.  居住空间窗户外表面上产生的垂直面照度不应大于表3.4.3-1的规定值。
2.  夜景照明灯具朝居室方向的发光强度不应大于表3.4.3-2的规定值。
3.  当采用闪动的夜景照明时，相应灯具朝居室方向的发光强度最大允许值不应大于表3.4.3-2中规定数值的1/2。

**表3.4.3-1 居住空间窗户外表面的垂直照度最大允许值**

| 照明技术参数 | 应用条件 | 环境区域 | 环境区域 | 环境区域 | 环境区域 |
| :--- | :--- | :--- | :--- | :--- | :--- |
|  |  | E0 区、E1 区 | E2 区 | E3 区 | E4 区 |
| 垂直面照度 E v (lx) | 非熄灯时段 | 2 | 5 | 10 | 25 |
| 垂直面照度 E v (lx) | 熄灯时段 | 0 * | 1 | 2 | 5 |

> 注：*当有公共（道路）照明时，此值提高到1lx。

**表3.4.3-2 夜景照明灯具朝居室方向的发光强度最大允许值**

| 照明技术参数 | 应用条件 | 环境区域 | 环境区域 | 环境区域 | 环境区域 |
| :--- | :--- | :--- | :--- | :--- | :--- |
|  |  | E0 区、E1 区 | E2 区 | E3 区 | E4 区 |
| 灯具发光强度 I(cd) | 非熄灯时段 | 2500 | 7500 | 10000 | 25000 |
| 灯具发光强度 I(cd) | 熄灯时段 | 0 * | 500 | 1000 | 2500 |

> 注：1 本表不适用于瞬时或短时间看到的灯具；  
> 2 *当有公共（道路）照明时，此值提高到500cd。

> **条文说明**  
> 照明对居住者的影响，通常与暗黑的居室里射入的户外照明光线在窗上形成的垂直照度相关，本条是为了限制进入房间的光线数量。  
> 除窗面的垂直照度外，影响居住者的另外一个因素来源于为可直接看到灯具的刺眼的光线，因此，应对灯具朝向居室窗方向的光强进行限制。

#### 3.4.4
建筑立面和标识面应符合下列规定：
1.  建筑立面和标识面的平均亮度不应大于表3.4.4的规定值。
2.  E1区和E2区里不应采用闪烁、循环组合的发光标识，在所有环境区域这类标识均不应靠近住宅的窗户设置。

**表3.4.4建筑立面和标识面的平均亮度最大允许值**

| 照明技术参数 | 应用条件 | 环境区域 | 环境区域 | 环境区域 | 环境区域 |
| :--- | :--- | :--- | :--- | :--- | :--- |
|  |  | E0 区、E1 区 | E2 区 | E3 区 | E4 区 |
| 建筑立面亮度 1 L b (cd/㎡) | 被照面平均亮度 | 0 | 5 | 10 | 25 |
| 标识亮度 2 L s (cd/㎡) | 外投光标识被照面平均亮度； 对自发光广告标识， 指发光面的平均亮度 | 50 | 400 | 800 | 1000 |

> 注：本表中L s 值不适用于交通信号标识。

> **条文说明**  
> 本条主要针对居住建筑的装饰性照明以及照明标识的亮度水平进行限制，避免对周边产生光污染影响，影响居民的正常生活和休息。

#### 3.4.5
室外照明采用泛光照明时，应控制投射范围，散射到被照面之外的溢散光不应超过20％。
> **条文说明**  
> 本条规定了投光照明的溢散光控制指标，提高照明效果，满足节能要求，同时避免光污染。

### 3.5 检测与验收

#### 3.5.1
竣工验收时，应根据建筑类型及使用功能要求对采光、照明进行检测。
> **条文说明**  
> 由于现场条件的影响，采光与照明效果的计算值与实际值会存在一定的差异，因此要求工程项目竣工验收时，对采光和照明进行现场测量，测量方法可按照国家现行标准执行。当场 所数量 较大时，采光和照明测量可采取抽样的方式，如对于室内同类场所测量的数量不应少于总数的5％，且不少于2个；对于道路照明测量的数量不应少于总数的10％，且不少于1条；而对于应急照明则应全数检测。

#### 3.5.2
采光测量项目应包括采光系数、采光均匀度、反射比和颜色透射指数。
> **条文说明**  
> 对于采光系统的竣工验收检测，应至少保证能够对规定的几项采光指标进行检测，从而保证安全、舒适、健康的室内光环境。采光测量可按照现行国家标准《采光测量方法》GB/T 5699执行。

#### 3.5.3
照明测量应符合下列规定：
1.  室内各主要功能房间或场所的测量项目应包括照度、照度均匀度、统一眩光值、色温、显色指数、闪变指数和频闪效应可视度；
2.  室外公共区域照明的测量项目应包括照度、色温、显色指数和亮度；
3.  应急照明条件下，测量项目应包括各场所的照度和灯具表面亮度。
> **条文说明**  
> 对于照明系统的竣工验收检测，应至少保证能够对规定的几项照明指标进行检测，从而保证安全、舒适、健康的室内光环境。对于室外公共区域照明应对场所的照度测量项目应包括本规范规定的相应指标。照明测量可按照现行国家标准《照明测量方法》GB/T 5700执行。

## 4 建筑热工

### 4.1 一般规定

#### 4.1.1
建筑热工设计应与地区气候相适应。建筑气候区划应符合本规范附录C的规定。
> **条文说明**  
> 建筑热工设计需求与室外气候条件密切相关。采用气候区划以明确不同地区建筑所处 的气候条件，可以针对性地进行设计工作。因此将区划纳入强制性条文以保证设计的标准和质量。  
> 建筑与气候相适应是建筑设计的基本原则，也是创造良好室内外热环境的必要手段。建筑气候区划从较大尺度上将全国按照不同的气候特征进行划分，可以区分我国不同地区气候条件对建筑影响的差异性，明确各气候区的建筑基本要求，从总体上做到合理利用气候资源，防止气候对建筑的不利影响。  
> 建筑气候区划是反映我国建筑与气候关系的区域划分，由于影响建筑气候区划的因素很多，各气候要素的时空分布不一，各气候要素对建筑气候区划的作用也不相同。因此，区划必须分级。这样可使各级分区中，突出各级区内建筑的相似性和差异性。本区划主要用于宏观控制，是高层次的，必须有较大的概括性。为了便于应用，目前的区划系统以避繁就简为宜。各级区的划分原则必须有一定的建筑气候特征和相应的建筑基本要求为依据，假使仅有某一气候要素在程度上的较小差别，而目前建筑技术经济上无明显的反应，在这样的地区范围内就没有必要再划区。据此，全国划分为7个一级区，20个二级区。一级区反映全国建筑气候上大的差异，二级区反映各大区内建筑气候上小的不同。

#### 4.1.2
建筑设计时，应按建筑所在地的建筑热工设计区划进行保温、防热、防潮设计。建筑热工设计区划应符合本规范附录D的规定。
> **条文说明**  
> 现行与热工设计相关的强制性条文的规定多按照气候区属分别提出要求。明确建筑所在地的气候区属是确定其热工设计标准的基础和依据。因此将区划纳入强制性条文以保证设计的标准和质量。  
> 这一分区是在建筑气候区划的基础上，根据建筑热工设计的实际需要，分区名称要直观贴切等要求制定的。由于目前建筑热工设计主要涉及冬季保温和夏季隔热，主要与冬季和夏季的温度状况有关，因此，用累年最冷月（即一月）和最热月（即七月）平均温度作为分区主要指标，累年日平均温度小于或等于5℃和大于或等于25℃的天数作为辅助指标，将全国划分成5个区，即严寒、寒冷、夏热冬冷、夏热冬暖和温和地区，并提出相应的设计要求。  
> 由于我国地域辽阔，每个热工一级区划的面积非常大。例如：同为严寒地区的黑龙江漠河和内蒙古额济纳旗，最冷月平均温度相差18.3℃、HDD18相差4110。对于寒冷程度差别如此大的两个地区，采用相同的设计要求显然是不合适的。因此，有必要对一级区划进行细分。  
> 热工设计二级分区采用“HDD18、CDD26”作为区划指标，将建筑热工各一级区划进行细分。与一级区划指标（最冷、最热月平均温度）相比，该指标既表征了气候的寒冷和炎热的程度，也反映了寒冷和炎热持续时间的长短。采用该指标在一级区划的基础上进行细分，保证了一、二级区划间不会产生矛盾。  
> 需要指出的是：影响气候的因素很多，地理距离的远近并不是造成气候差异的唯一因素。海拔高度、地形、地貌、大气环流等对局地气候影响显著。因此，各区划间一定会出现相互参差的情况。这在只有5个一级区划时已经有所表现，但由于一级区划的尺度较大，现象并不明显。当将一级区划细分后，这一现象非常突出。因此，二级区划没有再采用分区图的形式表达，改用表格的形式给出每个城市的区属。这样避免了复杂图形可能带来的理解偏差，各城市的区属明确、边界清晰，且便于规范的执行和管理。

### 4.2 保温设计

#### 4.2.1
严寒、寒冷、夏热冬冷及温和A区的建筑应进行保温设计。
> **条文说明**  
> 本条对具体要进行强制性保温设计的地域做出了规定，保证了保温设计能够正确执行。  
> 本条按照不同气候区满足建筑保温需求的程度进行了规定，不同气候区应根据不同的需求程度在设计中有所区别。  
> 中国地域广阔、气候差别巨大，从南到北冬季的寒冷程度逐渐增强。同样是针对冬季保温问题，不同地区的建筑应对的程度一定有所不同。本条按照中国建筑热工区划设计要求对不同气候区在保温设计方面分别作出规定。

#### 4.2.2
非透光围护结构内表面温度与室内空气温度的差值应符合表4.2.2的规定。

**表4.2.2 非透光围护结构内表面温度与室内空气温度的允许温差**

| 非透光围护结构部位 | 允许温差△t(K) |
| :--- | :--- |
| 外墙 | ≤ t i — t d |
| 楼、屋面 | ≤ t i — t d |
| 地面 | ≤ t i — t d |
| 地下室外墙 | ≤ t i — t d |

> 注：△t为非透光围护结构的内表面温度与室内空气温度的温差， t i 为室内空气温度，t d 为室内空气的露点温度。

> **条文说明**  
> 建筑非透光围护结构的热工性能要求主要从节能和消除结露两个方面进行约束。随着国内节能设计标准的逐步提高，一般情况下，符合节能要求的建筑围护结构能够保证冬季供暖期的内表面温度大于室内空气的露点温度。但由于节能规范是按照气候区提出热工限值，而每个城镇的冬季室外温度是有差别的。因此，本条是对节能规范限值的补充，是围护结构保温设计的最低要求。围护结构保温设计还应符合现行国家标准《建筑节能与可再生能源利用通用规范》GB 55015的有关规定。  
> 内表面温度的计算方法应符合国家标准《民用建筑热工设计规范》GB 50176-2016的要求。

### 4.3 防热设计

#### 4.3.1
夏热冬暖、夏热冬冷地区及寒冷B区的建筑应进行防热设计。
> **条文说明**  
> 本条对具体要进行强制性防热设计的地域做出了规定，保证防热设计能够正确执行。  
> 防热也是建筑节能的重要措施，防热设计还应符合现行国家标准《建筑节能与可再生能源利用通用规范》GB 55015的有关规定。

#### 4.3.2
在给定两侧空气温度及变化规律的情况下，外墙和屋面内表面最高温度应符合表4.3.2的规定。

**表4.3.2 外墙和屋面内表面最高温度限值**

| 房间类型 | 自然通风 房间 | 空调房间 | 空调房间 |
| :--- | :--- | :--- | :--- |
|  |  | 重质围护结构 (D≥2.5) | 轻质围护结构 (D<2.5) |
| 外墙内表面最高温度 θ i,max | ≤ t e,max | ≤t i +2 | ≤t i +3 |
| 屋面内表面最高温度 θ i,max | ≤ t e,max | ≤t i +2.5 | ≤t i +3.5 |

> 注： t e,max 表示室外逐时空气温度最高值； t i 表示室内空气温度。

> **条文说明**  
> 人体热感觉除了与环境温湿度相关，还包括与周围环境之间的辐射换热。夏季过高的围护结构内壁面温度会对人产生强烈的热辐射，造成人体不适。  
> 对夏季围护结构内表面温度最高值做出了规定，以保证建筑围护结构的隔热性能，保证夏季室内热环境能够满足正常使用的要求。  
> 围护结构内表面温度是衡量围护结构隔热水平的重要指标，夏季内表面温度太高，易造成室内过热，影响人体健康。应把围护结构内表面温度与室内空气温度的差值控制在规范允许的范围内，防止室内过热，保持室内舒适度要求。  
> 在我国南方地区夏季屋面外表面综合温度会达到60℃以上，西墙外表面温度达50℃以上，围护结构外表面综合温度的波幅可超过20℃，在这种强波动作用下，会造成围护结构内表面温度出现较大的波动，使围护结构内表面平均辐射温度大大超过人体热舒适热辐射温度，直接影响室内热环境的好坏和建筑能耗的大小。对屋面、外墙（特别是西墙）要进行隔热处理，合理设计围护结构热工参数，减少传进室内的热量和降低围护结构的内表面温度；合理地选择外围护结构的材料和构造形式，达到防热所要求的热工指标。  
> 由于围护结构材料的热物性和构造形式不同，围护结构所体现出的隔热特性也不同。在我国夏热冬冷和夏热冬暖地区，无论是自然通风、连续空调还是间歇空调，热稳定性好的厚重围护结构与加气混凝土、混凝土空心砌块以及金属夹芯板等热稳定性差的轻质围护结构相比，外围护结构内表面温度波幅差别很大。通过计算分析和实验、工程现场测试，在热阻相同条件下（0.52m 2 ·K/W），连续空调室内温度为26℃时，实心页岩砖外墙内表面温度波幅值为1℃以内，加气混凝土外墙内表面温度波幅为2.0℃以上，金属夹芯板外墙内表面温度波幅为3.0℃以上。可以看出在热阻相同条件下，轻质围护结构比重质围护结构抵抗室外热扰动能力要差得多，所以对轻质围护结构内表面最高温度比重质围护表面最高温度的限值要宽松。  
> 在现行国家标准《民用建筑热工设计规范》GB 50176中，隔热设计将围护结构内表面最高温度低于当地夏季室外计算温度最高值作为评价指标，相当于在自然通风条件下240mm实心砖墙（清水墙，内侧抹20mm石灰砂浆）的隔热水平。随着经济水平的发展和国家对建筑节能工作的重视，240mm砖墙的隔热水平远远达不到节能建筑墙体的热工性能，而且越来越多的建筑采用了空调方式进行室内环境的控制，这些情况都与30多年前发生了根本性的改变。但自然通风条件下围护结构隔热性能同样重要，尤其在评价被动建筑热性能时具有重要的作用，在南方还有许多建筑利用自然通风来改善室内热环境。因此，本规范采用自然通风和空调二种工况条件下来评价围护结构的隔热性能。  
> 本规范给出了隔热设计的评价标准，评价仅仅围绕围护结构本身的隔热性能，只反映出围护结构固有的热特性，而不是整个房间的热特性。分别按空调房间还是自然通风房间给出不同的设计限值。具体评价标准的基准条件是外墙的两侧分别给定空气温度及变化规律，即外墙外表面为当地的夏季最热月典型日的逐时室外综合温度，自然通风房间外墙内侧空气温度平均值比室外空气温度平均值高1.5℃、波幅小1.5℃；空调房间外墙内侧空气温度为固定的 26℃。由于围护结构重质与轻质对热稳定性影响很大，所以分别对重质围护结构和轻质围护结构的内表面最高温度作出不同的标准规定。  
> 把屋面内表面最高温度作为控制围护结构隔热性能的强制性条文给予规定，是由于屋面所受到的太阳辐射比外墙更大，而且屋面内表面的表面放热系数还小于外墙内表面，屋面的内表面温度比外墙的内表面温度更难控制。在气候相同条件下屋面内表面平均辐射温度大于外墙内表面平均辐射温度，所以将屋面的内表面最高温度限值在外墙基础上提高了0.5K。

#### 4.3.3
在给定两侧空气温度和变化规律的情况下，非透光围护结构内表面温度的计算应符合下列规定：
1.  应采用一维非稳态方法进行计算，并应按房间的运行工况确定相应的边界条件；
2.  计算模型应选取外墙、屋面的平壁部分；
3.  当外墙、屋面采用2种以上不同构造，且各部分面积相当时，应对每种构造分别进行计算，内表面温度的计算结果应取最高值。
> **条文说明**  
> 为保证本设计结果的正确性、一致性和可比性，能够对非透光围护结构的隔热性能进行控制，需要对设计计算方法和边界条件、设计参数进行规定。  
> 计算方法是设计计算的核心，直接决定设计结果。本条对计算时必须满足的条件进行规定，以保证计算结果的正确性，实现整个热工设计过程的闭环。  
> 条文引用的非稳态计算方法是满足夏季隔热设计精度要求所必需的。国家标准《民用建筑热工设计规范》GB 50176-2016中附录C.3中，对隔热性能计算的方法、计算模型、边界条件、计算参数，以及计算软件都提出了要求。

### 4.4 防潮设计

#### 4.4.1
供暖建筑非透光围护结构中的热桥部位应进行表面结露验算，并应采取保温措施确保热桥内表面温度高于房间空气露点温度。
> **条文说明**  
> 建筑围护结构中的水分，会改变围护结构的热传递方式，降低围护结构的保温性能；对围护结构材料产生破坏，影响建筑寿命；滋生霉菌，影响室内空气品质，威胁人体健康。  
> 热桥部位是围护结构热工性能的薄弱环节，确保热桥部位在冬季不结露是避免围护结构内表面霉变的必要条件。从保证建筑正常使用、保证健康室内环境的角度考虑，将冬季热桥内表面温度高于房间空气露点温度作为强制性要求。

#### 4.4.2
非透光围护结构热桥部位的表面结露验算应符合以下规定：
1.  当冬季室外计算温度低于0.9℃时，应对热桥部位进行内表面结露验算。
2.  热桥部位的内表面温度计算应符合下列规定：
    1) 室内空气相对湿度应取60％；
    2) 应根据热桥部位确定采用二维或三维传热计算；
    3) 距离较小的热桥应合并计算。
3.  当热桥部位内表面温度低于空气露点温度时，应采取保温措施，并应重新进行验算。
> **条文说明**  
> 计算方法是设计计算的核心，直接决定设计结果。本条对计算时必须满足的条件进行规定，以保证计算结果的正确性，实现整个热工设计过程的闭环。  
> 热桥部分是否结露是供暖建筑围护结构设计的重要内容。为保证设计结果的正确性、一致性和可比性，能够对非透光围护结构的热桥部位的性能进行有效控制，需要对计算方法进行规 定。  
> 在围护结构自身热阻的作用下，当室内计算条件一定时，只有当室外空气温度低于某一特定的值时，围护结构内表面温度才有可能低于室内空气露点温度，存在表面结露的风险。因此，可以确定出无须进行内表面结露验算的范围，以简化结露验算设计。在建筑围护结构常用材料中，由于钢筋混凝土的导热系数较大，条文中规定需要进行表面结露验算的室外计算温度临界值是按照160mm厚钢筋混凝土为例计算确定的。  
> 需要特别强调的是，当热桥节点有结露风险时，必须对节点构造设计进行修改，并再次复核验算，直至满足要求。  
> 当两个热桥之间的距离小于热桥节点厚度的3倍时，为避免热桥间的相互影响，应将两个热桥合并计算。

#### 4.4.3
供暖期间，围护结构中保温材料因内部冷凝受潮而增加的重量湿度允许增量，应符合表4.4.3的规定；相应冷凝计算界面内侧最小蒸汽渗透阻应大于按式（4.4.3）计算的蒸汽渗透阻。

**表4.4.3 保温材料因内部冷凝受潮而增加的重量湿度允许增量**

| 保温材料 | 重量湿度允许增量 [△w](%) |
| :--- | :--- |
| 多孔混凝土(泡沫混凝土、加气混凝土等) (ρ 0 =500kg/m³~700kg/m³) | 4 |
| 矿渣和炉渣填料 | 2 |
| 水泥纤维板 | 5 |
| 矿棉、岩棉、玻璃棉及制品(板或毡) | 5 |
| 模塑聚苯乙烯泡沫塑料(EPS) | 15 |
| 挤塑聚苯乙烯泡沫塑料(XPS) | 10 |
| 硬质聚氨酯泡沫塑料(PUR) | 10 |
| 酚醛泡沫塑料(PF) | 10 |
| 胶粉聚苯颗粒保温浆料(自然干燥后) | 5 |
| 复合硅酸盐保温板 | 5 |

> 式中：H0， i ——冷凝计算界面内侧所需的蒸汽渗透阻（m2·h·Pa/g）；  
> H0，e——冷凝计算界面至围护结构外表面之间的蒸汽渗透阻（m2·h·Pa/g）；  
> ρ0——保温材料的干密度（kg/m3）；  
> δ i ——保温材料厚度（m）；  
> [△ω]——保温材料因内部冷凝受潮而增加的重量湿度的允许增量（％），应按本规范表4.4.3的规定取值；  
> Z——供暖期天数；  
> Ps，c——冷凝计算界面处与界面温度θc对应的饱和水蒸气分压（Pa）。

> **条文说明**  
> 为保证围护结构中的水分不会对保温材料的耐久性和保温性能造成显著的影响，需要对材料层中的水分增量提出限值要求。  
> 材料的耐久性和保温性与其潮湿状况密切相关。湿度过高会明显降低其机械强度，产生破坏性变形。同时，湿度过高会使材料的保温性能显著降低。因此，对于一般供暖建筑，虽然允许结构内部含有一定的水分，但是为了保证材料的耐久性和保温性，材料的湿度不得超过一定限度。允许增量系指经过一个供暖期，保温材料重量湿度的增量在允许范围之内，以便供暖期过后，保温材料中的冷凝水逐渐向内侧和外侧散发，而不致在内部逐年积聚，导致湿度过高。  
> 通过对不同含水率下保温材料导热系数的变化研究，可以认为材料在含水率小于本规范表4.4.3中的规定值时，导热系数的变化对围护结构的热工性能影响较小，因此，将材料的含水率按本规范第4.4.3条中的 规定值控制。  
> 为保证设计结果的正确性、一致性和可比性，对围护结构满足本规范第4.4.3条规定的重量湿度允许增量的蒸汽渗透阻的计算方法进行统一规定。  
> 国家标准《民用建筑热工设计规范》GB 50176-2016第7.1.4条给出了冷凝计算界面内侧所需的蒸汽渗透阻的计算方法。该条文还对各项计算参数的取值进行了说明。

#### 4.4.4
屋面、地面、外墙、外窗应能防止雨水和冰雪融化水浸入室内。
> **条文说明**  
> 防水是建筑围护结构的基本功能。  
> 屋面、地面、外墙、外窗等建筑外围护结构必须能够阻挡雨水和冰雪融化水进入室内，以保证建筑内部的设施不受雨雪侵扰，保证建筑的正常使用。

### 4.5 检测与验收

#### 4.5.1
竣工验收时，应按照竣工验收资料对围护结构的保温、防热、防潮性能进行复核。
> **条文说明**  
> 建筑热工设计目标的实现主要由建筑建造时所采用的材料和构造决定。围护结构的材料、构造是建筑竣工验收的主要内容，因此本条要求按照竣工图纸和资料对围护结构保温、隔热、防潮性能进行校验，以避免由于材料性能、尺寸偏差等降低围护结构热工性能。

#### 4.5.2
冬季非透光围护结构内表面温度的检验应在供暖系统正常运行后进行，检测持续时间不应少于72h，监测数据应逐时记录。检测结果应符合本规范第4.2.2条的规定。
> **条文说明**  
> 为保证设计目标的实现、保证建筑的保温性能，需要对围护结构内表面温度的检验方法做出统一规定。  
> 为保证保温设计的目标能够实现，对建筑进行检验是重要手段。本条对检测时必须满足的条件进行规定，以保证检测结果的正确性，实现整个热工设计过程的闭环。  
> 《居住建筑节能检验标准》JGJ/T 132-2009的第6章中，对围护结构热桥的内表面温度检测方法进行了规定，包括了检测设备、测点布置、测试要求、测试时间、数据处理等方面的内容。对围护结构平壁部分的内表面温度的检测可以参照执行。

#### 4.5.3
夏季非透光围护结构内表面最高温度的检验应在围护结构施工完成12个月后进行，检测持续时间不应少于24h，内表面温度应取内表面所有测点相应时刻检测结果的平均值。检测结果应符合本规范第4.3.2条的规定。
> **条文说明**  
> 为保证设计目标的实现、保证建筑的隔热性能，需要对围护结构内表面温度的检验方法做出统一规定。  
> 为保证隔热设计的目标能够实现，对建筑进行检验是重要手段。本条对检测时必须满足的条件进行规定，以保证检测结果的正确性，实现整个热工设计过程的闭环。  
> 《居住建筑节能检验标准》JGJ/T 132-2009的第9章中，对围护结构的内表面温度检测方法进行了规定，包括了检测部位、检测时间、气候条件、测试要求、检测项目、测点布置、数据采集、数据处理等方面的内容。对热桥内表面温度的检测可以参照执行。

#### 4.5.4
围护结构中保温材料重量湿度检测时，受检样品应经过一个供暖期；检测方法应与保温材料吸放湿特性相适应。检测结果应符合本规范表4.4.3的规定。
> **条文说明**  
> 建筑在施工过程中，材料中的含水率会出现上升。经过一段时间材料含水率达到平衡状态后进行实验，以避免施工过程的影响。由于不同材料的吸放湿特性差别很大。受材料性能的影响，不同材料含湿量的测试应当采用合适的测试方法。对于多孔的水汽可以渗透的材料采用《建筑材料及制品的湿热性能 含湿率的测定 烘干法》GB/T 20313进行测试。

## 5 室内空气质量

### 5.1 一般规定

#### 5.1.1
室内空气污染物控制应按下列顺序采取控制措施：
1.  控制建筑选址场地的土壤氡浓度对室内空气质量的影响；
2.  控制建筑空间布局有利于污染物排放；
3.  控制建筑主体、节能工程材料、装饰装修材料的有害物质释放量满足限值；
4.  采取自然通风措施改善室内空气质量；
5.  设置机械通风空调系统，必要时设置空气净化装置进行空气污染物控制。
> **条文说明**  
> 本条规定了室内空气污染物控制应遵循的基本原则，对民用建筑室内空气污染物控制采取的措施按照优先考虑的顺序作了规定。  
> 建筑的核心用途是供人员在其中工作、生活，在建设全生命期内均需要防止或减小室内空气污染物对人身健康安全的危害。本规范提出了建筑本体散发的基础污染物指标强制性限值要求和技术措施，同时为了实现建筑使用阶段室内空气污染指标满足或优于卫生要求，提出了除控制建筑本体散发的污染外，还要结合通风、空气净化等主动手段，对室内空气污染物进行控制的技术要求。具体措施是采用大量的引入新风还是采取室内循环空气净化进行控制，应结合节能要求综合分析。通风及空气净化等相关要求应符合现行国家标准《民用建筑供暖通风与空气调节通用规范》（在编）的有关规定。

#### 5.1.2
工程竣工验收时，室内空气污染物浓度限量应符合表5.1.2的规定。

**表5.1.2 室内空气污染物浓度限量**

| 污染物 | Ⅰ类民用建筑工程 | Ⅱ类民用建筑工程 |
| :--- | :--- | :--- |
| 氡(Bq/m³) | ≤150 | ≤150 |
| 甲醛(mg/m³) | ≤0.07 | ≤0.08 |
| 氨(mg/m³) | ≤0.15 | ≤0.20 |
| 苯(mg/m³) | ≤0.06 | ≤0.09 |
| 甲苯(mg/m³) | ≤0.15 | ≤0.20 |
| 二甲苯(mg/m³) | ≤0.20 | ≤0.20 |
| TVOC( mg/m³) | ≤0.45 | ≤0.50 |

> 注：Ⅰ类民用建筑：住宅、医院、老年人照料房屋设施、幼儿园、学校教室、学生宿舍、军人宿舍等民用建筑；Ⅱ类民用建筑：办公楼、商店、旅馆、文化娱乐场所、书店、图书馆、展览馆、体育馆、公共交通等候室、餐厅、理发店等民用建筑。

#### 5.1.3
室内空气污染物浓度测量应符合下列规定：
1.  除氡外，污染物浓度测量值均应为室内测量值扣除室外上风向空气中污染物浓度测量值（本底值）后的测量值；
2.  污染物浓度测量值的极限值判定应采用全数值比较法。
> **条文说明**  
> 5.1.2、5.1.3 室内空气污染物检测结果要全部符合本规范的规定，各房间检测点检测值的平均值也要全部符合本规范的规定，否则，不能判定为室内环境质量合格。  
> 关于室内氡限量值，世界卫生组织（WHO）的室内氡浓度建议值为100Bq/m 3 ；《中国室内氡研究》实测调查结果表明，我国全年平均住宅室内氡浓度大于100Bq/m 3 的房间数小于10％；现行国家标准《室内氡及其子体控制要求》GB/T 16146规定新建建筑物室内氡浓度目标水平为100Bq/m 3 。本规范将室内氡限量值确定为150Bq/m 3 ，系主要考虑到本规范规定自然通风房屋的氡检测条件是对外门窗封闭24h后进行检测的情况。  
> 关于室内甲醛浓度指标，WHO建议室内甲醛限量值为0.10mg/m 3 ；现行国家标准《室内空气质量标准》GB/T 18883、《公共场所卫生指标及限值要求》GB 37488将使用房屋室内甲醛限量值定为0.10mg/m 3 ，两者均包含装饰装修材料、活动家具、生活工作过程等产生的甲醛污染；《中国室内环境概况调查与研究》资料表明，活动家具对室内甲醛污染的贡献率统计值约为30％，本规范将Ⅰ类民用建筑室内甲醛浓度指标定为0.07mg/m 3 ，相当于为房屋使用后活动家具等进入预留了适当净空间。  
> 关于空气中苯限量值，现行国家标准《室内空气质量标准》GB/T 18883、《公共场所卫生指标及限值要求》GB 37488将苯限量定为0.11mg/m 3 。由于民用建筑工程禁止在室内使用以苯为溶剂的涂料、胶粘剂、处理剂、稀释剂及溶剂，因此，近年来室内空气中苯污染已经受到一定控制，同时考虑到活动家具等对室内苯污染的贡献率，本规范将Ⅰ类建筑空气中苯污染限值定为不大于0.06mg/m 3 。  
> 关于氨、甲苯、二甲苯限量值，Ⅰ类民用建筑工程室内氨、甲苯、二甲苯限量值指标均比现行国家标准《室内空气质量标准》GB/T 18883和《公共场所卫生指标及限值要求》GB 37488要求更加严格。  
> Ⅰ类民用建筑工程室内TVOC限量指标0.45mg/m 3 的确定，与甲醛等情况类似，同样为活动家具进入预留了适当净空间。  
> 本规范表5.1.2中室内环境指标（除氡外）均为在扣除室外空气本底值的基础上制定的，是工程建设阶段必须实实在在进行有效控制的范围，室外空气污染程度不是工程建设单位能够控制的。扣除室外空气本底值可以突出控制建筑材料和装修材料所产生的污染。检测现场及其周围应无影响空气质量检测的因素，检测时室外风力不大于5级，选取适当地点的适当高度进行（注意避免地面附近污染源，如窨井等），并与室内样品同步采集，雾霾重度污染及以上情况，不宜进行现场检测。本规范表5.1.2中的氡浓度，系指现场检测的实测氡浓度值，不再进行平衡氡子体换算，与国际接轨。  
> 第5.1.3条规定污染物浓度测量值的极限值判定，采用全数值比较法，依据的是现行国家标准《数值修约规则与极限数值的表示和判定》GB/T 8170，在该标准中提出有两种极限值的判定方法，即修约值比较法和全数值比较法，并进一步明确，当各种极限数值（包括带有极限偏差值的数值）未加说明时，均指采用全数值比较法；如规定采用修约值比较法，应在标准中加以说明。考虑到许多检测人员对现行国家标准《数值修约规则与极限数值的表示和判定》GB/T 8170标准不熟悉，因此，在本规范第5.1.3条中进行了明确。

#### 5.1.4
空气净化装置在空气净化处理后不应产生新的污染。
> **条文说明**  
> 当采用材料控制、通风等手段仍不能满足空气质量要求时，应采用机械通风加空气净化系统。  
> 室内空气净化是指从空气中分离或去除一种或多种空气污染物。室内空气污染的种类主要包括颗粒污染、生物污染和化学污染等，这些污染物主要源自建筑材料、电气设备、人自身活动和室外空气等，空气净化是控制室内污染物的重要手段，它不仅可以降低室内污染物浓度，改善室内空气质量、创造健康舒适的室内环境，而且可降低人们对新风量的需求，减少空调能耗。  
> 空气净化装置不能成为室内空气的新污染源，应限制其净化过程中所产生的有害副产品量（如臭氧等），即二次污染。  
> 空气净化装置选择时其净化技术指标、电气安全和臭氧发生指标等应符合现行国家标准《空气过滤器》GB/T 14295、《通风系统用空气净化装置》GB/T 34012和《空气净化器》GB/T 18801等标准要求。

#### 5.1.5
装饰装修时，严禁在室内使用有机溶剂清洗施工用具。
> **条文说明**  
> 不在室内用溶剂清洗施工用具，可减轻有害气体对室内环境的污染，也是施工人员必须具备的保护室内环境的基本素质。

### 5.2 场地土壤氡控制

#### 5.2.1
建筑工程设计前应对建筑工程所在城市区域土壤中氡浓度或土壤表面氡析出率进行调查，并应提交相应的调查报告。未进行过区域土壤中氡浓度或土壤表面氡析出率测定的，应对建筑场地土壤中氡浓度或土壤氡析出率进行测定，并应提供相应的检测报告。
> **条文说明**  
> 国内外土壤氡及室内氡浓度水平调查表明：建筑物室内氡主要源于地下土壤、岩石和建筑物使用的建筑材料（有地质构造断层的区域也会出现土壤氡浓度高的情况），因此，建筑工程项目在设计前应了解土壤氡水平。通过工程开始前的调查，可以知道建筑工程所在区域是否已进行过土壤氡测定及测定的结果如何。目前已初步完成了全国18个城市的土壤氡浓度测定（2km×2km网格布检测点，部分1km×1km网格点为检测点），并算出了土壤氡浓 度平均值，其他大多数城市未进行过土壤氡测定，当地的土壤氡实际情况不清楚，因此，工程设计勘察阶段应进行土壤氡现场测定。  
> 根据《中国室内氡研究》（科学出版社2013.1）的内容和国内外进行室内氡浓度水平调查结果，建筑物室内氡主要源于建筑材料和地下土壤、岩石，有地质构造断层的区域也会出现土壤氡浓度高的情况，因此，在建筑设计前应了解土壤氡水平。通过工程开始前的调查，可以知道建筑工程所在城市区域是否已进行过土壤氡测定，以及测定的结果如何。《中国土壤氡概况》（科学出版社2006.1）已公布了全国部分城市区域的初步土壤氡浓度测定结果，未进行过土壤氡测定的城区土壤氡情况不清楚，在工程设计勘察阶段应进行土壤氡现场测定。  
> 本条所说区域测定，系指某城市、某开发区等城市区域性土壤氡水平实测调查，由于这项工作涉及建设、规划、国土等部门，是一项基础性科研工作。因此，宜专门立项，组织相关技术人员参加，最后调查成果应经过科技鉴定并发表，以保证其权威性。

#### 5.2.2
当建筑工程场地土壤氡浓度测定结果大于20000Bq/m3且小于30000Bq/m3，或土壤表面氡析出率大于0.05Bq/（m2·s）且小于0.1Bq/（m2·s）时，应采取建筑物底层地面抗开裂措施。
> **条文说明**  
> 2003年至2004年住房和城乡建设部组织了全国土壤氡概况调查，利用国内几十年积累的放射性航空遥测资料，进行了约500万平方公里的国土面积的土壤氡浓度推算，得出全国土壤氡浓度的平均值为7300Bq/m 3 。并粗略推算出了全国144个重点城市的平均土壤氡浓度（注：由于多方面原因，这些推算结果不可作为工程勘察设计阶段，在决定是否进行工地土壤氡浓度测定时，判定该城市土壤氡浓度平均值的依据），首次编制了中国土壤氡浓度背景概略图（1：8000000）。与此同时，在统一方案下，运用了多种检测方法，开展了18个城市的土壤氡实地调查（连同过去的共20个城市），所取得的数据具有较高的可信度，并与航测研究结果进行了比较研究，两方面结果大体一致。全国土壤氡水平调查结果表明，大于10000Bq/m 3 的城市约占被调查城市总数的约20％。  
> 建筑工程在工程勘察设计阶段可根据建筑工程所在城市区域土壤氡调查资料，结合本规范的要求，确定是否采取防氡措施。当地土壤氡浓度实测平均值较低（即不大于10000Bq/m 3 ）且工程地点无地质断裂构造时，土壤氡对工程的影响不大，工程可不进行土壤氡浓度测定。当已知当地土壤氡浓度实测平均值较高（即大于10000Bq/m 3 ）或工程地点有地质断裂构造时，工程仍需要进行土壤氡浓度测定。土壤氡浓度不大于20000Bq/m 3 时或土壤表面氡析出率不大于0.05Bq/（m 2 ·s）时，工程设计中可不采取防氡工程措施。  
> 一般情况下，建筑工程地点的土壤氡调查目的在于发现土壤氡浓度异常点。本规范中所提出的几个档次土壤氡浓度限量值（10000Bq/m 3 、20000Bq/m 3 、30000Bq/m 3 、50000Bq/m 3 ）考虑了以下因素：  
> （1）从郑州市1996年所做的土壤氡调查中，发现土壤氡浓度达到15000Bq/m 3 左右时，该地点平房建筑物室内氡浓度接近国家标准限量值；土壤氡浓度达到25000Bq/m 3 左右时，该地点平房建筑物室内氡浓度明显超过国家标准限量值。我国部分地方的调查资料显示，当土壤氡浓度达到50000Bq/m 3 左右时，室内氡超标问题比较突出。从这些材料出发，考虑到不同防氡措施的不同难度，将采取不同防氡措施的土壤氡浓度极限值分别定在20000Bq/m 3 、30000Bq/m 3 、50000Bq/m 3 。  
> （2）在一般数理统计中，可以认为偏离平均值（7300Bq/m 3 ）2倍（即14600Bq/m 3 ）为超常，3倍（即21900Bq/m 3 ）为更超常，作为确认土壤氧明显高出的临界点，符合数据处理的惯例。  
> （3）参考了美国对土壤氡潜在危害性的分级：1级为小于9250Bq/m 3 ，2级为（9250～18500） Bq/m 3 ，3级为（18500～27750）Bq/m 3 ，4级为大于27750Bq/m 3 。  
> （4）参考了瑞典的经验：大于50000Bq/m 3 的地区定为“高危险地区”，并要求加厚加固混凝土地基和地基下通风结构。本规范将必须采取严格防氡措施的土壤氡浓度极限值定位50000Bq/m 3 。  
> （5）参考了俄罗斯的经验：他们将45年内积累的1.8亿个氡测量原始数据，以50000Bq/m 3 为基线，圈出全国氡危害草图。经比例尺逐步放大后发现，几乎所有大范围的室内高氡均落在50000Bq/m 3 等值线内，说明50000Bq/m 3 应是土壤（岩石）氡可能造成室内氡超标的限量值。  
> 大量资料表明，土壤氡来自土壤本身和深层的地质断裂构造两方面，因此，当土壤氡浓度高到一定程度时，需分清两者的作用大小，此时进行土壤天然放射性核素测定是必要的。对于Ⅰ类民用建筑工程而言，当土壤的放射性内照射指数（ I Ra ）大于1.0或外照射指数（ I r ）大于1.3时，原土再作为回填土已不合适，也没有必要继续使用，而采取更换回填土的办法，简便易行，有利于降低工程成本。Ⅰ类民用建筑工程要求采用放射性内照射指数（ I Ra ）不大于1.0、外照射指数（ I r ）不大于1.3的土壤作为回填土使用。  
> 土壤氡水平高时，为阻止氡气通道，可以采取多种工程措施，但比较起来，采取地下防水工程的处理方式最好，因为这样既可以防氡，又可以防止地下水，事半功倍，降低成本。而且地下防水工程措施有成熟的经验，可以做得很好。只是土壤氡浓度特别高时，才要求采取综合的防氡工程措施，其中“综合防氡措施”可参照现行行业标准《民用建筑氡防治技术规程》JGJ/T 349的要求进行。在实施防氡基础工程措施时，要加强土壤氡泄漏监督，保证工程质量。  
> 我国南方部分地区地下水位浅（特别是多雨季节）难以进行土壤氡浓度测量。有些地方土壤层很薄，甚至基层全为石头，同样难以进行土壤氡浓度测量。这种情况下，可以使用测量氡析出率的办法了解地下氡的析出情况。实际上，对室内影响的大小直接决定于土壤氡的析出率。  
> 我国目前缺少土壤表面氡析出率方面的深入研究，本规范中所列氡析出率方面的限量值及与土壤氡浓度值的对应关系均是现阶段研究结果。待今后积累更多资料后，将进一步修改完善。

#### 5.2.3
当建筑工程场地土壤氡浓度测定结果不小于30000Bq/m3且小于50000Bq/m3，或土壤表面氡析出率大于或等于0.1Bq/（m2·s）且小于0.3Bq/（m2·s）时，除应采取建筑物底层地面抗开裂措施外，还必须按一级防水要求，对基础进行处理。
> **条文说明**  
> 对基础进行的一级防水处理应按现行国家标准《地下工程防水技术规范》GB 50108的有关规定。

#### 5.2.4
当建筑工程场地土壤氡浓度平均值不小于50000Bq/m3或土壤表面氡析出率平均值大于或等于0.3Bq/（m2·s）时，应采取建筑物综合防氡措施。
> **条文说明**  
> 建筑物综合防氡措施可参照现行行业标准《民用建筑氡防治技术规程》JGJ/T 349的有关规定。该标准中给出了设计、施工时需要采取的建筑物综合防氡措施。

### 5.3 材料控制

#### 5.3.1
建筑工程所使用的砂、石、砖、实心砌块、水泥、混凝土、混凝土预制构件等无机非金属建筑主体材料，其放射性限量应符合表5.3.1的规定。

**表5.3.1 无机非金属建筑主体材料的放射性限量**

| 测定项目 | 限量 |
| :--- | :--- |
| 内照射指数( I Ra ) | ≤1.0 |
| 外照射指数( I γ ) | ≤1.0 |

> **条文说明**  
> 建筑材料中所含的长寿命天然放射性核素，会放射γ射线，直接对人体构成外照射危害。γ射线外照射危害的大小与建筑材料中所含的放射性同位素的比活度相关，还与建筑物空间大小、几何形状、放射性同位素在建筑材料中的分布均匀性等相关。  
> 目前，国内外普遍认同的意见是：将建筑材料的内、外照射问题一并考虑，经过理论推导、简化计算，提出了一个控制内、外照射的统一数学模式，即：  
> 式中： C Ra ——建筑主体材料或装饰装修材料中天然放射性核素镭-226的放射性比活度；   C Th ——建筑主体材料或装饰装修材料中天然放射性核素钍-232的放射性比活度；  
> C k ——建筑主体材料或装饰装修材料中天然放射性核素钾-40的放射性比活度。  
> 本条文说明参考了如下文献：  
> [1] OECD，NEA，Exposure to Radiation from the Natural Radioactivity in Building Materials.Report by an NEA，Group of Experts.1979，1-34.  
> [2] Karpov VI，et al，Estimation of Indoor Gamma Dose Rate.Healthphys.1980，38（5）.  
> [3] Krisiuk ZM，et al.Study and Standardization of the Radioactivity of Building Materials.In ERDA-tr 250，1976，1-62.  
> 建筑工程中使用的无机非金属建筑主体材料制品混凝土、预制构件等制品，如所使用的原材料（水泥、沙石等）的放射性指标合格，制品可不再进行放射性指标检验。  
> 凡能同时满足公式（1）、公式（2）要求的建筑材料，即为控制氡-222的内照射危害及γ外照射危害达到了 “可以合理达到的尽可能低水平”，即在长期连续的照射中，人体所受到的电离辐射照射的年有效剂量当量不超过1mSv。我国早在1986年就接受了这一概念，并依此形成了国家标准《建筑材料放射性核素限量》GB 6566。

#### 5.3.2
建筑工程中所使用的混凝土外加剂，氨的释放量不应大于0.10％，氨释放量测定方法应按国家现行有关标准的规定执行。
> **条文说明**  
> 本条是对能释放氨的混凝土外加剂作出的规定，例如，混凝土外加剂中的防冻剂采用能挥发氨气的氨水、尿素、硝铵等后，建筑物内氨气严重污染的情况将会发生，有关部门已规定不允许使用这类防冻剂。混凝土外加剂中氨测定方法应符合现行国家标准《混凝土外加剂中释放氨的限量》GB 18588的有关规定。

#### 5.3.3
建筑工程所使用的石材、建筑卫生陶瓷、石膏制品、无机粉状粘结材料等无机非金属装饰装修材料，其放射性限量应分类符合表5.3.3的规定。

**表5.3.3 无机非金属装饰装修材料放射性限量**

| 测定项目 | 限量 | 限量 |
| :--- | :--- | :--- |
|  | A类 | B类 |
| 内照射指数( I Ra ) | ≤1.0 | ≤1.3 |
| 外照射指数( I γ ) | ≤1.3 | ≤1.9 |

> **条文说明**  
> 无机非金属建筑装饰装修材料制品（包括石材），连同无机粉状粘结材料一起，主要用于贴面材料。无机非金属建筑装饰装修材料按照放射性限量可分为A类装修材料、B类装饰装修材料，限量值与现行国家标准《建筑材料放射性核素限量》GB 6566一致。不满足A类装修材料要求，但满足内照射指数（ I Ra ）不大于1.3和外照射指数（ I r ）不大于1.9要求的为B类装饰装修材料。

#### 5.3.4
Ⅰ类民用建筑工程室内装饰装修采用的无机非金属装饰装修材料放射性限量应符合本规范5.3.3表中A类的规定。
> **条文说明**  
> 无论是Ⅰ类或Ⅱ类民用建筑工程，使用的无机非金属建筑主体材料均必须符合《建筑材料放射性核素限量》GB 6566的要求。无机非金属建筑装饰装修材料按照放射性限量可分为A类装修材料、B类装饰装修材料，限量值与现行国家标准《建筑材料放射性核素限量》GB 6566一致。对Ⅰ类民用建筑工程严格要求是必要的，因此，Ⅰ类民用建筑只允许使用A类无机非金属装饰装修材料。

#### 5.3.5
室内装饰装修中所使用的木地板及其他木质材料，严禁采用沥青、煤焦油类防腐、防潮处理剂。
> **条文说明**  
> 沥青类防腐、防潮处理剂会持续释放出污染严重的有害气体，故严禁用于室内木地板及其他木质材料的处理。

#### 5.3.6
室内装饰装修时，严禁使用苯、工业苯、石油苯、重质苯及混苯等含苯稀释剂和溶剂。
> **条文说明**  
> 民用建筑室内装修工程中采用稀释剂和溶剂按现行国家标准《涂装作业安全规程安全管理通则》GB 7691的有关规定，禁止使用含苯（包括工业苯、石油苯、重质苯，不包括甲苯、二甲苯）的涂料、稀释剂和溶剂。混苯中含有大量苯，故也不应使用。

### 5.4 检测与验收

#### 5.4.1
建筑材料进场检验应符合下列规定：
1.  无机非金属建筑主体材料和建筑装饰装修材料进场时，应查验其放射性指标检测报告；
2.  室内装饰装修中所采用的人造木板及其制品进场时，应查验其游离甲醛释放量检测报告；
3.  室内装饰装修中所采用的水性涂料、水性处理剂进场时，应查验其同批次产品的游离甲醛含量检测报告；溶剂型涂料进场时，施工单位应查验其同批次产品的VOC、苯、甲苯＋ 二甲苯、乙苯含量检测报告，其中聚氨酯类的应有游离二异氰酸酯（TDI＋HDI）的含量检测报告；
4.  室内装饰装修中所采用的水性胶粘剂进场时，应查验其同批次产品的游离甲醛含量和VOC检测报告；溶剂型、本体型胶粘剂进场时，应查验其同批次产品的苯、甲苯＋二甲苯、VOC含量检测报告，其中聚氨酯类的应有游离甲苯二异氰酸酯（TDI）的含量检测报告；
5.  幼儿园、学校教室、学生宿舍、老年人照料房屋设施等民用建筑工程室内装饰装修，应对不同产品、不同批次的人造木板及其制品的甲醛释放量和涂料、橡塑类合成材料的挥发性有机化合物释放量进行抽查复验。
> **条文说明**  
> 本条要求建筑工程主体中所采用的无机非金属材料必须有放射性指标检测报告。国家有关部门曾对无机非金属装修材料多次抽样检测，发现部分材料制品放射性超标情况突出，因此要求采用的无机非金属建筑主体材料和建筑装饰装修材料必须有放射性指标检测报告。多年来，大理石石材未发现超标情况，可放开使用。  
> 《中国室内环境概况调查与研究》统计结果表明，装饰装修后住宅甲醛浓度超标约33％。各类装修材料的甲醛污染强度大体排序是：人造板及复合地板污染强度强，人造板家具污染强度较强，壁纸壁布污染强度居中或较弱，实木板最弱。因此，人造板及复合地板必须要严格控制。  
> VOC等挥发性有机污染物主要来自各类涂料和胶粘剂，因此，这类产品中VOC及苯、甲苯＋二甲苯、乙苯、游离二异氰酸酯的含量必须严格控制。  
> 近年来，幼儿园、学校教室的装饰装修污染问题引起社会广泛关注，反响强烈，为了严格控制幼儿园、学校教室、学生宿舍的装饰装修污染问题，必须提出更加严格要求，在选用建筑装修材料时，要求对不同产品、批次的人造木板及其制品的甲醛释放量、涂料、橡塑类合成材料的挥发物释放量进行抽查复验。  
> 相关检测方法应符合现行国家标准《民用建筑工程室内环境污染控制规范》GB 50325的有关规定。

#### 5.4.2
幼儿园、学校教室、学生宿舍、老年人照料房屋设施室内装饰装修验收时，室内空气中氡、甲醛、氨、苯、甲苯、二甲苯、TVOC的抽检量不得少于房间总数的50％，且不得少于20间。当房间总数不大于20间时，应全数检测。
> **条文说明**  
> 近年来，多地幼儿园、学校教室装饰装修后发生甲醛、VOC超标的情况，社会反响强烈，需加强监督管理。为此，幼儿园、学校教室、学生宿舍、老年人照料房屋设施装饰装修后验收时，甲醛、氡、氨、苯、甲苯、二甲苯、TVOC的抽检量增加到不得少于房间总数的50％，并不得少于20间，当房间总数少于20间时，应全数检测。检测方法应按现行国家标准《民用建筑工程室内环境污染控制标准》GB 50325执行。

#### 5.4.3
竣工交付使用前，必须进行室内空气污染物检测，其限量应符合本规范表5.1.2的规定。室内空气污染物浓度限量不合格的工程，严禁交付投入使用。
> **条文说明**  
> 室内空气污染物达标，是保障人身健康的底线要求，工程竣工验收时必须合格。本条与本规范第5.1.2条相呼应并保持一致。检测方法应按现行国家标准《民用建筑工程室内环境污染控制标准》GB 50325执行。

## 附录A 声环境功能区分类

### A.0.1
声环境功能区分类应符合表A.0.1的规定。

**表A.0.1 声环境功能区分类**

| 声环境功能区类别 | 区域特征 |
| :--- | :--- |
| 0类 | 指康复疗养区等特别需要安静的区域 |
| 1类 | 指以居民住宅、医疗卫生、文化教育、科研设计、行政办公为主要功能，需要保持安静的区域 |
| 2类 | 指以商业金融、集市贸易为主要功能，或者居住、商业、工业混杂，需要维护住宅安静的区域 |
| 3类 | 指以工业生产、仓储物流为主要功能，需要防止工业噪声对周围环境产生严重影响的区域 |
| 4类 | 指交通干线两侧一定距离之内，需要防止交通噪声对周围环境产生严重影响的区域，包括4a类和4b类两种类型。4a类为高速公路、一级公路、二级公路、城市快速路、城市主干路、城市次干路、城市轨道交通(地面段)、内河航道两侧区域;4b类为铁路干线两侧区域 |

> **条文说明**  
> 附录A是建筑环境设计的基础参数。

## 附录B 光气候区划

> **条文说明**  
> 附录B是建筑环境设计的基础参数。  
> 我国缺少照度观测资料的情况下，可以利用各地区多年的辐射观测资料及辐射光当量模型来求得各地的总照度和散射照度。根据我国273个站近30年的逐时气象数据，并利用辐射光当量模型，可以得到典型气象年的逐时总照度和散射照度。根据逐时的照度数据，可得到各地区年平均的总照度，从而可绘制我国的总照度分布图（可参照《建筑采光设计标准》GB 50033-2014中图4），并根据总照度的范围进行光气候分区。从气候特点分析，它与我国气候分布状况特别是太阳能资源分布状况也是吻合的。天然光照度随着海拔高度和日照时数的增加而增加，如拉萨、西宁地区照度较高；随着湿度的增加而减少，如宜宾、重庆地区。  
> 光气候区划的范围可按国家现行标准《建筑采光设计标准》GB 50033-2013中图A.0.1确定。

### B.0.1
光气候区划应按天然光年平均总照度（Eq）划分，并应符合表B.0.1的规定。

### B.0.2
各主要城市的光气候区划应按表B.0.2确定。

## 附录C 建筑气候区划

> **条文说明**  
> C.0.1 建筑气候一级区划指标应符合表C.0.1的规定。  
> C.0.2 建筑气候二级区划指标应符合附表C.0.2的规定。

## 附录D 建筑热工设计区划

> **条文说明**  
> D.0.1 建筑热工设计一级区划指标应符合表D.0.1的规定。  
> D.0.2 建筑热工设计二级区划指标应符合表D.0.2的规定。  
> D.0.3 全国主要城镇的建筑热工设计区属应按表D.0.3确定。