# 第三章 建筑节能与“双碳”目标的落地经验（GB 55015 / GB 50189）

## 3.1 强制性规范下的审查风暴

《建筑节能与可再生能源利用通用规范》（GB 55015-2021）的发布，意味着节能设计从“推荐性”全面转向“强制性”。专家指出，这不仅是技术升级，更是法律责任的升级。所有新建建筑必须进行碳排放计算，这一要求在最初执行阶段导致了大量施工图审查不合格。

## 3.2 工业建筑太阳能系统的边界界定

在GB 55015实施初期，关于工业厂房是否需要安装太阳能光伏系统，引发了巨大的行业争议。

1.  **争议点**：规范第5.2.1条规定“新建建筑应安装太阳能系统”。
2.  **专家裁定**：北京等地的审图专家组给出了明确的执行口径——区分有无暖通空调。
    - **2.a.** 对于设置了供暖或空调系统的丙类厂房，必须安装太阳能系统，以抵消其运营能耗。
    - **2.b.** 对于纯仓储、冷库或无空调的生产车间（即使是新建），可豁免安装。这一专家解释为大量物流地产项目节省了数百万的非必要投资，体现了实事求是的科学态度。

## 3.3 近零能耗建筑（NZEB）的施工与运维陷阱

近零能耗建筑不仅是设计的挑战，更是施工工艺的试金石。

1.  **热桥（Thermal Bridge）的微观失效**：
    - **1.a. 设计图纸**：图纸上通常只标注“断桥铝合金窗”。
    - **1.b. 现场问题**：专家在验收中发现，施工方往往忽视窗框与墙体之间的连接节点。如果保温层在窗框处断开，或者使用了普通的金属膨胀螺栓直接穿透保温层，会形成严重的热桥。专家测算，仅此一项由于施工误差导致的漏热，就可能使整窗的传热系数（K值）恶化30%以上。
    - **1.c. 对策**：专家建议采用“外挂式安装”系统，并使用预压膨胀密封带（P-tape）代替传统的发泡胶+硅胶工艺，确保气密性和热工性能的连续性。

2.  **光伏一体化（BIPV）的防水与电气风险**：
    - **2.a. 隐患**：BIPV屋顶直接作为建筑围护结构。
    - **2.b. 专家经验**：专家警告，光伏组件的寿命（25年）与建筑防水层寿命不匹配，且组件接缝处的胶条易老化漏水。专家建议，BIPV下方必须设置独立的二次防水层。此外，直流拉弧（DC Arc）是光伏火灾的主因，专家在电气审查中强制要求配备具有直流拉弧检测与快速关断功能的逆变器，这在许多早期项目中是缺失的。

## 3.4 既有建筑的低干扰改造策略

对于政府办公楼等既有公共建筑，大拆大改往往不可行。

1.  **案例**：江苏省生态环境厅办公楼改造。
2.  **技术路线**：专家摒弃了更换整面幕墙的高成本方案，转而推荐使用纳米陶瓷隔热膜进行内贴或外贴。
3.  **成效**：这种“轻介入”方案不改变建筑立面，不产生建筑垃圾，却能阻隔大部分红外线热辐射。专家将其列为既有建筑节能改造的“高性价比”推荐技术（Low-Hanging Fruit）。

## 3.5 计算书中的常见错误

专家在审查节能计算报告时，常发现以下典型错误：

1.  **自保温体系的修正系数**：设计人员常直接使用加气混凝土砌块的实验室导热系数进行计算。专家指出，必须乘以“灰缝修正系数”。由于砂浆的导热性能远高于砌块，实际墙体的保温性能会打折扣（通常折减20%-30%）。忽略此系数属于原则性错误。
2.  **照明功率密度（LPD）**：在学生宿舍设计中，设计方常按住宅标准从宽处理。专家强调，宿舍属于公共建筑范畴，必须严格执行GB 55015中关于教育建筑的LPD限值，这意味着必须全面使用高光效LED灯具，严禁使用低效光源。