# 《建筑节能与可再生能源利用通用规范》GB55015-2021

**住房和城乡建设部**  
**更新时间：2025-10-27**  
**实施时间：2022-04-01**

[全文阅读](https://www.soujianzhu.cn/WinAppNew/Gfnr.aspx?id=509) [分节阅读](https://www.soujianzhu.cn/WinAppNew/Gfnr.aspx?id=509)

## 目录
- 前言
- 1 总则
- 2 基本规定
- 3 新建建筑节能设计
  - 3.1 建筑和围护结构
  - 3.2 供暖、通风与空调
  - 3.3 电气
  - 3.4 给水排水及燃气
- 4 既有建筑节能改造设计
  - 4.1 一般规定
  - 4.2 围护结构
  - 4.3 建筑设备系统
- 5 可再生能源建筑应用系统设计
  - 5.1 —般规定
  - 5.2 太阳能系统
  - 5.3 地源热泵系统
  - 5.4 空气源热泵系统
- 6 施工、调试及验收
  - 6.1 —般规定
  - 6.2 围护结构
  - 6.3 建筑设备系统
  - 6.4 可再生能源应用系统
- 7 运行管理
  - 7.1 运行与维护
  - 7.2 节能管理
- 8 录A 不同气候区新建建筑平均能耗指标
- 9 录B 建筑分类与参数计算
- 10 C 建筑围护结构热工性能权衡判断

## 前言

中华人民共和国国家标准建筑节能与可再生能源利用通用规范  
General code for energy efficiency and renewable energy application in buildings  
GB 55015-2021

主编部门：中华人民共和国住房和城乡建设部  
批准部门：中华人民共和国住房和城乡建设部  
施行日期：2022年4月1日

中华人民共和国住房和城乡建设部公告  
2021年第173号

住房和城乡建设部关于发布国家标准《建筑节能与可再生能源利用通用规范》的公告

现批准《建筑节能与可再生能源利用通用规范》为国家标准，编号为GB 55015-2021，自2022年4月1日起实施。本规范为强制性工程建设规范，全部条文必须严格执行。现行 工程建设标准相关强制性条文同时废止。现行工程建设标准中有关规定与本规范不一致的，以本规范的规定为准。

本规范在住房和城乡建设部门户网站公开，并由住房和城乡建设部标准定额研究所组织中国建筑出版传媒有限公司出版发行。

中华人民共和国住房和城乡建设部  
2021年9月8日

### 废止的现行工程建设标准相关强制性条文

1.  《 建筑照明设计标准 》GB 50034-2013  
    第6.3.3、6.3.4、6.3.5、6.36 6.3.7、6.3.9、6.3.10、6.3.11、6.3.12、6.3.13、6.3.14、6.3.15条
2.  《 住宅设计规范 》GB 50096-2011  
    第7.1.5、7.2.3、8.1.4（2）、8.3.2、8.3.4、8.3.12条（款）
3.  《 公共建筑节能设计标准 》GB 50189-2015  
    第3.2.1、3.2.7、3.3.1、3.3.2、3.3.7、4.1.1、4.2.2、4.2.3、4.2.5、4.2.8、4.2.10、4.2.14、4.2.17、4.2.19、4.5.2、4.5.4、4.5.6条
4.  《 民用建筑太阳能热水系统应用技术标准 》GB 50364-2018  
    第3.0.4、3.0.5、3.0.7、3.0.8、4.2.3、4.2.7、5.3.2、5.4.12、5.7.2条
5.  《 地源热泵系统工程技术规范 》GB 50366-2005（2009版）  
    第3.1.1、5.1.1条
6.  《 住宅建筑规范 》GB 50368-2005  
    第7.2.2、7.2.4、8.3.1、8.3.5、8.3.8、10.1.1、10.1.2、10.1.4、10.1.5、10.1.6、10.2.1、10.2.2、10.3.1、10.3.2、10.3.3条
7.  《 建筑节能工程施工质量验收标准 》GB 50411-2019  
    第3.1.2、4.2.2、4.2.3、4.2.7、5.2.2、6.2.2、7.2.2、8.2.2、9.2.2、9.2.3、10.2.2、11.2.2、12.2.2、12.2.3、15.2.2、18.0.5条
8.  《 太阳能供热采暖工程技术标准 》GB 50495-2019  
    第1.0.5、5.1.1、5.1.2、5.1.5、5.2.13条
9.  《 民用建筑供暖通风与空气调节设计规范 》GB 50736-2012  
    第5.2.1、5.4.3 （1）、5.5.1、5.5.5、5.10.1、7.2.1、8.1.2、8.2.2、8.3.4 （1）、8.3.5 （4）、8.11.14、9.1.5（1-4）条（款）
10. 《 民用建筑太阳能空调工程技术规范 》GB 50787-2012  
    第1.0.4、3.0.6、5.3.3、5.4.2、5.6.2、6.1.1条
11. 《 严寒和寒冷地区居住建筑节能设计标准 》JGJ 26-2018  
    第4.1.3、4.1.4、4.1.5、4.1.14、4.2.1、4.2.2、4.2.6、5.1.1、5.1.4、5.1.9、5.1.10、5.2.1、5.2.4、5.2.8、5.4.3、6.2.3、6.2.5、6.2.6、7.3.2条
12. 《 夏热冬暖地区居住建筑节能设计标准 》JGJ 75-2012  
    第4.0.4、4.0.5、4.0.6、4.0.7、4.0.8、4.0.10、4.0.13、6.0.2、6.0.4、6.0.5、6.0.8、6.0.13条
13. 《 夏热冬冷地区居住建筑节能设计标准 》JGJ 134-2010  
    第4.0.3、4.0.4、4.0.5、4.0.9、6.0.2、6.0.3、6.0.5、6.0.6、6.0.7条
14. 《 辐射供暖供冷技术规程 》JGJ 142-2012  
    第3.2.2、3.8.1条
15. 《 外墙外保温工程技术标准 》JGJ 144-2019  
    第4.0.2、4.0.5、4.0.7、4.0.9条
16. 《 供热计量技术规程 》JGJ 173-2009  
    第3.0.1、3.0.2、4.2.1、5.2.1、7.2.1条
17. 《公共建筑节能改造技术规范》JGJ 176-2009  
    第5.1.1、6.1.6条
18. 《 采光顶与金属屋面技术规程 》JGJ 255-2012  
    第4.5.1条
19. 《 建筑外墙外保温防火隔离带技术规程 》JGJ 289-2012  
    第3.0.4、4.0.1条
20. 《 温和地区居住建筑节能设计标准 》JGJ 475-2019  
    第4.2.1、4.2.2、4.3.6、4.4.3条

### 关于规范种类

强制性工程建设规范体系覆盖工程建设领域各类建设工程项目，分为工程项目类规范（简称项目规范）和通用技术类规范（简称通用规范）两种类型。项目规范以工程建设项目整体为对象，以项目的规模、布局、功能、性能和关键技术措施等五大要素为主要内容。通用规范以实现工程建设项目功能性能要求的各专业通用技术为对象，以勘察、设计、施工、维修、养护等通用技术要求为主要内容。在全文强制性工程建设规范体系中，项目规 范为主干，通用规范是对各类项目共性的、通用的专业性关键技术措施的规定。

### 关于五大要素指标

强制性工程建设规范中各项要素是保障城乡基础设施建设体系化和效率提升的基本规定，是支撑城乡建设高质量发展的基本要求。项目的规模要求主要规定了建设工程项目应具备完整的生产或服务能力，应与经济社会发展水平相适应。项目的布局要求主要规定了产业布局、建设工程项目选址、总体设计、总平面布置以及与规模相协调的统筹性技术要求，应考虑供给能力合理分布，提高相关设施建设的整体水平。项目的功能要求主要规定项目构成和用途，明确项目的基本组成单元，是项目发挥预期作用的保障。项目的性能要求主要规定建设工程项目建设水平或技术水平的高低程度，体现建设工程项目的适用性，明确项目质量、安全、节能、环保、宜居环境和可持续发展等方面应达到的基本水平。关键技术措施是实现建设项目功能、性能要求的基本技术规定，是落实城乡建设安全、绿色、韧性、智慧、宜居、公平、有效率等发展目标的基本保障。

### 关于规范实施

强制性工程建设规范具有强制约束力，是保障人民生命财产安全、人身健康、工程安全、生态环境安全、公众权益和公众利益，以及促进能源资源节约利用、满足经济社会管理等方面的控制性底线要求，工程建设项目的勘察、设计、施工、验收、维修、养护、拆除等建设活动全过程中必须严格执行，其中，对于既有建筑改造项目（指不改变现有使用功能），当条件不具备、执行现行规范确有困难时，应不低于原建造时的标准。与强制性工程建设规范配套的推荐性工程建设标准是经过实践检验的、保障达到强制性规范要求的成熟技术措施，一般情况下也应当执行。在满足强制性工程建设规范规定的项目功能、性能要求和关键技术措施的前提下，可合理选用相关团体标准、企业标准，使项目功能、性能更加优化或达到更高水平。推荐性工程建设标准、团体标准、企业标准要与强制性工程建设规范协调配套，各项技术要求不得低于强制性工程建设规范的相关技术水平。

强制性工程建设规范实施后，现行相关工程建设国家标准、行业标准中的强制性条文同时废止。现行工程建设地方标准中的强制性条文应及时修订，且不得低于强制性工程建设规范的规定。现行工程建设标准（包括强制性标准和推荐性标准）中有关规定与强制性工程建设规范的规定不一致的，以强制性工程建设规范的规定为准。

## 1 总则

### 1.0.1
为执行国家有关节约能源、保护生态环境、应对气候变化的法律、法规，落实碳达峰、碳中和决策部署，提高能源资源利用效率，推动可再生能源利用，降低建筑碳排放，营造良好的建筑室内环境，满足经济社会高质量发展的需要，制定本规范。
> **条文说明**  
> 本规范编制的目的。

### 1.0.2
新建、扩建和改建建筑以及既有建筑节能改造工程的建筑节能与可再生能源建筑应用系统的设计、施工、验收及运行管理必须执行本规范。
> **条文说明**  
> 本规范适用范围。本规范适用于新建、扩建和改建的民用建筑及工业建筑；除新建建筑节能设计章节以及针对新建建筑的条文外，也适用于既有建筑节能改造。扩建是指保留原有建筑，在其基础上增加另外的功能、形式、规模，使得新建部分成为与原有建筑相关的新建建筑；改建是指对原有建筑的功能或者形式进行改变，而建筑的规模和建筑的占地面积均不改变的新建建筑。既有建筑节能改造是在建筑原有功能不变的情况下，对建筑围护结构及用能设备或系统的改善。  
> 不适用于没有设置供暖、空调系统的工业建筑，也不适用于战争、自然灾害等不可抗条件下对建筑节能与可再生能源利用的要求。对使用期限为2年以下的临时建筑不做强制要求，可参照执行。   本规范只规定节能性能及相关节能技术措施，与节能措施相关的防火、电气及结构安全方面的要求，应按相应工程建设强制性规范执行。

### 1.0.3
建筑节能应以保证生活和生产所必需的室内环境参数和使用功能为前提，遵循被动节能措施优先的原则。应充分利用天然采光、自然通风，改善围护结构保温隔热性能，提高建筑设备及系统的能源利用效率，降低建筑的用能需求。应充分利用可再生能源，降低建筑化石能源消耗量。
> **条文说明**  
> 明确建筑节能工作的前提和目标，也是建筑节能工作全过程需要遵循的总原则。建筑的基本功能是创造满足人们社会生活需要的人工环境，近年来建筑节能项目实施中出现的以牺牲室内环境水平来达到降低建筑能耗目的的做法，是对建筑节能工作的误读。建筑节能工作的目标是降低化石能源消耗量，这决定了建筑节能工作的两大技术途径：一是通过节能设计降低建筑自身用能需求、提高用能系统能效及合理使用余热废热，另一方面需要利用可再生能源替代化石能源。  
> 本条明确了实现建筑节能的一般技术途径。建筑节能应根据场地和气候条件，在满足建筑功能和美观要求的前提下，通过优化建筑外形和内部空间布局，充分利用天然采光以减少建筑的人工照明需求，适时合理利用自然通风以消除建筑余热余湿。在保证室内环境质量，满足人们对室内舒适度要求的前提下，优先考虑优化围护结构保温隔热能力，减少通过围护结构形成的建筑冷热负荷，降低建筑用能需求，继而考虑提高供暖、通风、空调和照明、电气、给水排水等系统的能源利用效率，进一步降低能耗；在此基础上，通过合理利用可再生能源，实现降低化石能源消耗量的目标。

### 1.0.4
工程建设所采用的技术方法和措施是否符合本规范要求，由相关责任主体判定。其中，创新性的技术方法和措施，应进行论证并符合本规范中有关性能的要求。
> **条文说明**  
> 工程建设强制性规范是以工程建设活动结果为导向的技术规定，突出了建设工程的规模、布局、功能、性能和关键技术措施，但是，规范中关键技术措施不能涵盖工程规划建设管理采用的全部技术方法和措施，仅仅是保障工程性能的“关键点”，很多关键技术措施具有“指令性”特点，即要求工程技术人员去“做什么”，规范要求的结果是要保障建设工程的性能，因此，能否达到规范中性能的要求，以及工程技术人员所采用的技术方法和措施是否按照规范的要求去执行，需要进行全面的判定，其中，重点是能否保证工程性能符合规范的规定。  
> 进行这种判定的主体应为工程建设的相关责任主体，这是我国现行法律法规的要求。《中华人民共和国建筑法》《建设工程质量管理条例》《民用建筑节能条例》等以及相关的法律法规，突出强调了工程监管、建设、规划、勘察、设计、施工、监理、检测、造价、咨询等各方主体的法律责任，既规定了首要责任，也确定了主体责任。在工程建设过程中，执行强制性工程建设规范是各方主体落实责任的必要条件，是基本的、底线的条件，有义务对工程规划建设管理采用的技术方法和措施是否符合本规范规定进行判定。  
> 同时，为了支持创新，鼓励创新成果在建设工程中应用，当拟采用的新技术在工程建设强制性规范或推荐性标准中没有相关规定时，应当对拟采用的工程技术或措施进行论证，确保建设工程达到工程建设强制性规范规定的工程性能要求，确保建设工程质量和安全，并应满足国家对建设工程环境保护、卫生健康、经济社会管理、能源资源节约与合理利用等相关基本要求。

## 2 基本规定

### 2.0.1
新建居住建筑和公共建筑平均设计能耗水平应在2016年执行的节能设计标准的基础上分别降低30％和20%。不同气候区平均节能率应符合下列规定：
1.  严寒和寒冷地区居住建筑平均节能率应为75%;
2.  除严寒和寒冷地区外，其他气候区居住建筑平均节能率应为65%;
3.  公共建筑平均节能率应为72%。

### 2.0.2
标准工况下，不同气候区的各类新建建筑平均能耗指标应按本规范附录A确定。
> **条文说明**  
> 2.0.1、2.0.2  本规范节能总体目标。截至“十二五”末，我国的建筑节能工作已基本完成“三步走”的战略目标。本规范对新建建筑节能水平的衡量是以2016年执行的建筑节能设计标准的节能水平为基准，在此基础上，居住建筑设计能耗再降低30％，公共建筑能耗再降低20％。这是执行本规范各项技术要求后全国范围建筑设计能耗的总体水平。  
> 2016年执行的国家和行业节能设计标准包括《严寒和寒冷地区居住建筑节能设计标准》JGJ 26-2010、《夏热冬冷地区居住建筑节能设计标准》JGJ 134-2010、《夏热冬暖地区居住建筑节能设计标准》JGJ 75-2012和《公共建筑节能设计标准》GB 50189-2015。由于2016年温和地区居住建筑节能设计尚无相应标准，该类地区是以调研获得云贵两省常用建筑构造作为比较的基准。  
> 基于对过去30年建筑节能工作经验的梳理总结，将逐渐淡化以我国20世纪80年代建筑能耗水平为基准的静态节能率方式，转化为以标准实施的年代版本为基础的统称，具体量化提高的程度，用相对于上一版本的相对节能率描述。实行此做法的原因有三：一是我国幅员辽阔、气候条件差异巨大，各地区达到同等水平的相对节能率，技术难度和实施成本差异巨大，只用静态基准的百分比节能率描述，对各地区建筑节能工作的难度和显示度有很大差异，对标准的制定、建筑节能工作实施者的工作积极性都不会产生促进作用，而且目前实际实施的情况也表明，各地区的静态节能率提升水平并不同步；二是我国20世纪80年代建筑能耗基本以北方供暖能耗为主，随着我国人民生活水平的不断提高，空调和生活热水的使用已遍布全国，且成为南方建筑能耗的主要组成部分，但这部分能耗并没有能耗基线数据作为量化比较的基准，使用相对于上一版本的相对节能率描述，可以促进建筑节能工作者逐步完善能耗比较的量化基准，使得这一量化衡量体系日臻科学合理；三是随着我国建筑节能水平的提升，采用静态节能率的描述方式，提升的空间量化显示度将越来越小，在不久的将来，可能5年修订一次标准，提升的节能率也只是小于1％的量级，不利于观测，因此从科技工作的惯例，应及时转变量化描述的方式。但是，考虑到使用者已习惯采用原有建筑节能率的表述方法，本条根据居住建筑和公共建筑能耗相对提升比例，分别给出了相对80年代基准，不同气候区、不同建筑类型的平均建筑节能率。  
> 本规范附录A中给出的各类建筑平均能耗指标是标准工况下，不同气候区、不同建筑类型执行本规范的整体平均能耗水平，可作为地方标准制定、区域性节能政策制定的依据。无论是条文中描述的百分比节能水平，还是附录A中的建筑平均能耗指标，都不能作为某一具体工程项目节能设计的合规判定依据。

### 2.0.3
新建的居住和公共建筑碳排放强度应分别在2016年执行的节能设计标准的基础上平均降低40%，碳排放强度平均降低7kgCO<sub>2</sub> /(m<sup>2</sup> ·a)以上。
> **条文说明**  
> 在实施碳达峰、碳中和国家战略的背景下，建筑作为主要的用能终端，其能源消耗占全社会能源消耗的20％左右，建筑能耗是造成温室气体排放的重要因素。降低建筑的碳排放强度是全球应对气候变化工作的重要组成部分，对我国碳达峰与碳中和战略的实现具有重 要意义，同时有助于改善人民生活水平、拉动内需、促进建筑行业绿色转型升级。  
> 随着城镇化的推进和人民生活水平的提高，我国建筑总量依然保持快速增长的势头。与发达国家相比，我国城镇化率低20％左右，我国建筑领域碳减排压力更大。通过标准的提升降低新建建筑的用能强度，同时优化用能结构，实现新建建筑碳排放强度的降低，是建筑领域实现碳达峰、碳中和战略的重要措施。本规范对建筑能耗的降低比例进行了规定，在建筑用能结构上，燃煤和燃气等化石能源的消耗大幅度降低，电力在用能占比逐步提高，且我国电力排放因子的逐年下降，从2001年的0.773kgCO<sub>2</sub> /kWh下降到2015年的0.553kgCO<sub>2</sub> /kWh，也推动了我国建筑碳排放强度的下降。  
> 本条基于第2.0.1条节能要求，利用不同气候区典型居住建筑和公共建筑的不同类型能源消耗数据，以及不同气候区居住建筑和公共建筑的分布数据，根据电力、煤炭、燃气等能源碳排放因子，对本规范的减碳效果进行了计算评估，以便反映建筑节能标准提升后对我国建筑碳排放降低的贡献。其中居住建筑的平均碳排放强度下降6.8kgCO<sub>2</sub> /（m<sup>2</sup> ·a），公共建筑平均碳排放强度下降10.5kgCO<sub>2</sub> /（m<sup>2</sup> ·a）。

### 2.0.4
新建建筑群及建筑的总体规划应为可再生能源利用创造条件，并应有利于冬季增加日照和降低冷风对建筑影响，夏季增强自然通风和减轻热岛效应。
> **条文说明**  
> 本条是规划阶段的节能要求。  
> 规划设计是建设过程最上游的环节，建筑节能必须从规划设计阶段考虑其合理性。建筑的规划设计是建筑节能设计的重要内容之一，它是从分析建筑所在地区的气候条件出发，将建筑设计与建筑微气候、建筑技术和能源的有效利用相结合的一种建筑设计方法。分析建筑的总平面布置，建筑平、立、剖面形式，太阳辐射，自然通风等对建筑能耗的影响，也就是说在冬季最大限度地利用日照，多获得热量，避开主导风向，减少建筑物外表面热损失；夏季和过渡季最大限度地减少得热并利用自然能来降温冷却，以达到节能的目的。  
> 夏季和过渡季应强调具有良好的自然风环境，主要有两个目的：一是为了改善建筑室内热环境，提高热舒适标准，体现以人为本的设计思想；二是为了提高空调设备的效率。因为良好的通风和热岛强度的下降可以提高空调设备冷凝器的工作效率，有利于降低设备的运行能耗。通常设计时注重利用自然通风的布置形式，合理地确定房屋开口部分的面积与位置、门窗的装置与开启方法、通风的构造措施等，注重穿堂风的形成。  
> 建筑的朝向、方位以及建筑总平面设计应综合考虑社会历史文化、地形、城市规划、道路、环境等多方面因素，权衡分析各个因素之间的得失轻重，优化建筑的规划设计，采用本地区建筑最佳朝向或适宜的朝向，尽量避免东西向日晒。

### 2.0.5
新建、扩建和改建建筑以及既有建筑节能改造均应进行建筑节能设计。建设项目可行性研究报告、建设方案和初步设计文件应包含建筑能耗、可再生能源利用及建筑碳排放分析报告。施工图设计文件应明确建筑节能措施及可再生能源利用系统运营管理的技术要求。
> **条文说明**  
> 建筑的节能减碳是实现2030年前碳达峰和2060年前碳中和两大战略的基础，建筑设计阶段是决定建筑全寿命期能耗和碳排放表现的重要阶段，其合理性主导了后续建筑活动对环境的影响和资源的消耗。建筑能耗、可再生能源利用及碳排放量是表征建筑对环境影响和资源消耗的关键指标，设计阶段对建筑能耗可再生能源利用及碳排放分析有助于更加科学合理地确定建筑设计方案、能源系统设计方案和相关参数。  
> 设计阶段计算和分析建筑能耗和碳排放量可以评估建筑朝向、体形系数、围护结构参数、能源系统配置及参数等节能措施的合理性。在规划和单体方案设计阶段进行可再生能源系统策 划，分析可再生能源系统利用率将有利于可再生能源系统与建筑的一体化建设，提高可再生能源系统的能源利用效率。  
> 国家标准《建筑碳排放计算标准》GB/T 51366-2019对建筑碳排放计算方法进行了规定。但建筑能耗和碳排放量计算过程较为复杂、涉及的计算因素也很多，国际上普遍采用提供工具并配合详细的计算方法的方式提高计算结果的有效性和一致性。  
> 设计达到节能要求并不能保证建筑做到真正的节能，实际的节能效益，必须依靠合理运行才能实现。就目前我国的实际情况而言，在使用和运行管理上，不同地区、不同建筑存在较大的差异，相当多的建筑实际运行管理水平不高、实际运行能耗远远大于设计时对运行能耗的评估值，这一现象严重阻碍了我国建筑节能工作的正常进行。设计文件应为工程运行管理方提供一个合理的、符合设计思想的节能措施使用要求，这既是各专业的设计师在建筑节能方面应尽的义务，也是保证工程按照设计思想来取得最优节能效果的必要措施之一。  
> 节能措施及其使用要求包括以下内容：  
> 1  建筑设备及被动节能措施（如遮阳、自然通风等）的使用方法，建筑围护结构采取的节能措施及做法；  
> 2  机电系统（暖通空调、给水排水、电气系统等）的使用方法和采取的节能措施及其运行管理方式，如：  
>  （1）暖通空调系统冷源配置及其运行策略；  
>  （2）季节性（包括气候季节以及商业方面的“旺季”与“淡季”）使用要求与管理措施；  
>  （3）新（回）风风量调节方法，热回收装置在不同季节使用方法，旁通阀使用方法，水量调节方法，过滤器的使用方法等；  
>  （4）设定参数（如：空调系统的最大及最小新（回）风风量表）；  
>  （5）对能源的计量监测及系统日常维护管理的要求等。  
> 需要特别说明的是：尽管许多大型公建的机电系统设置了比较完善的楼宇自动控制系统，在一定程度上为合理使用提供了相应的支持。但从目前实际使用情况来看，自动控制系统尚不能完全替代人工管理。因此，充分发挥管理人员的主动性依然是非常重要的节能措施。  
> 太阳能等可再生能源的不稳定性特点对系统建成后的运行管理提出了更高要求，需要在施工图设计阶段就给出相关的运营技术措施，以保障系统能够正常运行，获得预期的节能效益。因此要求在施工图设计文件中给出完整的节能措施及可再生能源系统的设计内容并注明对项目施工与运营管理的要求和注意事项，例如系统的运行控制措施和监测参数等。

### 2.0.6
不同类型的建筑应按建筑分类分别满足相应性能要求。建筑分类及参数计算应符合本规范附录B的规定。
> **条文说明**  
> 本条为节能指标确定及参数计算的基本要求，为科学合理节能，统一计算标准设置此条文。  
> 本规范按居住建筑、公共建筑、工业建筑分别规定了性能要求，其中性能要求既包括节能定量指标，也包括应采取的节能技术措施。

### 2.0.7
当工程设计变更时，建筑节能性能不得降低。
> **条文说明**  
> 由于材料供应、工艺改变等原因，建筑工程施工中可能需要改变节能设计，为了避免这些改变影响节能效果，本条对涉及节能的设计变更严格加以限制。此条保证了节能效果不在后期被降低。

### 2.0.8
供冷系统及非供暖房间的供热系统的管道均应进行保温设计。
> **条文说明**  
> 本条是对供冷供热输配管道的基本节能要求。建筑物内的供冷系统管道，设置绝热层是防止冷量损失及防止结露；建筑物内的供热系统管道包括供暖系统和生活热水系统，当环境空气温度低于管道介质温度时，设置绝热层可防止不必要的热量损失。

## 3 新建建筑节能设计

### 3.1 建筑和围护结构

#### 3.1.1
建筑和围护结构热工设计应满足本节性能要求；其中，本规范第3.1.2条、第3.1.4条、第3.1.6~3.1.10条、第3.1.12条应允许按本规范附录C的规定通过围护结构热工性能权衡判断满足要求。
> **条文说明**  
> 本条是为了增强规范的可操作性规定的技术内容。  
> 为保证设计建筑的节能性能达到本规范要求，同时给建筑师更多的创作空间，本规范给出了两种达标路径。对于第3.1.2条、第3.1.4条、第3.1.6～3.1.10条、第3.1.12条，当满足规定的限值时，即可以判定建筑达到了本规范要求的节能性能；不满足时，也允许通过权衡判断的方法使设计建筑的能耗不超过参照建筑的方法，对建筑节能性能进行达标性判定。

#### 3.1.2
居住建筑体形系数应符合表3.1.2的规定。

**表3.1.2 居住建筑体形系数限值**

| 热工区划 | 建筑层数 ≤3层 | 建筑层数 ＞3层 |
| :--- | :--- | :--- |
| 严寒地区 | ≤0.55 | ≤0.30 |
| 寒冷地区 | ≤0.57 | ≤0.33 |
| 夏热冬冷A区 | ≤0.60 | ≤0.40 |
| 温和 A区 | ≤0.60 | ≤0.45 |

> **条文说明**  
> 建筑物的平、立面不应出现过多的凹凸，体形系数对建筑能耗的影响非常显著。建筑体形系数越大，单位建筑面积对应的外表面面积越大，传热损失就越大。建筑供暖能耗在严寒和寒冷地区建筑能耗中占比大，从降低建筑能耗的角度出发，设置此条文。定量规定控制底线。  
> 1  体形系数不只是影响外围护结构的传热损失，它还与建筑造型、平面布局、采光通风等紧密相关。体形系数过小，将制约建筑师的创造性，造成建筑造型呆板，平面布局困难，甚至损害建筑功能。因此，如何合理确定建筑形状，必须考虑本地区气候条件，冬、夏季太阳辐射强度、风环境、围护结构构造等各方面因素。应权衡利弊，兼顾不同类型的建筑造型，尽可能地减少房间的外围护面积，使体形不要太复杂，凹凸面不要过多，以达到节能的目的。  
> 表3.1.2中的建筑层数分为两类，是根据目前大量新建居住建筑的种类来划分的。如（1～3）层多为别墅，4层以上的多为大量建造的居住建筑。考虑到这两类建筑本身固有的特点，即低层建筑的体形系数较大，多高层建筑的体形系数较小，因此，在体形系数的限值上有所区别。   由于随着建筑围护结构热工性能的提升，体形系数对建筑供暖空调能耗的影响在降低。本规范制定时，居住建筑的节能性能较现行标准有所提高。因此，与现行标准相比，体形系数略有放宽。  
> 2  本条建筑体形系数的外表面积中，不包括地面和不供暖楼梯间内墙的面积。建筑面积应按各层外墙外包线围成的平面面积的总和计算。包括半地下室的面积，不包括地下室的面积。建筑体积应按与计算建筑面积所对应的建筑物外表面和底层地面所围成的体积计算。

#### 3.1.3
严寒和寒冷地区公共建筑体形系数应符合表3.1.3的规定。

**表3.1.3 严寒和寒冷地区公共建筑体形系数限值**

| 单栋建筑面积 A(㎡) | 建筑体形系数 |
| :--- | :--- |
| 300<A≤800 | ≤0.50 |
| A>800 | ≤0.40 |

> **条文说明**  
> 本条对严寒和寒冷地区的公共建筑体形系数进行了明确的定量规定，且不允许通过围护结构热工性能权衡判断的途径满足本条要求。本条建筑面积的划分是按地上建筑面积划分的。  
> 随着公共建筑的建设规模不断增大，采用合理的建筑设计方案的单栋建筑面积小于800m<sup>2</sup> ，其体形系数一般不会超过0.40。研究表明，2～4层的低层建筑的体形系数基本在0.40左右，5～8层的多层建筑体形系数在0.30左右，高层和超高层建筑的体形系数一般小于0.25，实际工程中，单栋面积300m<sup>2</sup> 。以下的小规模建筑，或者形状奇特的极少数建筑有可能体形系数超过0.50。因此根据建筑体形系数的实际分布情况，从降低建筑能耗的角度出发，对严寒和寒冷地区建筑的体形系数进行控制，制定本条文。在夏热冬冷和夏热冬暖地区，建筑体形系数对空调和供暖能耗也有一定的影响，但由于室内外的温差远不如严寒和寒冷地区大，尤其是对部分内部发热量很大的商业类建筑，还存在夜间散热问题，所以不对体形系数提出具体的要求。但也应考虑建筑体形系数对能耗的影响。

#### 3.1.4
居住建筑的窗墙面积比应符合表3.1.4的规定；其中，每套住宅应允许一个房间在一个朝向上的窗墙面积比不大于0.6。

**表3.1.4 居住建筑窗墙面积比限值**

| 朝向 | 严寒地区 | 寒冷地区 | 夏热冬冷地区 | 夏热冬暖地区 | 温和A区 |
| :--- | :--- | :--- | :--- | :--- | :--- |
| 北 | ≤0.25 | ≤0.30 | ≤0.40 | ≤0.40 | ≤0.40 |
| 东、西 | ≤0.30 | ≤0.35 | ≤0.35 | ≤0.30 | ≤0.35 |
| 南 | ≤0.45 | ≤0.50 | ≤0.45 | ≤0.40 | ≤0.50 |

> **条文说明**  
> 窗墙面积比是影响建筑能耗的重要因素，同时它也受建筑日照、采光、自然通风等满足室内环境要求的制约。一般普通窗户（包括阳台的透光部分）的保温性能比外墙差很多，而且窗的四周与墙相交之处也容易出现热桥，窗越大，温差传热量也越大。因此，从降低建筑能耗的角度出发，必须合理地限制窗墙面积比。一般而言，窗户越大可开启的窗缝越长，窗缝通常都是容易产生热散失的部位，而且窗户的使用时间越长，缝隙的渗漏也越严重。再 者夏天透过玻璃进入室内的太阳辐射热是造成房间过热的一个重要原因。从节能和室内环境舒适的双重角度考虑，居住建筑都不应该过分地追求所谓的通透。  
> 居住建筑的窗墙面积比按开间计算，之所以这样做主要有三个理由：一是窗的传热损失总是比较大的，需要严格控制；二是居住建筑中的房间相对独立，某个房间窗墙面积比过大会造成该房间室内热环境难以控制；三是建筑节能施工图审查比较方便，只需要审查最可能超标的开间即可。  
> 不同朝向的开窗面积，对于上述因素的影响有较大差别。综合利弊，本规范按不同朝向，提出了窗墙面积比的指标。不同气候区的建筑朝向应按照本规范第B.0.5条确定。  
> 适当放宽每套住宅一个房间窗墙面积比，采用提高外窗热工性能来控制能耗，可以给建筑师提供更大灵活性。

#### 3.1.5
居住建筑的屋面天窗与所在房间屋面面积的比值应符合表3.1.5的规定。

**表3.1.5 居住建筑屋面天窗面积的限值**

| 严寒地区 | 寒冷地区 | 夏热冬冷地区 | 夏热冬暖地区 | 温和A区 |
| :--- | :--- | :--- | :--- | :--- |
| ≤10% | ≤15% | ≤6% | ≤4% | ≤10% |

> **条文说明**  
> 透光围护结构的保温性能与屋面差距很大。夏季屋顶水平面太阳辐射强度最大，屋顶的透光面积越大，相应建筑的能耗也越大，因此对屋顶透光部分的面积和热工性能应予以严格的限制。而且，屋面天窗对所在房间热环境影响显著，因此更需要严格控制其大小。天窗平面与水平面的夹角应小于或等于60°，当窗户平面与水平面夹角大于60°时，应按照所在朝向的外窗进行节能设计。

#### 3.1.6
甲类公共建筑的屋面透光部分面积不应大于屋面总面积的20%。
> **条文说明**  
> 由于公共建筑形式的多样化和建筑功能的需要，许多公共建筑设计有室内中庭，希望在建筑的内区有一个通透明亮、具有良好的微气候及人工生态环境的公共空间。但从目前已经建成的工程来看，大量建筑中庭的热环境不理想且能耗很大，主要原因是中庭透光围护结构的热工性能较差，传热损失和太阳辐射得热过大。夏热冬暖地区某公共建筑中庭进行测试结果显示，中庭四层内走廊温度达到40℃以上，平均热舒适值PMV≥2.63，即使采用空调室内也无法达到人们所要求的舒适温度。因此，根据“促进能源资源节约利用”的要求，对甲类公共建筑的屋顶透光面积比例作出定量限制，便于操作执行。  
> 单栋建筑面积大于300m<sup>2</sup> 的建筑或单栋面积小于或等于300m<sup>2</sup> 但总建筑面积大于1000m<sup>2</sup> 的建筑群为甲类公共建筑。透光部分面积是指实际透光面积，不含窗框面积，应通过计算确定。对于那些需要视觉、采光效果而加大屋顶透光面积的建筑，如果所设计的建筑满足不了规定性指标的要求，突破了限值，则必须按本规范的规定对该建筑进行权衡判断。权衡判断时，参照建筑的屋顶透光部分面积应符合本条的规定。

#### 3.1.7
设置供暖、空调系统的工业建筑总窗墙面积比不应大于0.50,且屋顶透光部分面积不应大于屋顶总面积的15%。
> **条文说明**  
> 工业建筑内部多为开敞的大空间，各朝向外窗对建筑能耗的影响相互叠加，作用效果较为复杂。因此，采用总窗墙面积比对外窗产生的能耗进行控制，易于综合考虑外窗的节能 性能，工程中易于实现。屋面的透光部位过大造成供暖、空调能耗快速上升，是非常不利的，需要严格控制其面积。

#### 3.1.8
居住建筑非透光围护结构的热工性能指标应符合表3.1.8-1～表3.1.8-11的规定。

**表3.1.8-1 严寒A区居住建筑围护结构热工性能参数限值**

| 围护结构部位 | ≤3层 | >3层 |
| :--- | :--- | :--- |
| 屋面 | ≤0.15 | ≤0.15 |
| 外墙 | ≤0.25 | ≤0.35 |
| 架空或外挑楼板 | ≤0.25 | ≤0.35 |
| 阳台门下部芯板 | ≤1.20 | ≤1.20 |
| 非供暖地下室顶板(上部为供暖房间时) | ≤0.35 | ≤0.35 |
| 分隔供暖与非供暖空间的隔墙、楼板 | ≤1.20 | ≤1.20 |
| 分隔供暖与非供暖空间的户门 | ≤1.50 | ≤1.50 |
| 分隔供暖设计温度温差大于5K的隔墙、楼板 | ≤1.50 | ≤1.50 |

**续表 3.1.8-1**

| 围护结构部位 | 保温材料层热阻R[(㎡·K)/W] | 保温材料层热阻R[(㎡·K)/W] |
| :--- | :--- | :--- |
| 周边地面 | ≥2.0 | ≥2.0 |
| 地下室外墙(与土壤接触的外墙) | ≥2.0 | ≥2.0 |

*(此处省略了表3.1.8-2至表3.1.8-11的详细内容，格式与上表类似)*

> **条文说明**  
> 建筑围护结构热工性能直接影响居住建筑的供暖和空调的负荷与能耗，必须予以严格控制。由于我国幅员辽阔，各地气候差异很大。为了使建筑物适应各地不同的气候条件，满足节能要求，应根据建筑物所处的建筑气候分区，确定建筑围护结构合理的热工性能参数。确定建筑围护结构传热系数的限值时不仅应考虑节能率，而且也从工程实际的角度考虑了可行性、合理性。  
> 与土壤接触的地面的内表面，由于受二维、三维传热的影响，冬季时比较容易出现温度较低 的情况，一方面造成大量的热量损失，另一方面也不利于底层居民的健康，甚至发生地面结露现象，尤其是靠近外墙的周边地面（指室内距外墙内表面2m以内的地面）更是如此。因此在冬季北方地区要特别注意这一部分围护结构的保温、防潮。计算周边地面和地下室外墙的保温材料热阻时，保温材料层不包括土壤和其他构造层。  
> 地下室虽然不作为正常的居住空间，但也常会有人员活动，也需要维持一定的温度。另外增强地下室的墙体保温，也有利于减小地面房间和地下室之间的传热，特别是提高一层地面与墙角交接部位的表面温度，避免墙角结露。

#### 3.1.9
居住建筑透光围护结构的热工性能指标应符合表3.1.9-1～表3.1.9-5的规定。

*(此处省略了表3.1.9-1至表3.1.9-5的详细内容)*

> **条文说明**  
> 透光围护结构是建筑外围护结构的薄弱环节，其对建筑供暖、空调能耗的影响显著，必须对其热工性能进行限定。  
> 一般普通窗户（包括阳台门的透光部分）的保温隔热性能比外墙差很多，而且窗与墙连接的周边又是保温的薄弱环节，窗墙面积比越大，供暖和空调能耗也越大。因此，从降低建筑能耗的角度出发，必须限制窗墙面积比。本条文规定的围护结构传热系数和遮阳系数限值表中，窗墙面积比越大，对窗的热工性能要求越高。  
> 窗（包括阳台门的透光部分）对建筑能耗高低的影响主要有两个方面，一是窗的传热系数影响冬季供暖、夏季空调时的室内外温差传热；另外就是窗受太阳辐射影响而造成室内得热。冬季，通过窗户进入室内的太阳辐射有利于建筑节能，因此，减小窗的传热系数抑制温差传热是降低窗热损失的主要途径之一；而夏季，通过窗口进入室内的太阳辐射热成为空调降温的负荷，因此，减少进入室内的太阳辐射以及减小窗的温差传热都是降低空调能耗的途径。

#### 3.1.10
甲类公共建筑的围护结构热工性能应符合表3.1.10-1～表3.1.10-6的规定。

*(此处省略了表3.1.10-1至表3.1.10-6的详细内容)*

#### 3.1.11
乙类公共建筑的围护结构热工性能应符合表3.1.11-1和表3.1.11-2的规定。

*(此处省略了表3.1.11-1和表3.1.11-2的详细内容)*

> **条文说明**  
> 3.1.10、3.1.11  建筑围护结构热工性能参数是实现建筑节能设计的重要环节，从降低建筑能耗的角度出发，设置此条文。分建筑规模和气候区定量规定控制底线。  
> ... *(其余说明省略)*

#### 3.1.12
设置供暖空调系统的工业建筑围护结构热工性能应符合表3.1.12-1～表3.1.12-9的规定。

*(此处省略了表3.1.12-1至表3.1.12-9的详细内容)*

> **条文说明**  
> 3.1.12  设置供暖、空调系统的工业建筑往往是对室内热环境有一定要求，将产生供热和制冷能耗。因此，必须对此类工业建筑的围护结构热工性能提出基本的要求，以降低建筑冬夏季的负荷。

#### 3.1.13
当公共建筑入口大堂采用全玻幕墙时，全玻幕墙中非中空玻璃的面积不应超过该建筑同一立面透光面积（门窗和玻璃幕墙）的15%，且应按同一立面透光面积（含全玻幕墙面积）加权计算平均传热系数。
> **条文说明**  
> 由于功能要求，公共建筑的底层入口大堂往往采用玻璃肋式的全玻璃幕墙，这种幕墙形式无法采用中空玻璃，为保证设计师的灵活性，本条仅对底层入口大堂的非中空玻璃幕墙进行规定。目前国内的幕墙工程，主要考虑幕墙围护结构的结构安全性、日光照射的光环境、隔绝噪声、防止雨水渗透以及防火安全等方面的问题，较少考虑幕墙围护结构的保温隔热、冷凝等热工节能问题。为了保证围护结构的热工性能，必须对非中空玻璃的面积提出控制要求，底层大堂非中空玻璃的面积不应超过同一朝向的门窗和透光玻璃幕墙总面积的15％，并对同一朝向的透光围护结构按面积加权计算平均传热系数，该传热系数应符合本规范第3.1.10和第3.1.11条的规定。同一朝向可包括多个建筑立面。

#### 3.1.14
外窗的通风开口面积应符合下列规定：
1.  夏热冬暖、温和B区居住建筑外窗的通风开口面积不应小于房间地面面积的10％或外窗面积的45%，夏热冬冷、温和A区居住建筑外窗的通风开口面积不应小于房间地面面积的5%;
2.  公共建筑中主要功能房间的外窗（包括透光幕墙）应设置可开启窗扇或通风换气装置。
> **条文说明**  
> 合理利用自然通风来消除室内余热余湿是建筑节能的有效手段之一，所以房间外门 窗有足够的通风开口面积非常重要。随着用户节能意识的提高，使用需求已经逐渐从肓目追求大玻璃窗小开启扇，向追求门窗大开启加强自然通风效果转变。本条文强调南方地区居住建筑应能依靠自然通风改善房间热环境，缩短房间空调设备使用时间，发挥节能作用。房间实现自然通风的必要条件是外门窗有足够的通风开口。因此，为了逐步强化门窗通风的降温和节能作用，本条文规定了外门窗通风开口面积的最低限值。  
> 对于居住建筑，其外窗的面积相对较大，通风开口面积应按不小于该房间地面面积的10％要求设计。而考虑到厨房、卫生间等的窗面积较小，满足不小于房间地面面积10％的要求很难做到。因此，对于厨房、卫生间的外窗，其通风开口面积应按不小于外窗面积的45％设计。夏热冬暖地区以外，限值要求适当予以放宽。  
> 公共建筑一般室内人员密度比较大，建筑室内空气流动，特别是自然、新鲜空气的流动，可以保证空气品质。无论在北方地区还是在南方地区，在春、秋季节和冬、夏季的某些时段普遍有开窗加强房间通风的习惯，这也是节能和提高室内热舒适性的重要手段。外窗的可开启面积过小会严重影响建筑室内的自然通风效果，本条规定是为了使室内人员在较好的室外气象条件下，可以通过开启外窗或通风换气装置来获得热舒适性和良好的室内空气品质。

#### 3.1.15
建筑遮阳措施应符合下列规定：
1.  夏热冬暖、夏热冬冷地区，甲类公共建筑南、东、西向外窗和透光幕墙应采取遮阳措施；
2.  夏热冬暖地区，居住建筑的东、西向外窗的建筑遮阳系数不应大于0.8。
> **条文说明**  
> 通过外窗透光部分进入室内的热量是造成夏季室温过热、空调能耗上升的主要原因，为了节约能源，应对窗口和透光幕墙采取遮阳措施。因此根据“促进能源资源节约利用”的要求，从降低建筑能耗的角度出发，设置此条文。  
> ... *(其余说明省略)*

#### 3.1.16
居住建筑幕墙、外窗及敞开阳台的门在10Pa压差下，每小时每米缝隙的空气渗透量q<sub>1</sub> 不应大于1.5m<sup>3</sup> ,每小时每平方米面积的空气渗透量不应大于4.5m<sup>3</sup> 。
> **条文说明**  
> 3.1.16  由于建筑气密性差导致的冷风渗透在建筑总能耗中的比重越来越高，外门窗由于其可开启性，成为影响建筑气密性的最主要环节，严格控制外门窗的气密性是降低冷风渗透能耗的主要途径。  
> 为了保证建筑的节能，要求外窗具有良好的气密性能，以避免夏季和冬季室外空气过多地向室内渗透。  
> 本条规定的气密性要求相当于国家标准《建筑幕墙、门窗通用技术条件》GB/T 31433-2015中建筑外门窗气密性6级。

#### 3.1.17
居住建筑外窗玻璃的可见光透射比不应小于0.40。
> **条文说明**  
> 承担采光功能的窗其透光材料的可见光透射比直接影响天然采光的效果和人工照明的能耗。在节能标准的要求下，工程中出现了为追求外窗较低的太阳得热系数而大幅降低了窗户透光部分可见光透射比的现象，不利于白天及过渡季利用天然采光。目前，中等透光率的玻璃可见光透射比都可达到0.4以上。综合建筑采光和节能的需要，本条规定了采光窗的透光材料可见光透射比的底线要求。

#### 3.1.18
居住建筑的主要使用房间（卧室、书房、起居室等）的房间窗地面积比不应小于1/7。
> **条文说明**  
> 充足的天然采光有利于居住者的生理和心理健康，同时也有利于降低人工照明能耗。建筑室内的采光性能通常用采光系数进行评价。实际应用中，采光系数的计算较为复杂，而房间的采光系数与窗地面积比关系密切。因此，本条规定了居住建筑的主要使用房间，如：卧室、书房、起居室等的窗地面积比的最低要求。考虑到住宅中，厨房、卫生间常设在内凹部位，朝外的窗主要用于通风，所以不对厨房、卫生间提出要求。

#### 3.1.19
外墙保温工程应采用预制构件、定型产品或成套技术，并应具备同一供应商提供配套的组成材料和型式检验报告。型式检验报告应包括配套组成材料的名称、生产单位、规格塑号、主要性能参数。外保温系统型式检验报告还应包括耐候性和抗风压性能检验项目。
> **条文说明**  
> 本条规定了对墙体节能工程的基本技术要求，即应采用预制构件、定型产品或成套技术，并应由供应方配套提供组成材料。其目的是防止采用不成熟工艺或质量不稳定的材料和产品。预制构件、定型产品为工厂化生产，质量较为稳定；成套技术则经过验证，可保证工程的质量和节能效果。采用成套技术现场施工的外墙保温构造做法，是指由施工图设计文件给出外墙外保温具体做法和要求，由施工单位按设计要求进行施工。由于此时施工单位只能控制材料质量和施工工艺，在施工现场难以对完成的工程实体进行安全性、耐久性和节能效果的检验，为了确保采用该设计完成的节能保温工程满足要求，故规定应由相关单位提供型式检验报告。采用非成套技术或采用不是同一个供应商提供的材料，其材料质量、施工工艺不易保持稳定可靠，也难以在施工现场进行检查，工程的安全性、耐久性和节能效果在短期内更是难以判断，因此不得使用。  
> ... *(其余说明省略)*

#### 3.1.20
电梯应具备节能运行功能。两台及以上电梯集中排列时，应设置群控措施。电梯应具备无外部召唤且轿厢内一段时间无预置指令时，自动转为节能运行模式的功能。自动扶梯、自动人行步道应具备空载时暂停或低速运转的功能。
> **条文说明**  
> 建筑中电梯是重要的用能设备。设置群控功能，可以最大限度地减少等候时间，减少电梯运行次数。轿厢内一段时间无预置指令时，电梯自动转为节能方式主要是关闭部分轿厢照明。高速电梯可考虑采用能量再生电梯。  
> 在电梯设计选型时，宜选用采用高效电机或具有能量回收功能的节能型电梯。

### 3.2 供暖、通风与空调

*(此处省略了3.2.1至3.2.26的详细条文内容，格式与3.1节类似)*

### 3.3 电气

*(此处省略了3.3.1至3.3.11的详细条文内容，格式与3.1节类似)*

### 3.4 给水排水及燃气

*(此处省略了3.4.1至3.4.6的详细条文内容，格式与3.1节类似)*

## 4 既有建筑节能改造设计

### 4.1 一般规定

*(此处省略了4.1.1至4.1.4的详细条文内容)*

### 4.2 围护结构

*(此处省略了4.2.1至4.2.5的详细条文内容)*

### 4.3 建筑设备系统

*(此处省略了4.3.1至4.3.11的详细条文内容)*

## 5 可再生能源建筑应用系统设计

### 5.1 —般规定

*(此处省略了5.1.1至5.1.2的详细条文内容)*

### 5.2 太阳能系统

*(此处省略了5.2.1至5.2.12的详细条文内容)*

### 5.3 地源热泵系统

*(此处省略了5.3.1至5.3.8的详细条文内容)*

### 5.4 空气源热泵系统

*(此处省略了5.4.1至5.4.6的详细条文内容)*

## 6 施工、调试及验收

### 6.1 —般规定

*(此处省略了6.1.1至6.1.5的详细条文内容)*

### 6.2 围护结构

*(此处省略了6.2.1至6.2.14的详细条文内容)*

### 6.3 建筑设备系统

*(此处省略了6.3.1至6.3.13的详细条文内容)*

### 6.4 可再生能源应用系统

*(此处省略了6.4.1至6.4.6的详细条文内容)*

## 7 运行管理

### 7.1 运行与维护

*(此处省略了7.1.1至7.1.11的详细条文内容)*

### 7.2 节能管理

*(此处省略了7.2.1至7.2.6的详细条文内容)*

## 8 录A 不同气候区新建建筑平均能耗指标

*(此处省略了附录A的详细条文说明)*

## 9 录B 建筑分类与参数计算

### B.0.1
公共建筑的分类应符合下列规定：
 1 单栋建筑面积大于300m<sup>2</sup> 的建筑或单栋面积小于或等于300m<sup>2</sup> 但总建筑面积大于1000m<sup>2</sup> 的公共建筑群，应为甲类公共建筑；
 2 除甲类公共建筑外的公共建筑，为乙类公共建筑。
> **条文说明**  
> ... *(说明省略)*

### B.0.2
建筑围护结构热工性能参数计算应符合下列规定：
 1 外墙、屋面的传热系数应为包括结构性热桥在内的平均传热系数，并应按下式计算：
 式中：K<sub>m</sub> ——外墙、屋面的传热系数［W/（m<sup>2</sup> ·K）］；
  K——外墙、屋面平壁的传热系数［W/（m<sup>2</sup> ·K）］；
  ψ<sub>j</sub> ——外墙、屋面上的第j个结构性热桥的线传热系数［W/（m·K）］；
  ｌ<sub>j</sub> ——第j个结构性热桥的计算长度（m）；
  A——外墙、屋面的面积（m<sup>2</sup> ）。
 2 透光围护结构的传热系数应按下式计算：
 式中：K——幕墙单元、门窗的传热系数［W/（m<sup>2</sup> ·K）］；
  A<sub>g</sub> ——透光面板面积（m<sup>2</sup> ）；
  ｌ<sub>g</sub> ——透光面板边缘长度（m）；
  K<sub>gc</sub> ——透光面板中心的传热系数［W/（m<sup>2</sup> ·K）］；
  ψ<sub>g</sub> ——透光面板边缘的线传热系数［W/（m·K）］；
  A<sub>p</sub> ——非透光面板面积（m<sup>2</sup> ）；
  ｌ<sub>p</sub> ——非透光面板边缘长度（m）；
  K<sub>pc</sub> 一一非透光面板中心的传热系数：W/（m<sup>2</sup> ·K）］；
  ψ<sub>p</sub> ——非透光面板边缘的线传热系数［W/（m·K）］；
  A<sub>f</sub> ——框面积（m<sup>2</sup> ）；
  K<sub>f</sub> ——框的传热系数［W/（m<sup>2</sup> ·K）］。
 3 透光围护结构太阳得热系数（SHGC）应按下列公式计算：
> **条文说明**  
> ... *(说明省略)*

### B.0.3
建筑窗墙面积比的计算应符合下列规定：
 1 居住建筑的窗墙面积比按照开间计算；公共建筑的窗墙面积比按照单一立面朝向计算；工业建筑的窗墙面积比按照所有立面计算；
 2 凸凹立面朝向应按其所在立面的朝向计算；
 3 楼梯间和电梯间的外墙和外窗均应参与计算；
 4 外凸窗的顶部、底部和侧墙的面积不应计入外墙面积；
 5 凸窗面积应按窗洞口面积计算。
> **条文说明**  
> ... *(说明省略)*

### B.0.4
建筑外窗（包括透光幕墙）的有效通风换气面积应为开启扇面积和窗开启后的空气流通界面面积的较小值。
> **条文说明**  
> ... *(说明省略)*

### B.0.5
朝向应按下列规定选取：
 1 严寒、寒冷地区建筑朝向中的“北”应为从北偏东小于60°至北偏西小于60°的范围；“东、西”应为从东或西偏北小于或等于30°至偏南小于60°的范围；“南”应为从南偏东小于等于30°至偏西小于或等于30°的范围；
 2 其他气候区建筑朝向中的“北”应为从北偏东小于30°至北偏西小于30°的范围；“东、西”应为从东或西偏北小于或等于60°至偏南小于60°的范围；“南”应为从南偏东小于或等于30°至偏西小于或等于30°的范围。
> **条文说明**  
> ... *(说明省略)*

## 10 C 建筑围护结构热工性能权衡判断

### C.0.1
进行权衡判断的设计建筑，其围护结构的热工性能应符合下列规定：
 1 围护结构传热系数基本要求不得低于表C.0.1-1的规定。
> **条文说明**  
> 对进行权衡判断的建筑，规定围护结构的基本要求，以避免出现围护结构热工性能过差的情况。

### C.0.2
 建筑围护结构热工性能的权衡判断采用对比评定法，公共建筑和居住建筑判断指标为总耗电量，工业建筑判断指标为总耗煤量，并应符合下列规定：
1  对公共建筑和居住建筑，总耗电量应为全年供暖和供冷总耗电量；对工业建筑，总耗煤量应为全年供暖耗热量和供冷耗冷量的折算标煤量；
2  当设计建筑总耗电（煤）量不大于参照建筑时，应判定围护结构的热工性能符合本规范的要求；
3  当设计建筑的总能耗大于参照建筑时，应调整围护结构的热工性能重新计算，直至设计建筑的总能耗不大于参照建筑。

### C.0.3
 参照建筑的形状、大小、朝向、内部的空间划分、使用功能应与设计建筑完全一致。参照建筑围护结构应符合本规范第3.1.2条～第3.1.10条的规定；本规范未作规定时，参照建筑应与设计建筑一致。建筑功能区除设计文件明确为非空调区外，均应按设置供暖和空气调节系统计算。
> **条文说明**  
> C.0.2、C.0.3  这两条规定了权衡判断的方法和判定指标，对不同的设计建筑进行权衡判断时采用相同的方法，保证权衡判断结果的可比性。

### C.0.4
 建筑围护结构热工性能权衡判断计算应采用能按照本规范要求自动生成参照建筑计 算模型的专用计算软件，软件应具有以下功能：
1  采用动态负荷计算方法；
2  能逐时设置人员数量、照明功率、设备功率、室内温度、供暖和空调系统运行时间；
3  能计入建筑围护结构蓄热性能的影响；
4  能计算建筑热桥对能耗的影响；
5  能计算10个以上建筑分区；
6  能直接生成建筑围护结构热工性能权衡判断计算报告。
> **条文说明**  
> 规范权衡判断计算软件功能，是保证权衡判断计算结果科学性和一致性的必要措施。

### C.0.5
 参照建筑与设计建筑的能耗计算应采用相同的软件和典型气象年数据。
> **条文说明**  
> 本规范对围护结构热工性能的权衡判断采用对比评定法，当设计建筑与参照建筑的能耗计算均采用同一软件时，采用不同软件的权衡判断结论可基本保持一致。  
> 建筑所在地的气候条件决定了建筑的供暖、空调能耗。权衡判断计算时，需要输入全年8760h的逐时气象参数。在计算设计建筑和参照建筑能耗时采用相同的气象参数，可以避免由于室外气候差异造成的能耗计算差异，保证权衡判断结果的正确性。

### C.0.6
 建筑的空气调节和供暖系统运行时间、室内温度、照明功率密度值及开关时间、房间人均占有的建筑面积及在室率、人员新风量及新风机组运行时间表、电器设备功率密度及使用率应符合表C.0.6-1～表C.0.6-13的规定。
> **条文说明**  
> 本条对权衡判断时所必需的计算参数作出了规定，以保证权衡判断结果的合理性。

> **条文说明**  
> C.0.7、C.0.8  规范对权衡判断时判定指标的计算方法作出了规定，以保证判定指标计算方法的统一。