# 《公共建筑节能设计标准》GB 50189-2015

**住房和城乡建设部**  
更新时间：2022-10-13  
实施时间：2015-10-01

> **重要提示**：自2022年4月1日起，本标准中第3.2.1、3.2.7、3.3.1、3.3.2、3.3.7、4.1.1、4.2.2、4.2.3、4.2.5、4.2.8、4.2.10、4.2.14、4.2.17、4.2.19、4.5.2、4.5.4、4.5.6条强制性条文废止，相关要求以《建筑节能与可再生能源利用通用规范》GB 55015-2021为准。

## 目录
1. [总则](#1-总则)
2. [术语](#2-术语)
3. [建筑与建筑热工](#3-建筑与建筑热工)
    3.1. [一般规定](#31-一般规定)
    3.2. [建筑设计](#32-建筑设计)
    3.3. [围护结构热工设计](#33-围护结构热工设计)
    3.4. [围护结构热工性能的权衡判断](#34-围护结构热工性能的权衡判断)
4. [供暖通风与空气调节](#4-供暖通风与空气调节)
    4.1. [一般规定](#41-一般规定)
    4.2. [冷源与热源](#42-冷源与热源)
    4.3. [输配系统](#43-输配系统)
    4.4. [末端系统](#44-末端系统)
    4.5. [监测、控制与计量](#45-监测控制与计量)
5. [给水排水](#5-给水排水)
    5.1. [一般规定](#51-一般规定)
    5.2. [给水与排水系统设计](#52-给水与排水系统设计)
    5.3. [生活热水](#53-生活热水)
6. [电气](#6-电气)
    6.1. [一般规定](#61-一般规定)
    6.2. [供配电系统](#62-供配电系统)
    6.3. [照 明](#63-照-明)
    6.4. [电能监测与计量](#64-电能监测与计量)
7. [可再生资源应用](#7-可再生资源应用)
    7.1. [一般规定](#71-一般规定)
    7.2. [太阳能利用](#72-太阳能利用)
    7.3. [地源热泵系统](#73-地源热泵系统)
[附录A 外墙平均传热系数的计算](#附录a-外墙平均传热系数的计算)
[附录B 围护结构热工性能的权衡计算](#附录b-围护结构热工性能的权衡计算)
[附录C 建筑围护结构热工性能权衡判断审核表](#附录c-建筑围护结构热工性能权衡判断审核表)
[附录D 管道与设备保温及保冷厚度](#附录d-管道与设备保温及保冷厚度)
[本标准用词说明](#本标准用词说明)
[引用标准名录](#引用标准名录)

---

## 1 总则

**1.0.1** 为贯彻国家有关法律法规和方针政策，改善公共建筑的室内环境，提高能源利用效率，促进可再生能源的建筑应用，降低建筑能耗，制定本标准。

**1.0.2** 本标准适用于新建、扩建和改建的公共建筑节能设计。

**1.0.3** 公共建筑节能设计应根据当地的气候条件，在保证室内环境参数条件下，改善围护结构保温隔热性能，提高建筑设备及系统的能源利用效率，利用可再生能源，降低建筑暖通空调、给水排水及电气系统的能耗。

**1.0.4** 当建筑高度超过150m或单栋建筑地上建筑面积大于200000m²时，除应符合本标准的各项规定外，还应组织专家对其节能设计进行专项论证。

**1.0.5** 施工图设计文件中应说明该工程项目采取的节能措施，并宜说明其使用要求。

**1.0.6** 公共建筑节能设计除应符合本标准的规定外，尚应符合国家现行有关标准的规定。

## 2 术语

**2.0.1** 透光幕墙 transparent curtain wall
可见光可直接透射入室内的幕墙。

**2.0.2** 建筑体形系数 shape factor
建筑物与室外空气直接接触的外表面积与其所包围的体积的比值，外表面积不包括地面和不供暖楼梯间内墙的面积。

**2.0.3** 单一立面窗墙面积比 single facade window to wall ratio
建筑某一个立面的窗户洞口面积与该立面的总面积之比，简称窗墙面积比。

**2.0.4** 太阳得热系数(SHGC) solar heat gain coefficient
通过透光围护结构(门窗或透光幕墙)的太阳辐射室内得热量与投射到透光围护结构(门窗或透光幕墙)外表面上的太阳辐射量的比值。太阳辐射室内得热量包括太阳辐射通过辐射透射的得热量和太阳辐射被构件吸收再传入室内的得热量两部分。

**2.0.5** 可见光透射比 visible transmittance
透过透光材料的可见光光通量与投射在其表面上的可见光光通量之比。

**2.0.6** 围护结构热工性能权衡判断 building envelope thermal performance trade-off
当建筑设计不能完全满足围护结构热工设计规定指标要求时，计算并比较参照建筑和设计建筑的全年供暖和空气调节能耗，判定围护结构的总体热工性能是否符合节能设计要求的方法，简称权衡判断。

**2.0.7** 参照建筑 reference building
进行围护结构热工性能权衡判断时，作为计算满足标准要求的全年供暖和空气调节能耗用的基准建筑。

**2.0.8** 综合部分负荷性能系数(IPLV) integrated part load value
基于机组部分负荷时的性能系数值，按机组在各种负荷条件下的累积负荷百分比进行加权计算获得的表示空气调节用冷水机组部分负荷效率的单一数值。

**2.0.9** 集中供暖系统耗电输热比(EHR-h) electricity consumption to transferred heat quantity ratio
设计工况下，集中供暖系统循环水泵总功耗(kW)与设计热负荷(kW)的比值。

**2.0.10** 空调冷(热)水系统耗电输冷(热)比 [EC(H)R-a] electricity consumption to transferred cooling(heat)quantity ratio
设计工况下，空调冷(热)水系统循环水泵总功耗(kW)与设计冷(热)负荷(kW)的比值。

**2.0.11** 电冷源综合制冷性能系数 (SCOP) system coefficient of refrigeration performance
设计工况下，电驱动的制冷系统的制冷量与制冷机、冷却水泵及冷却塔净输入能量之比。

**2.0.12** 风道系统单位风量耗功率 (Ws) energy consumption per unit air volume of air duct system
设计工况下，空调、通风的风道系统输送单位风量(m³/h)所消耗的电功率(W)。

## 3 建筑与建筑热工

### 3.1 一般规定

**3.1.1** 公共建筑分类应符合下列规定：
1. 单栋建筑面积大于300m²的建筑，或单栋建筑面积小于或等于300m²但总建筑面积大于1000m²的建筑群，应为甲类公共建筑；
2. 单栋建筑面积小于或等于300m²的建筑，应为乙类公共建筑。

**3.1.2** 代表城市的建筑热工设计分区应按表3.1.2确定。

**3.1.3** 建筑群的总体规划应考虑减轻热岛效应。建筑的总体规划和总平面设计应有利于自然通风和冬季日照。建筑的主朝向宜选择本地区最佳朝向或适宜朝向，且宜避开冬季主导风向。

**3.1.4** 建筑设计应遵循被动节能措施优先的原则，充分利用天然采光、自然通风，结合围护结构保温隔热和遮阳措施，降低建筑的用能需求。

**3.1.5** 建筑体形宜规整紧凑，避免过多的凹凸变化。

**3.1.6** 建筑总平面设计及平面布置应合理确定能源设备机房的位置，缩短能源供应输送距离。同一公共建筑的冷热源机房宜位于或靠近冷热负荷中心位置集中设置。

### 3.2 建筑设计

**3.2.1** 严寒和寒冷地区公共建筑体形系数应符合表3.2.1的规定。
> **（自2022年4月1日起废止该条）**

**3.2.2** 严寒地区甲类公共建筑各单一立面窗墙面积比(包括透光幕墙)均不宜大于0.60；其他地区甲类公共建筑各单一立面窗墙面积比(包括透光幕墙)均不宜大于0.70。

**3.2.3** 单一立面窗墙面积比的计算应符合下列规定：
1. 凸凹立面朝向应按其所在立面的朝向计算；
2. 楼梯间和电梯间的外墙和外窗均应参与计算；
3. 外凸窗的顶部、底部和侧墙的面积不应计入外墙面积；
4. 当外墙上的外窗、顶部和侧面为不透光构造的凸窗时，窗面积应按窗洞口面积计算；当凸窗顶部和侧面透光时，外凸窗面积应按透光部分实际面积计算。

**3.2.4** 甲类公共建筑单一立面窗墙面积比小于0.40时，透光材料的可见光透射比不应小于0.60；甲类公共建筑单一立面窗墙面积比大于等于0.40时，透光材料的可见光透射比不应小于0.40。

**3.2.5** 夏热冬暖、夏热冬冷、温和地区的建筑各朝向外窗(包括透光幕墙)均应采取遮阳措施；寒冷地区的建筑宜采取遮阳措施。当设置外遮阳时应符合下列规定：
1. 东西向宜设置活动外遮阳，南向宜设置水平外遮阳；
2. 建筑外遮阳装置应兼顾通风及冬季日照。

**3.2.6** 建筑立面朝向的划分应符合下列规定：
1. 北向应为北偏西60°至北偏东60°；
2. 南向应为南偏西30°至南偏东30°；
3. 西向应为西偏北30°至西偏南60°(包括西偏北30°和西偏南60°)；
4. 东向应为东偏北30°至东偏南60°(包括东偏北30°和东偏南60°)。

**3.2.7** 甲类公共建筑的屋顶透光部分面积不应大于屋顶总面积的20%。当不能满足本条的规定时，必须按本标准规定的方法进行权衡判断。
> **（自2022年4月1日起废止该条）**

**3.2.8** 单一立面外窗(包括透光幕墙)的有效通风换气面积应符合下列规定；
1. 甲类公共建筑外窗(包括透光幕墙)应设可开启窗扇，其有效通风换气面积不宜小于所在房间外墙面积的10%；当透光幕墙受条件限制无法设置可开启窗扇时，应设置通风换气装置。
2. 乙类公共建筑外窗有效通风换气面积不宜小于窗面积的30%。

**3.2.9** 外窗(包括透光幕墙)的有效通风换气面积应为开启扇面积和窗开启后的空气流通界面面积的较小值。

**3.2.10** 严寒地区建筑的外门应设置门斗；寒冷地区建筑面向冬季主导风向的外门应设置门斗或双层外门，其他外门宜设置门斗或应采取其他减少冷风渗透的措施；夏热冬冷、夏热冬暖和温和地区建筑的外门应采取保温隔热措施。

**3.2.11** 建筑中庭应充分利用自然通风降温，并可设置机械排风装置加强自然补风。

**3.2.12** 建筑设计应充分利用天然采光。天然采光不能满足照明要求的场所，宜采用导光、反光等装置将自然光引入室内。

**3.2.13** 人员长期停留房间的内表面可见光反射比宜符合表3.2.13的规定。

**3.2.14** 电梯应具备节能运行功能。两台及以上电梯集中排列时，应设置群控措施。电梯应具备无外部召唤且轿厢内一段时间无预置指令时，自动转为节能运行模式的功能。

**3.2.15** 自动扶梯、自动人行步道应具备空载时暂停或低速运转的功能。

### 3.3 围护结构热工设计

**3.3.1** 根据建筑热工设计的气候分区，甲类公共建筑的围护结构热工性能应分别符合表3.3.1-1～表3.3.1-6的规定。当不能满足本条的规定时，必须按本标准规定的方法进行权衡判断。
> **（自2022年4月1日起废止该条）**

**3.3.2** 乙类公共建筑的围护结构热工性能应符合表3.3.2-1和表3.3.2-2的规定。
> **（自2022年4月1日起废止该条）**

**3.3.3** 建筑围护结构热工性能参数计算应符合下列规定：
1. 外墙的传热系数应为包括结构性热桥在内的平均传热系数，平均传热系数应按本标准附录A的规定进行计算；
2. 外窗(包括透光幕墙)的传热系数应按现行国家标准《民用建筑热工设计规范》GB 50176的有关规定计算；
3. 当设置外遮阳构件时，外窗(包括透光幕墙)的太阳得热系数应为外窗(包括透光幕墙)本身的太阳得热系数与外遮阳构件的遮阳系数的乘积。外窗(包括透光幕墙)本身的太阳热系数和外遮阳构件的遮阳系数应按现行国家标准《民用建筑热工设计规范》GB 50176的有关规定计算。

**3.3.4** 屋面、外墙和地下室的热桥部位的内表面温度不应低于室内空气露点温度。

**3.3.5** 建筑外门、外窗的气密性分级应符合国家标准《建筑外门窗气密、水密、抗风压性能分级及检测方法》GB/T 7106-2008中第4.1.2条的规定，并应满足下列要求：
1. 10层及以上建筑外窗的气密性不应低于7级；
2. 10层以下建筑外窗的气密性不应低于6级；
3. 严寒和寒冷地区外门的气密性不应低于4级。

**3.3.6** 建筑幕墙的气密性应符合国家标准《建筑幕墙》GB/T 21086-2007中第5.1.3条的规定且不应低于3级。

**3.3.7** 当公共建筑入口大堂采用全玻幕墙时，全玻幕墙中非中空玻璃的面积不应超过同一立面透光面积(门窗和玻璃幕墙)的15%，且应按同一立面透光面积(含全玻幕墙面积)加权计算平均传热系数。
> **（自2022年4月1日起废止该条）**

### 3.4 围护结构热工性能的权衡判断

**3.4.1** 进行围护结构热工性能权衡判断前，应对设计建筑的热工性能进行核查；当满足下列基本要求时，方可进行权衡判断：
1. 屋面的传热系数基本要求应符合表3.4.1-1的规定。
2. 外墙(包括非透光幕墙)的传热系数基本要求应符合表3.4.1-2的规定。
3. 当单一立面的窗墙面积比大于或等于0.40时，外窗(包括透光幕墙)的传热系数和综合太阳得热系数基本要求应符合表3.4.1-3的规定。

**3.4.2** 建筑围护结构热工性能的权衡判断，应首先计算参照建筑在规定条件下的全年供暖和空气调节能耗，然后计算设计建筑在相同条件下的全年供暖和空气调节能耗，当设计建筑的供暖和空气调节能耗小于或等于参照建筑的供暖和空气调节能耗时，应判定围护结构的总体热工性能符合节能要求。当设计建筑的供暖和空气调节能耗大于参照建筑的供暖和空气调节能耗时，应调整设计参数重新计算，直至设计建筑的供暖和空气调节能耗不大于参照建筑的供暖和空气调节能耗。

**3.4.3** 参照建筑的形状、大小、朝向、窗墙面积比、内部的空间划分和使用功能应与设计建筑完全一致。当设计建筑的屋顶透光部分的面积大于本标准第3.2.7条的规定时，参照建筑的屋顶透光部分的面积应按比例缩小，使参照建筑的屋顶透光部分的面积符合本标准第3.2.7条的规定。

**3.4.4** 参照建筑围护结构的热工性能参数取值应按本标准第3.3.1条的规定取值。参照建筑的外墙和屋面的构造应与设计建筑一致。当本标准第3.3.1条对外窗(包括透光幕墙)太阳得热系数未作规定时，参照建筑外窗(包括透光幕墙)的太阳得热系数应与设计建筑一致。

**3.4.5** 建筑围护结构热工性能的权衡计算应符合本标准附录B的规定，并应按本标准附录C提供相应的原始信息和计算结果。

## 4 供暖通风与空气调节

### 4.1 一般规定

**4.1.1** 甲类公共建筑的施工图设计阶段，必须进行热负荷计算和逐项逐时的冷负荷计算。
> **（自2022年4月1日起废止该条）**

**4.1.2** 严寒A区和严寒B区的公共建筑宜设热水集中供暖系统，对于设置空气调节系统的建筑，不宜采用热风末端作为唯一的供暖方式；对于严寒C区和寒冷地区的公共建筑，供暖方式应根据建筑等级、供暖期天数、能源消耗量和运行费用等因素，经技术经济综合分析比较后确定。

**4.1.3** 系统冷热媒温度的选取应符合现行国家标准《民用建筑供暖通风与空气调节设计规范》GB 50736的有关规定。在经济技术合理时，冷媒温度宜高于常用设计温度，热媒温度宜低于常用设计温度。

**4.1.4** 当利用通风可以排除室内的余热、余湿或其他污染物时，宜采用自然通风、机械通风或复合通风的通风方式。

**4.1.5** 符合下列情况之一时，宜采用分散设置的空调装置或系统：
1. 全年所需供冷、供暖时间短或采用集中供冷、供暖系统不经济；
2. 需设空气调节的房间布置分散；
3. 设有集中供冷、供暖系统的建筑中，使用时间和要求不同的房间；
4. 需增设空调系统，而难以设置机房和管道的既有公共建筑。

**4.1.6** 采用温湿度独立控制空调系统时，应符合下列要求：
1. 应根据气候特点，经技术经济分析论证，确定高温冷源的制备方式和新风除湿方式；
2. 宜考虑全年对天然冷源和可再生能源的应用措施；
3. 不宜采用再热空气处理方式。

**4.1.7** 使用时间不同的空气调节区不应划分在同一个定风量全空气风系统中。温度、湿度等要求不同的空气调节区不宜划分在同一个空气调节风系统中。

### 4.2 冷源与热源

**4.2.1** 供暖空调冷源与热源应根据建筑规模、用途、建设地点的能源条件、结构、价格以及国家节能减排和环保政策的相关规定，通过综合论证确定，并应符合下列规定：
1. 有可供利用的废热或工业余热的区域，热源宜采用废热或工业余热。当废热或工业余热的温度较高、经技术经济论证合理时，冷源宜采用吸收式冷水机组。
2. 在技术经济合理的情况下，冷、热源宜利用浅层地能、太阳能、风能等可再生能源。当采用可再生能源受到气候等原因的限制无法保证时，应设置辅助冷、热源。
3. 不具备本条第1、2款的条件，但有城市或区域热网的地区，集中式空调系统的供热热源宜优先采用城市或区域热网。
4. 不具备本条第1、2款的条件，但城市电网夏季供电充足的地区，空调系统的冷源宜采用电动压缩式机组。
5. 不具备本条第1款～第4款的条件，但城市燃气供应充足的地区，宜采用燃气锅炉、燃气热水机供热或燃气吸收式冷(温)水机组供冷、供热。
6. 不具备本条第1款～5款条件的地区，可采用燃煤锅炉、燃油锅炉供热，蒸汽吸收式冷水机组或燃油吸收式冷(温)水机组供冷、供热。
7. 夏季室外空气设计露点温度较低的地区，宜采用间接蒸发冷却冷水机组作为空调系统的冷源。
8. 天然气供应充足的地区，当建筑的电力负荷、热负荷和冷负荷能较好匹配、能充分发挥冷、热、电联产系统的能源综合利用效率且经济技术比较合理时，宜采用分布式燃气冷热电三联供系统。
9. 全年进行空气调节，且各房间或区域负荷特性相差较大，需要长时间地向建筑同时供热和供冷，经技术经济比较合理时，宜采用水环热泵空调系统供冷、供热。
10. 在执行分时电价、峰谷电价差较大的地区，经技术经济比较，采用低谷电能够明显起到对电网“削峰填谷”和节省运行费用时，宜采用蓄能系统供冷、供热。
11. 夏热冬冷地区以及干旱缺水地区的中、小型建筑宜采用空气源热泵或土壤源地源热泵系统供冷、供热。
12. 有天然地表水等资源可供利用，或者有可利用的浅层地下水且能保证100%回灌时，可采用地表水或地下水地源热泵系统供冷、供热。
13. 具有多种能源的地区，可采用复合式能源供冷、供热。

**4.2.2** 除符合下列条件之一外，不得采用电直接加热设备作为供暖热源：
1. 电力供应充足，且电力需求侧管理鼓励用电时；
2. 无城市或区域集中供热，采用燃气、煤、油等燃料受到环保或消防限制，且无法利用热泵提供供暖热源的建筑；
3. 以供冷为主、供暖负荷非常小，且无法利用热泵或其他方式提供供暖热源的建筑；
4. 以供冷为主、供暖负荷小，无法利用热泵或其他方式提供供暖热源，但可以利用低谷电进行蓄热，且电锅炉不在用电高峰和平段时间启用的空调系统；
5. 利用可再生能源发电，且其发电量能满足自身电加热用电量需求的建筑。
> **（自2022年4月1日起废止该条）**

**4.2.3** 除符合下列条件之一外，不得采用电直接加热设备作为空气加湿热源：
1. 电力供应充足，且电力需求侧管理鼓励用电时；
2. 利用可再生能源发电，且其发电量能满足自身加湿用电量需求的建筑；
3. 冬季无加湿用蒸汽源，且冬季室内相对湿度控制精度要求高的建筑。
> **（自2022年4月1日起废止该条）**

**4.2.4** 锅炉供暖设计应符合下列规定：
1. 单台锅炉的设计容量应以保证其具有长时间较高运行效率的原则确定，实际运行负荷率不宜低于50%；
2. 在保证锅炉具有长时间较高运行效率的前提下，各台锅炉的容量宜相等；
3. 当供暖系统的设计回水温度小于或等于50℃时，宜采用冷凝式锅炉。

**4.2.5** 名义工况和规定条件下，锅炉的热效率不应低于表4.2.5的数值。
> **（自2022年4月1日起废止该条）**

**4.2.6** 除下列情况外，不应采用蒸汽锅炉作为热源：
1. 厨房、洗衣、高温消毒以及工艺性湿度控制等必须采用蒸汽的热负荷；
2. 蒸汽热负荷在总热负荷中的比例大于70%且总热负荷不大于1.4MW。

**4.2.7** 集中空调系统的冷水(热泵)机组台数及单机制冷量(制热量)选择，应能适应负荷全年变化规律，满足季节及部分负荷要求。机组不宜少于两台，且同类型机组不宜超过4台；当小型工程仅设一台时，应选调节性能优良的机型，并能满足建筑最低负荷的要求。

**4.2.8** 电动压缩式冷水机组的总装机容量，应按本标准第4.1.1条的规定计算的空调冷负荷值直接选定，不得另作附加。在设计条件下，当机组的规格不符合计算冷负荷的要求时，所选择机组的总装机容量与计算冷负荷的比值不得大于1.1。
> **（自2022年4月1日起废止该条）**

**4.2.9** 采用分布式能源站作为冷热源时，宜采用由自身发电驱动、以热电联产产生的废热为低位热源的热泵系统。

**4.2.10** 采用电机驱动的蒸气压缩循环冷水(热泵)机组时，其在名义制冷工况和规定条件下的性能系数(COP)应符合下列规定：
1. 水冷定频机组及风冷或蒸发冷却机组的性能系数(COP)不应低于表4.2.10的数值；
2. 水冷变频离心式机组的性能系数(COP)不应低于表4.2.10中数值的0.93倍；
3. 水冷变频螺杆式机组的性能系数(COP)不应低于表4.2.10中数值的0.95倍。
> **（自2022年4月1日起废止该条）**

**4.2.11** 电机驱动的蒸气压缩循环冷水(热泵)机组的综合部分负荷性能系数(IPLV)应符合下列规定：
1. 综合部分负荷性能系数(IPLV)计算方法应符合本标准第4.2.13条的规定；
2. 水冷定频机组的综合部分负荷性能系数(IPLV)不应低于表4.2.11的数值；
3. 水冷变频离心式冷水机组的综合部分负荷性能系数(IPLV)不应低于表4.2.11中水冷离心式冷水机组限值的1.30倍；
4. 水冷变频螺杆式冷水机组的综合部分负荷性能系数(IPLV)不应低于表4.2.11中水冷螺杆式冷水机组限值的1.15倍。

**4.2.12** 空调系统的电冷源综合制冷性能系数(SCOP)不应低于表4.2.12的数值。对多台冷水机组、冷却水泵和冷却塔组成的冷水系统，应将实际参与运行的所有设备的名义制冷量和耗电功率综合统计计算，当机组类型不同时，其限值应按冷量加权的方式确定。

**4.2.13** 电机驱动的蒸气压缩循环冷水(热泵)机组的综合部分负荷性能系数(IPLV)应按下式计算：
> IPLV = 2.3%×A + 41.5%×B + 46.1%×C + 10.1%×D
>
> 式中：A——100％负荷时的性能系数(W/W)，冷却水进水温度30℃/冷凝器进气干球温度35℃；
> B——75％负荷时的性能系数(W/W)，冷却水进水温度26℃/冷凝器进气干球温度31.5℃；
> C——50％负荷时的性能系数(W/W)，冷却水进水温度23℃/冷凝器进气干球温度28℃；
> D——25％负荷时的性能系数(W/W)，冷却水进水温度19℃/冷凝器进气干球温度24.5℃。

**4.2.14** 采用名义制冷量大于7.1kW、电机驱动的单元式空气调节机、风管送风式和屋顶式空气调节机组时，其在名义制冷工况和规定条件下的能效比(EER)不应低于表4.2.14的数值。
> **（自2022年4月1日起废止该条）**

**4.2.15** 空气源热泵机组的设计应符合下列规定：
1. 具有先进可靠的融霜控制，融霜时间总和不应超过运行周期时间的20%；
2. 冬季设计工况下，冷热风机组性能系数(COP)不应小于1.8，冷热水机组性能系数(COP)不应小于2.0；
3. 冬季寒冷、潮湿的地区，当室外设计温度低于当地平衡点温度时，或当室内温度稳定性有较高要求时，应设置辅助热源；
4. 对于同时供冷、供暖的建筑，宜选用热回收式热泵机组。

**4.2.16** 空气源、风冷、蒸发冷却式冷水(热泵)式机组室外机的设置，应符合下列规定：
1. 应确保进风与排风通畅，在排出空气与吸入空气之间不发生明显的气流短路；
2. 应避免污浊气流的影响；
3. 噪声和排热应符合周围环境要求；
4. 应便于对室外机的换热器进行清扫。

**4.2.17** 采用多联式空调(热泵)机组时，其在名义制冷工况和规定条件下的制冷综合性能系数IPLV(C)不应低于表4.2.17的数值。
> **（自2022年4月1日起废止该条）**

**4.2.18** 除具有热回收功能型或低温热泵型多联机系统外，多联机空调系统的制冷剂连接管等效长度应满足对应制冷工况下满负荷时的能效比(EER)不低于2.8的要求。

**4.2.19** 采用直燃型溴化锂吸收式冷(温)水机组时，其在名义工况和规定条件下的性能参数应符合表4.2.19的规定。
> **（自2022年4月1日起废止该条）**

**4.2.20** 对冬季或过渡季存在供冷需求的建筑，应充分利用新风降温；经技术经济分析合理时，可利用冷却塔提供空气调节冷水或使用具有同时制冷和制热功能的空调(热泵)产品。

**4.2.21** 采用蒸汽为热源，经技术经济比较合理时，应回收用汽设备产生的凝结水。凝结水回收系统应采用闭式系统。

**4.2.22** 对常年存在生活热水需求的建筑，当采用电动蒸汽压缩循环冷水机组时，宜采用具有冷凝热回收功能的冷水机组。

### 4.3 输配系统

**4.3.1** 集中供暖系统应采用热水作为热媒。

**4.3.2** 集中供暖系统的热力入口处及供水或回水管的分支管路上，应根据水力平衡要求设置水力平衡装置。

**4.3.3** 在选配集中供暖系统的循环水泵时，应计算集中供暖系统耗电输热比(EHR-h)，并应标注在施工图的设计说明中。集中供暖系统耗电输热比应按下式计算：
> EHR-h = G·H / (367.3·Q·ΔT)
>
> 式中：EHR-h——集中供暖系统耗电输热比；
> G——每台运行水泵的设计流量(m³/h)；
> H——每台运行水泵对应的设计扬程(mH₂O)；
> ηb——每台运行水泵对应的设计工作点效率；
> Q——设计热负荷(kW)；
> ΔT——设计供回水温差(℃)；
> A——与水泵流量有关的计算系数，按本标准表4.3.9-2选取；
> B——与机房及用户的水阻力有关的计算系数，一级泵系统时B取17，二级泵系统时B取21；
> ∑L——热力站至供暖末端(散热器或辐射供暖分集水器)供回水管道的总长度(m)；
> α——与∑L有关的计算系数；
> 当∑L≤400m时，α＝0.0115；
> 当400m＜∑L＜1000m时，α＝0.003833＋3.067/∑L；
> 当∑L≥1000m时，α＝0.0069。

**4.3.4** 集中供暖系统采用变流量水系统时，循环水泵宜采用变速调节控制。

**4.3.5** 集中空调冷、热水系统的设计应符合下列规定：
1. 当建筑所有区域只要求按季节同时进行供冷和供热转换时，应采用两管制空调水系统；当建筑内一些区域的空调系统需全年供冷、其他区域仅要求按季节进行供冷和供热转换时，可采用分区两管制空调水系统；当空调水系统的供冷和供热工况转换频繁或需同时使用时，宜采用四管制空调水系统。
2. 冷水水温和供回水温差要求一致且各区域管路压力损失相差不大的中小型工程，宜采用变流量一级泵系统；单台水泵功率较大时，经技术经济比较，在确保设备的适应性、控制方案和运行管理可靠的前提下，空调冷水可采用冷水机组和负荷侧均变流量的一级泵系统，且一级泵应采用调速泵。
3. 系统作用半径较大、设计水流阻力较高的大型工程，空调冷水宜采用变流量二级泵系统。当各环路的设计水温一致且设计水流阻力接近时，二级泵宜集中设置；当各环路的设计水流阻力相差较大或各系统水温或温差要求不同时，宜按区域或系统分别设置二级泵，且二级泵应采用调速泵。
4. 提供冷源设备集中且用户分散的区域供冷的大规模空调冷水系统，当二级泵的输送距离较远且各用户管路阻力相差较大，或者水温(温差)要求不同时，可采用多级泵系统，且二级泵等负荷侧各级泵应采用调速泵。

**4.3.6** 空调水系统布置和管径的选择，应减少并联环路之间压力损失的相对差额。当设计工况下并联环路之间压力损失的相对差额超过15%时，应采取水力平衡措施。

**4.3.7** 采用换热器加热或冷却的二次空调水系统的循环水泵宜采用变速调节。

**4.3.8** 除空调冷水系统和空调热水系统的设计流量、管网阻力特性及水泵工作特性相近的情况外，两管制空调水系统应分别设置冷水和热水循环泵。

**4.3.9** 在选配空调冷(热)水系统的循环水泵时，应计算空调冷(热)水系统耗电输冷(热)比[EC(H)R-a]，并应标注在施工图的设计说明中。空调冷(热)水系统耗电输冷(热)比计算应符合下列规定：
1. 空调冷(热)水系统耗电输冷(热)比应按下式计算：
> EC(H)R-a = G·H / (367.3·Q·ΔT)
>
> 式中：EC(H)R-a——空调冷(热)水系统循环水泵的耗电输冷(热)比；
> G——每台运行水泵的设计流量(m³/h)；
> H——每台运行水泵对应的设计扬程(mH₂O)；
> ηb——每台运行水泵对应的设计工作点效率；
> Q——设计冷(热)负荷(kW)；
> ΔT——规定的计算供回水温差(℃)，按表4.3.9-1选取；
> A——与水泵流量有关的计算系数，按表4.3.9-2选取；
> B——与机房及用户的水阻力有关的计算系数，按表4.3.9-3选取；
> α——与∑L有关的计算系数，按表4.3.9-4或表4.3.9-5选取；
> ∑L——从冷热机房出口至该系统最远用户供回水管道的总输送长度(m)。

2. 空调冷(热)水系统耗电输冷(热)比计算参数应符合下列规定：
1) 空气源热泵、溴化锂机组、水源热泵等机组的热水供回水温差应按机组实际参数确定；直接提供高温冷水的机组，冷水供回水温差应按机组实际参数确定。
2) 多台水泵并联运行时，A值应按较大流量选取。
3) 两管制冷水管道的B值应按四管制单冷管道的B值选取；多级泵冷水系统，每增加一级泵，B值可增加5；多级泵热水系统，每增加一级泵，B值可增加4。
4) 两管制冷水系统α计算式应与四管制冷水系统相同。
5) 当最远用户为风机盘管时，∑L应按机房出口至最远端风机盘管的供回水管道总长度减去100m确定。

**4.3.10** 当通风系统使用时间较长且运行工况(风量、风压)有较大变化时，通风机宜采用双速或变速风机。

**4.3.11** 设计定风量全空气空气调节系统时，宜采取实现全新风运行或可调新风比的措施，并宜设计相应的排风系统。

**4.3.12** 当一个空气调节风系统负担多个使用空间时，系统的新风量应按下列公式计算：
> Y = X / (1 + X - Z)
> Vot = Y * Vst
>
> 式中：Y——修正后的系统新风量在送风量中的比例；
> Vot——修正后的总新风量(m³/h)；
> Vst——总送风量，即系统中所有房间送风量之和(m³/h)；
> X——未修正的系统新风量在送风量中的比例；
> Von——系统中所有房间的新风量之和(m³/h)：
> Z——新风比需求最大的房间的新风比；
> Voc——新风比需求最大的房间的新风量(m³/h)；
> Vsc——新风比需求最大的房间的送风量(m³/h)。

**4.3.13** 在人员密度相对较大且变化较大的房间，宜根据室内CO2浓度检测值进行新风需求控制，排风量也宜适应新风量的变化以保持房间的正压。

**4.3.14** 当采用人工冷、热源对空气调节系统进行预热或预冷运行时，新风系统应能关闭；当室外空气温度较低时，应尽量利用新风系统进行预冷。

**4.3.15** 空气调节内、外区应根据室内进深、分隔、朝向、楼层以及围护结构特点等因素划分。内、外区宜分别设置空气调节系统。

**4.3.16** 风机盘管加新风空调系统的新风宜直接送入各空气调节区，不宜经过风机盘管机组后再送出。

**4.3.17** 空气过滤器的设计选择应符合下列规定：
1. 空气过滤器的性能参数应符合现行国家标准《空气过滤器》GB/T 14295的有关规定；
2. 宜设置过滤器阻力监测、报警装置，并应具备更换条件；
3. 全空气空气调节系统的过滤器应能满足全新风运行的需要。

**4.3.18** 空气调节风系统不应利用土建风道作为送风道和输送冷、热处理后的新风风道。当受条件限制利用土建风道时，应采取可靠的防漏风和绝热措施。

**4.3.19** 空气调节冷却水系统设计应符合下列规定：
1. 应具有过滤、缓蚀、阻垢、杀菌、灭藻等水处理功能；
2. 冷却塔应设置在空气流通条件好的场所；
3. 冷却塔补水总管上应设置水流量计量装置；
4. 当在室内设置冷却水集水箱时，冷却塔布水器与集水箱设计水位之间的高差不应超过8m。

**4.3.20** 空气调节系统送风温差应根据焓湿图表示的空气处理过程计算确定。空气调节系统采用上送风气流组织形式时，宜加大夏季设计送风温差，并应符合下列规定：
1. 送风高度小于或等于5m时，送风温差不宜小于5℃；
2. 送风高度大于5m时，送风温差不宜小于10℃。

**4.3.21** 在同一个空气处理系统中，不宜同时有加热和冷却过程。

**4.3.22** 空调风系统和通风系统的风量大于10000m³/h时，风道系统单位风量耗功率(Ws)不宜大于表4.3.22的数值。风道系统单位风量耗功率(Ws)应按下式计算：
> Ws = P / (ηF * ηCD * 1000)
>
> 式中：Ws——风道系统单位风量耗功率[W/(m³/h)]；
> P——空调机组的余压或通风系统风机的风压(Pa)；
> ηCD——电机及传动效率(%)，ηCD取0.855；
> ηF——风机效率(%)，按设计图中标注的效率选择。

**4.3.23** 当输送冷媒温度低于其管道外环境温度且不允许冷媒温度有升高，或当输送热媒温度高于其管道外环境温度且不允许热媒温度有降低时，管道与设备应采取保温保冷措施。绝热层的设置应符合下列规定：
1. 保温层厚度应按现行国家标准《设备及管道绝热设计导则》GB/T 8175中经济厚度计算方法计算；
2. 供冷或冷热共用时，保冷层厚度应按现行国家标准《设备及管道绝热设计导则》GB/T 8175中经济厚度和防止表面结露的保冷层厚度方法计算，并取大值；
3. 管道与设备绝热层厚度及风管绝热层最小热阻可按本标准附录D的规定选用；
4. 管道和支架之间，管道穿墙、穿楼板处应采取防止“热桥”或“冷桥”的措施；
5. 采用非闭孔材料保温时，外表面应设保护层；采用非闭孔材料保冷时，外表面应设隔汽层和保护层。

**4.3.24** 严寒和寒冷地区通风或空调系统与室外相连接的风管和设施上应设置可自动连锁关闭且密闭性能好的电动风阀，并采取密封措施。

**4.3.25** 设有集中排风的空调系统经技术经济比较合理时，宜设置空气-空气能量回收装置。严寒地区采用时，应对能量回收装置的排风侧是否出现结霜或结露现象进行核算。当出现结霜或结露时，应采取预热等保温防冻措施。

**4.3.26** 有人员长期停留且不设置集中新风、排风系统的空气调节区或空调房间，宜在各空气调节区或空调房间分别安装带热回收功能的双向换气装置。

### 4.4 末端系统

**4.4.1** 散热器宜明装；地面辐射供暖面层材料的热阻不宜大于0.05m²·K/W。

**4.4.2** 夏季空气调节室外计算湿球温度低、温度日较差大的地区，宜优先采用直接蒸发冷却、间接蒸发冷却或直接蒸发冷却与间接蒸发冷却相结合的二级或三级蒸发冷却的空气处理方式。

**4.4.3** 设计变风量全空气空气调节系统时，应采用变频自动调节风机转速的方式，并应在设计文件中标明每个变风量末端装置的最小送风量。

**4.4.4** 建筑空间高度大于等于10m且体积大于10000m³时，宜采用辐射供暖供冷或分层空气调节系统。

**4.4.5** 机电设备用房、厨房热加工间等发热量较大的房间的通风设计应满足下列要求：
1. 在保证设备正常工作前提下，宜采用通风消除室内余热。机电设备用房夏季室内计算温度取值不宜低于夏季通风室外计算温度。
2. 厨房热加工间宜采用补风式油烟排气罩。采用直流式空调送风的区域，夏季室内计算温度取值不宜低于夏季通风室外计算温度。

### 4.5 监测、控制与计量

**4.5.1** 集中供暖通风与空气调节系统，应进行监测与控制。建筑面积大于20000m²的公共建筑使用全空气调节系统时，宜采用直接数字控制系统。系统功能及监测控制内容应根据建筑功能、相关标准、系统类型等通过技术经济比较确定。

**4.5.2** 锅炉房、换热机房和制冷机房应进行能量计量，能量计量应包括下列内容：
1. 燃料的消耗量；
2. 制冷机的耗电量；
3. 集中供热系统的供热量；
4. 补水量。
> **（自2022年4月1日起废止该条）**

**4.5.3** 采用区域性冷源和热源时，在每栋公共建筑的冷源和热源入口处，应设置冷量和热量计量装置。采用集中供暖空调系统时，不同使用单位或区域宜分别设置冷量和热量计量装置。

**4.5.4** 锅炉房和换热机房应设置供热量自动控制装置。
> **（自2022年4月1日起废止该条）**

**4.5.5** 锅炉房和换热机房的控制设计应符合下列规定：
1. 应能进行水泵与阀门等设备连锁控制；
2. 供水温度应能根据室外温度进行调节；
3. 供水流量应能根据末端需求进行调节；
4. 宜能根据末端需求进行水泵台数和转速的控制；
5. 应能根据需求供热量调节锅炉的投运台数和投入燃料量。

**4.5.6** 供暖空调系统应设置室温调控装置；散热器及辐射供暖系统应安装自动温度控制阀。
> **（自2022年4月1日起废止该条）**

**4.5.7** 冷热源机房的控制功能应符合下列规定：
1. 应能进行冷水(热泵)机组、水泵、阀门、冷却塔等设备的顺序启停和连锁控制；
2. 应能进行冷水机组的台数控制，宜采用冷量优化控制方式；
3. 应能进行水泵的台数控制，宜采用流量优化控制方式；
4. 二级泵应能进行自动变速控制，宜根据管道压差控制转速，且压差宜能优化调节；
5. 应能进行冷却塔风机的台数控制，宜根据室外气象参数进行变速控制；
6. 应能进行冷却塔的自动排污控制；
7. 宜能根据室外气象参数和末端需求进行供水温度的优化调节；
8. 宜能按累计运行时间进行设备的轮换使用；
9. 冷热源主机设备3台以上的，宜采用机组群控方式；当采用群控方式时，控制系统应与冷水机组自带控制单元建立通信连接。

**4.5.8** 全空气空调系统的控制应符合下列规定：
1. 应能进行风机、风阀和水阀的启停连锁控制；
2. 应能按使用时间进行定时启停控制，宜对启停时间进行优化调整；
3. 采用变风量系统时，风机应采用变速控制方式；
4. 过渡季宜采用加大新风比的控制方式；
5. 宜根据室外气象参数优化调节室内温度设定值；
6. 全新风系统送风末端宜采用设置人离延时关闭控制方式。

**4.5.9** 风机盘管应采用电动水阀和风速相结合的控制方式，宜设置常闭式电动通断阀。公共区域风机盘管的控制应符合下列规定：
1. 应能对室内温度设定值范围进行限制；
2. 应能按使用时间进行定时启停控制，宜对启停时间进行优化调整。

**4.5.10** 以排除房间余热为主的通风系统，宜根据房间温度控制通风设备运行台数或转速。

**4.5.11** 地下停车库风机宜采用多台并联方式或设置风机调速装置，并宜根据使用情况对通风机设置定时启停(台数)控制或根据车库内的一氧化碳浓度进行自动运行控制。

**4.5.12** 间歇运行的空气调节系统，宜设置自动启停控制装置。控制装置应具备按预定时间表、服务区域是否有人等模式控制设备启停的功能。

## 5 给水排水

### 5.1 一般规定

**5.1.1** 给水排水系统的节水设计应符合现行国家标准《建筑给水排水设计规范》GB 50015和《民用建筑节水设计标准》GB 50555有关规定。

**5.1.2** 计量水表应根据建筑类型、用水部门和管理要求等因素进行设置，并应符合现行国家标准《民用建筑节水设计标准》GB 50555的有关规定。

**5.1.3** 有计量要求的水加热、换热站室，应安装热水表、热量表、蒸汽流量计或能源计量表。

**5.1.4** 给水泵应根据给水管网水力计算结果选型，并应保证设计工况下水泵效率处在高效区。给水泵的效率不宜低于现行国家标准《清水离心泵能效限定值及节能评价值》GB 19762规定的泵节能评价值。

**5.1.5** 卫生间的卫生器具和配件应符合现行行业标准《节水型生活用水器具》CJ/T 164的有关规定。

### 5.2 给水与排水系统设计

**5.2.1** 给水系统应充分利用城镇给水管网或小区给水管网的水压直接供水。经批准可采用叠压供水系统。

**5.2.2** 二次加压泵站的数量、规模、位置和泵组供水水压应根据城镇给水条件、小区规模、建筑高度、建筑的分布、使用标准、安全供水和降低能耗等因素合理确定。

**5.2.3** 给水系统的供水方式及竖向分区应根据建筑的用途、层数、使用要求、材料设备性能、维护管理和能耗等因素综合确定。分区压力要求应符合现行国家标准《建筑给水排水设计规范》GB 50015和《民用建筑节水设计标准》GB 50555的有关规定。

**5.2.4** 变频调速泵组应根据用水量和用水均匀性等因素合理选择搭配水泵及调节设施，宜按供水需求自动控制水泵启动的台数，保证在高效区运行。

**5.2.5** 地面以上的生活污、废水排水宜采用重力流系统直接排至室外管网。

### 5.3 生活热水

**5.3.1** 集中热水供应系统的热源，宜利用余热、废热、可再生能源或空气源热泵作为热水供应热源。当最高日生活热水量大于5m³时，除电力需求侧管理鼓励用电，且利用谷电加热的情况外，不应采用直接电加热热源作为集中热水供应系统的热源。

**5.3.2** 以燃气或燃油作为热源时，宜采用燃气或燃油机组直接制备热水。当采用锅炉制备生活热水或开水时，锅炉额定工况下热效率不应低于本标准表4.2.5中的限定值。

**5.3.3** 当采用空气源热泵热水机组制备生活热水时，制热量大于10kW的热泵热水机在名义制热工况和规定条件下，性能系数(COP)不宜低于表5.3.3的规定，并应有保证水质的有效措施。

**5.3.4** 小区内设有集中热水供应系统的热水循环管网服务半径不宜大于300m且不应大于500m。水加热、热交换站室宜设置在小区的中心位置。

**5.3.5** 仅设有洗手盆的建筑不宜设计集中生活热水供应系统。设有集中热水供应系统的建筑中，日热水用量设计值大于等于5m³或定时供应热水的用户宜设置单独的热水循环系统。

**5.3.6** 集中热水供应系统的供水分区宜与用水点处的冷水分区同区，并应采取保证用水点处冷、热水供水压力平衡和保证循环管网有效循环的措施。

**5.3.7** 集中热水供应系统的管网及设备应采取保温措施，保温层厚度应按现行国家标准《设备及管道绝热设计导则》GB/T 8175中经济厚度计算方法确定，也可按本标准附录D的规定选用。

**5.3.8** 集中热水供应系统的监测和控制宜符合下列规定：
1. 对系统热水耗量和系统总供热量宜进行监测；
2. 对设备运行状态宜进行检测及故障报警；
3. 对每日用水量、供水温度宜进行监测；
4. 装机数量大于等于3台的工程，宜采用机组群控方式。

## 6 电气

### 6.1 一般规定

**6.1.1** 电气系统的设计应经济合理、高效节能。

**6.1.2** 电气系统宜选用技术先进、成熟、可靠，损耗低、谐波发射量少、能效高、经济合理的节能产品。

**6.1.3** 建筑设备监控系统的设置应符合现行国家标准《智能建筑设计标准》GB 50314的有关规定。

### 6.2 供配电系统

**6.2.1** 电气系统的设计应根据当地供电条件，合理确定供电电压等级。

**6.2.2** 配变电所应靠近负荷中心、大功率用电设备。

**6.2.3** 变压器应选用低损耗型，且能效值不应低于现行国家标准《三相配电变压器能效限定值及能效等级》GB 20052中能效标准的节能评价值。

**6.2.4** 变压器的设计宜保证其运行在经济运行参数范围内。

**6.2.5** 配电系统三相负荷的不平衡度不宜大于15%。单相负荷较多的供电系统，宜采用部分分相无功自动补偿装置。

**6.2.6** 容量较大的用电设备，当功率因数较低且离配变电所较远时，宜采用无功功率就地补偿方式。

**6.2.7** 大型用电设备、大型可控硅调光设备、电动机变频调速控制装置等谐波源较大设备，宜就地设置谐波抑制装置。当建筑中非线性用电设备较多时，宜预留滤波装置的安装空间。

### 6.3 照 明

**6.3.1** 室内照明功率密度(LPD)值应符合现行国家标准《建筑照明设计标准》GB 50034的有关规定。

**6.3.2** 设计选用的光源、镇流器的能效不宜低于相应能效标准的节能评价值。

**6.3.3** 建筑夜景照明的照明功率密度(LPD)限值应符合现行行业标准《城市夜景照明设计规范》JGJ/T 163的有关规定。

**6.3.4** 光源的选择应符合下列规定：
1. 一般照明在满足照度均匀度条件下，宜选择单灯功率较大、光效较高的光源，不宜选用荧光高压汞灯，不应选用自镇流荧光高压汞灯；
2. 气体放电灯用镇流器应选用谐波含量低的产品；
3. 高大空间及室外作业场所宜选用金属卤化物灯、高压钠灯；
4. 除需满足特殊工艺要求的场所外，不应选用白炽灯；
5. 走道、楼梯间、卫生间、车库等无人长期逗留的场所，宜选用发光二极管(LED)灯；
6. 疏散指示灯、出口标志灯、室内指向性装饰照明等宜选用发光二极管(LED)灯；
7. 室外景观、道路照明应选择安全、高效、寿命长、稳定的光源，避免光污染。

**6.3.5** 灯具的选择应符合下列规定：
1. 使用电感镇流器的气体放电灯应采用单灯补偿方式，其照明配电系统功率因数不应低于0.9；
2. 在满足眩光限制和配光要求条件下，应选用效率高的灯具，并应符合现行国家标准《建筑照明设计标准》GB 50034的有关规定；
3. 灯具自带的单灯控制装置宜预留与照明控制系统的接口。

**6.3.6** 一般照明无法满足作业面照度要求的场所，宜采用混合照明。

**6.3.7** 照明设计不宜采用漫射发光顶棚。

**6.3.8** 照明控制应符合下列规定：
1. 照明控制应结合建筑使用情况及天然采光状况，进行分区、分组控制；
2. 旅馆客房应设置节电控制型总开关；
3. 除单一灯具的房间，每个房间的灯具控制开关不宜少于2个，且每个开关所控的光源数不宜多于6盏；
4. 走廊、楼梯间、门厅、电梯厅、卫生间、停车库等公共场所的照明，宜采用集中开关控制或就地感应控制；
5. 大空间、多功能、多场景场所的照明，宜采用智能照明控制系统；
6. 当设置电动遮阳装置时，照度控制宜与其联动；
7. 建筑景观照明应设置平时、一般节日、重大节日等多种模式自动控制装置。

### 6.4 电能监测与计量

**6.4.1** 主要次级用能单位用电量大于等于10kW或单台用电设备大于等于100kW时，应设置电能计量装置。公共建筑宜设置用电能耗监测与计量系统，并进行能效分析和管理。

**6.4.2** 公共建筑应按功能区域设置电能监测与计量系统。

**6.4.3** 公共建筑应按照明插座、空调、电力、特殊用电分项进行电能监测与计量。办公建筑宜将照明和插座分项进行电能监测与计量。

**6.4.4** 冷热源系统的循环水泵耗电量宜单独计量。

## 7 可再生资源应用

### 7.1 一般规定

**7.1.1** 公共建筑的用能应通过对当地环境资源条件和技术经济的分析，结合国家相关政策，优先应用可再生能源。

**7.1.2** 公共建筑可再生能源利用设施应与主体工程同步设计。

**7.1.3** 当环境条件允许且经济技术合理时，宜采用太阳能、风能等可再生能源直接并网供电。

**7.1.4** 当公共电网无法提供照明电源时，应采用太阳能、风能等发电并配置蓄电池的方式作为照明电源。

**7.1.5** 可再生能源应用系统宜设置监测系统节能效益的计量装置。

### 7.2 太阳能利用

**7.2.1** 太阳能利用应遵循被动优先的原则。公共建筑设计宜充分利用太阳能。

**7.2.2** 公共建筑宜采用光热或光伏与建筑一体化系统；光热或光伏与建筑一体化系统不应影响建筑外围护结构的建筑功能，并应符合国家现行标准的有关规定。

**7.2.3** 公共建筑利用太阳能同时供热供电时，宜采用太阳能光伏光热一体化系统。

**7.2.4** 公共建筑设置太阳能热利用系统时，太阳能保证率应符合表7.2.4的规定。

**7.2.5** 太阳能热利用系统的辅助热源应根据建筑使用特点、用热量、能源供应、维护管理及卫生防菌等因素选择，并宜利用废热、余热等低品位能源和生物质、地热等其他可再生能源。

**7.2.6** 太阳能集热器和光伏组件的设置应避免受自身或建筑本体的遮挡。在冬至日采光面上的日照时数，太阳能集热器不应少于4h，光伏组件不宜少于3h。

### 7.3 地源热泵系统

**7.3.1** 公共建筑地源热泵系统设计时，应进行全年动态负荷与系统取热量、释热量计算分析，确定地热能交换系统，并宜采用复合热交换系统。

**7.3.2** 地源热泵系统设计应选用高能效水源热泵机组，并宜采取降低循环水泵输送能耗等节能措施，提高地源热泵系统的能效。

**7.3.3** 水源热泵机组性能应满足地热能交换系统运行参数的要求，末端供暖供冷设备选择应与水源热泵机组运行参数相匹配。

**7.3.4** 有稳定热水需求的公共建筑，宜根据负荷特点，采用部分或全部热回收型水源热泵机组。全年供热水时，应选用全部热回收型水源热泵机组或水源热水机组。

## 附录A 外墙平均传热系数的计算

**A.0.1** 外墙平均传热系数应按现行国家标准《民用建筑热工设计规范》GB 50176的有关规定进行计算。

**A.0.2** 对于一般建筑，外墙平均传热系数也可按下式计算：
> K = φ * Kp
>
> 式中：K——外墙平均传热系数[W/(m²·K)]；
> Kp——外墙主体部位传热系数[W/(m²·K)]；
> φ——外墙主体部位传热系数的修正系数。

**A.0.3** 外墙主体部位传热系数的修正系数φ可按表A.0.3取值。

## 附录B 围护结构热工性能的权衡计算

**B.0.1** 建筑围护结构热工性能权衡判断应采用能自动生成符合本标准要求的参照建筑计算模型的专用计算软件，软件应具有下列功能：
1. 全年8760h逐时负荷计算；
2. 分别逐时设置工作日和节假日室内人员数量、照明功率、设备功率、室内温度、供暖和空调系统运行时间；
3. 考虑建筑围护结构的蓄热性能；
4. 计算10个以上建筑分区；
5. 直接生成建筑围护结构热工性能权衡判断计算报告。

**B.0.2** 建筑围护结构热工性能权衡判断应以参照建筑与设计建筑的供暖和空气调节总耗电量作为其能耗判断的依据。参照建筑与设计建筑的供暖耗煤量和耗气量应折算为耗电量。

**B.0.3** 参照建筑与设计建筑的空气调节和供暖能耗应采用同一软件计算，气象参数均应采用典型气象年数据。

**B.0.4** 计算设计建筑全年累计耗冷量和累计耗热量时，应符合下列规定：
1. 建筑的形状、大小、朝向、内部的空间划分和使用功能、建筑构造尺寸、建筑围护结构传热系数、做法、外窗(包括透光幕墙)太阳得热系数、窗墙面积比、屋面开窗面积应与建筑设计文件一致；
2. 建筑空气调节和供暖应按全年运行的两管制风机盘管系统设置。建筑功能区除设计文件明确为非空调区外，均应按设置供暖和空气调节计算；
3. 建筑的空气调节和供暖系统运行时间、室内温度、照明功率密度值及开关时间、房间人均占有的使用面积及在室率、人员新风量及新风机组运行时间表、电气设备功率密度及使用率应按表8.0.4-1～表8.0.4-10设置。

**B.0.5** 计算参照建筑全年累计耗冷量和累计耗热量时，应符合下列规定：
1. 建筑的形状、大小、朝向、内部的空间划分和使用功能、建筑构造尺寸应与设计建筑一致；
2. 建筑围护结构做法应与建筑设计文件一致，围护结构热工性能参数取值应符合本标准第3.3节的规定；
3. 建筑空气调节和供暖系统的运行时间、室内温度、照明功率密度及开关时间、房间人均占有的使用面积及在室率、人员新风量及新风机组运行时间表、电气设备功率密度及使用率应与设计建筑一致；
4. 建筑空气调节和供暖应采用全年运行的两管制风机盘管系统。供暖和空气调节区的设置应与设计建筑一致。

**B.0.6** 计算设计建筑和参照建筑全年供暖和空调总耗电量时，空气调节系统冷源应采用电驱动冷水机组；严寒地区、寒冷地区供暖系统热源应采用燃煤锅炉；夏热冬冷地区、夏热冬暖地区、温和地区供暖系统热源应采用燃气锅炉，并应符合下列规定：
1. 全年供暖和空调总耗电量应按下式计算：
> E = EC + EH
>
> 式中：E——全年供暖和空调总耗电量(kWh/m²)；
> EC——全年空调耗电量(kWh/m²)；
> EH——全年供暖耗电量(kWh/m²)。

2. 全年空调耗电量应按下式计算：
> EC = QC / (A * SCOPT)
>
> 式中：QC——全年累计耗冷量(通过动态模拟软件计算得到)(kWh)；
> A——总建筑面积(m²)；
> SCOPT——供冷系统综合性能系数，取2.50。

3. 严寒地区和寒冷地区全年供暖耗电量应按下式计算：
> EH = QH * q2 / (A * η1 * q1)
>
> 式中：QH——全年累计耗热量(通过动态模拟软件计算得到)(kWh)；
> η1——热源为燃煤锅炉的供暖系统综合效率，取0.60；
> q1——标准煤热值，取8.14kWh/kgce；
> q2——发电煤耗(kgce/kWh)取0.360kgce/kWh。

4. 夏热冬冷、夏热冬暖和温和地区全年供暖耗电量应按下式计算：
> EH = QH * φ / (A * η2 * q3)
>
> 式中：η2——热源为燃气锅炉的供暖系统综合效率，取0.75；
> q3——标准天然气热值，取9.87kWh/m³；
> φ——天然气与标煤折算系数．取1.21kgce/m³。

## 附录C 建筑围护结构热工性能权衡判断审核表

*(此附录为表格形式，用于提交审查，此处省略具体表格内容)*

## 附录D 管道与设备保温及保冷厚度

**D.0.1** 热管道经济绝热层厚度可按表D.0.1-1～表D.0.1-3选用。热设备绝热层厚度可按最大口径管道的绝热层厚度再增加5mm选用。

**D.0.2** 室内空调冷水管道最小绝热层厚度可按表D.0.2-1、表D.0.2-2选用；蓄冷设备保冷厚度可按对应介质温度最大口径管道的保冷厚度再增加5mm～10mm选用。

**D.0.3** 室内生活热水管经济绝热层厚度可按表D.0.3-1、表D.0.3-2选用。

**D.0.4** 室内空调风管绝热层最小热阻可按表D.0.4选用。

## 本标准用词说明

1. 为便于在执行本标准条文时区别对待，对要求严格程度不同的用词说明如下：
    1) 表示很严格，非这样做不可的：
    正面词采用“必须”，反面词采用“严禁”；
    2) 表示严格，在正常情况下均应这样做的：
    正面词采用“应”，反面词采用“不应”或“不得”；
    3) 表示允许稍有选择，在条件许可时首先应这样做的：
    正面词采用“宜”，反面词采用“不宜”；
    4) 表示有选择，在一定条件下可以这样做的：
    采用“可”。
2. 标准中指明应按其他有关标准执行时，写法为：“应符合…的规定(或要求)”或“应按……执行”。

## 引用标准名录

1. 《建筑给水排水设计规范》GB 50015
2. 《建筑照明设计标准》GB 50034
3. 《民用建筑热工设计规范》GB 50176
4. 《智能建筑设计标准》GB 50314
5. 《民用建筑节水设计标准》GB 50555
6. 《民用建筑供暖通风与空气调节设计规范》GB 50736
7. 《建筑外门窗气密、水密、抗风压性能分级及检测方法》GB/T 7106
8. 《设备及管道绝热设计导则》GB/T 8175
9. 《空气过滤器》GB/T 14295
10. 《清水离心泵能效限定值及节能评价值》GB 19762
11. 《三相配电变压器能效限定值及能效等级》GB 20052
12. 《建筑幕墙》GB/T 21086
13. 《城市夜景照明设计规范》JGJ/T 163
14. 《节水型生活用水器具》CJ/T 164