# 《无障碍设计规范》GB 50763-2012

**住房和城乡建设部**  
更新时间：2025-12-23  
实施时间：2012-09-01  

> **阅读模式**：[全文阅读](https://www.soujianzhu.cn/WinAppNew/Gfnr.aspx?id=212) | [分节阅读](https://www.soujianzhu.cn/WinAppNew/Gfnr.aspx?id=212)

---

## 目录

- [公告](#公告)
- [前言](#前言)
- [1 总则](#1-总则)
- [2 术语](#2-术语)
- [3 无障碍设施的设计要求](#3-无障碍设施的设计要求)
  - [3.1 缘石坡道](#31-缘石坡道)
  - [3.2 盲道](#32-盲道)
  - [3.3 无障碍出入口](#33-无障碍出入口)
  - [3.4 轮椅坡道](#34-轮椅坡道)
  - [3.5 无障碍通道、门](#35-无障碍通道门)
  - [3.6 无障碍楼梯、台阶](#36-无障碍楼梯台阶)
  - [3.7 无障碍电梯、升降平台](#37-无障碍电梯升降平台)
  - [3.8 扶手](#38-扶手)
  - [3.9 公共厕所、无障碍厕所](#39-公共厕所无障碍厕所)
  - [3.10 公共浴室](#310-公共浴室)
  - [3.11 无障碍客房](#311-无障碍客房)
  - [3.12 无障碍住房及宿舍](#312-无障碍住房及宿舍)
  - [3.13 轮椅席位](#313-轮椅席位)
  - [3.14 无障碍机动车停车位](#314-无障碍机动车停车位)
  - [3.15 低位服务设施](#315-低位服务设施)
  - [3.16 无障碍标识系统、信息无障碍](#316-无障碍标识系统信息无障碍)
- [4 城市道路](#4-城市道路)
  - [4.1 实施范围](#41-实施范围)
  - [4.2 人行道](#42-人行道)
  - [4.3 人行横道](#43-人行横道)
  - [4.4 人行天桥及地道](#44-人行天桥及地道)
  - [4.5 公交车站](#45-公交车站)
  - [4.6 无障碍标识系统](#46-无障碍标识系统)
- [5 城市广场](#5-城市广场)
  - [5.1 实施范围](#51-实施范围)
  - [5.2 实施部位和设计要求](#52-实施部位和设计要求)
- [6 城市绿地](#6-城市绿地)
  - [6.1 实施范围](#61-实施范围)
  - [6.2 公园绿地](#62-公园绿地)
  - [6.3 附属绿地](#63-附属绿地)
  - [6.4 其他绿地](#64-其他绿地)
- [7 居住区、居住建筑](#7-居住区居住建筑)
  - [7.1 道路](#71-道路)
  - [7.2 居住绿地](#72-居住绿地)
  - [7.3 配套公共设施](#73-配套公共设施)
  - [7.4 居住建筑](#74-居住建筑)
- [8 公共建筑](#8-公共建筑)
  - [8.1 一般规定](#81-一般规定)
  - [8.2 办公、科研、司法建筑](#82-办公科研司法建筑)
  - [8.3 教育建筑](#83-教育建筑)
  - [8.4 医疗康复建筑](#84-医疗康复建筑)
  - [8.5 福利及特殊服务建筑](#85-福利及特殊服务建筑)
  - [8.6 体育建筑](#86-体育建筑)
  - [8.7 文化建筑](#87-文化建筑)
  - [8.8 商业服务建筑](#88-商业服务建筑)
  - [8.9 汽车客运站](#89-汽车客运站)
  - [8.10 公共停车场（库）](#810-公共停车场库)
  - [8.11 汽车加油加气站](#811-汽车加油加气站)
  - [8.12 高速公路服务区建筑](#812-高速公路服务区建筑)
  - [8.13 城市公共厕所](#813-城市公共厕所)
- [9 历史文物保护建筑无障碍建设与改造](#9-历史文物保护建筑无障碍建设与改造)
  - [9.1 实施范围](#91-实施范围)
  - [9.2 无障碍游览路线](#92-无障碍游览路线)
  - [9.3 出入口](#93-出入口)
  - [9.4 院落](#94-院落)
  - [9.5 服务设施](#95-服务设施)
  - [9.6 信息与标识](#96-信息与标识)
- [附录A 无障碍标志](#附录a-无障碍标志)
- [附录B 无障碍设施标志牌](#附录b-无障碍设施标志牌)
- [附录C 用于指示方向的无障碍设施标志牌](#附录c-用于指示方向的无障碍设施标志牌)
- [本规范用词说明](#本规范用词说明)

---

## 公告

中华人民共和国住房和城乡建设部  
公告

关于发布国家标准《无障碍设计规范》的公告

现批准《无障碍设计规范》为国家标准，编号为GB 50763-2012，自2012年9月1日起实施。其中，第3.7.3(3、5)、4.4.5、6.2.4(5)、6.2.7(4)、8.1.4条(款)为强制性条文，必须严格执行。原《城市道路和建筑物无障碍设计规范》JGJ 50-2001同时废止。本规范由我部标准定额研究所组织中国建筑工业出版社出版发行。

中华人民共和国住房和城乡建设部  
2012年3月30日

---

## 前言

本规范是根据住房和城乡建设部《关于印发〈2009年工程建设标准规范制订、修订计划〉的通知》（建标[2009]88号）的要求，由北京市建筑设计研究院会同有关单位编制完成。

本规范在编制过程中，编制组进行了广泛深入的调查研究，认真总结了我国不同地区近年来无障碍建设的实践经验，认真研究分析了无障碍建设的现状和发展，参考了有关国际标准和国外先进技术，并在广泛征求全国有关单位意见的基础上，通过反复讨论、修改和完善，最后经审查定稿。

本规范共分9章和3个附录，主要技术内容有：总则，术语，无障碍设施的设计要求，城市道路，城市广场，城市绿地，居住区、居住建筑，公共建筑及历史文物保护建筑无障碍建设与改造。

本规范中以黑体字标志的条文为强制性条文，必须严格执行。

本规范由住房和城乡建设部负责管理和对强制性条文的解释，由北京市建筑设计研究院负责具体技术内容的解释。

本规范在执行过程中，请各单位注意总结经验，积累资料，如发现需要修改和补充之处，请将有关意见和建议反馈给北京市建筑设计研究院（地址：北京市西城区南礼士路62号，邮政编码：100045），以便今后修订时参考。

**本规范主编单位**：北京市建筑设计研究院  
**本规范参编单位**：
- 北京市市政工程设计研究总院
- 上海市市政规划设计研究院
- 北京市园林古建设计研究院
- 中国建筑标准设计研究院
- 广州市城市规划勘测设计研究院
- 北京市残疾人联合会
- 中国老龄科学研究中心
- 重庆市市政设施管理局

**本规范主要起草人员**：焦舰、孙蕾、刘杰、杨曼、刘思达、聂大华、段铁铮、朱胜跃、赵林祝、长康、汪原平、吕建强、椿波、郭景、易晓峰、廖远涛、王静奎、郭平、杨宏

**本规范主要审查人员**：周文麟、马国馨、顾放、张东旺、吴秋风、刘秋君、殷波、王奎宝、陈青军、张薇、胡正芳、王可赢

---

## 1 总则

**1.0.1** 为建设城市的无障碍环境，提高人民的社会生活质量，确保有需求的人能够安全地、方便地使用各种设施，制定本规范。

**1.0.2** 本规范适用于全国城市新建、改建和扩建的城市道路、城市广场、城市绿地、居住区、居住建筑、公共建筑及历史文物保护建筑等。本规范未涉及的城市道路、城市广场、城市绿地、建筑类型或有无障碍需求的设计，宜按本规范中相似类型的要求执行。农村道路及公共服务设施宜按本规范执行。

**1.0.3** 铁路、航空、城市轨道交通以及水运交通相关设施的无障碍设计，除应符合本规范的要求外，尚应符合相关行业的有关无障碍设计的规定。

**1.0.4** 城市无障碍设计在执行本规范时尚应遵循国家的有关方针政策，符合城市的总体发展要求，应做到安全适用、技术先进、经济合理。

**1.0.5** 城市无障碍设计除应符合本规范外，尚应符合国家现行有关标准的规定。

---

## 2 术语

**2.0.1 缘石坡道**（curb ramp）  
位于人行道口或人行横道两端，为了避免人行道路缘石带来的通行障碍，方便行人进入人行道的一种坡道。

**2.0.2 盲道**（tactile ground surface indicator）  
在人行道上或其他场所铺设的一种固定形态的地面砖，使视觉障碍者产生盲杖触觉及脚感，引导视觉障碍者向前行走和辨别方向以到达目的地的通道。

**2.0.3 行进盲道**（directional indicator）  
表面呈条状形、使视觉障碍者通过盲杖触觉及脚感，指引视觉障碍者可直接向正前方继续行走的盲道。

**2.0.4 提示盲道**（warning indicator）  
表面呈圆点形，用在盲道的起点处、拐弯处、终点处和表示服务设施的位置以及提示视觉障碍者前方将有不安全或危险状态等，具有提醒注意作用的盲道。

**2.0.5 无障碍出入口**（accessible entrance）  
在坡度、宽度、高度上以及地面材质、扶手形式等方面方便行动障碍者通行的出入口。

**2.0.6 平坡出入口**（ramp entrance）  
地面坡度不大于1:20且不设扶手的出入口。

**2.0.7 轮椅回转空间**（wheelchair turning space）  
为方便乘轮椅者旋转以改变方向而设置的空间。

**2.0.8 轮椅坡道**（wheelchair ramp）  
在坡度、宽度、高度、地面材质、扶手形式等方面方便乘轮椅者通行的坡道。

**2.0.9 无障碍通道**（accessible route）  
在坡度、宽度、高度、地面材质、扶手形式等方面方便行动障碍者通行的通道。

**2.0.10 轮椅通道**（wheelchair accessible path/lane）  
在检票口或结算口等处为方便乘轮椅者设置的通道。

**2.0.11 无障碍楼梯**（accessible stairway）  
在楼梯形式、宽度、踏步、地面材质、扶手形式等方面方便行动及视觉障碍者使用的楼梯。

**2.0.12 无障碍电梯**（wheelchair accessible elevator）  
适合行动障碍者和视觉障碍者进出和使用的电梯。

**2.0.13 升降平台**（wheelchair platform lift and stair lift）  
方便乘轮椅者进行垂直或斜向通行的设施。

**2.0.14 安全抓杆**（grab bar）  
在无障碍厕位、厕所、浴间内，方便行动障碍者安全移动和支撑的一种设施。

**2.0.15 无障碍厕位**（water closet compartment for wheelchair users）  
公共厕所内设置的带坐便器及安全抓杆且方便行动障碍者进出和使用的带隔间的厕位。

**2.0.16 无障碍厕所**（individual washroom for wheelchair users）  
出入口、室内空间及地面材质等方面方便行动障碍者使用且无障碍设施齐全的小型无性别厕所。

**2.0.17 无障碍洗手盆**（accessible wash basin）  
方便行动障碍者使用的带安全抓杆的洗手盆。

**2.0.18 无障碍小便器**（accessible urinal）  
方便行动障碍者使用的带安全抓杆的小便器。

**2.0.19 无障碍盆浴间**（accessible bathtub）  
无障碍设施齐全的盆浴间。

**2.0.20 无障碍淋浴间**（accessible shower stall）  
无障碍设施齐全的淋浴间。

**2.0.21 浴间坐台**（shower seat）  
洗浴时使用的固定坐台或活动坐板。

**2.0.22 无障碍客房**（accessible guest room）  
出入口、通道、通信、家具和卫生间等均设有无障碍设施，房间的空间尺度方便行动障碍者安全活动的客房。

**2.0.23 无障碍住房**（accessible housing）  
出入口、通道、通信、家具、厨房和卫生间等均设有无障碍设施，房间的空间尺度方便行动障碍者安全活动的住房。

**2.0.24 轮椅席位**（wheelchair accessible seat）  
在观众厅、报告厅、阅览室及教室等设有固定席位的场所内，供乘轮椅者使用的位置。

**2.0.25 陪护席位**（seats for accompanying persons）  
设置于轮椅席位附近，方便陪伴者照顾乘轮椅者使用的席位。

**2.0.26 安全阻挡措施**（edge protection）  
控制轮椅小轮和拐杖不会侧向滑出坡道、踏步以及平台边界的设施。

**2.0.27 无障碍机动车停车位**（accessible vehicle parking lot）  
方便行动障碍者使用的机动车停车位。

**2.0.28 盲文地图**（braille map）  
供视觉障碍者用于触摸的有立体感的位置图或平面图及盲文说明。

**2.0.29 盲文站牌**（bus-stop braille board）  
采用盲文标识，告知视觉障碍者公交候车站的站名、公交车线路和终点站名等的车站站牌。

**2.0.30 盲文铭牌**（braille signboard）  
安装在无障碍设施上或设施附近固定部位上，采用盲文标识以告知信息的铭牌。

**2.0.31 过街音响提示装置**（audible pedestrian signals for street crossing）  
通过语音提示系统引导视觉障碍者安全通行的音响装置。

**2.0.32 语音提示站台**（bus station with intelligent voice prompts）  
设有为视觉障碍者提供乘坐或换乘公共交通相关信息的语音提示系统的站台。

**2.0.33 信息无障碍**（information accessibility）  
通过相关技术的运用，确保人们在不同条件下都能够平等地、方便地获取和利用信息。

**2.0.34 低位服务设施**（low height service facilities）  
为方便行动障碍者使用而设置的高度适当的服务设施。

**2.0.35 母婴室**（mother and baby room）  
设有婴儿打理台、水池、座椅等设施，为母亲提供的给婴儿换尿布、喂奶或临时休息使用的房间。

**2.0.36 安全警示线**（safety warning line）  
用于界定和划分危险区域，向人们传递某种注意或警告的信息，以避免人身伤害的提示线。

---

## 3 无障碍设施的设计要求

### 3.1 缘石坡道

**3.1.1** 缘石坡道应符合下列规定：  
1 缘石坡道的坡面应平整、防滑；  
2 缘石坡道的坡口与车行道之间宜没有高差；当有高差时，高出车行道的地面不应大于10mm；  
3 宜优先选用全宽式单面坡缘石坡道。

**3.1.2** 缘石坡道的坡度应符合下列规定：  
1 全宽式单面坡缘石坡道的坡度不应大于1:20；  
2 三面坡缘石坡道正面及侧面的坡度不应大于1:12；  
3 其他形式的缘石坡道的坡度均不应大于1:12。

**3.1.3** 缘石坡道的宽度应符合下列规定：  
1 全宽式单面坡缘石坡道的宽度应与人行道宽度相同；  
2 三面坡缘石坡道的正面坡道宽度不应小于1.20m；  
3 其他形式的缘石坡道的坡口宽度均不应小于1.50m。

---

### 3.2 盲道

**3.2.1** 盲道应符合下列规定：  
1 盲道按其使用功能可分为行进盲道和提示盲道；  
2 盲道的纹路应凸出路面4mm高；  
3 盲道铺设应连续，应避开树木(穴)、电线杆、拉线等障碍物，其他设施不得占用盲道；  
4 盲道的颜色宜与相邻的人行道铺面的颜色形成对比，并与周围景观相协调，宜采用中黄色；  
5 盲道型材表面应防滑。

**3.2.2** 行进盲道应符合下列规定：  
1 行进盲道应与人行道的走向一致；  
2 行进盲道的宽度宜为250mm ~ 500mm；  
3 行进盲道宜在距围墙、花台、绿化带250mm ~ 500mm处设置；  
4 行进盲道宜在距树池边缘250mm~ 500mm 处设置；如无树池，行进盲道与路缘石上沿在同一水平面时，距路缘石不应小于500mm，行进盲道比路缘石上沿低时，距路缘石不应小于250mm; 盲道应避开非机动车停放的位置；  
5 行进盲道的触感条规格应符合表3.2.2的规定。

**表3.2.2 行进盲道的触感条规格**

| 部位 | 尺寸要求(mm) |
|------|--------------|
| 面宽 | 25           |
| 底宽 | 35           |
| 高度 | 4            |
| 中心距 | 62 ~ 75      |

**3.2.3** 提示盲道应符合下列规定：  
1 行进盲道在起点、终点、转弯处及其他有需要处应设提示盲道，当盲道的宽度不大于300mm 时，提示盲道的宽度应大于行进盲道的宽度；  
2 提示盲道的触感圆点规格应符合表3.2.3的规定。

**表3.2.3 提示盲道的触感圆点规格**

| 部位 | 尺寸要求(mm) |
|------|--------------|
| 表面直径 | 25           |
| 底部直径 | 35           |
| 圆点高度 | 4            |
| 圆点中心距 | 50           |

---

### 3.3 无障碍出入口

**3.3.1** 无障碍出入口包括以下几种类别：  
1 平坡出入口；  
2 同时设置台阶和轮椅坡道的出入口；  
3 同时设置台阶和升降平台的出入口。

**3.3.2** 无障碍出入口应符合下列规定：  
1 出入口的地面应平整、防滑；  
2 室外地面滤水箅子的孔洞宽度不应大于15mm；  
3 同时设置台阶和升降平台的出入口宜只应用于受场地限制无法改造坡道的工程，并应符合本规范第3.7.3条的有关规定；  
4 除平坡出入口外，在门完全开启的状态下，建筑物无障碍出入口的平台的净深度不应小于1.50m；  
5 建筑物无障碍出入口的门厅、过厅如设置两道门，门扇同时开启时两道门的间距不应小于1.50m；  
6 建筑物无障碍出入口的上方应设置雨棚。

**3.3.3** 无障碍出入口的轮椅坡道及平坡出入口的坡度应符合下列规定：  
1 平坡出入口的地面坡度不应大于1:20，当场地条件比较好时，不宜大于1:30；  
2 同时设置台阶和轮椅坡道的出入口，轮椅坡道的坡度应符合本规范第3.4节的有关规定。

---

### 3.4 轮椅坡道

**3.4.1** 轮椅坡道宜设计成直线形、直角形或折返形。

**3.4.2** 轮椅坡道的净宽度不应小于1.00m，无障碍出入口的轮椅坡道净宽度不应小于1.20m。

**3.4.3** 轮椅坡道的高度超过300mm且坡度大于1:20时，应在两侧设置扶手，坡道与休息平台的扶手应保持连贯，扶手应符合本规范第3.8节的相关规定。

**3.4.4** 轮椅坡道的最大高度和水平长度应符合表3.4.4的规定。

**表3.4.4 轮椅坡道的最大高度和水平长度**

| 坡度   | 1:20  | 1:16  | 1:12  | 1:10  | 1:8   |
|--------|-------|-------|-------|-------|-------|
| 最大高度(m) | 1.20  | 0.90  | 0.75  | 0.60  | 0.30  |
| 水平长度(m) | 24.00 | 14.40 | 9.00  | 6.00  | 2.40  |

注：其他坡度可用插入法进行计算。

**3.4.5** 轮椅坡道的坡面应平整、防滑、无反光。

**3.4.6** 轮椅坡道起点、终点和中间休息平台的水平长度不应小于1.50m。

**3.4.7** 轮椅坡道临空侧应设置安全阻挡措施。

**3.4.8** 轮椅坡道应设置无障碍标志，无障碍标志应符合本规范第3.16节的有关规定。

---

### 3.5 无障碍通道、门

**3.5.1** 无障碍通道的宽度应符合下列规定：  
1 室内走道不应小于1.20m，人流较多或较集中的大型公共建筑的室内走道宽度不宜小于1.80m；  
2 室外通道不宜小于1.50m；  
3 检票口、结算口轮椅通道不应小于900mm。

**3.5.2** 无障碍通道应符合下列规定：  
1 无障碍通道应连续，其地面应平整、防滑、反光小或无反光，并不宜设置厚地毯；  
2 无障碍通道上有高差时，应设置轮椅坡道；  
3 室外通道上的雨水箅子的孔洞宽度不应大于15mm；  
4 固定在无障碍通道的墙、立柱上的物体或标牌距地面的高度不应小于2.00m；如小于2.00m时，探出部分的宽度不应大于100mm；如突出部分大于100mm，则其距地面的高度应小于600mm；  
5 斜向的自动扶梯、楼梯等下部空间可以进入时，应设置安全挡牌。

**3.5.3** 门的无障碍设计应符合下列规定：  
1 不应采用力度大的弹簧门并不宜采用弹簧门、玻璃门；当采用玻璃门时，应有醒目的提示标志；  
2 自动门开启后通行净宽度不应小于1.00m；  
3 平开门、推拉门、折叠门开启后的通行净宽度不应小于800mm，有条件时，不宜小于900mm；  
4 在门扇内外应留有直径不小于1.50m的轮椅回转空间；  
5 在单扇平开门、推拉门、折叠门的门把手一侧的墙面，应设宽度不小于400mm的墙面；  
6 平开门、推拉门、折叠门的门扇应设距地900mm的把手，宜设视线观察玻璃，并宜在距地350mm范围内安装护门板；  
7 门槛高度及门内外地面高差不应大于15mm，并以斜面过渡；  
8 无障碍通道上的门扇应便于开关；  
9 宜与周围墙面有一定的色彩反差，方便识别。

---

### 3.6 无障碍楼梯、台阶

**3.6.1** 无障碍楼梯应符合下列规定：  
1 宜采用直线形楼梯；  
2 公共建筑楼梯的踏步宽度不应小于280mm，踏步高度不应大于160mm；  
3 不应采用无踢面和直角形突缘的踏步；  
4 宜在两侧均做扶手；  
5 如采用栏杆式楼梯，在栏杆下方宜设置安全阻挡措施；  
6 踏面应平整防滑或在踏面前缘设防滑条；  
7 距踏步起点和终点250mm~300mm宜设提示盲道；  
8 踏面和踢面的颜色宜有区分和对比；  
9 楼梯上行及下行的第一阶宜在颜色或材质上与平台有明显区别。

**3.6.2** 台阶的无障碍设计应符合下列规定：  
1 公共建筑的室内外台阶踏步宽度不宜小于300mm，踏步高度不宜大于150mm，并不应小于100mm；  
2 踏步应防滑；  
3 三级及三级以上的台阶应在两侧设置扶手；  
4 台阶上行及下行的第一阶宜在颜色或材质上与其他阶有明显区别。

---

### 3.7 无障碍电梯、升降平台

**3.7.1** 无障碍电梯的候梯厅应符合下列规定：  
1 候梯厅深度不宜小于1.50m，公共建筑及设置病床梯的候梯厅深度不宜小于1.80m；  
2 呼叫按钮高度为0.90m ~ 1.10m；  
3 电梯门洞的净宽度不宜小于900mm；  
4 电梯出入口处宜设提示盲道；  
5 候梯厅应设电梯运行显示装置和抵达音响。

**3.7.2** 无障碍电梯的轿厢应符合下列规定：  
1 轿厢门开启的净宽度不应小于800mm；  
2 在轿厢的侧壁上应设高0.90m ~ 1.10m带盲文的选层按钮，盲文宜设置于按钮旁；  
3 轿厢的三面壁上应设高850mm ~ 900mm扶手，扶手应符合本规范第3.8节的相关规定；  
4 轿厢内应设电梯运行显示装置和报层音响；  
5 轿厢正面高900mm处至顶部应安装镜子或采用有镜面效果的材料；  
6 轿厢的规格应依据建筑性质和使用要求的不同而选用。最小规格为深度不应小于1.40m，宽度不应小于1.10m；中型规格为深度不应小于1.60m，宽度不应小于1.40m；医疗建筑与老人建筑宜选用病床专用电梯；  
7 电梯位置应设无障碍标志，无障碍标志应符合本规范第3.16节的有关规定。

**3.7.3** 升降平台应符合下列规定：  
1 升降平台只适用于场地有限的改造工程；  
2 垂直升降平台的深度不应小于1.20m，宽度不应小于900mm，应设扶手、挡板及呼叫控制按钮；  
3 垂直升降平台的基坑应采用防止误入的安全防护措施；（自2022年4月1日起废止该条,详见新规《建筑与市政工程无障碍通用规范》GB 55019-2021）  
4 斜向升降平台宽度不应小于900mm，深度不应小于1.00m，应设扶手和挡板；  
5 垂直升降平台的传送装置应有可靠的安全防护装置。（自2022年4月1日起废止该条,详见新规《建筑与市政工程无障碍通用规范》GB 55019-2021）

---

### 3.8 扶手

**3.8.1** 无障碍单层扶手的高度应为850mm ~ 900mm，无障碍双层扶手的上层扶手高度应为850mm ~ 900mm，下层扶手高度应为650mm ~ 700mm。

**3.8.2** 扶手应保持连贯，靠墙面的扶手的起点和终点处应水平延伸不小于300mm的长度。

**3.8.3** 扶手末端应向内拐到墙面或向下延伸不小于100mm，栏杆式扶手应向下成弧形或延伸到地面上固定。

**3.8.4** 扶手内侧与墙面的距离不应小于40mm。

**3.8.5** 扶手应安装坚固，形状易于抓握。圆形扶手的直径应为35mm ~ 50mm，矩形扶手的截面尺寸应为35mm ~ 50mm。

**3.8.6** 扶手的材质宜选用防滑、热惰性指标好的材料。

---

### 3.9 公共厕所、无障碍厕所

**3.9.1** 公共厕所的无障碍设计应符合下列规定：  
1 女厕所的无障碍设施包括至少1个无障碍厕位和1个无障碍洗手盆；男厕所的无障碍设施包括至少1个无障碍厕位、1个无障碍小便器和1个无障碍洗手盆；  
2 厕所的入口和通道应方便乘轮椅者进入和进行回转，回转直径不小于1.50m；  
3 门应方便开启，通行净宽度不应小于800mm；  
4 地面应防滑、不积水；  
5 无障碍厕位应设置无障碍标志，无障碍标志应符合本规范第3.16节的有关规定。

**3.9.2** 无障碍厕位应符合下列规定：  
1 无障碍厕位应方便乘轮椅者到达和进出，尺寸宜做到2.00mX1.50m，不应小于1.80mX1.00m；  
2 无障碍厕位的门宜向外开启，如向内开启，需在开启后厕位内留有直径不小于1.50m的轮椅回转空间，门的通行净宽不应小于800mm，平开门外侧应设高900mm的横扶把手，在关闭的门扇里侧设高900mm的关门拉手，并应采用门外可紧急开启的插销；  
3 厕位内应设坐便器，厕位两侧距地面700mm处应设长度不小于700mm的水平安全抓杆，另一侧应设高1.40m的垂直安全抓杆。

**3.9.3** 无障碍厕所的无障碍设计应符合下列规定：  
1 位置宜靠近公共厕所，应方便乘轮椅者进入和进行回转，回转直径不小于1.50m；  
2 面积不应小于4.00m²；  
3 当采用平开门，门扇宜向外开启，如向内开启，需在开启后留有直径不小于1.50m的轮椅回转空间，门的通行净宽度不应小于800mm，平开门应设高900mm的横扶把手，在门扇里侧应采用门外可紧急开启的门锁；  
4 地面应防滑、不积水；  
5 内部应设坐便器、洗手盆、多功能台、挂衣钩和呼叫按钮；  
6 坐便器应符合本规范第3.9.2条的有关规定，洗手盆应符合本规范第3.9.4条的有关规定；  
7 多功能台长度不宜小于700mm，宽度不宜小于400mm，高度宜为600mm；  
8 安全抓杆的设计应符合本规范第3.9.4条的有关规定；  
9 挂衣钩距地高度不应大于1.20m；  
10 在坐便器旁的墙面上应设高400mm~500mm的救助呼叫按钮；  
11 入口应设置无障碍标志，无障碍标志应符合本规范第3.16节的有关规定。

**3.9.4** 厕所里的其他无障碍设施应符合下列规定：  
1 无障碍小便器下口距地面高度不应大于400mm，小便器两侧应在离墙面250mm处，设高度为1.20m的垂直安全抓杆，并在离墙面550mm处，设高度为900mm水平安全抓杆，与垂直安全抓杆连接；  
2 无障碍洗手盆的水嘴中心距侧墙应大于550mm，其底部应留出宽750mm、高650mm、深450mm供乘轮椅者膝部和足尖部的移动空间，并在洗手盆上方安装镜子，出水龙头宜采用杠杆式水龙头或感应式自动出水方式；  
3 安全抓杆应安装牢固，直径应为30mm ~ 40mm，内侧距墙不应小于40mm；  
4 取纸器应设在坐便器的侧前方，高度为400mm ~ 500mm。

---

### 3.10 公共浴室

**3.10.1** 公共浴室的无障碍设计应符合下列规定：  
1 公共浴室的无障碍设施包括1个无障碍淋浴间或盆浴间以及1个无障碍洗手盆；  
2 公共浴室的人口和室内空间应方便乘轮椅者进入和使用，浴室内部应能保证轮椅进行回转，回转直径不小于1.50m；  
3 浴室地面应防滑、不积水；  
4 浴间入口宜采用活动门帘，当采用平开门时，门扇应向外开启，设高900mm的横扶把手，在关闭的门扇里侧设高900mm的关门拉手，并应采用门外可紧急开启的插销；  
5 应设置一个无障碍厕位。

**3.10.2** 无障碍淋浴间应符合下列规定：  
1 无障碍淋浴间的短边宽度不应小于1.50m；  
2 浴间坐台高度宜为450mm，深度不宜小于450mm；  
3 淋浴间应设距地面高700mm的水平抓杆和高1.40m ~ 1.60m的垂直抓杆；  
4 淋浴间内的淋浴喷头的控制开关的高度距地面不应大于1.20m；  
5 毛巾架的高度不应大于1.20m。

**3.10.3** 无障碍盆浴间应符合下列规定：  
1 在浴盆一端设置方便进入和使用的坐台，其深度不应小于400mm；  
2 浴盆内侧应设高600mm和900mm的两层水平抓杆，水平长度不小于800mm；洗浴坐台一侧的墙上设高900mm、水平长度不小于600mm的安全抓杆；  
3 毛巾架的高度不应大于1.20m。

---

### 3.11 无障碍客房

**3.11.1** 无障碍客房应设在便于到达、进出和疏散的位置。

**3.11.2** 房间内应有空间能保证轮椅进行回转，回转直径不小于1.50m。

**3.11.3** 无障碍客房的门应符合本规范第3.5节的有关规定。

**3.11.4** 无障碍客房卫生间内应保证轮椅进行回转，回转直径不小于1.50m，卫生器具应设置安全抓杆，其地面、门、内部设施应符合本规范第3.9.3条、第3.10.2条及第3.10.3条的有关规定。

**3.11.5** 无障碍客房的其他规定：  
1 床间距离不应小于1.20m；  
2 家具和电器控制开关的位置和高度应方便乘轮椅者靠近和使用，床的使用高度为450mm；  
3 客房及卫生间应设高400mm ~ 500mm的救助呼叫按钮；  
4 客房应设置为听力障碍者服务的闪光提示门铃。

---

### 3.12 无障碍住房及宿舍

**3.12.1** 户门及户内门开启后的净宽应符合本规范第3.5节的有关规定。

**3.12.2** 通往卧室、起居室（厅）、厨房、卫生间、储藏室及阳台的通道应为无障碍通道，并按照本规范第3.8节的要求在一侧或两侧设置扶手。

**3.12.3** 浴盆、淋浴、坐便器、洗手盆及安全抓杆等应符合本规范第3.9节、第3.10节的有关规定。

**3.12.4** 无障碍住房及宿舍的其他规定：  
1 单人卧室面积不应小于7.00m²，双人卧室面积不应小于10.50m²，兼起居室的卧室面积不应小于16.00m²，起居室面积不应小于14.00m²，厨房面积不应小于6.00m²；  
2 设坐便器、洗浴器（浴盆或淋浴）、洗面盆三件卫生洁具的卫生间面积不应小于4.00m²；设坐便器、洗浴器二件卫生洁具的卫生间面积不应小于3.00m²；设坐便器、洗面盆二件卫生洁具的卫生间面积不应小于2.50m²；单设坐便器的卫生间面积不应小于2.00m²；  
3 供乘轮椅者使用的厨房，操作台下方净宽和高度都不应小于650mm，深度不应小于250mm；  
4 居室和卫生间内应设求助呼叫按钮；  
5 家具和电器控制开关的位置和高度应方便乘轮椅者靠近和使用；  
6 供听力障碍者使用的住宅和公寓应安装闪光提示门铃。

---

### 3.13 轮椅席位

**3.13.1** 轮椅席位应设在便于到达疏散口及通道的附近，不得设在公共通道范围内。

**3.13.2** 观众厅内通往轮椅席位的通道宽度不应小于1.20m。

**3.13.3** 轮椅席位的地面应平整、防滑，在边缘处宜安装栏杆或栏板。

**3.13.4** 每个轮椅席位的占地面积不应小于1.10m×0.80m。

**3.13.5** 在轮椅席位上观看演出和比赛的视线不应当受到遮挡，但也不应遮挡他人的视线。

**3.13.6** 在轮椅席位旁或在邻近的观众席内宜设置1:1的陪护席位。

**3.13.7** 轮椅席位处地面上应该设置无障碍标志，无障碍标志应符合本规范第3.16节的有关规定。

---

### 3.14 无障碍机动车停车位

**3.14.1** 应将通行方便、行走距离路线最短的停车位设为无障碍机动车停车位。

**3.14.2** 无障碍机动车停车位的地面应平整、防滑、不积水，地面坡度不应大于1:50。

**3.14.3** 无障碍机动车停车位一侧，应设宽度不小于1.20m的通道，供乘轮椅者从轮椅通道直接进入人行道和无障碍入口。

**3.14.4** 无障碍机动车停车位的地面应涂有停车线、轮椅通道线和无障碍标志。

---

### 3.15 低位服务设施

**3.15.1** 设置低位服务设施的范围包括问询台、服务窗口、电话台、安检验证台、行李托运台、借阅台、各种业务台、饮水机等。

**3.15.2** 低位服务设施上表面距地面高度宜为700mm ~ 850mm，其下部宜至少留出宽750mm，高650mm，深450mm供乘轮椅者膝部和足尖部的移动空间。

**3.15.3** 低位服务设施前应有轮椅回转空间，回转直径不小于1.50m。

**3.15.4** 挂式电话离地不应高于900mm。

---

### 3.16 无障碍标识系统、信息无障碍

**3.16.1** 无障碍标志应符合下列规定：  
1 无障碍标志包括下列几种:  
   1) 通用的无障碍标志应符合本规范附录A的规定；  
   2) 无障碍设施标志牌符合本规范附录B的规定；  
   3) 带指示方向的无障碍设施标志牌符合本规范附录C的规定。  
2 无障碍标志应醒目，避免遮挡。  
3 无障碍标志应纳入城市环境或建筑内部的引导标志系统，形成完整的系统，清楚地指明无障碍设施的走向及位置。

**3.16.2** 盲文标志应符合下列规定：  
1 盲文标志可分成盲文地图、盲文铭牌、盲文站牌；  
2 盲文标志的盲文必须采用国际通用的盲文表示方法。

**3.16.3** 信息无障碍应符合下列规定：  
1 根据需求，因地制宜设置信息无障碍的设备和设施，使人们便捷地获取各类信息；  
2 信息无障碍设备和设施位置和布局应合理。

---

## 4 城市道路

### 4.1 实施范围

**4.1.1** 城市道路无障碍设计的范围应包括：  
1 城市各级道路；  
2 城镇主要道路；  
3 步行街；  
4 旅游景点、城市景观带的周边道路。

**4.1.2** 城市道路、桥梁、隧道、立体交叉中人行系统均应进行无障碍设计，无障碍设施应沿行人通行路径布置。

**4.1.3** 人行系统中的无障碍设计主要包括人行道、人行横道、人行天桥及地道、公交车站。

---

### 4.2 人行道

**4.2.1** 人行道处缘石坡道设计应符合下列规定：  
1 人行道在各种路口、各种出入口位置必须设置缘石坡道；  
2 人行横道两端必须设置缘石坡道。

**4.2.2** 人行道处盲道设置应符合下列规定：  
1 城市主要商业街、步行街的人行道应设置盲道；  
2 视觉障碍者集中区域周边道路应设置盲道；  
3 坡道的上下坡边缘处应设置提示盲道；  
4 道路周边场所、建筑等出入口设置的盲道应与道路盲道相衔接。

**4.2.3** 人行道的轮椅坡道设置应符合下列规定：  
1 人行道设置台阶处，应同时设置轮椅坡道；  
2 轮椅坡道的设置应避免干扰行人通行及其他设施的使用。

**4.2.4** 人行道处服务设施设置应符合下列规定：  
1 服务设施的设置应为残障人士提供方便；  
2 宜为视觉障碍者提供触摸及音响一体化信息服务设施；  
3 设置屏幕信息服务设施，宜为听觉障碍者提供屏幕手语及字幕信息服务；  
4 低位服务设施的设置，应方便乘轮椅者使用；  
5 设置休息座椅时，应设置轮椅停留空间。

---

### 4.3 人行横道

**4.3.1** 人行横道范围内的无障碍设计应符合下列规定：  
1 人行横道宽度应满足轮椅通行需求；  
2 人行横道安全岛的形式应方便乘轮椅者使用；  
3 城市中心区及视觉障碍者集中区域的人行横道，应配置过街音响提示装置。

---

### 4.4 人行天桥及地道

**4.4.1** 盲道的设置应符合下列规定:  
1 设置于人行道中的行进盲道应与人行天桥及地道出入口处的提示盲道相连接;  
2 人行天桥及地道出入口处应设置提示盲道;  
3 距每段台阶与坡道的起点与终点250mm ~ 500mm处应设提示盲道，其长度应与坡道、梯道相对应。

**4.4.2** 人行天桥及地道处坡道与无障碍电梯的选择应符合下列规定：  
1 要求满足轮椅通行需求的人行天桥及地道处宜设置坡道，当设置坡道有困难时，应设置无障碍电梯；  
2 坡道的净宽度不应小于2.00m；  
3 坡道的坡度不应大于1:12；  
4 弧线形坡道的坡度，应以弧线内缘的坡度进行计算；  
5 坡道的高度每升高1.50m时，应设深度不小于2.00m的中间平台；  
6 坡道的坡面应平整、防滑。

**4.4.3** 扶手设置应符合下列规定：  
1 人行天桥及地道在坡道的两侧应设扶手，扶手宜设上、下两层；  
2 在栏杆下方宜设置安全阻挡措施；  
3 扶手起点水平段宜安装盲文铭牌。

**4.4.4** 当人行天桥及地道无法满足轮椅通行需求时，宜考虑地面安全通行。

**4.4.5** 人行天桥桥下的三角区净空高度小于2.00m时，应安装防护设施，并应在防护设施外设置提示盲道。（自2022年4月1日起废止该条,详见新规《建筑与市政工程无障碍通用规范》GB 55019-2021）

---

### 4.5 公交车站

**4.5.1** 公交车站处站台设计应符合下列规定：  
1 站台有效通行宽度不应小于1.50m；  
2 在车道之间的分隔带设公交车站时应方便乘轮椅者使用。

**4.5.2** 盲道与盲文信息布置应符合下列规定：  
1 站台距路缘石250mm ~ 500mm处应设置提示盲道，其长度应与公交车站的长度相对应；  
2 当人行道中设有盲道系统时，应与公交车站的盲道相连接；  
3 宜设置盲文站牌或语音提示服务设施，盲文站牌的位置、高度、形式与内容应方便视觉障碍者的使用。

---

### 4.6 无障碍标识系统

**4.6.1** 无障碍设施位置不明显时，应设置相应的无障碍标识系统。

**4.6.2** 无障碍标志牌应沿行人通行路径布置，构成标识引导系统。

**4.6.3** 无障碍标志牌的布置应与其他交通标志牌相协调。

---

## 5 城市广场

### 5.1 实施范围

**5.1.1** 城市广场进行无障碍设计的范围应包括下列内容:  
1 公共活动广场；  
2 交通集散广场。

---

### 5.2 实施部位和设计要求

**5.2.1** 城市广场的公共停车场的停车数在50辆以下时应设置不少于1个无障碍机动车停车位，100辆以下时应设置不少于2个无障碍机动车停车位，100辆以上时应设置不少于总停车数2%的无障碍机动车停车位。

**5.2.2** 城市广场的地面应平整、防滑、不积水。

**5.2.3** 城市广场盲道的设置应符合下列规定：  
1 设有台阶或坡道时，距每段台阶与坡道的起点与终点250mm ~ 500mm处应设提示盲道，其长度应与台阶、坡道相对应，宽度应为250mm ~ 500mm；  
2 人行道中有行进盲道时，应与提示盲道相连接。

**5.2.4** 城市广场的地面有高差时坡道与无障碍电梯的选择应符合下列规定：  
1 设置台阶的同时应设置轮椅坡道；  
2 当设置轮椅坡道有困难时，可设置无障碍电梯。

**5.2.5** 城市广场内的服务设施应同时设置低位服务设施。

**5.2.6** 男、女公共厕所均应满足本规范第8.13节的有关规定。

**5.2.7** 城市广场的无障碍设施的位置应设置无障碍标志，无障碍标志应符合本规范第3.16节的有关规定，带指示方向的无障碍设施标志牌应与无障碍设施标志牌形成引导系统，满足通行的连续性。

---

## 6 城市绿地

### 6.1 实施范围

**6.1.1** 城市绿地进行无障碍设计的范围应包括下列内容：  
1 城市中的各类公园，包括综合公园、社区公园、专类公园、带状公园、街旁绿地等；  
2 附属绿地中的开放式绿地；  
3 对公众开放的其他绿地。

---

### 6.2 公园绿地

**6.2.1** 公园绿地停车场的总停车数在50辆以下时应设置不少于1个无障碍机动车停车位，100辆以下时应设置不少于2个无障碍机动车停车位，100辆以上时应设置不少于总停车数2%的无障碍机动车停车位。

**6.2.2** 售票处的无障碍设计应符合下列规定：  
1 主要出入口的售票处应设置低位售票窗口；  
2 低位售票窗同前地面有高差时，应设轮椅坡道以及不小于1.50m X 1.50m的平台；  
3 售票窗口前应设提示盲道，距售票处外墙应为250mm ~ 500mm。

**6.2.3** 出入口的无障碍设计应符合下列规定：  
1 主要出入口应设置为无障碍出入口，设有自动检票设备的出入口，也应设置专供乘轮椅者使用的检票口；  
2 出入口检票口的无障碍通道宽度不应小于1.20m；  
3 出入口设置车挡时，车挡间距不应小于900mm。

**6.2.4** 无障碍游览路线应符合下列规定：  
1 无障碍游览主园路应结合公园绿地的主路设置，应能到达部分主要景区和景点，并宜形成环路，纵坡宜小于5%，山地公园绿地的无障碍游览主园路纵坡应小于8%；无障碍游览主园路不宜设置台阶、梯道，必须设置时应同时设置轮椅坡道；  
2 无障碍游览支园路应能连接主要景点，并和无障碍游览主园路相连，形成环路；小路可到达景点局部，不能形成环路时，应便于折返，无障碍游览支园路和小路的纵坡应小于8%；坡度超过8%时，路面应作防滑处理，并不宜轮椅通行；  
3 园路坡度大于8%时，宜每隔10.00m ~ 20.00m在路旁设置休息平台；  
4 紧邻湖岸的无障碍游览园路应设置护栏，高度不低于900mm；  
5 在地形险要的地段应设置安全防护设施和安全警示线；（自2022年4月1日起废止该条,详见新规《建筑与市政工程无障碍通用规范》GB 55019-2021）  
6 路面应平整、防滑、不松动，园路上的窖井盖板应与路面平齐，排水沟的滤水箅子孔的宽度不应大于15mm。

**6.2.5** 游憩区的无障碍设计应符合下列规定：  
1 主要出入口或无障碍游览园路沿线应设置一定面积的无障碍游憩区;  
2 无障碍游憩区应方便轮椅通行，有高差时应设置轮椅坡道，地面应平整、防滑、不松动；  
3 无障碍游憩区的广场树池宜高出广场地面，与广场地面相平的树池应加箅子。

**6.2.6** 常规设施的无障碍设计应符合下列规定：  
1 在主要出入口、主要景点和景区，无障碍游憩区内的游憩设施、服务设施、公共设施、管理设施应为无障碍设施；  
2 游憩设施的无障碍设计应符合下列规定：  
   1) 在没有特殊景观要求的前提下，应设为无障碍游憩设施；  
   2) 单体建筑和组合建筑包括亭、廊、榭、花架等，若有台明和台阶时，台明不宜过高，入口应设置坡道，建筑室内应满足无障碍通行；  
   3) 建筑院落的出入口以及院内广场、通道有高差时，应设置轮椅坡道；有三个以上出入口时，至少应设两个无障碍出入口，建筑院落的内廊或通道的宽度不应小于1.20m；  
   4) 码头与无障碍园路和广场衔接处有高差时应设置轮椅坡道；  
   5) 无障碍游览路线上的桥应为平桥或坡度在8%以下的小拱桥，宽度不应小于1.20m，桥面应防滑，两侧应设栏杆。桥面与园路、广场衔接有高差时应设轮椅坡道。  
3 服务设施的无障碍设计应符合下列规定：  
   1) 小卖店等的售货窗口应设置低位窗口；  
   2) 茶座、咖啡厅、餐厅、摄影部等出入口应为无障碍出入口，应提供一定数量的轮椅席位；  
   3) 服务台、业务台、咨询台、售货柜台等应设有低位服务设施。  
4 公共设施的无障碍设计应符合下列规定：  
   1) 公共厕所应满足本规范第8.13节的有关规定，大型园林建筑和主要游览区应设置无障碍厕所；  
   2) 饮水器、洗手台、垃圾箱等小品的设置应方便乘轮椅者使用；  
   3) 游客服务中心应符合本规范第8.8节的有关规定；  
   4) 休息座椅旁应设置轮椅停留空间。  
5 管理设施的无障碍设计应符合本规范第8.2节的有关规定。

**6.2.7** 标识与信息应符合下列规定：  
1 主要出入口、无障碍通道、停车位、建筑出入口、公共厕所等无障碍设施的位置应设置无障碍标志，并应形成完整的无障碍标识系统，清楚地指明无障碍设施的走向及位置，无障碍标志应符合第3.16节的有关规定；  
2 应设置系统的指路牌、定位导览图、景区景点和园中园说明牌；  
3 出入口应设置无障碍设施位置图、无障碍游览图；  
4 危险地段应设置必要的警示、提示标志及安全警示线。（自2022年4月1日起废止该条,详见新规《建筑与市政工程无障碍通用规范》GB 55019-2021）

**6.2.8** 不同类别的公园绿地的特殊要求：  
1 大型植物园宜设置盲人植物区域或者植物角，并提供语音服务、盲文铭牌等供视觉障碍者使用的设施；  
2 绿地内展览区、展示区、动物园的动物展示区应设置便于乘轮椅者参观的窗口或位置。

---

### 6.3 附属绿地

**6.3.1** 附属绿地中的开放式绿地应进行无障碍设计。

**6.3.2** 附属绿地中的无障碍设计应符合本规范第6.2节和第7.2节的有关规定。

---

### 6.4 其他绿地

**6.4.1** 其他绿地中的开放式绿地应进行无障碍设计。

**6.4.2** 其他绿地的无障碍设计应符合本规范第6.2节的有关规定。

---

## 7 居住区、居住建筑

### 7.1 道路

**7.1.1** 居住区道路进行无障碍设计的范围应包括居住区路、小区路、组团路、宅间小路的人行道。

**7.1.2** 居住区级道路无障碍设计应符合本规范第4章的有关规定。

---

### 7.2 居住绿地

**7.2.1** 居住绿地的无障碍设计应符合下列规定：  
1 居住绿地内进行无障碍设计的范围及建筑物类型包括：出入口、游步道、休憩设施、儿童游乐场、休闲广场、健身运动场、公共厕所等；  
2 基地地坪坡度不大于5%的居住区的居住绿地均应满足无障碍要求，地坪坡度大于5%的居住区，应至少设置1个满足无障碍要求的居住绿地；  
3 满足无障碍要求的居住绿地，宜靠近设有无障碍住房和宿舍的居住建筑设置，并通过无障碍通道到达。

**7.2.2** 出入口应符合下列规定：  
1 居住绿地的主要出入口应设置为无障碍出入口；有3个以上出入口时，无障碍出入口不应少于2个；  
2 居住绿地内主要活动广场与相接的地面或路面高差小于300mm时，所有出入口均应为无障碍出入口；高差大于300mm时，当出入口少于3个，所有出入口均应为无障碍出入口，当出入口为3个或3个以上，应至少设置2个无障碍出入口；  
3 组团绿地、开放式宅间绿地、儿童活动场、健身运动场出入口应设提示盲道。

**7.2.3** 游步道及休憩设施应符合下列规定：  
1 居住绿地内的游步道应为无障碍通道，轮椅园路纵坡不应大于4%；轮椅专用道不应大于8%；  
2 居住绿地内的游步道及园林建筑、园林小品如亭、廊、花架等休憩设施不宜设置高于450mm的台明或台阶；必须设置时，应同时设置轮椅坡道并在休憩设施入口处设提示盲道；  
3 绿地及广场设置休息座椅时，应留有轮椅停留空间。

**7.2.4** 活动场地应符合下列规定：  
1 林下铺装活动场地，以种植乔木为主，林下净空不得低于2.20m；

---

### 7.3 配套公共设施

**7.3.1** 居住区内的居委会、卫生站、健身房、物业管理、会所、社区中心、商业等为居民服务的建筑应设置无障碍出入口。设有电梯的建筑至少应设置1部无障碍电梯；未设有电梯的多层建筑，应至少设置1部无障碍楼梯。

**7.3.2** 供居民使用的公共厕所应满足本规范第8.13节的有关规定。

**7.3.3** 停车场和车库应符合下列规定：  
1 居住区停车场和车库的总停车位应设置不少于0.5%的无障碍机动车停车位；若设有多个停车场和车库，宜每处设置不少于1个无障碍机动车停车位；  
2 地面停车场的无障碍机动车停车位宜靠近停车场的出入口设置。有条件的居住区宜靠近住宅出入口设置无障碍机动车停车位；  
3 车库的人行出入口应为无障碍出入口。设置在非首层的车库应设无障碍通道与无障碍电梯或无障碍楼梯连通，直达首层。

---

### 7.4 居住建筑

**7.4.1** 居住建筑进行无障碍设计的范围应包括住宅及公寓、宿舍建筑（职工宿舍、学生宿舍）等。

**7.4.2** 居住建筑的无障碍设计应符合下列规定：  
1 设置电梯的居住建筑应至少设置1处无障碍出入口，通过无障碍通道直达电梯厅；未设置电梯的低层和多层居住建筑，当设置无障碍住房及宿舍时，应设置无障碍出入口；  
2 设置电梯的居住建筑，每居住单元至少应设置1部能直达户门层的无障碍电梯。

**7.4.3** 居住建筑应按每100套住房设置不少于2套无障碍住房。

**7.4.4** 无障碍住房及宿舍宜建于底层。当无障碍住房及宿舍设在二层及以上且未设置电梯时，其公共楼梯应满足本规范第3.6节的有关规定。

**7.4.5** 宿舍建筑中，男女宿舍应分别设置无障碍宿舍，每100套宿舍各应设置不少于1套无障碍宿舍；当无障碍宿舍设置在二层以上且宿舍建筑设置电梯时，应设置不少于1部无障碍电梯，无障碍电梯应与无障碍宿舍以无障碍通道连接。

**7.4.6** 当无障碍宿舍内未设置厕所时，其所在楼层的公共厕所至少有1处应满足本规范3.9.1条的有关规定或设置无障碍厕所，并宜靠近无障碍宿舍设置。

---

## 8 公共建筑

### 8.1 一般规定

**8.1.1** 公共建筑基地的无障碍设计应符合下列规定：  
1 建筑基地的车行道与人行通道地面有高差时，在人行通道的路口及人行横道的两端应设缘石坡道；  
2 建筑基地的广场和人行通道的地面应平整、防滑、不积水；  
3 建筑基地的主要人行通道当有高差或台阶时应设置轮椅坡道或无障碍电梯。

**8.1.2** 建筑基地内总停车数在100辆以下时应设置不少于1个无障碍机动车停车位，100辆以上时应设置不少于总停车数1%的无障碍机动车停车位。

**8.1.3** 公共建筑的主要出入口宜设置坡度小于1:30的平坡出入口。

**8.1.4** 建筑内设有电梯时，至少应设置1部无障碍电梯。（自2022年4月1日起废止该条,详见新规《建筑与市政工程无障碍通用规范》GB 55019-2021）

**8.1.5** 当设有各种服务窗口、售票窗口、公共电话台、饮水器等时应设置低位服务设施。

**8.1.6** 主要出入口、建筑出入口、通道、停车位、厕所电梯等无障碍设施的位置，应设置无障碍标志，无障碍标志应符合本规范第3.16节的有关规定；建筑物出入口和楼梯前室宜设楼面示意图，在重要信息提示处宜设电子显示屏。

**8.1.7** 公共建筑的无障碍设施应成系统设计，并宜相互靠近。

---

### 8.2 办公、科研、司法建筑

**8.2.1** 办公、科研、司法建筑进行无障碍设计的范围包括：政府办公建筑、司法办公建筑、企事业办公建筑、各类科研建筑、社区办公及其他办公建筑等。

**8.2.2** 为公众办理业务与信访接待的办公建筑的无障碍设施应符合下列规定：  
1 建筑的主要出入口应为无障碍出入口；  
2 建筑出入口大厅、休息厅、贵宾休息室、疏散大厅等人员聚集场所有高差或台阶时应设轮椅坡道，宜提供休息座椅和可以放置轮椅的无障碍休息区；  
3 公众通行的室内走道应为无障碍通道，走道长度大于60.00m时，宜设休息区，休息区应避开行走路线；  
4 供公众使用的楼梯宜为无障碍楼梯；  
5 供公众使用的男、女公共厕所均应满足本规范第3.9.1条的有关规定或在男、女公共厕所附近设置1个无障碍厕所，且建筑内至少应设置1个无障碍厕所，内部办公人员使用的男、女公共厕所至少应各有1个满足本规范第3.9.1条的有关规定或在男、女公共厕所附近设置1个无障碍厕所；  
6 法庭、审判庭及为公众服务的会议及报告厅等的公众坐席座位数为300座及以下时应至少设置1个轮椅席位，300座以上时不应少于0.2%且不少于2个轮椅席位。

**8.2.3** 其他办公建筑的无障碍设施应符合下列规定：  
1 建筑物至少应有1处为无障碍出入口，且宜位于主要出入口处；  
2 男、女公共厕所至少各有1处应满足本规范第3.9.1条或第3.9.2条的有关规定；  
3 多功能厅、报告厅等至少应设置1个轮椅坐席。

---

### 8.3 教育建筑

**8.3.1** 教育建筑进行无障碍设计的范围应包括托儿所、幼儿园建筑、中小学建筑、高等院校建筑、职业教育建筑、特殊教育建筑等。

**8.3.2** 教育建筑的无障碍设施应符合下列规定：  
1 凡教师、学生和婴幼儿使用的建筑物主要出入口应为无障碍出入口，宜设置为平坡出入口；  
2 主要教学用房应至少设置1部无障碍楼梯；  
3 公共厕所至少有1处应满足本规范第3.9.1条的有关规定。

**8.3.3** 接收残疾生源的教育建筑的无障碍设施应符合下列规定：  
1 主要教学用房每层至少有1处公共厕所应满足本规范第3.9.1条的有关规定；  
2 合班教室、报告厅以及剧场等应设置不少于2个轮椅坐席，服务报告厅的公共厕所应满足本规范第3.9.1条的有关规定或设置无障碍厕所；  
3 有固定座位的教室、阅览室、实验教室等教学用房，应在靠近出入口处预留轮椅回转空间。

**8.3.4** 视力、听力、言语、智力残障学校设计应符合现行行业标准《特殊教育学校建筑设计规范》JGJ 76的有关要求。

---

### 8.4 医疗康复建筑

**8.4.1** 医疗康复建筑进行无障碍设计的范围应包括综合医院、专科医院、疗养院、康复中心、急救中心和其他所有与医疗、康复有关的建筑物。

**8.4.2** 医疗康复建筑中，凡病人、康复人员使用的建筑的无障碍设施应符合下列规定：  
1 室外通行的步行道应满足本规范第3.5节有关规定的要求；  
2 院区室外的休息座椅旁，应留有轮椅停留空间；  
3 主要出入口应为无障碍出入口，宜设置为平坡出入口；  
4 室内通道应设置无障碍通道，净宽不应小于1.80m，并按照本规范第3.8节的要求设置扶手；  
5 门应符合本规范第3.5节的要求；  
6 同一建筑内应至少设置1部无障碍楼梯；  
7 建筑内设有电梯时，每组电梯应至少设置1部无障碍电梯；  
8 首层应至少设置1处无障碍厕所；各楼层至少有1处公共厕所应满足本规范第3.9.1条的有关规定或设置无障碍厕所；病房内的厕所应设置安全抓杆，并符合本规范第3.9.4条的有关规定；  
9 儿童医院的门、急诊部和医技部，每层宜设置至少1处母婴室，并靠近公共厕所；  
10 诊区、病区的护士站、公共电话台、查询处、饮水器、自助售货处、服务台等应设置低位服务设施；  
11 无障碍设施应设符合我国国家标准的无障碍标志，在康复建筑的院区主要出入口处宜设置盲文地图或供视觉障碍者使用的语音导医系统和提示系统、供听力障碍者需要的手语服务及文字提示导医系统。

**8.4.3** 门、急诊部的无障碍设施还应符合下列规定：  
1 挂号、收费、取药处应设置文字显示器以及语言广播装置和低位服务台或窗口；  
2 候诊区应设轮椅停留空间。

**8.4.4** 医技部的无障碍设施应符合下列规定：  
1 病人更衣室内应留有直径不小于1.50m的轮椅回转空间，部分更衣箱高度应小于1.40m；  
2 等候区应留有轮椅停留空间，取报告处宜设文字显示器和语音提示装置。

**8.4.5** 住院部病人活动室墙面四周扶手的设置应满足本规范第3.8节的有关规定。

**8.4.6** 理疗用房应根据治疗要求设置扶手，并满足本规范第3.8节的有关规定。

**8.4.7** 办公、科研、餐厅、食堂、太平间用房的主要出入口应为无障碍出入口。

---

### 8.5 福利及特殊服务建筑

**8.5.1** 福利及特殊服务建筑进行无障碍设计的范围应包括福利院、敬（安、养）老院、老年护理院、老年住宅、残疾人综合服务设施、残疾人托养中心、残疾人体训中心及其他残疾人集中或使用频率较高的建筑等。

**8.5.2** 福利及特殊服务建筑的无障碍设施应符合下列规定：  
1 室外通行的步行道应满足本规范第3.5节有关规定的要求；  
2 室外院区的休息座椅旁应留有轮椅停留空间；  
3 建筑物首层主要出入口应为无障碍出入口，宜设置为平坡出入口。主要出入口设置台阶时，台阶两侧宜设置扶手；  
4 建筑出入口大厅、休息厅等人员聚集场所宜提供休息座椅和可以放置轮椅的无障碍休息区；  
5 公共区域的室内通道应为无障碍通道，走道两侧墙面应设置扶手，并满足本规范3.8节的有关规定；室外的连通走道应选用平整、坚固、耐磨、不光滑的材料并宜设防风避雨设施；  
6 楼梯应为无障碍楼梯；  
7 电梯应为无障碍电梯；  
8 居室户门净宽不应小于900mm；居室内走道净宽不应小于1.20m；卧室、厨房、卫生间门净宽不应小于800mm；  
9 居室内宜留有直径不小于1.5m的轮椅回转空间；  
10 居室内的厕所应设置安全抓杆，并符合本规范第3.9.4条的有关规定;居室外的公共厕所应满足本规范第3.9.1条的有关规定或设置无障碍厕所；  
11 公共浴室应满足本规范第3.10节的有关规定；居室内的淋浴间或盆浴间应设置安全抓杆，并符合本规范第3.10.2及3.10.3条的有关规定；  
12 居室宜设置语音提示装置。

**8.5.3** 其他不同建筑类别应符合国家现行的有关建筑设计规范与标准的设计要求。

---

### 8.6 体育建筑

**8.6.1** 体育建筑进行无障碍设计的范围应包括作为体育比赛（训练）、体育教学、体育休闲的体育场馆和场地设施等。

**8.6.2** 体育建筑的无障碍设施应符合下列规定：  
1 特级、甲级场馆基地内应设置不少于停车数量的2%，且不少于2个无障碍机动车停车位，乙级、丙级场馆基地内应设置不少于2个无障碍机动车停车位；  
2 建筑物的观众、运动员及贵宾出入口应至少各设1处无障碍出入口，其他功能分区的出入口可根据需要设置无障碍出入口；  
3 建筑的检票口及无障碍出入口到各种无障碍设施的室内走道应为无障碍通道，通道长度大于60.00m时宜设休息区，休息区应避开行走路线；  
4 大厅、休息厅、贵宾休息室、疏散大厅等主要人员聚集场宜设放置轮椅的无障碍休息区；  
5 供观众使用的楼梯应为无障碍楼梯；  
6 特级、甲级场馆内各类观众看台区、主席台、贵宾区内如设置电梯应至少各设置1部无障碍电梯，乙级、丙级场馆内坐席区设有电梯时，至少应设置1部无障碍电梯，并应满足赛事和观众的需要；  
7 特级、甲级场馆每处观众区和运动员区使用的男、女公共厕所均应满足本规范第3.9.1条的有关规定或在每处男、女公共厕所附近设置1个无障碍厕所，且场馆内至少应设置1个无障碍厕所，主席台休息区、贵宾休息区应至少各设置1个无障碍厕所；乙级、丙级场馆的观众区和运动员区各至少有1处男、女公共厕所应满足本规范第3.9.1条的有关规定或各在男、女公共厕所附近设置1个无障碍厕所；  
8 运动员浴室均应满足本规范第3.10节的有关规定；  
9 场馆内各类观众看台的坐席区都应设置轮椅席位，并在轮椅席位旁或邻近的坐席处，设置1:1的陪护席位，轮椅席位数不应少于观众席位总数的0.2%。

---

### 8.7 文化建筑

**8.7.1** 文化建筑进行无障碍设计的范围应包括文化馆、活动中心、图书馆、档案馆、纪念馆、纪念塔、纪念碑、宗教建筑、博物馆、展览馆、科技馆、艺术馆、美术馆、会展中心、剧场、音乐厅、电影院、会堂、演艺中心等。

**8.7.2** 文化类建筑的无障碍设施应符合下列规定：  
1 建筑物至少应有1处为无障碍出入口，且宜位于主要出入口处；  
2 建筑出入口大厅、休息厅（贵宾休息厅）、疏散大厅等主要人员聚集场所有高差或台阶时应设轮椅坡道，宜设置休息座椅和可以放置轮椅的无障碍休息区；  
3 公众通行的室内走道及检票口应为无障碍通道，走道长度大于60.00m，宜设休息区，休息区应避开行走路线；  
4 供公众使用的主要楼梯宜为无障碍楼梯；  
5 供公众使用的男、女公共厕所每层至少有1处应满足本规范第3.9.1条的有关规定或在男、女公共厕所附近设置1个无障碍厕所；  
6 公共餐厅应提供总用餐数2%的活动座椅，供乘轮椅者使用。

**8.7.3** 文化馆、少儿活动中心、图书馆、档案馆、纪念馆、纪念塔、纪念碑、宗教建筑、博物馆、展览馆、科技馆、艺术馆、美术馆、会展中心等建筑物的无障碍设施还应符合下列规定：  
1 图书馆、文化馆等安有探测仪的出入口应便于乘轮椅者进入；  
2 图书馆、文化馆等应设置低位目录检索台；  
3 报告厅、视听室、陈列室、展览厅等设有观众席位时应至少设1个轮椅席位；  
4 县、市级及以上图书馆应设盲人专用图书室（角），在无障碍入口、服务台、楼梯间和电梯间入口、盲人图书室前应设行进盲道和提示盲道；  
5 宜提供语音导览机、助听器等信息服务。

**8.7.4** 剧场、音乐厅、电影院、会堂、演艺中心等建筑物的无障碍设施应符合下列规定：  
1 观众厅内座位数为300座及以下时应至少设置1个轮椅席位，300座以上时不应少于0.2%且不少于2个轮椅席位；  
2 演员活动区域至少有1处男、女公共厕所应满足本规范第3.9节的有关规定的要求，贵宾室宜设1个无障碍厕所。

---

### 8.8 商业服务建筑

**8.8.1** 商业服务建筑进行无障碍设计的范围包括各类百货店、购物中心、超市、专卖店、专业店、餐饮建筑、旅馆等商业建筑，银行、证券等金融服务建筑，邮局、电信局等邮电建筑，娱乐建筑等。

**8.8.2** 商业服务建筑的无障碍设计应符合下列规定：  
1 建筑物至少应有1处为无障碍出入口，且宜位于主要出入口处；  
2 公众通行的室内走道应为无障碍通道；  
3 供公众使用的男、女公共厕所每层至少有1处应满足本规范第3.9.1条的有关规定或在男、女公共厕所附近设置1个无障碍厕所，大型商业建筑宜在男、女公共厕所满足本规范第3.9.1条的有关规定的同时且在附近设置1个无障碍厕所；  
4 供公众使用的主要楼梯应为无障碍楼梯。

**8.8.3** 旅馆等商业服务建筑应设置无障碍客房，其数量应符合下列规定：  
1 100间以下，应设1间~2间无障碍客房；  
2 100间~400间，应设2间~4间无障碍客房；  
3 400间以上，应至少设4间无障碍客房。

**8.8.4** 设有无障碍客房的旅馆建筑，宜配备方便导盲犬休息的设施。

---

### 8.9 汽车客运站

**8.9.1** 汽车客运站建筑进行无障碍设计的范围包括各类长途汽车站。

**8.9.2** 汽车客运站建筑的无障碍设计应符合下列规定：  
1 站前广场人行通道的地面应平整、防滑、不积水，有高差时应做轮椅坡道；  
2 建筑物至少应有1处为无障碍出入口，宜设置为平坡出入口，且宜位于主要出入口处；  
3 门厅、售票厅、候车厅、检票口等旅客通行的室内走道应为无障碍通道；  
4 供旅客使用的男、女公共厕所每层至少有1处应满足本规范第3.9.1条的有关规定或在男、女公共厕所附近设置1个无障碍厕所，且建筑内至少应设置1个无障碍厕所；  
5 供公众使用的主要楼梯应为无障碍楼梯；  
6 行包托运处（含小件寄存处）应设置低位窗口。

---

### 8.10 公共停车场（库）

**8.10.1** 公共停车场（库）应设置无障碍机动车停车位，其数量应符合下列规定：  
1 Ⅰ类公共停车场（库）应设置不少于停车数量2%的无障碍机动车停车位；  
2 Ⅱ类及Ⅲ类公共停车场（库）应设置不少于停车数量2%，且不少于2个无障碍机动车停车位；  
3 Ⅳ类公共停车场（库）应设置不少于1个无障碍机动车停车位。

**8.10.2** 设有楼层公共停车库的无障碍机动车停车位宜设在与公共交通道路同层的位置，或通过无障碍设施衔接通往地面层。

---

### 8.11 汽车加油加气站

**8.11.1** 汽车加油加气站附属建筑的无障碍设计应符合下列规定：  
1 建筑物至少应有1处为无障碍出入口，且宜位于主要出入口处；  
2 男、女公共厕所宜满足本规范第8.13节的有关规定。

---

### 8.12 高速公路服务区建筑

**8.12.1** 高速公路服务区建筑内的服务建筑的无障碍设计应符合下列规定：  
1 建筑物至少应有1处为无障碍出入口，且宜位于主要出入口处；  
2 男、女公共厕所应满足本规范第8.13节的有关规定。

---

### 8.13 城市公共厕所

**8.13.1** 城市公共厕所进行无障碍设计的范围应包括独立式、附属式公共厕所。

**8.13.2** 城市公共厕所的无障碍设计应符合下列规定：  
1 出入口应为无障碍出入口；  
2 在两层公共厕所中，无障碍厕位应设在地面层；  
3 女厕所的无障碍设施包括至少1个无障碍厕位和1个无障碍洗手盆；男厕所的无障碍设施包括至少1个无障碍厕位、1个无障碍小便器和1个无障碍洗手盆；并应满足本规范第3.9.1条的有关规定；  
4 宜在公共厕所旁另设1处无障碍厕所；  
5 厕所内的通道应方便乘轮椅者进出和回转，回转直径不小于1.50m；  
6 门应方便开启，通行净宽度不应小于800mm；  
7 地面应防滑、不积水。

---

## 9 历史文物保护建筑无障碍建设与改造

### 9.1 实施范围

**9.1.1** 历史文物保护建筑进行无障碍设计的范围应包括开放参观的历史名园、开放参观的古建博物馆、使用中的庙宇、开放参观的近现代重要史迹及纪念性建筑、开放的复建古建筑等。

---

### 9.2 无障碍游览路线

**9.2.1** 对外开放的文物保护单位应根据实际情况设计无障碍游览路线，无障碍游览路线上的文物建筑宜尽量满足游客参观的需求。

---

### 9.3 出入口

**9.3.1** 无障碍游览路线上对游客开放参观的文物建筑对外的出入口至少应设1处无障碍出入口，其设置标准要以保护文物为前提，坡道、平台等可为可拆卸的活动设施。

**9.3.2** 展厅、陈列室、视听室等，至少应设1处无障碍出入口，其设置标准要以保护文物为前提，坡道、平台等可为可拆卸的活动设施。

**9.3.3** 开放的文物保护单位的对外接待用房的出入口宜为无障碍出入口。

---

### 9.4 院落

**9.4.1** 无障碍游览路线上的游览通道的路面应平整、防滑，其纵坡不宜大于1:50，有台阶处应同时设置轮椅坡道，坡道、平台等可为可拆卸的活动设施。

**9.4.2** 开放的文物保护单位内可不设置盲道，当特别需要时可设置，且应与周围环境相协调。

**9.4.3** 位于无障碍游览路线上的院落内的公共绿地及其通道、休息凉亭等设施的地面应平整、防滑，有台阶处宜同时设置坡道，坡道、平台等可为可拆卸的活动设施。

**9.4.4** 院落内的休息座椅旁宜设轮椅停留空间。

---

### 9.5 服务设施

**9.5.1** 供公众使用的男、女公共厕所至少应有1处满足本规范第8.13节的有关规定。

**9.5.2** 供公众使用的服务性用房的出入口至少应有1处为无障碍出入口，且宜位于主要出入口处。

**9.5.3** 售票处、服务台、公用电话、饮水器等应设置低位服务设施。

**9.5.4** 纪念品商店如有开放式柜台、收银台，应配备低位柜台。

**9.5.5** 设有演播电视等服务设施的，其观众区应至少设置1个轮椅席位。

**9.5.6** 建筑基地内设有停车场的，应设置不少于1个无障碍机动车停车位。

---

### 9.6 信息与标识

**9.6.1** 信息与标识的无障碍设计应符合下列规定：  
1 主要出入口、无障碍通道、停车位、建筑出入口、厕所等无障碍设施的位置，应设置无障碍标志，无障碍标志应符合本规范第3.16节的有关规定；  
2 重要的展览性陈设，宜设置盲文解说牌。

---

## 附录A 无障碍标志

（内容略）

## 附录B 无障碍设施标志牌

（内容略）

## 附录C 用于指示方向的无障碍设施标志牌

（内容略）

---

## 本规范用词说明

1. 为便于在执行本规范条文时区别对待，对要求严格程度不同的用词说明如下：
   1) 表示很严格，非这样做不可的：正面词采用“必须”，反面词采用“严禁”；
   2) 表示严格，在正常情况下均应这样做的：正面词采用“应”，反面词采用“不应”或“不得”；
   3) 表示允许稍有选择，在条件许可时首先应这样做的：正面词采用“宜”，反面词采用“不宜”；
   4) 表示有选择，在一定条件下可以这样做的，采用“可”。

2. 条文中指明应按其他有关标准执行的写法为“应符合......的规定”或“应按......执行”。
