"""
EA-RAG 配置文件 - 多专家版本 v3
对应架构图: EA-RAG Multi-Expert Architecture
"""

from pathlib import Path

# ================== API 配置 ==================
# 使用 google-genai 包的模型名称格式
EMBEDDING_MODEL = "gemini-embedding-exp-03-07"
LLM_MODEL = "gemini-2.5-flash"

# ================== 路径配置 ==================
KNOWLEDGE_BASE_DIR = Path("knowledge_base")
INDEX_CACHE_DIR = KNOWLEDGE_BASE_DIR / "index_cache"

# ================== 专家配置 ==================
# 对应架构图中的 Fire Safety Expert / Accessibility Expert / Energy Expert / Other Experts
# 每个专家包含:
#   - Code Layer: 规范层 (codes 字段列出相关规范)
#   - Exp. Layer: 经验层 (Clause Interpretation, Risk Tips, Case Experience)

EXPERTS = {
    "fire_safety": {
        "name": "消防专家",
        "name_en": "Fire Safety Expert",
        "icon": "🔥",
        # Code Layer - 对应架构图中的 "Code: GB 50016, GB 55037"
        "codes": ["GB 50016", "GB 55037", "GB 50222", "GB 50084", "GB 50116"],
        "keywords": [
            "消防", "防火", "疏散", "灭火", "火灾", "耐火", "防烟", "排烟",
            "安全出口", "疏散楼梯", "疏散走道", "防火分区", "防火门", "防火墙",
            "喷淋", "报警", "消防通道", "逃生", "耐火等级", "疏散距离"
        ],
        # Exp. Layer - Clause Interpretation, Risk Tips, Case Experience
        "experience_types": ["条款解读", "风险提示", "案例经验"],
        "description": "建筑防火设计、消防设施、安全疏散"
    },

    "accessibility": {
        "name": "无障碍专家",
        "name_en": "Accessibility Expert",
        "icon": "♿",
        # Code Layer - 对应架构图中的 "Code: GB 55019, GB 50763"
        "codes": ["GB 55019", "GB 50763", "JGJ 50"],
        "keywords": [
            "无障碍", "轮椅", "坡道", "扶手", "盲道", "残疾", "通行",
            "无障碍通道", "无障碍出入口", "无障碍厕所", "无障碍电梯",
            "无障碍停车位", "无障碍客房"
        ],
        "experience_types": ["条款解读", "风险提示", "案例经验"],
        "description": "无障碍设计、通行设施"
    },

    "energy": {
        "name": "节能专家",
        "name_en": "Energy Expert",
        "icon": "⚡",
        # Code Layer - 对应架构图中的 "Code: GB 55015, GB 50189"
        "codes": ["GB 55015", "GB 50189", "GB 50176", "GB 55036"],
        "keywords": [
            "节能", "保温", "隔热", "能耗", "传热系数", "遮阳", "气密性",
            "围护结构", "外墙", "屋面", "外窗", "热桥", "绿色建筑",
            "能效", "碳排放"
        ],
        "experience_types": ["条款解读", "风险提示", "案例经验"],
        "description": "建筑节能、围护结构热工"
    },

    "residential": {
        "name": "住宅专家",
        "name_en": "Residential Expert",
        "icon": "🏠",
        # Code Layer
        "codes": ["GB 50096", "GB 55031", "JGJ 242"],
        "keywords": [
            "住宅", "居住", "卧室", "起居室", "厨房", "卫生间", "阳台",
            "套型", "户型", "层高", "净高", "开间", "进深", "日照",
            "采光", "通风", "隔声", "私密性", "公共空间"
        ],
        "experience_types": ["条款解读", "风险提示", "案例经验"],
        "description": "住宅建筑设计要求"
    },

    "schools": {
        "name": "学校专家",
        "name_en": "Schools Expert",
        "icon": "🏫",
        # Code Layer
        "codes": ["GB 50099", "GB 55030", "JGJ 76"],
        "keywords": [
            "学校", "教室", "实验室", "图书馆", "体育馆", "食堂", "宿舍",
            "教学楼", "走廊", "楼梯", "操场", "运动场", "采光系数",
            "课桌", "黑板", "幼儿园", "中小学", "大学"
        ],
        "experience_types": ["条款解读", "风险提示", "案例经验"],
        "description": "学校建筑设计要求"
    },

    "general": {
        "name": "通用专家",
        "name_en": "General Expert",
        "icon": "📐",
        # Code Layer - 对应架构图中的 "Other Experts - Relevant Standards"
        "codes": ["GB 50096", "GB 50352", "GB 50099", "GB 51039"],
        "keywords": [
            "层高", "面积", "采光", "通风", "日照", "间距", "密度",
            "容积率", "建筑高度", "住宅", "办公", "商业", "走廊", "楼梯"
        ],
        # Domain Knowledge
        "experience_types": ["条款解读", "风险提示", "案例经验"],
        "description": "通用建筑设计要求"
    }
}

# ================== 检索参数 ==================
CHUNK_SIZE = 500
CHUNK_OVERLAP = 50
TOP_K_PER_EXPERT = 3  # 每个专家返回的结果数
EMBEDDING_BATCH_SIZE = 10

# ================== 专家激活阈值 ==================
KEYWORD_MATCH_THRESHOLD = 1  # 匹配到几个关键词才激活专家
CODE_MATCH_BOOST = 3  # 规范代码匹配的额外权重
SIMILARITY_THRESHOLD = 0.5  # 相似度阈值
MAX_ACTIVATED_EXPERTS = 3  # 最多激活专家数

# ================== 冲突检测配置 ==================
# Multi-Expert Fusion 中的冲突检测规则
CONFLICT_PAIRS = [
    # (专家1, 专家2, 可能冲突的场景描述)
    ("fire_safety", "accessibility", "走廊宽度：消防要求vs无障碍要求"),
    ("fire_safety", "energy", "外墙材料：防火要求vs保温要求"),
    ("structural", "fire_safety", "防火分区：结构布置vs消防分隔"),
]