from google import genai
import os

# 确保环境变量已设置
api_key = os.environ.get("GOOGLE_API_KEY")
if not api_key:
    print("错误：未找到 GOOGLE_API_KEY 环境变量")
else:
    client = genai.Client(api_key=api_key)
    print(f"--- 正在连接 Google API ---")

    try:
        # 获取所有模型并筛选支持生成内容的型号
        models = client.models.list()
        print(f"{'模型 ID (代码中填这个)':<40} | {'显示名称'}")
        print("-" * 70)

        for m in models:
            # 在 v1.0+ SDK 中，属性名为 supported_actions
            if 'generateContent' in m.supported_actions:
                # 提取模型短名，通常是 'gemini-1.5-flash' 这种格式
                model_id = m.name.split('/')[-1] if '/' in m.name else m.name
                print(f"{model_id:<40} | {m.display_name}")

    except Exception as e:
        print(f"获取模型列表失败: {e}")