"""
EA-RAG: Experience-Augmented RAG - 多专家版本 v3

经验增强型RAG建筑规范咨询系统

架构: EA-RAG Multi-Expert Architecture
- User Query → Query Router → [Expert Modules] → Multi-Expert Fusion → Structured Response

每个专家包含:
- Code Layer: 规范文档层
- Exp. Layer: 经验文档层 (Clause Interpretation, Risk Tips, Case Experience)

向量存储: ChromaDB
"""

from .system import EARAGSystem
from .config import EXPERTS, KNOWLEDGE_BASE_DIR
from .models import StructuredResponse, CodeRequirement
from .vector_store import VectorStore

__version__ = "0.3.1"
__all__ = [
    "EARAGSystem",
    "EXPERTS",
    "KNOWLEDGE_BASE_DIR",
    "StructuredResponse",
    "CodeRequirement",
    "VectorStore"
]