# EA-RAG v3: 多专家建筑规范咨询系统

## 架构概述

对应论文架构图 **EA-RAG: Multi-Expert Architecture**

```
┌──────────────────────────────────────────────────────────────────────────┐
│                    EA-RAG: Multi-Expert Architecture                      │
├──────────────────────────────────────────────────────────────────────────┤
│                                                                           │
│                         ┌─────────────────┐                               │
│                         │   User Query    │                               │
│                         │ "商业建筑走廊    │                               │
│                         │   宽度要求？"   │                               │
│                         └────────┬────────┘                               │
│                                  │                                        │
│                                  ▼                                        │
│                         ┌─────────────────┐                               │
│                         │  Query Router   │                               │
│                         │ Identify Relevant│                              │
│                         │    Domains      │                               │
│                         └────────┬────────┘                               │
│                                  │                                        │
│         ┌────────────────────────┼────────────────────────┐               │
│         │                        │                        │               │
│         ▼                        ▼                        ▼               │
│  ┌─────────────┐         ┌─────────────┐         ┌─────────────┐         │
│  │🔥 Fire Safety│        │♿Accessibility│        │⚡ Energy    │   ...   │
│  │   Expert    │         │   Expert    │         │   Expert    │         │
│  ├─────────────┤         ├─────────────┤         ├─────────────┤         │
│  │ Code Layer  │         │ Code Layer  │         │ Code Layer  │         │
│  │ GB 50016    │         │ GB 55019    │         │ GB 55015    │         │
│  │ GB 55037    │         │ GB 50763    │         │ GB 50189    │         │
│  ├─────────────┤         ├─────────────┤         ├─────────────┤         │
│  │ Exp. Layer  │         │ Exp. Layer  │         │ Exp. Layer  │         │
│  │ ・条款解读   │         │ ・条款解读   │         │ ・条款解读   │         │
│  │ ・风险提示   │         │ ・风险提示   │         │ ・风险提示   │         │
│  │ ・案例经验   │         │ ・案例经验   │         │ ・案例经验   │         │
│  └──────┬──────┘         └──────┬──────┘         └──────┬──────┘         │
│         │                        │                        │               │
│         │  ┌─────────────────────┼─────────────────────┐  │               │
│         │  │      Activated      │     Not Activated   │  │               │
│         └──┤   (Fire + Access.)  │       (Energy)      ├──┘               │
│            └──────────┬──────────┴────────────────────┘                   │
│                       │                                                   │
│                       ▼                                                   │
│            ┌─────────────────────┐                                        │
│            │  Multi-Expert Fusion │                                       │
│            │  ・Result Aggregation│                                       │
│            │  ・Conflict Detection│                                       │
│            │  ・Source Attribution│                                       │
│            └──────────┬──────────┘                                        │
│                       │                                                   │
│                       ▼                                                   │
│  ┌────────────────────────────────────────────────────────────────────┐  │
│  │                      Structured Response                           │  │
│  │ ┌────────────────────────────────────────────────────────────────┐ │  │
│  │ │📋 Regulatory Requirements:                                      │ │  │
│  │ │   [Fire] GB 50016 §5.5.18: Evacuation corridor ≥1.4m           │ │  │
│  │ │   [Accessibility] GB 55019 §4.2.3: Accessibility corridor ≥1.8m│ │  │
│  │ ├────────────────────────────────────────────────────────────────┤ │  │
│  │ │💡 Exp. Interpretation → Underground commercial: uniform 1.8m   │ │  │
│  │ │⚠️ Risk Tip → Common error: Satisfying only fire, not access.  │ │  │
│  │ │⚖️ Liability Boundary → Subject to review agency's opinion     │ │  │
│  │ └────────────────────────────────────────────────────────────────┘ │  │
│  └────────────────────────────────────────────────────────────────────┘  │
│                                                                           │
└──────────────────────────────────────────────────────────────────────────┘
```

## 目录结构

```
ea_rag_v3/
├── main.py                 # 启动脚本
├── requirements.txt        # 依赖
├── README.md              # 本文档
│
├── ea_rag/                # 核心包
│   ├── __init__.py
│   ├── config.py          # 配置 (专家定义、规范代码映射)
│   ├── models.py          # 数据模型 (StructuredResponse等)
│   ├── embeddings.py      # 嵌入服务
│   ├── expert.py          # 专家模块 + QueryRouter
│   ├── fusion.py          # Multi-Expert Fusion
│   ├── generator.py       # 响应生成器
│   └── system.py          # 主系统
│
└── knowledge_base/        # 知识库 (运行--init后创建)
    ├── fire_safety/       # 🔥 消防专家
    │   ├── code/          # Code Layer
    │   └── experience/    # Exp. Layer
    ├── accessibility/     # ♿ 无障碍专家
    ├── energy/           # ⚡ 节能专家
    ├── structural/       # 🏗️ 结构专家
    └── general/          # 📐 通用专家
```

## 快速开始

```bash
# 1. 安装依赖
pip install google-genai numpy

# 2. 设置 API Key
export GOOGLE_API_KEY="your-api-key"

# 3. 初始化 (创建示例文档)
python main.py --init

# 4. 运行查询
python main.py -q "商业建筑走廊宽度要求？"
```

## 核心组件说明

### 1. Query Router (查询路由器)
- **位置**: `ea_rag/expert.py` 中的 `QueryRouter` 类
- **功能**: 根据查询内容识别相关专业领域
- **机制**: 关键词匹配 + 规范代码匹配

### 2. Expert Modules (专家模块)
- **位置**: `ea_rag/expert.py` 中的 `Expert` 类
- **结构**: 每个专家包含 Code Layer + Exp. Layer
- **配置**: `ea_rag/config.py` 中的 `EXPERTS` 字典

### 3. Multi-Expert Fusion (多专家融合)
- **位置**: `ea_rag/fusion.py`
- **功能**:
  - Result Aggregation: 聚合多专家检索结果
  - Conflict Detection: 检测跨专业冲突
  - Source Attribution: 来源标注

### 4. Structured Response (结构化响应)
- **位置**: `ea_rag/models.py` 中的 `StructuredResponse` 类
- **格式**:
  - 📋 Regulatory Requirements (规范要求)
  - 💡 Exp. Interpretation (经验解读)
  - ⚠️ Risk Tip (风险提示)
  - ⚖️ Liability Boundary (责任边界)

## 示例输出

```
🔍 查询: 商业建筑走廊宽度要求？
   Query Router → Activated: 🔥消防专家, ♿无障碍专家
                 Not Activated: ⚡节能专家, 🏗️结构专家, 📐通用专家
   🔥 消防专家: Code 3, Exp 2
   ♿ 无障碍专家: Code 2, Exp 1
   Multi-Expert Fusion → Generating Structured Response...

🎯 激活专家: 🔥消防专家 + ♿无障碍专家

============================================================
### 📋 规范要求 (Regulatory Requirements)

**🔥 消防专家 (Fire)：**
- GB 50016 §5.5.18: 疏散走道净宽度不应小于1.10m

**♿ 无障碍专家 (Accessibility)：**
- GB 55019 §4.2.3: 无障碍通道宽度不应小于1.80m

### 💡 经验解读 (Exp. Interpretation)
商业建筑走廊需同时满足消防和无障碍要求。建议统一按1.8m设计。
地下商业还需考虑人员密度计算疏散宽度。

### ⚠️ 风险提示 (Risk Tip)
- 常见错误：仅满足消防1.1m要求，忽视无障碍1.8m要求
- 审图关注：疏散宽度计算书、无障碍通道连续性

### ⚖️ 责任边界 (Liability Boundary)
具体以审图机构意见为准。特殊情况请咨询消防及无障碍专业顾问。
============================================================
```

## 添加自定义知识库

1. 将规范文档放入 `knowledge_base/{expert_id}/code/`
2. 将经验文档放入 `knowledge_base/{expert_id}/experience/`
3. 运行 `python main.py --rebuild` 重建索引

## 添加新专家

修改 `ea_rag/config.py` 中的 `EXPERTS` 字典：

```python
EXPERTS = {
    "my_expert": {
        "name": "我的专家",
        "name_en": "My Expert",
        "icon": "🎯",
        "codes": ["GB XXXXX"],
        "keywords": ["关键词1", "关键词2"],
        "experience_types": ["条款解读", "风险提示", "案例经验"],
        "description": "专家描述"
    },
}
```
