get_sellers(model) = findall(>(0), model.net_excess)
get_buyers(model) = findall(<(0), model.net_excess)
get_actors(model) = findall(!=(0), model.net_excess)
get_neighs(model, p) = findall(<(0), model.net_excess .* model.net_excess[p])

function market_clearing!(model)
    while true
        exchange = make_exchange!(model)
        if isnothing(exchange) break
        else push_exchange!(model, exchange) end
    end
end

function make_exchange!(model)
    for p in shuffle!(abmrng(model), get_actors(model))
        neigh = get_neighs(model, p)
        if length(neigh) > 0
            offers = get_offers(model, p, neigh)
            exchange = get_exchange!(model, p, offers)
            if !isnothing(exchange) return exchange end
        end
    end
end

function get_offers(model, p, neigh)
    power = min.(Ref(model.abs_net_excess[p]), model.abs_net_excess[neigh])
    if model.net_excess[p] > 0 # is selling
        sellers = [p for _ in neigh]
        buyers = neigh
        min_price = model.sell_price[p] .* power
        max_price = model.buy_price[neigh] .* power
        price = copy(max_price)
    elseif model.net_excess[p] < 0 # is buying
        sellers = neigh
        buyers = [p for _ in neigh]
        min_price = model.sell_price[neigh] .* power
        max_price = model.buy_price[p] .* power
        price = copy(min_price)
    else
        error("Prosumer is not active")
    end
    [Dict{Symbol, Any}(
        :seller=>se,
        :buyer=>bu,
        :power=>po,
        :min_price=>mi,
        :max_price=>ma,
        :price=>pr,
        :price_per_e=>pr / po,
        :calculated=>false,
        :sender=>n,
        :receiver=>p,
    ) for (se, bu, po, ma, mi, pr, n) in zip(sellers, buyers, power, max_price, min_price, price, neigh)]
end

offer_price(offer) = offer[:price_per_e]
valid_offer(offer) = offer[:min_price] <= offer[:max_price]
seller_finder(offers) = findmax(offer_price, offers)
buyer_finder(offers) = findmin(offer_price, offers)

function get_exchange!(model, p, offers)
    if model.net_excess[p] > 0
        offer_finder = seller_finder
    elseif model.net_excess[p] < 0
        offer_finder = buyer_finder
    else error("Prosumer is not active") end
    while length(offers) > 0
        (price, i) = offer_finder(offers)
        offer = offers[i]
        if !valid_offer(offer)
            deleteat!(offers, i)
        elseif !offer[:calculated]
            offer_pf!(model, offer)
            if model.regulation
                sender_evaluate!(model, offer)
                receiver_evaluate!(model, offer)
            end
            offer[:price] = min(offer[:max_price], max(offer[:min_price], offer[:price]))
            offer[:price_per_e] = offer[:price] / offer[:power]
            offer[:calculated] = true
        else
            return offer
        end
    end
end

function offer_pf!(model, offer)
    bus_s = model.buses[offer[:seller]]
    bus_b = model.buses[offer[:buyer]]
    if bus_s == bus_b
        offer[:same_bus] = true
        offer[:violation_sum] = model.violation_sum
        offer[:fine] = 0.
        return
    end
    offer[:same_bus] = false
    injection = copy(model.injection)
    injection[bus_s] += offer[:power]
    injection[bus_b] -= offer[:power]
    if net_pf!(model.net, injection)
        offer[:violation_sum] = sum(model.net[:violation])
        if model.violation_sum == Inf
            offer[:fine] = offer[:violation_sum] * model.fine_per_vm
        else
            offer[:fine] = (offer[:violation_sum] - model.violation_sum) * model.fine_per_vm
        end
    else
        offer[:fine] = model.blackout_fine
        offer[:violation_sum] = Inf
    end
    offer[:fine] = max(0., offer[:fine])
end

function sender_evaluate!(model, offer)
    if model.is_regulated[offer[:sender]]
        if offer[:sender] == offer[:seller]
            offer[:min_price] += offer[:fine] #+ model.malus[s.id, offer[:buyer]]
        else
            offer[:max_price] -= offer[:fine] #+ model.malus[s.id, offer[:seller]]
        end
    end
end
function receiver_evaluate!(model, offer)
    #if model.is_regulated[offer[:receiver]]
    #    if offer[:receiver] == offer[:seller]
    #        offer[:min_price] += offer[:fine] #+ model.malus[s.id, offer[:buyer]]
    #    else
    #        offer[:max_price] -= offer[:fine] #+ model.malus[s.id, offer[:seller]]
    #    end
    #end
end
