using Pkg
Pkg.activate("srpc")
using srpc

net_name = "case14"

@everywhere begin
    using Pkg
    Pkg.activate("srpc")
    using srpc
    using Random
    using JSON
    using ProgressMeter
    using Distributed
    using Statistics

    net_name = "case14"
    std_inj = 0.8

    function run(_)
        net = net_load(net_name)
        injection = (rand(net[:n_buses]) .- 0.5) .* std_inj ./ 0.5
        injection[net[:main_bus]] = 0.
        injection[net[:prosumer_buses]] .-= mean(injection[net[:prosumer_buses]])
        if sum(injection) > 1e-10 error("SUM: $(sum(injection))") end
        if net_pf_real!(net, injection)
            Dict(
                :injection=>injection,
                :vm=>net[:vm],
            )
        else
            Dict(
                :injection=>injection,
                :vm=>nothing,
            )
        end
    end
end

results = @showprogress pmap(run, 1:1000)

data = JSON.parsefile("pf_results/$(net_name).json")
all_results = [data; results]
open("pf_results/case14.json", "w") do f
    JSON.print(f, all_results)
end
