using srpc
using PowerModels
using JSON

input_folder = "cases_m"
output_folder = "cases_json"

if isdir(output_folder)
    rm(output_folder, recursive=true)
end

mkdir(output_folder)

for case in readdir(input_folder, join=true)
    name = splitext(basename(case))[1]
    @info "Parsing: $name"

    net = PowerModels.make_basic_network(PowerModels.parse_file(case))
    n_buses = length(net["bus"])

    # Fix buses
    for bus in values(net["bus"])
        bus["vmax"] = 9999.
        bus["vmin"] = -9999.
    end

    main_bus = -1
    for bus in values(net["bus"])
        if bus["bus_type"] == 2
            bus["bus_type"] = 1
        elseif bus["bus_type"] == 3
            main_bus = bus["index"]
        end
    end

    # Fix loads
    net["load"] = Dict(
        string(i) => Dict(
            "index" => i,
            "source_id" => ["bus", i],
            "load_bus" => i,
            "status" => 1,
            "pd" => 0.0,
            "qd" => 0.0,
        )
        for i in 1:n_buses
    )

    # Keep main gen only
    for gen in values(net["gen"])
        if gen["gen_bus"] != main_bus continue end
        gen["source_id"] = ["gen", 1]
        gen["index"] = 1
        gen["pmin"] = -9999.
        gen["pmax"] = 9999.
        gen["qmin"] = -9999.
        gen["qmax"] = 9999.
        net["gen"] = Dict("1"=>gen)
        break
    end

    net = Dict(
        :name=>name,
        :net=>net,
        :n_buses=>n_buses,
        :main_bus=>main_bus,
        :pf_coeff=>tan(acos(0.9)),
        :prosumer_buses=>[i for i in 1:n_buses if i != main_bus],
        :vm=>ones(n_buses),
        :violation=>zeros(n_buses),
        :base_injection=>zeros(n_buses),
    )

    while true
        if net_pf!(net, zeros(n_buses))
            if all(net[:violation] .== 0.) break
            else
                for (i, vm) in enumerate(net[:vm])
                    if i == net[:main_bus] continue end
                    if vm < 0.9 net[:base_injection][i] += rand() * 0.01
                    elseif vm > 1.1 net[:base_injection][i] -= rand() * 0.01 end
                end
            end
        else
            net[:base_injection] = randn(net[:n_buses]) * 0.01
        end
        net_pf!(net, zeros(n_buses))
    end

    filepath = "$output_folder/$name.json"
    open(filepath, "w") do f
        JSON.print(f, net)
    end
end

@info "Done"
