import json
from itertools import product
from pathlib import Path

root = Path(__file__).parent

save_path = root / "experiments"
save_path.mkdir(exist_ok=True)


def generate_experiment(
        name: str,
        **params
):
    params["name"] = name
    data = json.dumps(params, indent=2)
    with open(save_path / f"{name}.json", "w") as f:
        f.write(data)

nonet = {
    "price_change": 0.1,
    "fine_per_vm": 10.,
    "start_price": 20.,
    "power_std": 0.1,
    "n_prosumers": 100,
    "case_name": "nonet14",
    "blackout_fine": 100,
}

for (p_name, perc), (o_name, offset, thres) in product([
    ("zero", 0.01),
    ("poco", 0.1),
    ("less", 0.25),
    ("half", 0.5),
    ("more", 0.75),
    ("tanto", 0.85),
    ("tiss", 0.9),
    ("extr", 0.95),
    ("all", 0.99)
], [
    ("", 0., 0.9),
    ("_more_demand", -0.07, 0.35),
    ("_more_offer", 0.07, 0.35)
]):
    generate_experiment(
        name=f"{p_name}_nonet{o_name}",
        perc_regulated=perc,
        power_offset=offset,
        power_met_thres=thres,
        **nonet
    )
