from abc import ABC
from itertools import cycle
from typing import Sequence

import numpy as np
from dash_mantine_components import LineChart

dataKey = "t"


class Chart(LineChart, ABC):
    def __init__(self, data: dict[str, Sequence | tuple[Sequence, Sequence]]):
        colors = cycle(
            ["#e60049", "#0bb4ff", "#50e991", "#e6d800", "#9b19f5", "#ffa300", "#dc0ab4", "#b3d4ff", "#00bfa0", "#aaaaff"])
        series = []
        values = []

        def append_line(name: str, sequence: Sequence, **kwargs):
            if len(sequence) == 0:
                return
            series.append({"name": name, "color": next(colors)} | kwargs)
            idx = np.round(np.linspace(0, len(sequence) - 1, 400)).astype(int)
            dt = len(sequence) / (len(idx) - 1)
            sequence = sequence[idx]
            if len(values) < len(sequence):
                values.extend([
                    {dataKey: int(i * dt)}
                    for i in range(len(values), len(sequence))
                ])
            for i, val in enumerate(sequence):
                values[i][name] = val

        for key, value in data.items():
            if len(value) == 2:
                mean, std = value
                append_line(key, mean)
                if len(std) > 0:
                    #append_line(f"{key} +1 std", mean + std, strokeDasharray="5 5")
                    #append_line(f"{key} -1 std", mean - std, strokeDasharray="5 5")
                    pass
            else:
                append_line(key, value)

        super().__init__(
            series=series,
            data=values,
            dataKey=dataKey,
            h="100%",
            withDots=False,
        )
