from pathlib import Path

import matplotlib.pyplot as plt
#import scienceplots

#plt.style.use(['science'])

from experiment import Experiment


class Exp:
    def __getattr__(self, item):
        return []


class Exps:
    def __init__(self, dct: dict[str, Experiment]):
        self._dct = dct

    def items(self):
        return self._dct.items()

    def __getitem__(self, item):
        return self._dct.get(item, Exp())


experiments = Exps({
    str(path.stem): Experiment(path, w=10)
    for path in (Path(__file__).parent / "results").iterdir()
})

lines = [
    #("zero", "0\%"),
    #("poco", "10%"),
    ("less", "25%"),
    ("half", "50%"),
    ("more", "75%"),
    ("tanto", "85%"),
    #("tiss", "90\%"),
    #("extr", "95\%"),
    #("all", "100\%")
]

for offset, capital in [
    ("", "profit_diff"),
    ("_more_demand", "capital_diff"),
    #"_more_offer"
]:

    # Violation

    fig, ax = plt.subplots()
    ax.set_ylim(-0.4, 5.5)
    for name, label in lines:
        ax.plot(experiments[f"{name}_nonet{offset}"].violation_sum, label=label, linewidth=1)
    ax.plot(experiments[f"half_nonet{offset}_unreg"].violation_sum, linewidth=1, label="Baseline")
    legend = ax.legend(title="Percentage of SRPs", loc="lower right", ncol=3)
    #ax.autoscale(tight=True)
    ax.set(xlabel="Timestep", ylabel="Sum of voltage violation [%]")
    plt.savefig(f"comparison_violation{offset}.png", dpi=300)
    plt.close()

    # Capital

    fig, ax = plt.subplots()
    #ax.set_yticklabels([])
    for name, label in lines:
        ax.plot(experiments[f"{name}_nonet{offset}"].capital_diff, label=label, linewidth=1)
    ax.plot(experiments[f"half_nonet{offset}_unreg"].capital_diff, linewidth=1, label="Baseline")
    legend = ax.legend(title="Percentage of SRPs", loc="upper left")
    ax.autoscale(tight=True)
    ax.set(xlabel="Timestep", ylabel="Revenue difference (1)")
    plt.savefig(f"comparison_capital{offset}.png", dpi=300)
    plt.close()

    # Profit

    fig, ax = plt.subplots()
    #ax.set_yticklabels([])
    for name, label in lines:
        ax.plot(experiments[f"{name}_nonet{offset}"].profit_diff, label=label, linewidth=1)
    ax.plot(experiments[f"half_nonet{offset}_unreg"].profit_diff, linewidth=1, label="Baseline")
    legend = ax.legend(title="Percentage of SRPs", loc="upper left")
    ax.autoscale(tight=True)
    ax.set(xlabel="Timestep", ylabel="Revenue difference (2)")
    plt.savefig(f"comparison_profit{offset}.png", dpi=300)
    plt.close()

    # Power Met

    fig, ax = plt.subplots()
    ax.set_ylim(0, 1)
    for name, label in lines:
        ax.plot(experiments[f"{name}_nonet{offset}"].power_met_reg, linewidth=0.5)
        ax.plot(experiments[f"{name}_nonet{offset}"].power_met_unreg, linewidth=0.5)
    ax.plot(experiments[f"half_nonet{offset}_unreg"].power_met_reg, linewidth=0.5)
    ax.plot(experiments[f"half_nonet{offset}_unreg"].power_met_unreg, linewidth=0.5)
    # ax.autoscale(tight=True)
    ax.set(xlabel="Timestep", ylabel="Power")
    plt.savefig(f"comparison_energy{offset}.png", dpi=300)
    plt.close()
