import logging
from pathlib import Path

import dash_mantine_components
from dash import Dash, dash
from dash_mantine_components import MantineProvider, Stack
from flask import Flask

from srpc import Pages, Experiment, Chart


def create_flask():
    flask_app = Flask(__name__)
    create_dash(server=flask_app)
    return flask_app


class Exp:
    def __getattr__(self, item):
        return []


class Exps:
    def __init__(self, dct: dict[str, Experiment]):
        self._dct = dct

    def items(self):
        return self._dct.items()

    def __getitem__(self, item):
        return self._dct.get(item, Exp())


def create_dash(**kwargs):
    dash._dash_renderer._set_react_version('18.2.0')
    dash_mantine_components.add_figure_templates(default="mantine_dark")

    dash_app = Dash(
        external_stylesheets=dash_mantine_components.styles.ALL,
        **kwargs
    )

    experiments = Exps({
        str(path.stem): Experiment(path)
        for path in (Path(__file__).parent / "results").iterdir()
    })

    dash_app.layout = MantineProvider(
        forceColorScheme="dark",
        children=Stack(
            h="100vh",
            children=Pages({
                name: Pages({
                    "Capital": Chart({
                        "R": exp.capital_reg,
                        "U": exp.capital_unreg,
                    }),
                    "Price": Chart({
                        "R_sell": exp.price_reg_sell,
                        "R_buy": exp.price_reg_buy,
                        "U_sell": exp.price_unreg_sell,
                        "U_buy": exp.price_unreg_buy,
                    }),
                    "Violation": Chart({
                        "R": exp.violation_reg,
                        "U": exp.violation_unreg,
                    }),
                })
                for name, exp in experiments.items()
            } | {
                "Comparison": Pages({
                    "Revenue Difference (1)": Chart({
                        "25": experiments["less_nonet"].profit_diff,
                        "50": experiments["half_nonet"].profit_diff,
                        "75": experiments["more_nonet"].profit_diff,
                        "85": experiments["tanto_nonet"].profit_diff,
                        "U": experiments["half_nonet_unreg"].profit_diff,
                    }),
                    "Revenue Difference (2)": Chart({
                        "25": experiments["less_nonet"].capital_diff,
                        "50": experiments["half_nonet"].capital_diff,
                        "75": experiments["more_nonet"].capital_diff,
                        "85": experiments["tanto_nonet"].capital_diff,
                        "U": experiments["half_nonet_unreg"].capital_diff,
                    }),
                    "Violation": Chart({
                        "50": experiments["half_nonet"].violation_sum,
                        "25": experiments["less_nonet"].violation_sum,
                        "75": experiments["more_nonet"].violation_sum,
                        "85": experiments["tanto_nonet"].violation_sum,
                        "U": experiments["half_nonet_unreg"].violation_sum,
                    }),
                })
            })
        )
    )

    return dash_app


if __name__ == '__main__':
    logging.basicConfig(level=logging.INFO)
    app = create_dash()
    app.run(debug=True)
