# LaTeX Thesis with Docker and VS Code Dev Containers

This repository contains a LaTeX template for a Master's thesis, fully configured to be built inside a Docker container. It uses the VS Code Dev Containers extension for a seamless and reproducible development environment.

The structure is based on the `toptesi` LaTeX class, but can be adapted for any university.

## Features

- **Reproducible Builds**: The entire LaTeX environment (Tex Live) is encapsulated in a Docker container, ensuring that the document builds consistently everywhere.
- **Seamless Development**: Integrates with VS Code and the Dev Containers extension for a one-click setup.
- **Live Preview**: The included `latex-workshop` VS Code extension provides live preview, synctex, and auto-build on save.
- **Structured Template**: The thesis is broken down into chapters and sections for better organization.

## Prerequisites

Before you begin, ensure you have the following installed:

- [Visual Studio Code](https://code.visualstudio.com/)
- [Docker Desktop](https://www.docker.com/products/docker-desktop)
- The [Dev Containers](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers) extension for VS Code.

## Getting Started

1.  **Clone the repository:**
    ```bash
    git clone https://github.com/amirhossein-shekari/Thesis-Report.git
    cd Thesis-Report
    ```

2.  **Open in VS Code:**
    ```bash
    code .
    ```

3.  **Reopen in Container:**
    - After opening the project in VS Code, you will see a notification in the bottom-right corner asking if you want to "Reopen in Container".
    - Click on **"Reopen in Container"**.
    - VS Code will then build the Docker container based on the configuration in the `.devcontainer` folder. This might take a few minutes on the first run as it downloads the Tex Live image.

4.  **Build the PDF:**
    - Once the container is running, open the `main.tex` file.
    - The `LaTeX Workshop` extension (which is automatically installed inside the container) will activate.
    - The PDF should compile automatically. If not, you can trigger a build by:
        - Saving the `main.tex` file (`Ctrl+S` or `Cmd+S`).
        - Using the Command Palette (`Ctrl+Shift+P` or `Cmd+Shift+P`) and running `LaTeX Workshop: Build LaTeX project`.

5.  **View the PDF:**
    - To view the generated PDF, click the "View LaTeX PDF" button (a magnifying glass icon) in the top-right corner of the editor.
    - The PDF (`main.pdf`) will be generated in the root of the project.

## Manual Build (using Docker Compose)

If you prefer not to use VS Code's Dev Containers, you can build the project manually using Docker Compose.

1.  **Start the container:**
    ```bash
    docker-compose up -d
    ```

2.  **Run the build commands:**
    Execute the following commands to compile the LaTeX document and generate the bibliography.
    ```bash
    docker-compose exec texlive pdflatex main.tex
    docker-compose exec texlive bibtex main
    docker-compose exec texlive pdflatex main.tex
    docker-compose exec texlive pdflatex main.tex
    ```

3.  **Find the output:**
    The final `main.pdf` will be available in the root directory of the project.

## Pushing to a New GitHub Repository

To push this project to a new GitHub repository, follow these steps.

1.  **Create a new repository on GitHub:**
    Go to [github.com/new](https://github.com/new) and create a new repository. Do not initialize it with a README, .gitignore, or license.

2.  **Connect your local repository to the new GitHub repository:**
    Replace `YOUR_USERNAME` and `YOUR_REPOSITORY` with your GitHub username and the name of your new repository.
    ```bash
    git remote set-url origin https://github.com/YOUR_USERNAME/YOUR_REPOSITORY.git
    git branch -M main
    git push -u origin main
    ```

## Project Structure

```
.
├── .devcontainer/      # Configuration for the VS Code Dev Container
│   ├── devcontainer.json
│   └── docker-compose.yml
├── Contents/           # Main content of the thesis
│   ├── acknowledgments.tex
│   └── Chapters/
│       ├── chapter1.tex
│       └── ...
├── Cover/              # Cover page
│   └── cover.tex
├── Figures/            # Folder for images and figures
├── biblio.bib          # Bibliography file
├── main.tex            # The main LaTeX file that pulls everything together
├── toptesi.cls         # The thesis LaTeX class and related style files
└── README.md           # This file
```

- **`main.tex`**: This is the root document. It loads necessary packages and includes the different parts of the thesis from the `Contents/` directory.
- **`Contents/`**: This directory holds the individual chapters and sections of your thesis. Splitting the content into multiple files makes it easier to manage.
- **`biblio.bib`**: Your bibliography in BibTeX format. Add all your references here.
- **`toptesi.cls` and `*.sty`**: These are the class and style files that define the layout and formatting of the thesis. You can modify these to change the appearance.
- **`.devcontainer/`**: This folder tells VS Code how to create the development environment. The `docker-compose.yml` defines the Docker service, and `devcontainer.json` configures VS Code to use it and install the recommended extensions.

## Customization

- **Thesis Content**: Edit the `.tex` files in the `Contents/` directory to write your thesis.
- **Bibliography**: Add your citations to `biblio.bib`.
- **Styling**: To change the formatting, you can modify `toptesi.cls` and the associated `.sty` files, or override settings in `main.tex`.

## License

This project is open source and available under the [MIT License](LICENSE).

