import numpy as np
from qiskit import QuantumCircuit
from qiskit_aer import Aer
from qiskit import transpile
from qiskit import transpile
from qiskit.quantum_info import DensityMatrix, entropy, partial_trace
from qiskit.quantum_info import random_density_matrix, state_fidelity, Operator
import numpy as np
import matplotlib.pyplot as plt
from functools import reduce
import pandas as pd


# Number of qubits in the system (A, B, Ap, Bp)
n_qubits = 4

# Backend for statevector simulation
backend = Aer.get_backend('statevector_simulator')

# Store values of causation measure and initial information of the system
S_A_init = []
S_B_init = []
S_init = []
causation_measures = []

### Create a quantum circuit to apply the CNOT transformations
qc = QuantumCircuit(n_qubits)

# Step 1: Apply CNOT on A -> Ap and B -> Bp
qc.cx(2, 3)  # CNOT(A -> Ap)
qc.cx(1, 0)  # CNOT(B -> Bp)


# Step 2: Apply single gate on A or B
# qc.x(2)
# qc.t(2)
# qc.x(1)  # X(B)
qc.h(1) # H(B)
# qc.s(1)
#qc.t(1)
    
# Step 3: Apply inverse of Step 1 (CNOT Ap -> A and Bp -> B)
qc.cx(3, 2)  # CNOT(Ap -> A)
qc.cx(0, 1)  # CNOT(Bp -> B)

U = Operator(qc)

# Simulation with random initial state of A
for _ in range(10000):
    rho_A = random_density_matrix(2)
    #rho_A = DensityMatrix(np.array(
    #    [[0.5, 0],
    #    [0, 0.5]]
    #))

    # Compute the initial Von Neumann entropy of A
    S_A_init.append(entropy(rho_A))
    
    # Initialize a full 4-qubit density matrix with B, Ap, Bp in |0>
    rho_Ap = DensityMatrix.from_label('0')
    #rho_B = DensityMatrix.from_label('0')
    #rho_B = DensityMatrix(np.array(
    #    [[0.5, 0.5],
    #    [0.5, 0.5]]
    #))
    rho_B = random_density_matrix(2)
    rho_Bp = DensityMatrix.from_label('0')

    S_B_init.append(entropy(rho_B))
    S_init.append(entropy(rho_A)+entropy(rho_B))

    rho_list = [rho_Ap, rho_A, rho_B, rho_Bp]
    rho_full = reduce(lambda x,y: x.tensor(y), rho_list)

    final_rho = rho_full.evolve(U)

    # Compute entropy terms for causation measure
    S_BBp = entropy(partial_trace(final_rho, [2, 3]))
    S_ApABp = entropy(partial_trace(final_rho, [1]))
    S_Bp = entropy(partial_trace(final_rho, [1, 2, 3]))
    S_ApABBp = entropy(final_rho)

    # Compute causation measure
    C_A_to_B = S_BBp + S_ApABp - S_Bp - S_ApABBp
    causation_measures.append(C_A_to_B)



# Print the causation measure results
CausationMeasure_dict = {'S_init_total': S_init, 'S_init(A)': S_A_init, 'S_init(B)': S_B_init, 'C(A->B)': causation_measures}
CausationMeasure_df = pd.DataFrame(CausationMeasure_dict)

print("Maxmum causation measure is:", CausationMeasure_df['C(A->B)'].max())
print("Minimum causation measure is:", CausationMeasure_df['C(A->B)'].min())
#print("Initial quantum information:", S_A_init)
#print("Causation Measures:", causation_measures)

#plt.plot(S_A_init, causation_measures)
#plt.xlabel('S_init(A)')
#plt.ylabel('C(A->B)')
#plt.title('Causation Entropy')
#plt.show()

CausationMeasure_df.sort_values(by='S_init(A)', inplace=True, ascending=True)
CausationMeasure_df.plot.scatter(x='S_init(A)', y='C(A->B)')
plt.title('Causation Entropy v.s. S(A)')

CausationMeasure_df.sort_values(by='S_init(B)', inplace=True, ascending=True)
CausationMeasure_df.plot.scatter(x='S_init(B)', y='C(A->B)')
plt.title('Causation Entropy v.s. S(B)')

CausationMeasure_df.sort_values(by='S_init_total', inplace=True, ascending=True)
CausationMeasure_df.plot.scatter(x='S_init_total', y='C(A->B)')
plt.title('Causation Entropy v.s. S(A)+S(B)')
plt.show()