rule contains_pe_file_attachment {
    meta:
        description = "Detects MZ header inside an extracted attachment"
        author = "Michele Merico - test rules"
    strings:
        $pe_header = { 4D 5A }   // 'MZ'
    condition:
        $pe_header
}

rule detect_activemime_attachment {
    meta:
        description = "Detects base64('ActiveMime') in an extracted attachment"
        author = "Michele Merico - test rules"
    strings:
        $activemime_b64 = "QWN0aXZlTWltZQ==" ascii
    condition:
        $activemime_b64
}

rule detect_embedded_excel_attachment {
    meta:
        description = "Detects Excel XML tag inside extracted attachment"
    strings:
        $xls_header = "<x:ExcelWorkbook>" ascii
    condition:
        $xls_header
}

rule detect_embedded_word_attachment {
    meta:
        description = "Detects Word XML tag inside extracted attachment"
    strings:
        $word_header = "<w:WordDocument>" ascii
    condition:
        $word_header
}

rule detect_embedded_mht_attachment {
    meta:
        description = "Detects 'mime' token inside extracted attachment"
    strings:
        $mht_header = "mime" ascii
    condition:
        $mht_header
}

rule detect_embedded_pdf_attachment {
    meta:
        description = "Detects embedded PDF header inside an extracted attachment"
    strings:
        $pdf_header = "%PDF-" ascii
    condition:
        $pdf_header
}
