# DORA Project - Chinese to English Translation TODO

This document tracks all files in the DORA project that contain Chinese text and need to be translated to English.

**Total files with Chinese content: 84**

---

## 📋 Translation TODO List

### Category 1: Main Documentation Files
**Priority: HIGH**

| File | Status | Notes |
|------|--------|-------|
| `介绍.md` | ⬜ Pending | Main project introduction - full Chinese document |
| `scripts/demo_guide.md` | ⬜ Pending | Demo guide for local & compose setup - heavily Chinese |
| `LIVEKIT_INTEGRATION_STATUS.md` | ⬜ Pending | Integration status report - contains Chinese comments |
| `DORA_PROJECT_STRUCTURE.md` | ⬜ Pending | Project structure documentation |
| `DEVELOPMENT_WORKFLOW.md` | ⬜ Pending | Development workflow guide |
| `DEVELOPMENT_TASKS.md` | ⬜ Pending | Development tasks list |
| `TROUBLESHOOTING_GUIDE.md` | ⬜ Pending | Troubleshooting guide |
| `QUICK_REFERENCE.md` | ⬜ Pending | Quick reference guide |
| `PROJECT_REQUIREMENTS.md` | ⬜ Pending | Project requirements |
| `TV_CALL_BACKUP.md` | ⬜ Pending | TV call backup documentation |
| `SCREEN_SHARE_TEST_REPORT.md` | ⬜ Pending | Screen share test report |
| `DEPRECATED_EVALUATION_SCRIPTS.md` | ⬜ Pending | Deprecated scripts documentation |

### Category 2: Client-Side Code (JavaScript/TypeScript/React)
**Priority: HIGH**

| File | Status | Notes |
|------|--------|-------|
| `client/src/routes/CaregiverPage.jsx` | ⬜ Pending | 3 Chinese strings/comments |
| `client/src/components/CoWatchController.tsx` | ⬜ Pending | 5 Chinese strings/comments |
| `client/src/components/BloodPressureMonitor.jsx` | ⬜ Pending | 8 Chinese strings/comments |
| `client/src/components/HABloodPressureMonitor.jsx` | ⬜ Pending | 40 Chinese strings/comments |
| `client/src/components/ElderCallNotification.jsx` | ⬜ Pending | 7 Chinese strings/comments |
| `client/src/components/AlertsPanel.jsx` | ⬜ Pending | 1 Chinese string/comment |
| `client/src/components/VoiceAssistantIcon.jsx` | ⬜ Pending | 3 Chinese strings/comments |

### Category 3: Server-Side Code (JavaScript/Node.js)
**Priority: MEDIUM**

| File | Status | Notes |
|------|--------|-------|
| `server/tele-assist-svc/app/index.js` | ⬜ Pending | Chinese comments in call handling logic |
| `server/tele-assist-svc/app/routers/livekit-token.js` | ⬜ Pending | Chinese comments |

### Category 4: Android/Kotlin Code
**Priority: MEDIUM**

| File | Status | Notes |
|------|--------|-------|
| `333/app/src/main/java/com/example/a333/MainActivity.kt` | ⬜ Pending | Chinese console.log messages and comments |
| `333/app/src/main/java/com/example/a333/WeekAdapter.kt` | ⬜ Pending | Chinese comments |
| `333/app/src/main/res/layout/activity_main.xml` | ⬜ Pending | Chinese UI strings |
| `333/app/src/main/res/values/colors.xml` | ⬜ Pending | Chinese comments |
| `333/app/src/main/res/values/styles.xml` | ⬜ Pending | Chinese comments |
| `333/app/src/main/res/layout/item_week_day.xml` | ⬜ Pending | Chinese UI strings |

### Category 5: Server-Side Code (Python)
**Priority: MEDIUM**

| File | Status | Notes |
|------|--------|-------|
| `server/home-safety-svc/app/fall_detection.py` | ⬜ Pending | Chinese comments |

### Category 6: Shell Scripts
**Priority: LOW**

| File | Status | Notes |
|------|--------|-------|
| `test-elder-call-admin.sh` | ⬜ Pending | Chinese comments |
| `test_ha_reader.sh` | ⬜ Pending | Chinese comments |
| `start_ha_reader.sh` | ⬜ Pending | Chinese comments |
| `start_admin_dashboard.sh` | ⬜ Pending | Chinese comments |
| `debug_unified_hangup.sh` | ⬜ Pending | Chinese comments |
| `debug_call_status.sh` | ⬜ Pending | Chinese comments |
| `test_unified_hangup.sh` | ⬜ Pending | Chinese comments |
| `test_elder_reject.sh` | ⬜ Pending | Chinese comments |
| `test_admin_ui_fix.sh` | ⬜ Pending | Chinese comments |
| `test_final_compilation.sh` | ⬜ Pending | Chinese comments |
| `test_simple_hangup.sh` | ⬜ Pending | Chinese comments |
| `test_hangup_detection.sh` | ⬜ Pending | Chinese comments |
| `test_all_fixes.sh` | ⬜ Pending | Chinese comments |
| `test_livekit_connection.sh` | ⬜ Pending | Chinese comments |
| `test_complete_flow.sh` | ⬜ Pending | Chinese comments |
| `test_admin_call_android.sh` | ⬜ Pending | Chinese comments |
| `test_call.sh` | ⬜ Pending | Chinese comments |

### Category 7: HTML Test Files
**Priority: LOW**

| File | Status | Notes |
|------|--------|-------|
| `client/public/api-test.html` | ⬜ Pending | Chinese text |
| `client/public/video-test.html` | ⬜ Pending | Chinese text |
| `client/public/screen-share-test.html` | ⬜ Pending | Chinese text |
| `test_tv_call.html` | ⬜ Pending | Chinese text |
| `test_bp_monitor.html` | ⬜ Pending | Chinese text |
| `dora/client/server/admin-ha-test.html` | ⬜ Pending | Chinese text |
| `dora/client/server/dora/client/server/admin-ha-test.html` | ⬜ Pending | Chinese text (duplicate path) |

### Category 8: Configuration and Other Files
**Priority: LOW**

| File | Status | Notes |
|------|--------|-------|
| `client/vite.config.js` | ⬜ Pending | Chinese comments |
| `client/index.html` | ⬜ Pending | Chinese text |
| `cursor_rules.json` | ⬜ Pending | Chinese text |
| `dora_structure.txt` | ⬜ Pending | Chinese text |
| `333/app/build.gradle.kts` | ⬜ Pending | Chinese comments |
| `333/app/src/main/assets/models/README.md` | ⬜ Pending | Chinese text |

### Category 9: Server Documentation
**Priority: MEDIUM**

| File | Status | Notes |
|------|--------|-------|
| `server/assistant-svc/README.md` | ⬜ Pending | Chinese documentation |
| `server/health-svc/README.md` | ⬜ Pending | Chinese documentation |
| `server/home-safety-svc/README.md` | ⬜ Pending | Chinese documentation |
| `server/home-safety-svc/DEPRECATED_FALL_DETECTION.md` | ⬜ Pending | Chinese documentation |
| `server/tv-svc/DEPRECATED_WEB_TV.md` | ⬜ Pending | Chinese documentation |
| `client/DEPRECATED_ELDER_WEB.md` | ⬜ Pending | Chinese documentation |
| `client/DEPRECATED_WEBSOCKET.md` | ⬜ Pending | Chinese documentation |

### Category 10: Docs Folder
**Priority: MEDIUM**

| File | Status | Notes |
|------|--------|-------|
| `docs/CARE_HTML_DATA_SUMMARY.md` | ⬜ Pending | Chinese documentation |
| `docs/ha_simulated_data.md` | ⬜ Pending | Chinese documentation |
| `docs/event_protocol.md` | ⬜ Pending | Chinese documentation |
| `docs/ENV_VARS.md` | ⬜ Pending | Chinese documentation |
| `client/server/HA_CONFIG.md` | ⬜ Pending | Chinese documentation |

### Category 11: Docker Compose and Ops Files
**Priority: LOW**

| File | Status | Notes |
|------|--------|-------|
| `ops/compose/docker-compose.client.yml` | ⬜ Pending | Chinese comments |
| `ops/compose/docker-compose.mqtt.yml` | ⬜ Pending | Chinese comments |
| `ops/compose/docker-compose.ha.yml` | ⬜ Pending | Chinese comments |

### Category 12: Other JavaScript Files
**Priority: LOW**

| File | Status | Notes |
|------|--------|-------|
| `client/server/ha_data_reader.js` | ⬜ Pending | Chinese comments |
| `test-livekit-simple.js` | ⬜ Pending | Chinese comments |
| `test-livekit.js` | ⬜ Pending | Chinese comments |

### Category 13: Python Scripts
**Priority: LOW**

| File | Status | Notes |
|------|--------|-------|
| `admin_health_dashboard.py` | ⬜ Pending | Chinese comments |

### Category 14: Other Files
**Priority: LOW**

| File | Status | Notes |
|------|--------|-------|
| `server/tele-assist-svc/static/tele-assist-svc_index.html.txt` | ⬜ Pending | Chinese text |
| `server/tele-assist-svc/static/index.html` | ⬜ Pending | Chinese text |
| `dora/client/server/README.md` | ⬜ Pending | Chinese documentation |
| `dora/client/server/start_ha_bridge.sh` | ⬜ Pending | Chinese comments |
| `dora/client/server/dora/client/server/start_ha_bridge.sh` | ⬜ Pending | Chinese comments (duplicate path) |

---

## 📊 Summary Statistics

- **Total files to translate**: 84
- **High Priority**: 19 files (main docs + client code)
- **Medium Priority**: 15 files (server code + docs)
- **Low Priority**: 50 files (scripts + test files)

## 🔄 Translation Workflow

1. **Start with High Priority files** - main documentation and client-side code
2. **Then Medium Priority** - server code and technical documentation
3. **Finally Low Priority** - scripts, test files, and configuration

## ✅ Progress Tracking

Use this checklist to track translation progress:
- ⬜ = Pending
- 🟡 = In Progress
- ✅ = Completed

---

**Last Updated**: Generated from file scan
