# Dora Project

This repository contains the code and configuration for the master's thesis on DORA,
a voice-first, local-first home assistance platform for older adults.

## Abstract

Population ageing increases demand for trustworthy, usable home support. Many older adults wish to remain independent, yet face risks from falls, chronic conditions and social isolation, while commercial smart‑home offerings are siloed, cloud‑dependent, or not designed for accessibility. This thesis presents DORA, a voice‑first, edge‑executed well‑being platform that integrates four capabilities—Home Safety (HS), Health Monitoring (HM), Smart‑TV Interaction (TV) and Tele‑Assistance (TA)—within a privacy‑preserving microservice architecture.

We contribute three results. (i) We elicit requirements from elder, caregiver and remote‑operator personas and derive domestic specifications that prioritise edge responsiveness, accessibility, data minimization and auditability. (ii) We design a microservice architecture with clear, domain‑oriented service boundaries (notification, HM, HS, TV, TA), versioned MQTT event schemas and a defence‑in‑depth model that keeps biometric data on premises by default and, under explicit authorization with purpose and bounded time, supports standards‑based exports (e.g., HL7 FHIR).
(iii) We implement a working prototype using Home Assistant for device orchestration, MQTT for decoupled events, a local time‑series store for vitals and a TV application coupled with a WebRTC tele‑assistance backend.

Architecturally, DORA separates sensing from decision and presentation. Device and wearable signals are normalised into stable JSON payloads on versioned topics; domain services subscribe, apply explainable analytics (rules, thresholds, rolling windows) and emit actions—text‑to‑speech prompts, TV overlays, caregiver notifications. This decoupling enables independent evolution, back‑pressure handling and graceful restart. Privacy is addressed through local‑first storage, consent‑bound and purpose‑limited exports, explicit data‑quality indicators (e.g., signal confidence, motion flags) and immutable audit logs. Accessibility centres on a TV‑first interaction model with short, confirmable prompts.

We evaluate DORA under controlled and realistic conditions. HS achieves sub‑second median alerting and recovers cleanly after broker/service restarts. HM sustains 1 Hz ingestion, serves on‑demand health summaries and performs consent‑scoped FHIR exports with only hundreds of milliseconds of local overhead. TA establishes operator‑to‑TV sessions in 1–3 s. Usability studies on three representative TV tasks—request health summary, acknowledge alert, join call—show low step counts and short completion times; accessibility reviews report readable overlays and clear recovery prompts.

These results suggest that decoupled events and idempotent consumers with retained state enable robust recovery without duplicate prompts. Interpretable analytics suffice for actionable home behaviour, and TV‑centric, short, confirmable prompts reduce cognitive load. Moreover, privacy and interoperability can coexist: local time‑series storage, consent‑scoped exports, and audit trails support integration with caregivers and clinical systems.

Overall, DORA shows that a modular, voice‑first, local‑first platform can improve perceived safety and connectedness for older adults without compromising data protection, while offering a reproducible path toward interoperable, explainable and trustworthy smart‑home care.
