function [fuel_frac, tau, E] = fuel_fraction(S_ref, V_tot, M, Range_cruise, ISP)

    A = 6;
    B = 2;

    gamma = 1.4;
    R = 287;
    h_cruise = 28000;
    T_cruise = isa_temp(h_cruise);
    a_cruise = sqrt( gamma * R * T_cruise);
    V_cruise = M * a_cruise;

   % Fractions for kerosene
    m_21 = 0.97;
    m_32 = 0.88;
    m_54 = 0.985;
    m_65 = 0.995;

    if (ISP>= 2500) && (ISP<=3100)
        m_21 = 1 - (1-m_21) / 2.75;
        m_32 = 1 - (1-m_32) / 2.75;
        m_54 = 1 - (1-m_54) / 2.75;
        m_65 = 1 - (1-m_65) / 2.75;
    elseif (ISP>= 1200) && (ISP<= 1500)
        m_21 = 1 - (1-m_21) / 1.25;
        m_32 = 1 - (1-m_32) / 1.25;
        m_54 = 1 - (1-m_54) / 1.25;
        m_65 = 1 - (1-m_65) / 1.25;
    end
    
    tau = V_tot / S_ref^1.5; % adimentional
    
    E = A*(M + B)/M * ((1.0128 - 0.2797 * log( tau / 0.03 ) / (1 - M^2 / 673) ));

    m_43 = exp(- Range_cruise * 1000 / (ISP * V_cruise * E));

    fuel_frac = 1.05 * (1 - m_65 * m_54 * m_43 * m_32 * m_21);

end


function T = isa_temp(h)
    if h < 11000
        T = 288.15 - 0.0065 * h;
    elseif h < 20000
        T = 216.65;
    elseif h < 32000
        T = 216.65 + 0.001 * (h - 20000);
    else
        T = 270;
    end
end