clc
clear
close all

%% HYCAT 1

mach_left  = [0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0 2.2 2.4 2.6 2.8 3.0];
mach_right = [3.2 3.4 3.6 3.8 4.0 4.2 4.4 4.6 4.8 5.0 5.2 5.4 5.6 5.8 6.0];
mach_full  = [mach_left mach_right];

CDf_1_common = [0.005932 0.005927 0.005891 0.005774 0.005581 0.005334 0.005111 0.004906 ...
        0.004736 0.004589 0.004454 0.004331 0.004226 0.004120];

CDf_1_4  = [CDf_1_common  0.00402 0.003932 0.003850 0.003768 0.003692 0.003622 0.003557...
    0.003493 0.003440 0.003375 0.003317 0.003264 0.003211 0.003152 0.003106];
CDf_1_8  = [CDf_1_common  0.00402 0.003932 0.003850 0.003768 0.003692 0.003622 0.003557 ...
    0.003493 0.003440 0.003393 0.003358 0.003317 0.003276 0.003246 0.003217];
CDf_1_12 = [CDf_1_common  0.00405 0.003991 0.003932 0.003886 0.003850 0.003821 0.003786 ...
    0.003757 0.003739 0.003721 0.003698 0.003680 0.003669 0.003657 0.003645];

figure; hold on;
plot(mach_full, CDf_1_4,  'k-', 'LineWidth', 2);
plot(mach_full, CDf_1_8,  'b-', 'LineWidth', 2);
plot(mach_full, CDf_1_12, 'r-', 'LineWidth', 2);
xlabel('Mach');
ylabel('Friction drag, C_{Df}');
legend('\alpha = 4°', '\alpha = 8°', '\alpha = 12°', 'Location', 'northeast');
title('HYCAT-1 friction drag');
grid on;

%% HYCAT 4

CDf_4_common = [0.007026 0.00702 0.0070066 0.0069934 0.006669 0.0063576 0.006099 0.005887];

CDf_4_4  = [CDf_4_common  0.0056689 0.005470 0.005278 0.005132 0.004987 0.004894 0.004768 0.0046755 0.004583 ...
    0.004490 0.004424 0.004344 0.004271 0.004199 0.0041457 0.004093 0.004026 0.003980 0.003947 0.0039 0.003861];
CDf_4_8  = [CDf_4_common  0.0056689 0.005470 0.005278 0.005132 0.005 0.004894 0.004795 0.004715 0.004642 0.0045695 ...
    0.0045165 0.00447 0.004417 0.004384 0.004338 0.004318 0.004291 0.004265 0.004245 0.004232 0.004225];
CDf_4_12 = [CDf_4_common  0.005695 0.005536 0.005391 0.005285 0.005179 0.005099 0.0050265 0.004967 0.004914 ...
    0.004874 0.0048477 0.004828 0.0048145 0.004808 0.004808 0.0048145 0.004821 0.004828 0.004834 0.004861 0.004887];

figure; hold on;
plot(mach_full, CDf_4_4,  'k-', 'LineWidth', 2);
plot(mach_full, CDf_4_8,  'b-', 'LineWidth', 2);
plot(mach_full, CDf_4_12, 'r-', 'LineWidth', 2);
xlabel('Mach');
ylabel('Friction drag, C_{Df}');
legend('\alpha = 4°', '\alpha = 8°', '\alpha = 12°', 'Location', 'northeast');
title('HYCAT-4 friction drag');
grid on;


%% --- Calcola la curva somma ---

CDf_sum_4  = CDf_1_4  + 0.05 * CDf_4_4;
CDf_sum_8  = CDf_1_8  + 0.05 * CDf_4_8;
CDf_sum_12 = CDf_1_12 + 0.05 * CDf_4_12;

figure; hold on;
plot(mach_full, CDf_sum_4, 'LineWidth', 2);
plot(mach_full, CDf_sum_8, 'LineWidth', 2);
plot(mach_full, CDf_sum_12, 'LineWidth', 2);
xlabel('Mach');
ylabel('Friction drag, C_{Df} (somma)');
legend('\alpha = 4°', '\alpha = 8°', '\alpha = 12°', 'Location', 'northeast');
title('HYCAT-1A friction drag');
grid on;

clc
clear
close all

% Data
fuels = {'Kerosene (Jet-A)', 'Liquid Methane (LNG)', 'Liquid Hydrogen (LH_2)'};

LHV = [43.0, 55.0, 120.0]; % Lower Heating Value MJ/kg
density = [804, 450, 71]; % kg/m^3
storage_temp = [15, -162, -253]; %ºC
vol_energy_density = [34.4, 22.5, 8.5]; % MJ/L

% Combine data for bar plot
bar_data = [LHV; vol_energy_density; storage_temp]';
bar_colors = [1 0.6 0; 0.6 0.8 1; 0.6 1 0.6; 0 0.7 0];

figure;
b = bar(bar_data,'grouped');
hold on

for k = 1:length(b)
    b(k).FaceColor = bar_colors(k,:);
end

% set(gca,'XTickLabel',fuels, 'FontSize', 10)
ylabel('Values')
title('Comparison between Kerosene, LNG, and LH_2')

legend({'LHV (MJ/kg)', 'Volumetric Energy Density (MJ/L)', 'Storage Temperature (°C)' }, 'Location','southwest')

grid on
hold off
