import os
import json
from tqdm import tqdm

input_folder = os.path.dirname(os.getcwd())
output_file = os.path.join(input_folder, "contours.json")

class_labels = ['Tissue', 'Fat', 'Other_Nuclei', 'Hepatocyte_Nuclei', 'Steatosis']

def merge_json(input_folder, outpu_file):
    json_files = sorted(
        [
            os.path.join(input_folder, f)
            for f in os.listdir(input_folder)
            if f.endswith(".json") and f.startswith("contours") and os.path.join(input_folder, f) != output_file
        ]
    )

    if not json_files:
        print(f"No JSON files found.")
        return
    print(f"Found {len(json_files)} JSON files to be merged.")

    with open(output_file, 'w', encoding='utf-8') as out:
        out.write("{")

        for i, label in enumerate(class_labels):
            out.write(f'"{label}":[')
            first_item_written = False

            for json_path in tqdm(json_files, desc=f"Merging {label}"):
                with open(json_path, 'r', encoding='utf-8') as f:
                    try:
                        data = json.load(f)
                        if label in data and data[label]:
                            for obj in data[label]:
                                if first_item_written:
                                    out.write(",")
                                json.dump(obj, out, separators=(',', ':'))
                                first_item_written = True

                    except Exception as e:
                        print(f"Error with {json_path}: {e}")

            out.write("]")
            if i < len(class_labels) - 1:
                out.write(",")

        out.write("}")
    print(f"Saved merged file as: {output_file}")


merge_json(input_folder, output_file)