import os
from tqdm import tqdm
import glob
import cv2
import numpy as np
import json


folder = "C:/Users/giuli/Documents/Uni/Tesi/Data/semantic/train/7"
output_json = os.path.join(os.path.dirname(os.getcwd()), "tissue_contours.json")
results = []
img_paths = glob.glob(os.path.join(folder, "*.png"))
for img_path in tqdm(img_paths, desc="Elaboration", unit="img") :
    img_name = os.path.basename(img_path)
    img = cv2.imread(img_path)
    gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)
    _, mask = cv2.threshold(gray, 1, 255, cv2.THRESH_BINARY)
    kernel = np.ones((3,3), np.uint8)
    mask_clean = cv2.morphologyEx(mask, cv2.MORPH_CLOSE, kernel, iterations=2)
    mask_clean = cv2.morphologyEx(mask_clean, cv2.MORPH_OPEN, kernel, iterations=1)

    contours, _ = cv2.findContours(mask_clean, cv2.RETR_EXTERNAL, cv2.CHAIN_APPROX_NONE)
    total_area = 1024 * 1024
    tissue_area = sum(cv2.contourArea(cnt) for cnt in contours)
    perc = (tissue_area / total_area) * 100

    coords_all = []
    for cnt in contours:
        coords = [[int(x), int(y)] for [[x,y]] in cnt]
        coords_all.append(coords)

    results.append({
        "Image": img_name,
        "Coordinates": coords_all,
        "Percentage": round(perc, 6)
    })

with open(output_json, "w") as f:
    json.dump(results, f, separators=(",", ":"))

print(f"Completed! File JSON saved in {output_json}")
