import ijson
import json
import os
import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde
from sympy.printing.pretty.pretty_symbology import line_width

folder = os.getcwd()
cell_json_path = os.path.join(os.path.dirname(folder), "contours_cut.json")


classes = ['Background', "Tissue", "Fat", "Other_Nuclei", "Hepatocyte_Nuclei", "Steatosis"]

points_per_class = {cls: [] for cls in classes}

with open(cell_json_path, 'r') as f:
    parser = ijson.parse(f)
    crt_class = None
    for prefix, event, value in parser:
        if prefix in classes and event == "start_array":
            crt_class = prefix
        elif prefix.endswith(".Coordinates.item") and crt_class:
            points_per_class[crt_class][-1] += 1
        elif prefix.endswith(".Coordinates") and event == "start_array" and crt_class:
            points_per_class[crt_class].append(0)
        elif prefix in classes and event == 'end_array':
            crt_class = None

plt.figure(figsize=(12,7))

for cls in classes:
    values = np.array(points_per_class[cls])
    if len(values) == 0:
        continue
    mean_val = values.mean()
    counts, bin_edges = np.histogram(values, bins=50, density=True)
    bin_centers = 0.5 * (bin_edges[1:] + bin_edges[:-1])
    plt.plot(bin_centers, counts, linewidth=2.5, label=f"{cls} (mean={mean_val:.1f})")

plt.title("Distribuzione del numero di punti per classe")
plt.xlabel("Numero di punti")
plt.xlim(0,400)
plt.ylabel("Densità")
plt.grid(True, linestyle="--", alpha=0.6)
plt.legend()
plt.show()


