# Generating HTML documentation, compatible with MATLAB's help system

## Style files - `ttb.css` and `ttb.xsl`

These files used MATLAB's default style file as a starting point: `MATLAB/R2018a/toolbox/matlab/codetools/private/mxdom2simplehtml.xsl`.

In particular, `ttb.xsl` is derived from that file, and it may need to be updated in
the future to conform to changes in MATLAB. 

The file `ttb.css` is derived from `ttb.xsl`, capturing the style elements.
These files should be identical in the styles that they define.

## Navigation and Help

* `doc/html/helptoc.xml` - Creates the search panel in MATLAB's help interface
* `doc/html/helpsearch-vs/` - Generated by MATLAB tools. This needs to be re-run whenever there is a change to the help files. Update this search database by running:

```matlab
builddocsearchdb('[full path to tensor_toolbox/doc/html directory]')
```

### Hand-coded HTML

The following files live in `doc/html`, are hand-coded. New files need to also be added to `helptoc.xml`.

* `index.html` - Main file
* `converting.html` 
* `cp.html`
* `eigen.html`
* `index.html`
* `tensor_types.html`
* `Tensor-Toolbox-for-MATLAB-Banner.png`
* `tucker.html`
* `working.html`

### Publishing from dot-m files

All help files of the form `<XXXX>_doc.html` are generated from dot-m files in the `doc` subdirectory.
The command to publish is:

```matlab
publish('<XXXX>_doc.m','stylesheet','ttb.xsl')
```

